/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.processes.items;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestItemModel;
import org.alfresco.rest.model.RestProcessModel;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataWorkflow;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.ProcessModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class DeleteProcessItemSanityTests
extends RestTest {
    private FileModel document;
    private FileModel document2;
    private SiteModel siteModel;
    private UserModel userWhoStartsTask;
    private UserModel assignee;
    private UserModel adminUser;
    private RestProcessModel processModel;
    private RestItemModel processItem;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.userWhoStartsTask = this.dataUser.createRandomTestUser();
        this.assignee = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.adminUser)).createPublicRandomSite();
        this.document = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.document)).createNewTaskAndAssignTo(this.assignee);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.SANITY}, description="Delete existing process item")
    @Test(groups={"rest-api", "workflow", "processes", "sanity"})
    public void deleteProcessItem() throws Exception {
        this.processModel = ((RestProcessModel)this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().getProcesses().getOneRandomEntry()).onModel();
        this.document2 = ((DataContent)this.dataContent.usingAdmin().usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.MSWORD);
        this.processItem = this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessItem(this.document2);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).deleteProcessItem(this.processItem);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessItems().assertThat().entriesListDoesNotContain("id", this.processItem.getId());
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.SANITY}, description="Try to delete existing process item using invalid processId")
    @Test(groups={"rest-api", "workflow", "processes", "sanity"})
    public void deleteProcessItemUsingInvalidProcessId() throws Exception {
        this.processModel = ((RestProcessModel)this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().getProcesses().getOneRandomEntry()).onModel();
        this.document2 = ((DataContent)this.dataContent.usingAdmin().usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.MSPOWERPOINT);
        this.processItem = this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessItem(this.document2);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.processModel.setId("incorrectProcessId");
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).deleteProcessItem(this.processItem);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND);
    }
}

