/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.processes;

import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.JsonBodyGenerator;
import org.alfresco.rest.exception.JsonToModelConversionException;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestProcessModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class AddProcessFullTests
extends RestTest {
    private UserModel userWhoStartsProcess;
    private UserModel assignee;
    RestProcessModel addedProcess;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.assignee = this.dataUser.createRandomTestUser();
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Verify user cannot start new process with invalid processDefinitionKey using REST API and status code is 400")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void userStartsNewProcessWithInvalidProcessDefinitionKey() throws JsonToModelConversionException, Exception {
        this.userWhoStartsProcess = this.dataUser.createRandomTestUser();
        this.addedProcess = this.restClient.authenticateUser(this.userWhoStartsProcess).withWorkflowAPI().addProcess("activitiAdhocc", this.assignee, false, CMISUtil.Priority.Normal);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsErrorKey(String.format(RestErrorModel.NO_WORKFLOW_DEFINITION_FOUND, "activitiAdhocc")).containsSummary(String.format(RestErrorModel.NO_WORKFLOW_DEFINITION_FOUND, "activitiAdhocc")).stackTraceIs(RestErrorModel.STACKTRACE).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER);
    }

    @Bug(id="REPO-1970")
    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Verify user cannot start new process with invalid processDefinitionKey using REST API and status code is 400")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void userStartsNewProcessWithEmptyVariablesBody() throws JsonToModelConversionException, Exception {
        this.userWhoStartsProcess = this.dataUser.createRandomTestUser();
        JsonObject postJson = JsonBodyGenerator.defineJSON().add("processDefinitionKey", "activitiAdhoc").add("variables", (JsonValue)JsonBodyGenerator.defineJSON().build()).build();
        this.addedProcess = this.restClient.authenticateUser(this.userWhoStartsProcess).withWorkflowAPI().addProcessWithBody(postJson);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsErrorKey(String.format(RestErrorModel.NO_WORKFLOW_DEFINITION_FOUND, "activitiAdhoc"));
    }

    @Bug(id="REPO-1970")
    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Verify user cannot start new process with invalid processDefinitionKey using REST API and status code is 400")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void userStartsNewProcessWithNoAssigneeInVariablesBody() throws JsonToModelConversionException, Exception {
        this.userWhoStartsProcess = this.dataUser.createRandomTestUser();
        JsonObject postJson = JsonBodyGenerator.defineJSON().add("processDefinitionKey", "activitiAdhoc").add("variables", (JsonValue)JsonBodyGenerator.defineJSON().add("bpm_sendEMailNotifications", false).add("bpm_workflowPriority", CMISUtil.Priority.Low.getLevel()).build()).build();
        this.addedProcess = this.restClient.authenticateUser(this.userWhoStartsProcess).withWorkflowAPI().addProcessWithBody(postJson);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsErrorKey(String.format(RestErrorModel.NO_WORKFLOW_DEFINITION_FOUND, "activitiAdhoc"));
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Verify user cannot start new process with invalid assignee using REST API and status code is 400")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void userStartsNewProcessWithInvalidAssignee() throws JsonToModelConversionException, Exception {
        this.userWhoStartsProcess = this.dataUser.createRandomTestUser();
        UserModel invalidAssignee = new UserModel("invalidAssignee", "password");
        this.addedProcess = this.restClient.authenticateUser(this.userWhoStartsProcess).withWorkflowAPI().addProcess("activitiAdhoc", invalidAssignee, false, CMISUtil.Priority.Normal);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsErrorKey(String.format(RestErrorModel.INVALID_USER_ID, invalidAssignee.getUsername())).containsSummary(String.format(RestErrorModel.INVALID_USER_ID, invalidAssignee.getUsername())).stackTraceIs(RestErrorModel.STACKTRACE).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER);
    }

    @Bug(id="REPO-1970")
    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Verify user cannot start new process with invalid sendEMailNotifications value using REST API and status code is 400")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void userStartsNewProcessWithInvalidEmailNotification() throws JsonToModelConversionException, Exception {
        this.userWhoStartsProcess = this.dataUser.createRandomTestUser();
        JsonObject postJson = JsonBodyGenerator.defineJSON().add("processDefinitionKey", "activitiAdhoc").add("variables", (JsonValue)JsonBodyGenerator.defineJSON().add("bpm_assignee", this.assignee.getUsername()).add("bpm_sendEMailNotifications", "111").add("bpm_workflowPriority", CMISUtil.Priority.Low.getLevel()).build()).build();
        this.addedProcess = this.restClient.authenticateUser(this.userWhoStartsProcess).withWorkflowAPI().addProcessWithBody(postJson);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsErrorKey(String.format(RestErrorModel.UNSUPPORTED_TYPE, "111")).stackTraceIs(RestErrorModel.STACKTRACE).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER);
    }

    @Bug(id="REPO-1970")
    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Verify user cannot start new process with invalid priority using REST API and status code is 400")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void userStartsNewProcessWithInvalidPriority() throws JsonToModelConversionException, Exception {
        this.userWhoStartsProcess = this.dataUser.createRandomTestUser();
        JsonObject postJson = JsonBodyGenerator.defineJSON().add("processDefinitionKey", "activitiAdhoc").add("variables", (JsonValue)JsonBodyGenerator.defineJSON().add("bpm_assignee", this.assignee.getUsername()).add("bpm_sendEMailNotifications", false).add("bpm_workflowPriority", "test").build()).build();
        this.addedProcess = this.restClient.authenticateUser(this.userWhoStartsProcess).withWorkflowAPI().addProcessWithBody(postJson);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsErrorKey(String.format(RestErrorModel.UNSUPPORTED_TYPE, "test")).stackTraceIs(RestErrorModel.STACKTRACE).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER);
    }
}

