/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.processDefinitions;

import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestProcessDefinitionModel;
import org.alfresco.rest.model.RestProcessDefinitionModelsCollection;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetProcessDefinitionsFullTests
extends RestTest {
    private UserModel adminUserModel;
    private RestProcessDefinitionModelsCollection processDefinitions;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUserModel = this.dataUser.getAdminUser();
    }

    @TestRail(section={"rest-api", "workflow", "process-definitions"}, executionType={ExecutionType.REGRESSION}, description="Verify admin gets process definitions with valid skipCount parameter applied using REST API and status code is OK (200)")
    @Test(groups={"rest-api", "workflow", "process-definitions", "regression"})
    public void getProcessDefinitionsWithValidSkipCount() throws Exception {
        this.processDefinitions = this.restClient.authenticateUser(this.adminUserModel).withWorkflowAPI().getAllProcessDefinitions();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        RestProcessDefinitionModel firstProcessDefinition = ((RestProcessDefinitionModel)this.processDefinitions.getEntries().get(0)).onModel();
        RestProcessDefinitionModel secondProcessDefinition = ((RestProcessDefinitionModel)this.processDefinitions.getEntries().get(1)).onModel();
        RestProcessDefinitionModelsCollection procDefWithSkipCount = this.restClient.withParams(new String[]{"skipCount=2"}).withWorkflowAPI().getAllProcessDefinitions();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)procDefWithSkipCount.assertThat().entriesListDoesNotContain("name", firstProcessDefinition.getName())).assertThat().entriesListDoesNotContain("name", secondProcessDefinition.getName())).assertThat().entriesListCountIs(this.processDefinitions.getEntries().size() - 2);
        procDefWithSkipCount.assertThat().paginationField("skipCount").is("2");
    }

    @TestRail(section={"rest-api", "workflow", "process-definitions"}, executionType={ExecutionType.REGRESSION}, description="Verify admin doesn't get process definitions with negative skipCount parameter applied using REST API")
    @Test(groups={"rest-api", "workflow", "process-definitions", "regression"})
    public void getProcessDefinitionsWithNegativeSkipCount() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel).withParams(new String[]{"skipCount=-1"}).withWorkflowAPI().getAllProcessDefinitions();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(RestErrorModel.NEGATIVE_VALUES_SKIPCOUNT).containsErrorKey(RestErrorModel.NEGATIVE_VALUES_SKIPCOUNT).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE).statusCodeIs(HttpStatus.BAD_REQUEST);
    }

    @TestRail(section={"rest-api", "workflow", "process-definitions"}, executionType={ExecutionType.REGRESSION}, description="Verify admin doesn't get process definitions with non numeric skipCount parameter applied using REST API")
    @Test(groups={"rest-api", "workflow", "process-definitions", "regression"})
    public void getProcessDefinitionsWithNonNumericSkipCount() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel).withParams(new String[]{"skipCount=A"}).withWorkflowAPI().getAllProcessDefinitions();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.INVALID_SKIPCOUNT, "A"));
    }

    @TestRail(section={"rest-api", "workflow", "process-definitions"}, executionType={ExecutionType.REGRESSION}, description="Verify admin gets process definitions with valid maxItems parameter applied using REST API and status code is OK (200)")
    @Test(groups={"rest-api", "workflow", "process-definitions", "regression"})
    public void getProcessDefinitionsWithValidMaxItems() throws Exception {
        this.processDefinitions = this.restClient.authenticateUser(this.adminUserModel).withWorkflowAPI().getAllProcessDefinitions();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        RestProcessDefinitionModel firstProcessDefinition = ((RestProcessDefinitionModel)this.processDefinitions.getEntries().get(0)).onModel();
        RestProcessDefinitionModel secondProcessDefinition = ((RestProcessDefinitionModel)this.processDefinitions.getEntries().get(1)).onModel();
        RestProcessDefinitionModelsCollection procDefWithMaxItems = this.restClient.withParams(new String[]{"maxItems=2"}).withWorkflowAPI().getAllProcessDefinitions();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)procDefWithMaxItems.assertThat().entriesListContains("name", firstProcessDefinition.getName())).assertThat().entriesListContains("name", secondProcessDefinition.getName())).assertThat().entriesListCountIs(2);
        procDefWithMaxItems.assertThat().paginationField("maxItems").is("2");
    }

    @TestRail(section={"rest-api", "workflow", "process-definitions"}, executionType={ExecutionType.REGRESSION}, description="Verify admin doesn't get process definitions with negative maxItems parameter applied using REST API")
    @Test(groups={"rest-api", "workflow", "process-definitions", "regression"})
    public void getProcessDefinitionsWithNegativeMaxItems() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel).withParams(new String[]{"maxItems=-1"}).withWorkflowAPI().getAllProcessDefinitions();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(RestErrorModel.ONLY_POSITIVE_VALUES_MAXITEMS).containsErrorKey(RestErrorModel.ONLY_POSITIVE_VALUES_MAXITEMS).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE).statusCodeIs(HttpStatus.BAD_REQUEST);
    }

    @TestRail(section={"rest-api", "workflow", "process-definitions"}, executionType={ExecutionType.REGRESSION}, description="Verify admin doesn't get process definitions with non numeric maxItems parameter applied using REST API")
    @Test(groups={"rest-api", "workflow", "process-definitions", "regression"})
    public void getProcessDefinitionsWithNonNumericMaxItems() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel).withParams(new String[]{"maxItems=A"}).withWorkflowAPI().getAllProcessDefinitions();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.INVALID_MAXITEMS, "A"));
    }

    @TestRail(section={"rest-api", "workflow", "process-definitions"}, executionType={ExecutionType.REGRESSION}, description="Verify Admin user gets process definitions with properties parameter applied using REST API and status code is OK (200)")
    @Test(groups={"rest-api", "workflow", "process-definitions", "regression"})
    public void getProcessDefinitionsWithValidProperties() throws Exception {
        this.processDefinitions = this.restClient.authenticateUser(this.adminUserModel).withParams(new String[]{"properties=name,graphicNotationDefined,version"}).withWorkflowAPI().getAllProcessDefinitions();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.processDefinitions.assertThat().entriesListIsNotEmpty();
        ((RestProcessDefinitionModel)((RestProcessDefinitionModel)((RestProcessDefinitionModel)((RestProcessDefinitionModel)((RestProcessDefinitionModel)((RestProcessDefinitionModel)((RestProcessDefinitionModel)((RestProcessDefinitionModel)((RestProcessDefinitionModel)((RestProcessDefinitionModel)((RestProcessDefinitionModel)this.processDefinitions.getOneRandomEntry()).onModel().assertThat().fieldsCount().is((Object)3)).and().field("deploymentId").isNull()).and().field("description").isNull()).and().field("id").isNull()).and().field("startFormResourceKey").isNull()).and().field("category").isNull()).and().field("title").isNull()).and().field("version").isNotEmpty()).and().field("graphicNotationDefined").isNotEmpty()).and().field("key").isNull()).and().field("name").isNotEmpty();
    }

    @TestRail(section={"rest-api", "workflow", "process-definitions"}, executionType={ExecutionType.REGRESSION}, description="Verify admin gets process definitions ordered by name ascendant using REST API and status code is OK (200)")
    @Test(groups={"rest-api", "workflow", "process-definitions", "regression"})
    public void getProcessDefinitionsOrderedByNameAsc() throws Exception {
        this.processDefinitions = this.restClient.authenticateUser(this.adminUserModel).withParams(new String[]{"orderBy=name ASC"}).withWorkflowAPI().getAllProcessDefinitions();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.processDefinitions.assertThat().entriesListIsSortedAscBy("name");
    }

    @TestRail(section={"rest-api", "workflow", "process-definitions"}, executionType={ExecutionType.REGRESSION}, description="Verify admin doesn't get process definitions when many fields are used for orderBy parameter")
    @Test(groups={"rest-api", "workflow", "process-definitions", "regression"})
    public void getProcessDefinitionsOrderedByManyFields() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel).withParams(new String[]{"orderBy=name,id"}).withWorkflowAPI().getAllProcessDefinitions();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(RestErrorModel.ONLY_ONE_ORDERBY);
    }

    @TestRail(section={"rest-api", "workflow", "process-definitions"}, executionType={ExecutionType.REGRESSION}, description="Verify admin gets process definitions when where parameter is applied")
    @Test(groups={"rest-api", "workflow", "process-definitions", "regression"})
    public void getProcessDefinitionsFilteredByKey() throws Exception {
        this.processDefinitions = this.restClient.authenticateUser(this.adminUserModel).withParams(new String[]{"where=(key matches('activitiParallel%'))"}).withWorkflowAPI().getAllProcessDefinitions();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)this.processDefinitions.assertThat().entriesListCountIs(2)).assertThat().entriesListContains("key", "activitiParallelReview")).assertThat().entriesListContains("key", "activitiParallelGroupReview");
    }
}

