/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rules;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestRuleModel;
import org.alfresco.rest.model.RestRuleModelsCollection;
import org.alfresco.rest.model.RestRuleSetLinkModel;
import org.alfresco.rest.model.RestRuleSetModel;
import org.alfresco.rest.model.RestRuleSetModelsCollection;
import org.alfresco.rest.requests.Node;
import org.alfresco.rest.rules.RulesRestTest;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"rules"})
public class RuleSetLinksTests
extends RulesRestTest {
    private UserModel user;
    private SiteModel site;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() {
        Step.STEP((String)"Create a user and site.");
        this.user = this.dataUser.createRandomTestUser();
        this.site = ((DataSite)this.dataSite.usingUser(this.user)).createPublicRandomSite();
    }

    @Test(groups={"rest-api", "rules"})
    public void linkToFolderContainingRules() {
        Step.STEP((String)"Create folders in existing site");
        FolderModel ruleFolder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder();
        FolderModel folder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder();
        Step.STEP((String)"Create a rule in the rule folder.");
        RestRuleModel ruleModel = this.rulesUtils.createRuleModel("ruleName");
        RestRuleModel rule = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)ruleFolder).usingDefaultRuleSet().createSingleRule(ruleModel);
        Step.STEP((String)"Get the rule sets for the folder and find the rule set id");
        RestRuleSetModelsCollection ruleSets = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)ruleFolder).getListOfRuleSets();
        ruleSets.assertThat().entriesListCountIs(1);
        String ruleSetId = ((RestRuleSetModel)ruleSets.getEntries().get(0)).onModel().getId();
        Step.STEP((String)"Link to a rule folder");
        RestRuleSetLinkModel request = new RestRuleSetLinkModel();
        request.setId(ruleFolder.getNodeRef());
        RestRuleSetLinkModel ruleLink = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)folder).createRuleLink(request);
        Step.STEP((String)"Assert link result");
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        RestRuleSetLinkModel expectedLink = new RestRuleSetLinkModel();
        expectedLink.setId(ruleSetId);
        ruleLink.assertThat().isEqualTo((Object)expectedLink, new String[0]);
        Step.STEP((String)"Check if folder returns same rules");
        RestRuleModelsCollection linkedRules = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)folder).usingDefaultRuleSet().getListOfRules();
        linkedRules.assertThat().entriesListCountIs(1);
        ((RestRuleModel)linkedRules.getEntries().get(0)).onModel().assertThat().isEqualTo((Object)rule, new String[0]);
        Step.STEP((String)"Check if folder returns rule set with linked inclusionType");
        RestRuleSetModelsCollection linkedRuleSets = ((Node)this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)folder).include(new String[]{"inclusionType"})).getListOfRuleSets();
        linkedRuleSets.assertThat().entriesListCountIs(1);
        RestRuleSetModel expectedRuleSet = new RestRuleSetModel();
        expectedRuleSet.setId(ruleSetId);
        expectedRuleSet.setInclusionType("linked");
        ((RestRuleSetModel)linkedRuleSets.getEntries().get(0)).onModel().assertThat().isEqualTo((Object)expectedRuleSet, new String[0]);
    }

    @Test(groups={"rest-api", "rules"})
    public void linkToRuleSet() {
        Step.STEP((String)"Create folders in existing site");
        FolderModel ruleFolder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder();
        FolderModel folder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder();
        Step.STEP((String)"Create a rule in the rule folder.");
        RestRuleModel ruleModel = this.rulesUtils.createRuleModel("ruleName");
        RestRuleModel rule = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)ruleFolder).usingDefaultRuleSet().createSingleRule(ruleModel);
        Step.STEP((String)"Get the rule sets for the folder and find the rule set id");
        RestRuleSetModelsCollection ruleSets = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)ruleFolder).getListOfRuleSets();
        ruleSets.assertThat().entriesListCountIs(1);
        String ruleSetId = ((RestRuleSetModel)ruleSets.getEntries().get(0)).onModel().getId();
        Step.STEP((String)"Link to a rule set");
        RestRuleSetLinkModel request = new RestRuleSetLinkModel();
        request.setId(ruleSetId);
        RestRuleSetLinkModel ruleLink = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)folder).createRuleLink(request);
        Step.STEP((String)"Assert link result");
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        RestRuleSetLinkModel expectedLink = new RestRuleSetLinkModel();
        expectedLink.setId(ruleSetId);
        ruleLink.assertThat().isEqualTo((Object)expectedLink, new String[0]);
        Step.STEP((String)"Check if folder returns same rules");
        RestRuleModelsCollection linkedRules = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)folder).usingDefaultRuleSet().getListOfRules();
        linkedRules.assertThat().entriesListCountIs(1);
        ((RestRuleModel)linkedRules.getEntries().get(0)).onModel().assertThat().isEqualTo((Object)rule, new String[0]);
        Step.STEP((String)"Check if folder returns rule set with linked inclusionType");
        RestRuleSetModelsCollection likedRuleSets = ((Node)this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)folder).include(new String[]{"inclusionType"})).getListOfRuleSets();
        likedRuleSets.assertThat().entriesListCountIs(1);
        RestRuleSetModel expectedRuleSet = new RestRuleSetModel();
        expectedRuleSet.setId(ruleSetId);
        expectedRuleSet.setInclusionType("linked");
        ((RestRuleSetModel)likedRuleSets.getEntries().get(0)).onModel().assertThat().isEqualTo((Object)expectedRuleSet, new String[0]);
    }

    @Test(groups={"rest-api", "rules"})
    public void linkFromFolderWithInheritedRules() {
        Step.STEP((String)"Create folders");
        FolderModel parentFolder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder();
        FolderModel childFolder = ((DataContent)this.dataContent.usingUser(this.user).usingResource((ContentModel)parentFolder)).createFolder();
        FolderModel linkedToFolder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder();
        Step.STEP((String)"Create rules in the parent folder and the linking folder");
        RestRuleModel parentRule = this.rulesUtils.createInheritableRuleModel();
        parentRule = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)parentFolder).usingDefaultRuleSet().createSingleRule(parentRule);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        RestRuleModel linkingFolderRule = this.rulesUtils.createRuleModelWithDefaultValues();
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)linkedToFolder).usingDefaultRuleSet().createSingleRule(linkingFolderRule);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        Step.STEP((String)"Get the rule sets for the linking folder and find the rule set id");
        RestRuleSetModelsCollection ruleSets = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)linkedToFolder).getListOfRuleSets();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ruleSets.assertThat().entriesListCountIs(1);
        String ruleSetId = ((RestRuleSetModel)ruleSets.getEntries().get(0)).onModel().getId();
        Step.STEP((String)"Link the child folder to the target folder");
        RestRuleSetLinkModel request = new RestRuleSetLinkModel();
        request.setId(linkedToFolder.getNodeRef());
        RestRuleSetLinkModel ruleLink = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)childFolder).createRuleLink(request);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        Step.STEP((String)"Assert link result");
        RestRuleSetLinkModel expectedLink = new RestRuleSetLinkModel();
        expectedLink.setId(ruleSetId);
        ruleLink.assertThat().isEqualTo((Object)expectedLink, new String[0]);
        Step.STEP((String)"Assert that the child folder has also inherited the parent rule");
        RestRuleSetModelsCollection ruleSetsInh = ((Node)this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)childFolder).include(new String[]{"inclusionType"})).getListOfRuleSets();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        String inheritedRuleSetId = ruleSetsInh.getEntries().stream().filter(ruleSet -> ruleSet.onModel().getInclusionType().equals("inherited")).findFirst().get().onModel().getId();
        RestRuleModelsCollection inheritedRules = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)childFolder).usingRuleSet(inheritedRuleSetId).getListOfRules();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)inheritedRules.assertThat().entriesListContains("id", parentRule.getId())).and().entriesListCountIs(1);
    }

    @Test(groups={"rest-api", "rules"})
    public void linkToNonExistingRuleSet() {
        Step.STEP((String)"Create a folder in existing site");
        FolderModel folder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder();
        Step.STEP((String)"Link to non-existing rule set");
        RestRuleSetLinkModel request = new RestRuleSetLinkModel();
        request.setId("dummy-rule-set-id");
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)folder).createRuleLink(request);
        Step.STEP((String)"Assert link result is 404");
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND);
    }

    @Test(groups={"rest-api", "rules"})
    public void linkToFolderWithoutRules() {
        Step.STEP((String)"Create 2 folders without rules in existing site");
        FolderModel folder1 = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder();
        FolderModel folder2 = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder();
        Step.STEP((String)"Link to a folder without rules");
        RestRuleSetLinkModel request = new RestRuleSetLinkModel();
        request.setId(folder2.getNodeRef());
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)folder1).createRuleLink(request);
        Step.STEP((String)"Assert link result is 400");
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary("The target node has no rules to link.");
    }

    @Test(groups={"rest-api", "rules"})
    public void linkFromFolderWithRules() {
        Step.STEP((String)"Create folders in existing site");
        FolderModel folder1 = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder();
        FolderModel folder2 = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder();
        Step.STEP((String)"Create rules in both folders.");
        RestRuleModel ruleModel1 = this.rulesUtils.createRuleModel("ruleName1");
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)folder1).usingDefaultRuleSet().createSingleRule(ruleModel1);
        RestRuleModel ruleModel2 = this.rulesUtils.createRuleModel("ruleName2");
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)folder2).usingDefaultRuleSet().createSingleRule(ruleModel2);
        Step.STEP((String)"Link from a folder with rules");
        RestRuleSetLinkModel request = new RestRuleSetLinkModel();
        request.setId(folder2.getNodeRef());
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)folder1).createRuleLink(request);
        Step.STEP((String)"Assert link result is 400");
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary("Unable to link to a rule set because the folder has pre-existing rules or is already linked to a rule set.");
    }

    @Test(groups={"rest-api", "rules"})
    public void linkToFileNode() {
        Step.STEP((String)"Create a folder in existing site");
        FolderModel folder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder();
        FileModel fileContent = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        Step.STEP((String)"Link to a file node");
        RestRuleSetLinkModel request = new RestRuleSetLinkModel();
        request.setId(fileContent.getNodeRef());
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)folder).createRuleLink(request);
        Step.STEP((String)"Assert link result is 400");
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary("NodeId of a folder is expected!");
    }

    @Test(groups={"rest-api", "rules"})
    public void linkToParentNodeWithRules() {
        Step.STEP((String)"Create parent/child folders in existing site");
        FolderModel parentFolder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder();
        FolderModel childFolder = ((DataContent)((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).usingResource((ContentModel)parentFolder)).createFolder();
        Step.STEP((String)"Create a rule in the parent folder.");
        RestRuleModel ruleModel = this.rulesUtils.createRuleModel("ruleName");
        RestRuleModel rule = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)parentFolder).usingDefaultRuleSet().createSingleRule(ruleModel);
        Step.STEP((String)"Get the rule sets for the folder and find the rule set id");
        RestRuleSetModelsCollection ruleSets = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)parentFolder).getListOfRuleSets();
        ruleSets.assertThat().entriesListCountIs(1);
        String ruleSetId = ((RestRuleSetModel)ruleSets.getEntries().get(0)).onModel().getId();
        Step.STEP((String)"Link to the parent folder");
        RestRuleSetLinkModel request = new RestRuleSetLinkModel();
        request.setId(parentFolder.getNodeRef());
        RestRuleSetLinkModel ruleLink = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)childFolder).createRuleLink(request);
        Step.STEP((String)"Assert link result");
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        RestRuleSetLinkModel expectedLink = new RestRuleSetLinkModel();
        expectedLink.setId(ruleSetId);
        ruleLink.assertThat().isEqualTo((Object)expectedLink, new String[0]);
        Step.STEP((String)"Check if child folder returns same rules");
        RestRuleModelsCollection linkedRules = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)childFolder).usingDefaultRuleSet().getListOfRules();
        linkedRules.assertThat().entriesListCountIs(1);
        ((RestRuleModel)linkedRules.getEntries().get(0)).onModel().assertThat().isEqualTo((Object)rule, new String[0]);
        Step.STEP((String)"Check if child folder returns rule set with linked inclusionType");
        RestRuleSetModelsCollection linkedRuleSets = ((Node)this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)childFolder).include(new String[]{"inclusionType"})).getListOfRuleSets();
        linkedRuleSets.assertThat().entriesListCountIs(1);
        RestRuleSetModel expectedRuleSet = new RestRuleSetModel();
        expectedRuleSet.setId(ruleSetId);
        expectedRuleSet.setInclusionType("linked");
        ((RestRuleSetModel)linkedRuleSets.getEntries().get(0)).onModel().assertThat().isEqualTo((Object)expectedRuleSet, new String[0]);
    }

    @Test(groups={"rest-api", "rules"})
    public void linkToRuleSetWithoutPermission() {
        Step.STEP((String)"Use admin to create a private site with a folder containing a rule.");
        SiteModel privateSite = ((DataSite)this.dataSite.usingAdmin()).createPrivateRandomSite();
        FolderModel privateFolder = ((DataContent)this.dataContent.usingAdmin().usingSite(privateSite)).createFolder();
        this.restClient.authenticateUser(this.dataUser.getAdminUser()).withPrivateAPI().usingNode((RepoTestModel)privateFolder).usingDefaultRuleSet().createSingleRule(this.rulesUtils.createRuleModelWithDefaultValues());
        Step.STEP((String)"Use a normal user to try to link to the rule.");
        FolderModel publicFolder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder();
        RestRuleSetLinkModel request = new RestRuleSetLinkModel();
        request.setId(privateFolder.getNodeRef());
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)publicFolder).createRuleLink(request);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN);
    }

    @Test(groups={"rest-api", "rules"})
    public void linkToRuleSetWithOnlyReadPermission() {
        Step.STEP((String)"Use admin to create a private site with a folder containing a rule.");
        SiteModel privateSite = ((DataSite)this.dataSite.usingAdmin()).createPrivateRandomSite();
        FolderModel privateFolder = ((DataContent)this.dataContent.usingAdmin().usingSite(privateSite)).createFolder();
        this.restClient.authenticateUser(this.dataUser.getAdminUser()).withPrivateAPI().usingNode((RepoTestModel)privateFolder).usingDefaultRuleSet().createSingleRule(this.rulesUtils.createRuleModelWithDefaultValues());
        Step.STEP((String)"Add the normal user as a consumer.");
        ((DataUser)this.dataUser.usingAdmin()).addUserToSite(this.user, privateSite, UserRole.SiteConsumer);
        Step.STEP((String)"Use a normal user to try to link to the rule.");
        FolderModel publicFolder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder();
        RestRuleSetLinkModel request = new RestRuleSetLinkModel();
        request.setId(privateFolder.getNodeRef());
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)publicFolder).createRuleLink(request);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
    }

    @Test(groups={"rest-api", "rules"})
    public void unlinkRuleSet() {
        Step.STEP((String)"Create folders in existing site");
        FolderModel ruleFolder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder();
        FolderModel folder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder();
        Step.STEP((String)"Create a rule in the rule folder.");
        RestRuleModel ruleModel = this.rulesUtils.createRuleModel("ruleName");
        RestRuleModel rule = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)ruleFolder).usingDefaultRuleSet().createSingleRule(ruleModel);
        Step.STEP((String)"Get the rule sets for the folder and find the rule set id");
        RestRuleSetModelsCollection ruleSets = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)ruleFolder).getListOfRuleSets();
        ruleSets.assertThat().entriesListCountIs(1);
        String ruleSetId = ((RestRuleSetModel)ruleSets.getEntries().get(0)).onModel().getId();
        Step.STEP((String)"Link to a rule folder");
        RestRuleSetLinkModel request = new RestRuleSetLinkModel();
        request.setId(ruleFolder.getNodeRef());
        RestRuleSetLinkModel ruleLink = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)folder).createRuleLink(request);
        Step.STEP((String)"Unlink the rule set");
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)folder).unlinkRuleSet(ruleSetId);
        Step.STEP((String)"Assert unlink result");
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        Step.STEP((String)"GET the rule set and isLinkedTo field.");
        RestRuleSetModel ruleSet = ((Node)this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)ruleFolder).include(new String[]{"isLinkedTo", "linkedToBy", "owningFolder"})).getDefaultRuleSet();
        Step.STEP((String)"Assert linkedTo is false.");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestRuleSetModel)ruleSet.assertThat().field("isLinkedTo").is((Object)false)).assertThat().field("linkedToBy").isEmpty();
    }

    @Test(groups={"rest-api", "rules"})
    public void unlinkUsingDocumentId() {
        Step.STEP((String)"Create folders in existing site");
        FolderModel folder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder();
        Step.STEP((String)"Attempt to unlink the rule set");
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)folder).unlinkRuleSet(folder.getNodeRef());
        Step.STEP((String)"Assert unlink result");
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary("NodeId of a rule set is expected!");
    }

    @Test(groups={"rest-api", "rules"})
    public void unlinkUsingRandomId() {
        Step.STEP((String)"Create folders in existing site");
        FolderModel folder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder();
        Step.STEP((String)"Attempt to unlink the rule set");
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)folder).unlinkRuleSet("non-existent-id");
        Step.STEP((String)"Assert unlink result");
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary("Rule set with id non-existent-id was not found");
    }

    @Test(groups={"rest-api", "rules"})
    public void unlinkFromRuleSetWithoutPermission() {
        Step.STEP((String)"Use admin to create a private site with a folder containing a rule.");
        SiteModel privateSite = ((DataSite)this.dataSite.usingAdmin()).createPrivateRandomSite();
        FolderModel privateFolder = ((DataContent)this.dataContent.usingAdmin().usingSite(privateSite)).createFolder();
        this.restClient.authenticateUser(this.dataUser.getAdminUser()).withPrivateAPI().usingNode((RepoTestModel)privateFolder).usingDefaultRuleSet().createSingleRule(this.rulesUtils.createRuleModelWithDefaultValues());
        Step.STEP((String)"Add the user as a consumer.");
        ((DataUser)this.dataUser.usingAdmin()).addUserToSite(this.user, privateSite, UserRole.SiteConsumer);
        Step.STEP((String)"Use the consumer to create a folder with a link to the private rule set.");
        FolderModel publicFolder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder();
        RestRuleSetLinkModel request = new RestRuleSetLinkModel();
        request.setId(privateFolder.getNodeRef());
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)publicFolder).createRuleLink(request);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        Step.STEP((String)"Remove the user from the private site.");
        ((DataUser)this.dataUser.usingAdmin()).removeUserFromSite(this.user, privateSite);
        Step.STEP((String)"Use the user to try to unlink from the rule set.");
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)publicFolder).unlinkRuleSet("-default-");
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN);
    }

    @Test(groups={"rest-api", "rules"})
    public void unlinkFromRuleSetWithOnlyReadPermission() {
        Step.STEP((String)"Use admin to create a private site with a folder containing a rule.");
        SiteModel privateSite = ((DataSite)this.dataSite.usingAdmin()).createPrivateRandomSite();
        FolderModel privateFolder = ((DataContent)this.dataContent.usingAdmin().usingSite(privateSite)).createFolder();
        this.restClient.authenticateUser(this.dataUser.getAdminUser()).withPrivateAPI().usingNode((RepoTestModel)privateFolder).usingDefaultRuleSet().createSingleRule(this.rulesUtils.createRuleModelWithDefaultValues());
        Step.STEP((String)"Add the user as a consumer.");
        ((DataUser)this.dataUser.usingAdmin()).addUserToSite(this.user, privateSite, UserRole.SiteConsumer);
        Step.STEP((String)"Use the consumer to create a folder with a link to the private rule set.");
        FolderModel publicFolder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder();
        RestRuleSetLinkModel request = new RestRuleSetLinkModel();
        request.setId(privateFolder.getNodeRef());
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)publicFolder).createRuleLink(request);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        Step.STEP((String)"Use the consumer to try to unlink from the rule set.");
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)publicFolder).unlinkRuleSet("-default-");
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
    }
}

