/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.processes;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestProcessModel;
import org.alfresco.utility.model.ProcessModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class DeleteProcessCoreTests
extends RestTest {
    private UserModel userWhoAddsProcess;
    private UserModel assignee;
    private RestProcessModel process;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.userWhoAddsProcess = this.dataUser.createRandomTestUser();
        this.assignee = this.dataUser.createRandomTestUser();
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Verify admin user is able to delete a process started by another user.")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void deleteProcessByAdminUser() throws Exception {
        this.process = this.restClient.authenticateUser(this.userWhoAddsProcess).withWorkflowAPI().addProcess("activitiAdhoc", this.assignee, false, CMISUtil.Priority.Normal);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.authenticateUser(this.dataUser.getAdminUser()).withWorkflowAPI().usingProcess((ProcessModel)this.process).deleteProcess();
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withWorkflowAPI().getProcesses().assertThat().entriesListDoesNotContain("id", this.process.getId());
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Verify User is not able to delete process with invalid id")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void deleteProcessWithInvalidId() throws Exception {
        this.process = this.restClient.authenticateUser(this.userWhoAddsProcess).withWorkflowAPI().addProcess("activitiAdhoc", this.assignee, false, CMISUtil.Priority.Normal);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.process.setId("00001");
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.process).deleteProcess();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, "00001"));
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Verify User is not able to delete process with empty id")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void deleteProcessWithEmptyId() throws Exception {
        this.process = this.restClient.authenticateUser(this.userWhoAddsProcess).withWorkflowAPI().addProcess("activitiAdhoc", this.assignee, false, CMISUtil.Priority.Normal);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.process.setId("");
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.process).deleteProcess();
        this.restClient.assertStatusCodeIs(HttpStatus.METHOD_NOT_ALLOWED).assertLastError().containsSummary(RestErrorModel.DELETE_EMPTY_ARGUMENT);
    }
}

