/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.deployments;

import java.util.List;
import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestDeploymentModel;
import org.alfresco.rest.model.RestDeploymentModelsCollection;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestProcessDefinitionModel;
import org.alfresco.rest.model.RestProcessModel;
import org.alfresco.rest.model.RestTaskModel;
import org.alfresco.utility.model.ProcessModel;
import org.alfresco.utility.model.TaskModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class DeleteDeploymentTests
extends RestTest {
    private UserModel adminUser;
    private UserModel userModel;
    private RestDeploymentModel deployment;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.userModel = this.dataUser.createRandomTestUser();
    }

    @Bug(id="REPO-1930")
    @TestRail(section={"rest-api", "workflow", "deployments"}, executionType={ExecutionType.SANITY}, description="Verify admin user deletes a specific deployment using REST API and status code is successful (204)")
    @Test(groups={"rest-api", "deployments", "sanity", "workflow"}, priority=100)
    public void adminDeletesDeploymentWithSuccess() throws Exception {
        this.dataContent.assertExtensionAmpExists("alfresco-workflow-extension");
        RestDeploymentModelsCollection allDeployments = this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().getDeployments();
        allDeployments.assertThat().entriesListContains("name", "customWorkflowExtentionForRest.bpmn");
        this.deployment = allDeployments.getDeploymentByName("customWorkflowExtentionForRest.bpmn");
        RestProcessDefinitionModel processDefinitionAssociated = this.restClient.withWorkflowAPI().getAllProcessDefinitions().getProcessDefinitionById(this.deployment.getId());
        RestProcessModel addedProcess = this.restClient.withWorkflowAPI().addProcess(processDefinitionAssociated.getName(), this.adminUser, false, CMISUtil.Priority.Normal);
        List processTasks = this.restClient.withWorkflowAPI().usingProcess((ProcessModel)addedProcess).getProcessTasks().getEntries();
        this.restClient.withWorkflowAPI().usingDeployment(this.deployment).deleteDeployment();
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withWorkflowAPI().usingDeployment(this.deployment).getDeployment();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, this.deployment.getId()));
        this.restClient.withWorkflowAPI().usingProcessDefinitions(processDefinitionAssociated).getProcessDefinition();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, processDefinitionAssociated.getId()));
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)addedProcess).getProcess();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, addedProcess.getId()));
        for (RestTaskModel processTask : processTasks) {
            this.restClient.withWorkflowAPI().usingTask((TaskModel)processTask).getTask();
            this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, processTask.getId()));
        }
        this.restClient.withWorkflowAPI().usingProcessDefinitions(processDefinitionAssociated).getProcessDefinitionStartFormModel();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, processDefinitionAssociated.getId()));
        this.restClient.withWorkflowAPI().usingProcessDefinitions(processDefinitionAssociated).getProcessDefinitionImage();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, processDefinitionAssociated.getId()));
        this.restClient.withWorkflowAPI().usingDeployment(this.deployment).deleteDeployment();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, this.deployment.getId())).containsErrorKey(RestErrorModel.ENTITY_NOT_FOUND_ERRORKEY).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Bug(id="REPO-1930")
    @TestRail(section={"rest-api", "workflow", "deployments"}, executionType={ExecutionType.SANITY}, description="Verify admin user cannot delete an inexistent deployment using REST API and status code is successful (204)")
    @Test(groups={"rest-api", "deployments", "sanity", "workflow"}, priority=100)
    public void adminCannotDeleteInexistentDeployment() throws Exception {
        this.deployment = ((RestDeploymentModel)this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().getDeployments().getOneRandomEntry()).onModel();
        this.deployment.setId(String.valueOf(1000));
        this.restClient.withWorkflowAPI().usingDeployment(this.deployment).deleteDeployment();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, "1000"));
    }

    @Bug(id="REPO-1930")
    @TestRail(section={"rest-api", "workflow", "deployments"}, executionType={ExecutionType.REGRESSION}, description="Verify deleteDeployment is unsupported for empty deployment id with REST API and status code is 404")
    @Test(groups={"rest-api", "deployments", "regression", "workflow"})
    public void deleteDeploymentIsUnsupportedForEmptyId() throws Exception {
        this.deployment = ((RestDeploymentModel)this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().getDeployments().getOneRandomEntry()).onModel();
        this.deployment.setId("");
        this.restClient.withWorkflowAPI().usingDeployment(this.deployment).deleteDeployment();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, ""));
    }

    @Bug(id="REPO-1930")
    @TestRail(section={"rest-api", "workflow", "deployments"}, executionType={ExecutionType.REGRESSION}, description="Verify deleteDeployment is forbidden using non admin user or different user than creator with REST API and status code is 403")
    @Test(groups={"rest-api", "deployments", "regression", "workflow"})
    public void deleteDeploymentUsingNonAdminUser() throws Exception {
        this.deployment = ((RestDeploymentModel)this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().getDeployments().getOneRandomEntry()).onModel();
        this.restClient.authenticateUser(this.userModel).withWorkflowAPI().usingDeployment(this.deployment).deleteDeployment();
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }
}

