/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.ratings;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.model.RestAggregateModel;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestRatingModel;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.exception.DataPreparationException;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class GetRatingTests
extends RestTest {
    private SiteModel siteModel;
    private UserModel adminUser;
    private UserModel userModel;
    private UserModel managerUser;
    private FileModel document;
    private DataUser.ListUserWithRoles usersWithRoles;
    private RestRatingModel restRatingModel;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws DataPreparationException {
        this.adminUser = this.dataUser.getAdminUser();
        this.userModel = this.dataUser.createRandomTestUser();
        this.managerUser = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.adminUser)).createPublicRandomSite();
        this.usersWithRoles = this.dataUser.addUsersWithRolesToSite(this.siteModel, new UserRole[]{UserRole.SiteManager, UserRole.SiteCollaborator, UserRole.SiteConsumer, UserRole.SiteContributor});
        this.dataUser.addUserToSite(this.managerUser, this.siteModel, UserRole.SiteManager);
    }

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.document = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingAdmin().createContent(CMISUtil.DocumentType.TEXT_PLAIN);
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.SANITY}, description="Verify user with Manager role is able to retrieve rating of a document")
    @Test(groups={"rest-api", "ratings", "sanity"})
    public void managerIsAbleToRetrieveRating() throws Exception {
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager));
        this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).likeDocument();
        this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).rateStarsToDocument(5);
        this.restRatingModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).getLikeRating();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestRatingModel)this.restRatingModel.assertThat().field("id").is((Object)"likes")).and().field("myRating").is((Object)"true");
        this.restRatingModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).getFiveStarRating();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestRatingModel)this.restRatingModel.assertThat().field("id").is((Object)"fiveStar")).and().field("myRating").is((Object)"5");
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Verify user with Collaborator role is able to retrieve rating of a document")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void collaboratorIsAbleToRetrieveRating() throws Exception {
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator));
        this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).likeDocument();
        this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).rateStarsToDocument(5);
        this.restRatingModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).getLikeRating();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestRatingModel)this.restRatingModel.assertThat().field("id").is((Object)"likes")).and().field("myRating").is((Object)"true");
        this.restRatingModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).getFiveStarRating();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestRatingModel)this.restRatingModel.assertThat().field("id").is((Object)"fiveStar")).and().field("myRating").is((Object)"5");
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Verify user with Contributor role is able to retrieve rating of a document")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void contributorIsAbleToRetrieveRating() throws Exception {
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor));
        this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).likeDocument();
        this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).rateStarsToDocument(5);
        this.restRatingModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).getLikeRating();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestRatingModel)this.restRatingModel.assertThat().field("id").is((Object)"likes")).and().field("myRating").is((Object)"true");
        this.restRatingModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).getFiveStarRating();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestRatingModel)this.restRatingModel.assertThat().field("id").is((Object)"fiveStar")).and().field("myRating").is((Object)"5");
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Verify user with Consumer role is able to retrieve rating of a document")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void consumerIsAbleToRetrieveRating() throws Exception {
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer));
        this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).likeDocument();
        this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).rateStarsToDocument(5);
        this.restRatingModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).getLikeRating();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestRatingModel)this.restRatingModel.assertThat().field("id").is((Object)"likes")).and().field("myRating").is((Object)"true");
        this.restRatingModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).getFiveStarRating();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestRatingModel)this.restRatingModel.assertThat().field("id").is((Object)"fiveStar")).and().field("myRating").is((Object)"5");
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Verify admin user is able to retrieve rating of a document")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void adminIsAbleToRetrieveRating() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.siteModel)).createFolder();
        FileModel document = ((DataContent)this.dataContent.usingUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.adminUser);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).likeDocument();
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).rateStarsToDocument(5);
        this.restRatingModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)document).getLikeRating();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestRatingModel)this.restRatingModel.assertThat().field("id").is((Object)"likes")).and().field("myRating").is((Object)"true");
        this.restRatingModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)document).getFiveStarRating();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestRatingModel)this.restRatingModel.assertThat().field("id").is((Object)"fiveStar")).and().field("myRating").is((Object)"5");
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.SANITY}, description="Verify unauthenticated user is not able to retrieve rating of a document")
    @Test(groups={"rest-api", "ratings", "sanity"})
    public void unauthenticatedUserIsNotAbleToRetrieveRating() throws Exception {
        this.restClient.authenticateUser(this.adminUser);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).likeDocument();
        this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).rateStarsToDocument(5);
        this.restClient.authenticateUser(new UserModel("random user", "random password"));
        this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).getLikeRating();
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).getFiveStarRating();
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Check that using invalid ratingId for get rating call returns status code 400.")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void checkInvalidRatingIdStatusCode() throws Exception {
        this.restClient.authenticateUser(this.adminUser).withCoreAPI();
        RestRequest request = RestRequest.simpleRequest((HttpMethod)HttpMethod.GET, (String)"nodes/{nodeId}/ratings/{ratingId}", (String[])new String[]{this.document.getNodeRef(), "invalid ratingId"});
        this.restClient.processModel(RestRatingModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.INVALID_RATING, "invalid ratingId"));
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Check that using invalid node ID for get rating call returns status code 404.")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void getRatingUsingInvalidNodeId() throws Exception {
        this.document.setNodeRef(RandomStringUtils.randomAlphanumeric((int)20));
        this.restRatingModel = this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)this.document).getFiveStarRating();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, this.document.getNodeRef()));
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Get rating of a file that has only likes.")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void getRatingOfFileThatHasOnlyLikes() throws Exception {
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)this.document).likeDocument();
        this.restRatingModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).getLikeRating();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestRatingModel)this.restRatingModel.assertThat().field("id").is((Object)"likes")).and().field("myRating").is((Object)"true");
        this.restRatingModel.getAggregate().assertThat().field("numberOfRatings").is((Object)"1");
        this.restRatingModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).getFiveStarRating();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restRatingModel.getAggregate().assertThat().field("numberOfRatings").is((Object)"0");
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Get rating of a file that has only stars.")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void getRatingOfFileThatHasOnlyStars() throws Exception {
        this.restClient.authenticateUser(this.userModel).withCoreAPI().usingResource((RepoTestModel)this.document).rateStarsToDocument(5);
        this.restRatingModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).getFiveStarRating();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestRatingModel)((RestRatingModel)this.restRatingModel.assertThat().field("myRating").is((Object)"5")).and().field("id").is((Object)"fiveStar")).and().field("aggregate").isNotEmpty();
        this.restRatingModel.getAggregate().assertThat().field("numberOfRatings").is((Object)"1");
        this.restRatingModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).getLikeRating();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restRatingModel.getAggregate().assertThat().field("numberOfRatings").is((Object)"0");
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Get rating of a file that has likes and stars.")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void getRatingOfFileThatHasLikesAndStars() throws Exception {
        this.restClient.authenticateUser(this.userModel).withCoreAPI().usingResource((RepoTestModel)this.document).likeDocument();
        this.restClient.authenticateUser(this.userModel).withCoreAPI().usingResource((RepoTestModel)this.document).rateStarsToDocument(5);
        this.restRatingModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).getLikeRating();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestRatingModel)this.restRatingModel.assertThat().field("id").is((Object)"likes")).and().field("myRating").is((Object)"true");
        this.restRatingModel.getAggregate().assertThat().field("numberOfRatings").is((Object)"1");
        this.restRatingModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).getFiveStarRating();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestRatingModel)((RestRatingModel)this.restRatingModel.assertThat().field("myRating").is((Object)"5")).and().field("id").is((Object)"fiveStar")).and().field("aggregate").isNotEmpty();
        this.restRatingModel.getAggregate().assertThat().field("numberOfRatings").is((Object)"1");
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Get rating of a folder that has only likes.")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void getRatingOfFolderThatHasOnlyLikes() throws Exception {
        FolderModel firstFolderModel = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.siteModel)).createFolder();
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)firstFolderModel).likeDocument();
        this.restRatingModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)firstFolderModel).getLikeRating();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestRatingModel)this.restRatingModel.assertThat().field("id").is((Object)"likes")).and().field("myRating").is((Object)"true");
        this.restRatingModel.getAggregate().assertThat().field("numberOfRatings").is((Object)"1");
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Get rating of a file that has no ratings.")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void getRatingOfFileThatHasNoRatings() throws Exception {
        this.restRatingModel = this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)this.document).getLikeRating();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restRatingModel.getAggregate().assertThat().field("numberOfRatings").is((Object)"0");
        this.restRatingModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).getFiveStarRating();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restRatingModel.getAggregate().assertThat().field("numberOfRatings").is((Object)"0");
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Check default error schema")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void checkDefaultErrorSchema() throws Exception {
        FileModel document = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingAdmin().createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        String randomNodeRef = RandomStringUtils.randomAlphanumeric((int)10);
        document.setNodeRef(randomNodeRef);
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)document).getLikeRating();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsErrorKey(RestErrorModel.ENTITY_NOT_FOUND_ERRORKEY).containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, randomNodeRef)).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Get rating of a folder that has only stars")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void getRatingOfFolderThatHasOnlyStars() throws Exception {
        FolderModel folder = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.siteModel)).createFolder();
        this.restClient.authenticateUser(this.managerUser).withCoreAPI().usingResource((RepoTestModel)folder).rateStarsToDocument(3);
        this.restRatingModel = this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)folder).getFiveStarRating();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestAggregateModel)((RestRatingModel)this.restRatingModel.assertThat().field("id").is((Object)"fiveStar")).getAggregate().assertThat().field("numberOfRatings").is((Object)"1")).assertThat().field("average").is((Object)"3.0");
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Get rating of a folder that has both likes and stars")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void getRatingOfFolderThatHasLikedAndStars() throws Exception {
        FolderModel folder = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.siteModel)).createFolder();
        this.restClient.authenticateUser(this.managerUser).withCoreAPI().usingResource((RepoTestModel)folder).rateStarsToDocument(3);
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)folder).likeDocument();
        this.restRatingModel = this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)folder).getFiveStarRating();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestAggregateModel)((RestRatingModel)this.restRatingModel.assertThat().field("id").is((Object)"fiveStar")).getAggregate().assertThat().field("numberOfRatings").is((Object)"1")).assertThat().field("average").is((Object)"3.0");
        this.restRatingModel = this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)folder).getLikeRating();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestRatingModel)this.restRatingModel.assertThat().field("id").is((Object)"likes")).assertThat().field("myRating").is((Object)"true");
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Get rating of a folder that has no ratings")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void getRatingOfFolderThatHasNoRatings() throws Exception {
        FolderModel folder = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.siteModel)).createFolder();
        this.restRatingModel = this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)folder).getFiveStarRating();
        this.restRatingModel.getAggregate().assertThat().field("numberOfRatings").is((Object)"0");
        this.restRatingModel = this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)folder).getLikeRating();
        this.restRatingModel.getAggregate().assertThat().field("numberOfRatings").is((Object)"0");
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Get rating of a folder after rating was deleted")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void getDeletedRatingOfAFolder() throws Exception {
        FolderModel folder = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.siteModel)).createFolder();
        this.restClient.authenticateUser(this.managerUser).withCoreAPI().usingResource((RepoTestModel)folder).rateStarsToDocument(3);
        this.restClient.authenticateUser(this.managerUser).withCoreAPI().usingResource((RepoTestModel)folder).deleteFiveStarRating();
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)folder).likeDocument();
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)folder).deleteLikeRating();
        this.restRatingModel = this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)folder).getFiveStarRating();
        ((RestAggregateModel)((RestRatingModel)this.restRatingModel.assertThat().field("id").is((Object)"fiveStar")).getAggregate().assertThat().field("numberOfRatings").is((Object)"0")).assertThat().field("average").isNull();
        this.restRatingModel = this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)folder).getLikeRating();
        ((RestRatingModel)((RestRatingModel)this.restRatingModel.assertThat().field("id").is((Object)"likes")).assertThat().field("myRating").isNull()).getAggregate().assertThat().field("numberOfRatings").is((Object)"0");
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Get rating of a file after rating was deleted")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void getDeletedRatingOfAFile() throws Exception {
        FileModel file = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.managerUser).withCoreAPI().usingResource((RepoTestModel)file).rateStarsToDocument(3);
        this.restClient.authenticateUser(this.managerUser).withCoreAPI().usingResource((RepoTestModel)file).deleteFiveStarRating();
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)file).likeDocument();
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)file).deleteLikeRating();
        this.restRatingModel = this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)file).getFiveStarRating();
        ((RestAggregateModel)((RestRatingModel)this.restRatingModel.assertThat().field("id").is((Object)"fiveStar")).getAggregate().assertThat().field("numberOfRatings").is((Object)"0")).assertThat().field("average").isNull();
        this.restRatingModel = this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)file).getLikeRating();
        ((RestRatingModel)((RestRatingModel)this.restRatingModel.assertThat().field("id").is((Object)"likes")).assertThat().field("myRating").isNull()).getAggregate().assertThat().field("numberOfRatings").is((Object)"0");
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Get rating of another user as admin")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void getRatingOfAnotherUserAsAdmin() throws Exception {
        FileModel file = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.managerUser).withCoreAPI().usingResource((RepoTestModel)file).rateStarsToDocument(3);
        this.restClient.authenticateUser(this.managerUser).withCoreAPI().usingResource((RepoTestModel)file).likeDocument();
        this.restRatingModel = this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)file).getFiveStarRating();
        ((RestAggregateModel)((RestRatingModel)((RestRatingModel)this.restRatingModel.assertThat().field("id").is((Object)"fiveStar")).and().field("myRating").isNull()).getAggregate().assertThat().field("numberOfRatings").is((Object)"1")).assertThat().field("average").is((Object)"3.0");
        this.restRatingModel = this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)file).getLikeRating();
        ((RestRatingModel)((RestRatingModel)this.restRatingModel.assertThat().field("id").is((Object)"likes")).assertThat().field("myRating").isNull()).getAggregate().assertThat().field("numberOfRatings").is((Object)"1");
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Get rating of admin with another user")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void getRatingOfAdminWithAnotherUser() throws Exception {
        FileModel file = ((DataContent)this.dataContent.usingUser(this.managerUser).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)file).rateStarsToDocument(3);
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)file).likeDocument();
        this.restRatingModel = this.restClient.authenticateUser(this.managerUser).withCoreAPI().usingResource((RepoTestModel)file).getFiveStarRating();
        ((RestAggregateModel)((RestRatingModel)((RestRatingModel)this.restRatingModel.assertThat().field("id").is((Object)"fiveStar")).and().field("myRating").isNull()).getAggregate().assertThat().field("numberOfRatings").is((Object)"1")).assertThat().field("average").is((Object)"3.0");
        this.restRatingModel = this.restClient.authenticateUser(this.managerUser).withCoreAPI().usingResource((RepoTestModel)file).getLikeRating();
        ((RestRatingModel)((RestRatingModel)this.restRatingModel.assertThat().field("id").is((Object)"likes")).assertThat().field("myRating").isNull()).getAggregate().assertThat().field("numberOfRatings").is((Object)"1");
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Get five star rating")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void getFiveStarRating() throws Exception {
        FileModel file = ((DataContent)this.dataContent.usingUser(this.managerUser).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)file).rateStarsToDocument(5);
        this.restRatingModel = this.restClient.authenticateUser(this.managerUser).withCoreAPI().usingResource((RepoTestModel)file).getFiveStarRating();
        ((RestAggregateModel)((RestRatingModel)((RestRatingModel)this.restRatingModel.assertThat().field("id").is((Object)"fiveStar")).and().field("myRating").isNull()).getAggregate().assertThat().field("numberOfRatings").is((Object)"1")).assertThat().field("average").is((Object)"5.0");
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Get one star rating")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void getOneStarRating() throws Exception {
        FileModel file = ((DataContent)this.dataContent.usingUser(this.managerUser).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)file).rateStarsToDocument(1);
        this.restRatingModel = this.restClient.authenticateUser(this.managerUser).withCoreAPI().usingResource((RepoTestModel)file).getFiveStarRating();
        ((RestAggregateModel)((RestRatingModel)((RestRatingModel)this.restRatingModel.assertThat().field("id").is((Object)"fiveStar")).and().field("myRating").isNull()).getAggregate().assertThat().field("numberOfRatings").is((Object)"1")).assertThat().field("average").is((Object)"1.0");
    }
}

