/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.search;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.alfresco.rest.core.IRestModel;
import org.alfresco.utility.model.TestModel;

public class RestRequestFieldsModel
extends TestModel
implements IRestModel<RestRequestFieldsModel> {
    @JsonProperty(value="entry")
    RestRequestFieldsModel model;
    @JsonProperty(required=true)
    private String field;
    private String prefix;
    private String postfix;
    private Integer snippetCount;
    private Integer fragmentSize;
    private Boolean mergeContiguous;

    public static RestRequestFieldsModel of(String field) {
        RestRequestFieldsModel fieldModel = new RestRequestFieldsModel();
        fieldModel.setField(field);
        return fieldModel;
    }

    public static RestRequestFieldsModel of(String field, String prefix, String postfix) {
        RestRequestFieldsModel fieldModel = new RestRequestFieldsModel();
        fieldModel.setField(field);
        fieldModel.setPrefix(prefix);
        fieldModel.setPostfix(postfix);
        return fieldModel;
    }

    @Override
    public RestRequestFieldsModel onModel() {
        return this.model;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPostfix() {
        return this.postfix;
    }

    public void setPostfix(String postfix) {
        this.postfix = postfix;
    }

    public Integer getSnippetCount() {
        return this.snippetCount;
    }

    public void setSnippetCount(Integer snippetCount) {
        this.snippetCount = snippetCount;
    }

    public Integer getFragmentSize() {
        return this.fragmentSize;
    }

    public void setFragmentSize(Integer fragmentSize) {
        this.fragmentSize = fragmentSize;
    }

    public Boolean getMergeContiguous() {
        return this.mergeContiguous;
    }

    public void setMergeContiguous(Boolean mergeContiguous) {
        this.mergeContiguous = mergeContiguous;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String field;
        private String prefix;
        private String postfix;
        private Integer snippetCount;
        private Integer fragmentSize;
        private Boolean mergeContiguous;

        public Builder field(String field) {
            this.field = field;
            return this;
        }

        public Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder postfix(String postfix) {
            this.postfix = postfix;
            return this;
        }

        public Builder snippetCount(Integer snippetCount) {
            this.snippetCount = snippetCount;
            return this;
        }

        public Builder fragmentSize(Integer fragmentSize) {
            this.fragmentSize = fragmentSize;
            return this;
        }

        public Builder mergeContiguous(Boolean mergeContiguous) {
            this.mergeContiguous = mergeContiguous;
            return this;
        }

        public RestRequestFieldsModel build() {
            RestRequestFieldsModel fieldModel = new RestRequestFieldsModel();
            fieldModel.setField(this.field);
            fieldModel.setPrefix(this.prefix);
            fieldModel.setPostfix(this.postfix);
            fieldModel.setSnippetCount(this.snippetCount);
            fieldModel.setFragmentSize(this.fragmentSize);
            fieldModel.setMergeContiguous(this.mergeContiguous);
            return fieldModel;
        }
    }
}

