/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.people;

import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestPaginationModel;
import org.alfresco.rest.model.RestSiteEntry;
import org.alfresco.rest.model.RestSiteMembershipModelsCollection;
import org.alfresco.rest.model.RestTaskModel;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.exception.DataPreparationException;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetSitesMembershipInformationFullTests
extends RestTest {
    private SiteModel publicSiteModel;
    private SiteModel moderatedSiteModel;
    private SiteModel privateSiteModel;
    private SiteModel anotherUserSite;
    private UserModel userModel;
    private UserModel adminUser;
    private UserModel anotherUserModel;
    private RestSiteMembershipModelsCollection sitesMembershipInformation;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws DataPreparationException {
        this.adminUser = this.dataUser.getAdminUser();
        this.anotherUserSite = ((DataSite)this.dataSite.usingUser(this.adminUser)).createPublicRandomSite();
        this.userModel = this.dataUser.createRandomTestUser();
        this.anotherUserModel = this.dataUser.createRandomTestUser();
        this.publicSiteModel = ((DataSite)this.dataSite.usingUser(this.adminUser)).createPublicRandomSite();
        this.dataUser.addUserToSite(this.userModel, this.publicSiteModel, UserRole.SiteCollaborator);
        this.moderatedSiteModel = ((DataSite)this.dataSite.usingUser(this.adminUser)).createModeratedRandomSite();
        this.dataUser.addUserToSite(this.userModel, this.moderatedSiteModel, UserRole.SiteConsumer);
        this.privateSiteModel = ((DataSite)this.dataSite.usingUser(this.userModel)).createPrivateRandomSite();
        this.dataUser.addUserToSite(this.anotherUserModel, this.anotherUserSite, UserRole.SiteCollaborator);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify if get site membership information request returns status code 200 for valid properties parameter")
    public void getSiteMembershipInformationUsingPropertiesParameter() throws Exception {
        this.sitesMembershipInformation = this.restClient.authenticateUser(this.userModel).withParams(new String[]{"properties=id"}).withCoreAPI().usingAuthUser().getSitesMembershipInformation();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.sitesMembershipInformation.assertThat().entriesListIsNotEmpty()).getPagination().assertThat().field("count").is((Object)"3");
        ((RestModels)((RestModels)((RestModels)((RestModels)((RestModels)this.sitesMembershipInformation.assertThat().entriesListContains("id", this.publicSiteModel.getId())).and().entriesListContains("id", this.moderatedSiteModel.getId())).and().entriesListContains("id", this.privateSiteModel.getId())).and().entriesListDoesNotContain("site")).and().entriesListDoesNotContain("role")).and().entriesListDoesNotContain("guid");
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify if get site membership information request returns status code 200 for order ASC by parameter")
    public void getSiteMembershipInformationUsingOrderAscByParameter() throws Exception {
        this.sitesMembershipInformation = this.restClient.authenticateUser(this.userModel).withParams(new String[]{"orderBy=id ASC"}).withCoreAPI().usingAuthUser().getSitesMembershipInformation();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.sitesMembershipInformation.assertThat().entriesListIsNotEmpty()).getPagination().assertThat().field("count").is((Object)"3");
        this.sitesMembershipInformation.assertThat().entriesListIsSortedAscBy("id");
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify if get site membership information request returns status code 200 for order DESC by parameter")
    public void getSiteMembershipInformationUsingOrderDescByParameter() throws Exception {
        this.sitesMembershipInformation = this.restClient.authenticateUser(this.userModel).withParams(new String[]{"orderBy=id Desc"}).withCoreAPI().usingAuthUser().getSitesMembershipInformation();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.sitesMembershipInformation.assertThat().entriesListIsNotEmpty()).getPagination().assertThat().field("count").is((Object)"3");
        this.sitesMembershipInformation.assertThat().entriesListIsSortedDescBy("id");
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify if get site membership information request returns status code 200 for order by role parameter")
    public void getSiteMembershipInformationUsingOrderByRoleParameter() throws Exception {
        this.sitesMembershipInformation = this.restClient.authenticateUser(this.userModel).withParams(new String[]{"orderBy=role"}).withCoreAPI().usingAuthUser().getSitesMembershipInformation();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.sitesMembershipInformation.assertThat().entriesListIsNotEmpty()).getPagination().assertThat().field("count").is((Object)"3");
        this.sitesMembershipInformation.assertThat().entriesListIsSortedAscBy("role");
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify if user gets site membership information of another user successfully")
    public void userCanGetSiteMembershipInformationOfAnotherUser() throws Exception {
        this.sitesMembershipInformation = this.restClient.authenticateUser(this.userModel).withCoreAPI().usingUser(this.anotherUserModel).getSitesMembershipInformation();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.sitesMembershipInformation.assertThat().entriesListIsNotEmpty()).getPagination().assertThat().field("count").is((Object)"1");
        ((RestSiteEntry)((RestSiteEntry)((RestSiteEntry)((RestSiteEntry)((RestSiteEntry)((RestSiteEntry)((RestSiteEntry)((RestSiteEntry)((RestSiteEntry)this.sitesMembershipInformation.getEntries().get(0)).onModel().assertThat().field("site.visibility").is((Object)this.anotherUserSite.getVisibility().toString())).and().field("site.guid").is((Object)this.anotherUserSite.getGuid())).and().field("site.description").is((Object)this.anotherUserSite.getDescription())).and().field("site.id").is((Object)this.anotherUserSite.getId())).and().field("site.preset").is((Object)"site-dashboard")).and().field("site.title").is((Object)this.anotherUserSite.getTitle())).and().field("id").is((Object)this.anotherUserSite.getId())).and().field("guid").is((Object)this.anotherUserSite.getGuid())).and().field("role").is((Object)UserRole.SiteCollaborator.toString());
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify if get site membership information request returns status code 200 for relations parameter")
    public void getSiteMembershipInformationUsingRelationsParameter() throws Exception {
        this.sitesMembershipInformation = this.restClient.authenticateUser(this.userModel).withParams(new String[]{"relations=site-membership-requests"}).withCoreAPI().usingAuthUser().getSitesMembershipInformation();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.sitesMembershipInformation.assertThat().entriesListIsNotEmpty()).getPagination().assertThat().field("count").is((Object)"3");
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify get site membership information request when a site membership request is rejected")
    public void getSiteMembershipInformationWhenASiteRequestIsRejected() throws Exception {
        UserModel userWithRequests = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(userWithRequests).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.moderatedSiteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.sitesMembershipInformation = this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingUser(userWithRequests).getSitesMembershipInformation();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.sitesMembershipInformation.assertThat().entriesListIsEmpty()).and().paginationField("count").is("0");
        RestTaskModel taskModel = this.restClient.authenticateUser(userWithRequests).withWorkflowAPI().getTasks().getTaskModelByDescription(this.moderatedSiteModel);
        this.workflow.approveSiteMembershipRequest(this.adminUser.getUsername(), this.adminUser.getPassword(), taskModel.getId(), false, "Rejected");
        this.sitesMembershipInformation = this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingUser(userWithRequests).getSitesMembershipInformation();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.sitesMembershipInformation.assertThat().entriesListIsEmpty()).and().paginationField("count").is("0");
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify get site membership information request when a site membership request is approved")
    public void getSiteMembershipInformationWhenASiteRequestIsAppropved() throws Exception {
        UserModel userWithRequests = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(userWithRequests).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.moderatedSiteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.sitesMembershipInformation = this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingUser(userWithRequests).getSitesMembershipInformation();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.sitesMembershipInformation.assertThat().entriesListIsEmpty()).and().paginationField("count").is("0");
        RestTaskModel taskModel = this.restClient.authenticateUser(userWithRequests).withWorkflowAPI().getTasks().getTaskModelByDescription(this.moderatedSiteModel);
        this.workflow.approveSiteMembershipRequest(this.adminUser.getUsername(), this.adminUser.getPassword(), taskModel.getId(), true, "Approve");
        this.sitesMembershipInformation = this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingUser(userWithRequests).getSitesMembershipInformation();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)((RestModels)((RestModels)this.sitesMembershipInformation.assertThat().entriesListIsNotEmpty()).and().entriesListContains("role", UserRole.SiteConsumer.toString())).and().entriesListContains("guid", this.moderatedSiteModel.getGuid())).and().entriesListContains("id", this.moderatedSiteModel.getId())).and().paginationField("count").is("1");
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify if get site membership information request returns status code 200 for valid maxItems parameter")
    public void getSiteMembershipInformationUsingMaxItemsParameter() throws Exception {
        this.sitesMembershipInformation = this.restClient.authenticateUser(this.userModel).withParams(new String[]{"maxItems=2"}).withCoreAPI().usingAuthUser().getSitesMembershipInformation();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestPaginationModel)((RestPaginationModel)((RestPaginationModel)((RestPaginationModel)((RestModels)this.sitesMembershipInformation.assertThat().entriesListCountIs(2)).getPagination().assertThat().field("count").is((Object)"2")).and().field("hasMoreItems").is((Object)"true")).and().field("totalItems").is((Object)"3")).and().field("skipCount").is((Object)"0")).and().field("maxItems").is((Object)"2");
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify if get site membership information request returns status code 200 for valid skipCount parameter")
    public void getSiteMembershipInformationUsingSkipCountParameter() throws Exception {
        this.sitesMembershipInformation = this.restClient.authenticateUser(this.userModel).withParams(new String[]{"skipCount=2"}).withCoreAPI().usingAuthUser().getSitesMembershipInformation();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestPaginationModel)((RestPaginationModel)((RestPaginationModel)((RestPaginationModel)((RestModels)this.sitesMembershipInformation.assertThat().entriesListCountIs(1)).getPagination().assertThat().field("count").is((Object)"1")).and().field("hasMoreItems").is((Object)"false")).and().field("totalItems").is((Object)"3")).and().field("skipCount").is((Object)"2")).and().field("maxItems").is((Object)"100");
    }
}

