/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.processes.items;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.exception.JsonToModelConversionException;
import org.alfresco.rest.model.RestItemModel;
import org.alfresco.rest.model.RestItemModelsCollection;
import org.alfresco.rest.model.RestProcessModel;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataWorkflow;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.ProcessModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class AddProcessItemSanityTests
extends RestTest {
    private FileModel document;
    private FileModel document2;
    private SiteModel siteModel;
    private UserModel userWhoStartsTask;
    private UserModel assignee;
    private UserModel adminUser;
    private RestProcessModel processModel;
    private RestItemModel processItem;
    private RestItemModelsCollection processItems;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.userWhoStartsTask = this.dataUser.createRandomTestUser();
        this.assignee = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.adminUser)).createPublicRandomSite();
        this.document = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.XML);
        ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.document)).createNewTaskAndAssignTo(this.assignee);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.SANITY}, description="Create non-existing process item")
    @Test(groups={"rest-api", "workflow", "processes", "sanity"})
    public void addProcessItem() throws JsonToModelConversionException, Exception {
        this.document2 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"This is a test file");
        ((DataContent)this.dataContent.usingSite(this.siteModel)).createContent(this.document2);
        this.processModel = ((RestProcessModel)this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().getProcesses().getOneRandomEntry()).onModel();
        this.processItem = this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessItem(this.document2);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)this.processItem.assertThat().field("createdAt").isNotEmpty()).and().field("size").is((Object)this.document2.getContent().length())).and().field("createdBy").is((Object)this.adminUser.getUsername())).and().field("modifiedAt").isNotEmpty()).and().field("name").is((Object)this.document2.getName())).and().field("modifiedBy").is((Object)this.adminUser.getUsername())).and().field("id").isNotEmpty()).and().field("mimeType").is((Object)this.document2.getFileType().mimeType);
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessItems().assertThat().entriesListContains("id", this.processItem.getId());
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.SANITY}, description="Create non-existing process item")
    @Test(groups={"rest-api", "workflow", "processes", "sanity"})
    public void addMultipleProcessItem() throws JsonToModelConversionException, Exception {
        this.document2 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"This is a test file");
        ((DataContent)this.dataContent.usingSite(this.siteModel)).createContent(this.document2);
        this.document = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"This is a test file");
        ((DataContent)this.dataContent.usingSite(this.siteModel)).createContent(this.document);
        this.processModel = ((RestProcessModel)this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().getProcesses().getOneRandomEntry()).onModel();
        this.processItems = this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessItems(new FileModel[]{this.document2, this.document});
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)this.processItems.getEntries().get(0)).onModel().assertThat().field("createdAt").isNotEmpty()).and().field("size").is((Object)this.document2.getContent().length())).and().field("createdBy").is((Object)this.adminUser.getUsername())).and().field("modifiedAt").isNotEmpty()).and().field("name").is((Object)this.document2.getName())).and().field("modifiedBy").is((Object)this.adminUser.getUsername())).and().field("id").isNotEmpty()).and().field("mimeType").is((Object)this.document2.getFileType().mimeType);
        ((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)this.processItems.getEntries().get(1)).onModel().assertThat().field("createdAt").isNotEmpty()).and().field("size").is((Object)this.document.getContent().length())).and().field("createdBy").is((Object)this.adminUser.getUsername())).and().field("modifiedAt").isNotEmpty()).and().field("name").is((Object)this.document.getName())).and().field("modifiedBy").is((Object)this.adminUser.getUsername())).and().field("id").isNotEmpty()).and().field("mimeType").is((Object)this.document.getFileType().mimeType);
        ((RestModels)this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessItems().assertThat().entriesListContains("id", ((RestItemModel)this.processItems.getEntries().get(0)).onModel().getId())).assertThat().entriesListContains("id", ((RestItemModel)this.processItems.getEntries().get(1)).onModel().getId());
    }

    @Bug(id="REPO-1927")
    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.SANITY}, description="Add process item that already exists")
    @Test(groups={"rest-api", "workflow", "processes", "sanity"})
    public void addProcessItemThatAlreadyExists() throws JsonToModelConversionException, Exception {
        this.document2 = ((DataContent)this.dataContent.usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.XML);
        this.processModel = ((RestProcessModel)this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().getProcesses().getOneRandomEntry()).onModel();
        this.processItem = this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessItem(this.document2);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)this.processItem.assertThat().field("createdAt").isNotEmpty()).and().field("size").is((Object)"19")).and().field("createdBy").is((Object)this.adminUser.getUsername())).and().field("modifiedAt").isNotEmpty()).and().field("name").is((Object)this.document2.getName())).and().field("modifiedBy").is((Object)this.adminUser.getUsername())).and().field("id").isNotEmpty()).and().field("mimeType").is((Object)this.document2.getFileType().mimeType);
        ((RestModels)this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessItems().assertThat().entriesListContains("id", this.processItem.getId())).and().entriesListContains("name", this.document2.getName());
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessItem(this.document2);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
    }

    @Bug(id="REPO-1927")
    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.SANITY}, description="Add process item that already exists")
    @Test(groups={"rest-api", "workflow", "processes", "sanity"})
    public void addMultipleProcessItemThatAlreadyExists() throws JsonToModelConversionException, Exception {
        this.document2 = ((DataContent)this.dataContent.usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.XML);
        this.document = ((DataContent)this.dataContent.usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.XML);
        this.processModel = ((RestProcessModel)this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().getProcesses().getOneRandomEntry()).onModel();
        this.processItems = this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessItems(new FileModel[]{this.document2, this.document});
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)this.processItems.getEntries().get(0)).onModel().assertThat().field("createdAt").isNotEmpty()).and().field("size").is((Object)"19")).and().field("createdBy").is((Object)this.adminUser.getUsername())).and().field("modifiedAt").isNotEmpty()).and().field("name").is((Object)this.document2.getName())).and().field("modifiedBy").is((Object)this.adminUser.getUsername())).and().field("id").isNotEmpty()).and().field("mimeType").is((Object)this.document2.getFileType().mimeType);
        ((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)this.processItems.getEntries().get(1)).onModel().assertThat().field("createdAt").isNotEmpty()).and().field("size").is((Object)"19")).and().field("createdBy").is((Object)this.adminUser.getUsername())).and().field("modifiedAt").isNotEmpty()).and().field("name").is((Object)this.document.getName())).and().field("modifiedBy").is((Object)this.adminUser.getUsername())).and().field("id").isNotEmpty()).and().field("mimeType").is((Object)this.document.getFileType().mimeType);
        ((RestModels)((RestModels)((RestModels)this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessItems().assertThat().entriesListContains("id", ((RestItemModel)this.processItems.getEntries().get(0)).onModel().getId())).and().entriesListContains("name", this.document2.getName())).assertThat().entriesListContains("id", ((RestItemModel)this.processItems.getEntries().get(1)).onModel().getId())).and().entriesListContains("name", this.document.getName());
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessItems(new FileModel[]{this.document2, this.document});
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
    }
}

