/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.tasks;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestTaskModel;
import org.alfresco.rest.model.RestTaskModelsCollection;
import org.alfresco.rest.requests.Task;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataWorkflow;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.GroupModel;
import org.alfresco.utility.model.ProcessModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.TaskModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class GetTaskTests
extends RestTest {
    UserModel userModel;
    UserModel assigneeUser;
    UserModel adminTenantUser;
    UserModel tenantUser;
    UserModel tenantUserAssignee;
    UserModel adminUser;
    SiteModel siteModel;
    FileModel fileModel;
    TaskModel taskModel;
    RestTaskModel restTaskModel;
    RestTaskModel tenantTask;
    RestTaskModelsCollection taskModels;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.userModel = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.userModel)).createPublicRandomSite();
        this.fileModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.assigneeUser = this.dataUser.createRandomTestUser();
    }

    @BeforeMethod(alwaysRun=true)
    public void createTask() throws Exception {
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userModel)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.assigneeUser);
    }

    @Test(groups={"rest-api", "workflow", "tasks", "sanity"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.SANITY}, description="Verify admin user gets any existing task with Rest API and response is successfull (200)")
    public void adminUserGetsAnyTaskWithSuccess() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().usingTask(this.taskModel).getTask();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("description").is((Object)this.taskModel.getMessage());
    }

    @Test(groups={"rest-api", "workflow", "tasks", "sanity"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.SANITY}, description="Verify assignee user gets its assigned task with Rest API and response is successfull (200)")
    public void assigneeUserGetsItsTaskWithSuccess() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.assigneeUser).withWorkflowAPI().usingTask(this.taskModel).getTask();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("description").is((Object)this.taskModel.getMessage())).and().field("assignee").is((Object)this.assigneeUser.getUsername());
    }

    @Test(groups={"rest-api", "workflow", "tasks", "sanity"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.SANITY}, description="Verify user that started the task gets the started task with Rest API and response is successfull (200)")
    public void starterUserGetsItsTaskWithSuccess() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.userModel).withWorkflowAPI().usingTask(this.taskModel).getTask();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("description").is((Object)this.taskModel.getMessage());
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify any user with no relation to task id forbidden to get other task with Rest API (403)")
    public void anyUserIsForbiddenToGetOtherTask() throws Exception {
        UserModel anyUser = this.dataUser.createRandomTestUser();
        this.restTaskModel = this.restClient.authenticateUser(anyUser).withWorkflowAPI().usingTask(this.taskModel).getTask();
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary("Permission was denied");
    }

    @Test(groups={"rest-api", "workflow", "tasks", "sanity"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.SANITY}, description="Verify candidate user gets its specific task and no other user claimed the task with Rest API and response is successfull (200)")
    public void candidateUserGetsItsTasks() throws Exception {
        UserModel userModel1 = this.dataUser.createRandomTestUser();
        UserModel userModel2 = this.dataUser.createRandomTestUser();
        GroupModel group = this.dataGroup.createRandomGroup();
        this.dataGroup.addListOfUsersToGroup(group, new UserModel[]{userModel1, userModel2});
        TaskModel taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userModel)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createPooledReviewTaskAndAssignTo(group);
        this.restTaskModel = this.restClient.authenticateUser(userModel1).withWorkflowAPI().usingTask(taskModel).getTask();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)taskModel.getId())).and().field("description").is((Object)taskModel.getMessage());
    }

    @Test(groups={"rest-api", "workflow", "tasks", "sanity"})
    @Bug(id="MNT-17051")
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.SANITY}, description="Verify involved user in a task without claim it gets the task with Rest API and response is successfull (200)")
    public void involvedUserWithoutClaimTaskGetsTask() throws Exception {
        UserModel userModel1 = this.dataUser.createRandomTestUser();
        UserModel userModel2 = this.dataUser.createRandomTestUser();
        GroupModel group = this.dataGroup.createRandomGroup();
        this.dataGroup.addListOfUsersToGroup(group, new UserModel[]{userModel1, userModel2});
        TaskModel taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userModel)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createPooledReviewTaskAndAssignTo(group);
        ((DataWorkflow)this.dataWorkflow.usingUser(userModel1)).claimTask(taskModel);
        this.restTaskModel = this.restClient.authenticateUser(userModel2).withWorkflowAPI().usingTask(taskModel).getTask();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)taskModel.getId())).and().field("description").is((Object)taskModel.getMessage());
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify user who started a task gets the task with empty taskId with Rest API")
    public void starterUserGetsTaskWithEmptyTaskId() throws Exception {
        UserModel userWhoStartsTask = this.dataUser.createRandomTestUser();
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(userWhoStartsTask);
        this.restClient.authenticateUser(userWhoStartsTask).withWorkflowAPI();
        RestRequest request = RestRequest.simpleRequest((HttpMethod)HttpMethod.GET, (String)"tasks/{taskId}", (String[])new String[]{""});
        RestTaskModelsCollection tasks = (RestTaskModelsCollection)this.restClient.processModels(RestTaskModelsCollection.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)tasks.assertThat().entriesListIsNotEmpty()).and().entriesListCountIs(1)).and().entriesListContains("id", this.taskModel.getId());
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify user who started a task gets the task with properties parameter with Rest API")
    public void starterUserGetsTaskWithPropertiesParameter() throws Exception {
        this.restTaskModel = ((Task)this.restClient.authenticateUser(this.userModel).withWorkflowAPI().usingTask(this.taskModel).usingParams(new String[]{"properties=id,assignee,formResourceKey"})).getTask();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)((RestTaskModel)((RestTaskModel)((RestTaskModel)((RestTaskModel)this.restTaskModel.assertThat().fieldsCount().is((Object)3)).and().field("id").is((Object)this.taskModel.getId())).and().field("assignee").is((Object)this.taskModel.getAssignee())).and().field("formResourceKey").is((Object)"wf:adhocTask")).and().field("processDefinitionId").isNull()).and().field("processId").isNull();
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify user who started a task gets the task after it is deleted with Rest API")
    public void starterUserGetsDeletedTask() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.userModel).withWorkflowAPI().usingTask(this.taskModel).getTask();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId());
        ProcessModel process = new ProcessModel();
        process.setId(this.taskModel.getProcessId());
        ((DataWorkflow)this.dataWorkflow.usingUser(this.userModel)).deleteProcess(process);
        this.restClient.authenticateUser(this.userModel).withWorkflowAPI().usingTask(this.taskModel).getTask();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsErrorKey(RestErrorModel.ENTITY_NOT_FOUND_ERRORKEY).containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, this.taskModel.getId())).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify if using invalid taskId status code 404 is returned.")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void invalidTaskId() throws Exception {
        this.taskModel.setId(RandomStringUtils.randomAlphanumeric((int)20));
        this.restTaskModel = this.restClient.authenticateUser(this.userModel).withWorkflowAPI().usingTask(this.taskModel).getTask();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, this.taskModel.getId()));
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify if using empty taskId status code 200 is returned.")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void emptyTaskId() throws Exception {
        this.restClient.authenticateUser(this.userModel).withWorkflowAPI();
        RestRequest request = RestRequest.simpleRequest((HttpMethod)HttpMethod.GET, (String)"tasks/{taskId}", (String[])new String[]{""});
        this.taskModels = (RestTaskModelsCollection)this.restClient.processModels(RestTaskModelsCollection.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.taskModels.assertThat().entriesListIsNotEmpty();
    }
}

