/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.processes.variables;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestProcessModel;
import org.alfresco.rest.model.RestProcessVariableModel;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataWorkflow;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.ProcessModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class AddProcessVariableSanityTests
extends RestTest {
    private FileModel document;
    private SiteModel siteModel;
    private UserModel userWhoStartsTask;
    private UserModel assignee;
    private UserModel adminUser;
    private RestProcessModel processModel;
    private RestProcessVariableModel variableModel;
    private RestProcessVariableModel processVariable;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.userWhoStartsTask = this.dataUser.createRandomTestUser();
        this.assignee = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.userWhoStartsTask)).createPublicRandomSite();
        this.document = ((DataContent)this.dataContent.usingUser(this.userWhoStartsTask).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.document)).createNewTaskAndAssignTo(this.assignee);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.SANITY}, description="Create non-existing variable")
    @Test(groups={"rest-api", "workflow", "processes", "sanity"})
    public void addProcessVariable() throws Exception {
        this.variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:text");
        this.processModel = ((RestProcessModel)this.restClient.authenticateUser(this.userWhoStartsTask).withWorkflowAPI().getProcesses().getOneRandomEntry()).onModel();
        this.processVariable = this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).updateProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestProcessVariableModel)((RestProcessVariableModel)this.processVariable.assertThat().field("name").is((Object)this.variableModel.getName())).and().field("type").is((Object)this.variableModel.getType())).and().field("value").is((Object)this.variableModel.getValue());
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessVariables().assertThat().entriesListContains("name", this.variableModel.getName());
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.SANITY}, description="Update existing variable")
    @Test(groups={"rest-api", "workflow", "processes", "sanity"})
    public void updateExistingProcessVariable() throws Exception {
        this.variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:text");
        this.processModel = ((RestProcessModel)this.restClient.authenticateUser(this.userWhoStartsTask).withWorkflowAPI().getProcesses().getOneRandomEntry()).onModel();
        this.processVariable = this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).updateProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestProcessVariableModel)((RestProcessVariableModel)this.processVariable.assertThat().field("name").is((Object)this.variableModel.getName())).and().field("type").is((Object)this.variableModel.getType())).and().field("value").is((Object)this.variableModel.getValue());
        String newValue = RandomData.getRandomName((String)"value");
        this.variableModel.setValue(newValue);
        this.processVariable = this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).updateProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.processVariable.assertThat().field("value").is((Object)newValue);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.SANITY}, description="Adding process variable is falling in case invalid variableBody is provided")
    @Test(groups={"rest-api", "workflow", "processes", "sanity"})
    public void failedAddingProcessVariableIfInvalidBodyIsProvided() throws Exception {
        this.variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"incorrect type");
        this.processModel = ((RestProcessModel)this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().getProcesses().getOneRandomEntry()).onModel();
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).updateProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsErrorKey(String.format(RestErrorModel.UNSUPPORTED_TYPE, "incorrect type")).containsSummary(String.format(RestErrorModel.UNSUPPORTED_TYPE, "incorrect type")).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }
}

