/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.favorites;

import java.util.List;
import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestPaginationModel;
import org.alfresco.rest.model.RestPersonFavoritesModel;
import org.alfresco.rest.model.RestPersonFavoritesModelsCollection;
import org.alfresco.rest.model.RestSiteModel;
import org.alfresco.rest.requests.People;
import org.alfresco.rest.search.RestRequestQueryModel;
import org.alfresco.rest.search.SearchRequest;
import org.alfresco.utility.Utility;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.hamcrest.Matchers;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetFavoritesTests
extends RestTest {
    private static final String ALLOWABLE_OPERATIONS = "allowableOperations";
    private UserModel adminUserModel;
    private UserModel userModel;
    private SiteModel firstSiteModel;
    private SiteModel secondSiteModel;
    private SiteModel thirdSiteModel;
    private FileModel firstFileModel;
    private FileModel secondFileModel;
    private FolderModel firstFolderModel;
    private FolderModel secondFolderModel;
    private DataUser.ListUserWithRoles firstSiteUsers;
    private DataUser.ListUserWithRoles secondSiteUsers;
    private RestPersonFavoritesModelsCollection userFavorites;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUserModel = this.dataUser.getAdminUser();
        this.userModel = this.dataUser.createRandomTestUser();
        this.firstSiteModel = ((DataSite)this.dataSite.usingUser(this.adminUserModel)).createPublicRandomSite();
        this.secondSiteModel = ((DataSite)this.dataSite.usingUser(this.adminUserModel)).createPublicRandomSite();
        this.thirdSiteModel = ((DataSite)this.dataSite.usingUser(this.adminUserModel)).createPublicRandomSite();
        this.firstFolderModel = ((DataContent)this.dataContent.usingUser(this.adminUserModel).usingSite(this.firstSiteModel)).createFolder();
        this.secondFolderModel = ((DataContent)this.dataContent.usingUser(this.adminUserModel).usingSite(this.firstSiteModel)).createFolder();
        this.firstFileModel = ((DataContent)this.dataContent.usingUser(this.adminUserModel).usingResource((ContentModel)this.firstFolderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.secondFileModel = ((DataContent)this.dataContent.usingUser(this.adminUserModel).usingResource((ContentModel)this.firstFolderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.firstSiteUsers = this.dataUser.addUsersWithRolesToSite(this.firstSiteModel, new UserRole[]{UserRole.SiteManager, UserRole.SiteCollaborator, UserRole.SiteConsumer, UserRole.SiteContributor});
        this.secondSiteUsers = this.dataUser.addUsersWithRolesToSite(this.secondSiteModel, new UserRole[]{UserRole.SiteManager, UserRole.SiteCollaborator, UserRole.SiteConsumer, UserRole.SiteContributor});
        this.restClient.authenticateUser(this.userModel);
        this.restClient.withCoreAPI().usingUser(this.userModel).addSiteToFavorites(this.firstSiteModel);
        this.restClient.withCoreAPI().usingUser(this.userModel).addSiteToFavorites(this.secondSiteModel);
        this.restClient.withCoreAPI().usingUser(this.userModel).addSiteToFavorites(this.thirdSiteModel);
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.SANITY}, description="Verify Manager user gets favorites with Rest API and status code is 200")
    @Test(groups={"rest-api", "favorites", "sanity"})
    public void managerIsAbleToRetrieveFavorites() {
        this.restClient.authenticateUser(this.firstSiteUsers.getOneUserWithRole(UserRole.SiteManager));
        this.restClient.withCoreAPI().usingAuthUser().addSiteToFavorites(this.firstSiteModel);
        this.restClient.withCoreAPI().usingAuthUser().addSiteToFavorites(this.secondSiteModel);
        this.userFavorites = this.restClient.withCoreAPI().usingAuthUser().getFavorites();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.userFavorites.assertThat().entriesListContains("targetGuid", this.firstSiteModel.getGuid())).assertThat().entriesListContains("targetGuid", this.secondSiteModel.getGuid());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.SANITY}, description="Verify user gets status code 401 if authentication call fails")
    @Test(groups={"rest-api", "favorites", "sanity"})
    public void userIsNotAbleToRetrieveFavoritesIfAuthenticationFails() {
        UserModel siteManager = this.firstSiteUsers.getOneUserWithRole(UserRole.SiteManager);
        siteManager.setPassword("wrongPassword");
        this.restClient.authenticateUser(siteManager).withCoreAPI().usingAuthUser().getFavorites();
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify Admin user gets favorites sites with Rest API and status code is 200")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void adminIsAbleToRetrieveFavoritesSites() {
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingUser(this.adminUserModel).addSiteToFavorites(this.firstSiteModel);
        this.restClient.withCoreAPI().usingUser(this.adminUserModel).addSiteToFavorites(this.secondSiteModel);
        this.userFavorites = this.restClient.withCoreAPI().usingAuthUser().where().targetSiteExist().getFavorites();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.userFavorites.assertThat().entriesListContains("targetGuid", this.firstSiteModel.getGuid())).and().entriesListContains("targetGuid", this.secondSiteModel.getGuid());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify Admin user gets favorites folders with Rest API and status code is 200")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void adminIsAbleToRetrieveFavoritesFolders() {
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingUser(this.adminUserModel).addFolderToFavorites(this.firstFolderModel);
        this.restClient.withCoreAPI().usingUser(this.adminUserModel).addFolderToFavorites(this.secondFolderModel);
        this.userFavorites = this.restClient.withCoreAPI().usingAuthUser().where().targetFolderExist().getFavorites();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.userFavorites.assertThat().entriesListContains("targetGuid", this.firstFolderModel.getNodeRef())).and().entriesListContains("targetGuid", this.secondFolderModel.getNodeRef());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify Admin user gets favorites files with Rest API and status code is 200")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void adminIsAbleToRetrieveFavoritesFiles() {
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingUser(this.adminUserModel).addFileToFavorites(this.firstFileModel);
        this.restClient.withCoreAPI().usingUser(this.adminUserModel).addFileToFavorites(this.secondFileModel);
        this.userFavorites = this.restClient.withCoreAPI().usingAuthUser().where().targetFileExist().getFavorites();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.userFavorites.assertThat().entriesListContains("targetGuid", this.firstFileModel.getNodeRefWithoutVersion())).and().entriesListContains("targetGuid", this.secondFileModel.getNodeRefWithoutVersion());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify Collaborator user gets favorites with Rest API and status code is 200")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void collaboratorIsAbleToRetrieveFavorites() {
        this.restClient.authenticateUser(this.firstSiteUsers.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingAuthUser().addSiteToFavorites(this.firstSiteModel);
        this.restClient.withCoreAPI().usingAuthUser().addSiteToFavorites(this.secondSiteModel);
        this.userFavorites = this.restClient.withCoreAPI().usingAuthUser().getFavorites();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.userFavorites.assertThat().entriesListContains("targetGuid", this.firstSiteModel.getGuid())).and().entriesListContains("targetGuid", this.secondSiteModel.getGuid());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify Contributor user gets favorites with Rest API and status code is 200")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void contributorIsAbleToRetrieveFavorites() {
        this.restClient.authenticateUser(this.firstSiteUsers.getOneUserWithRole(UserRole.SiteContributor)).withCoreAPI().usingAuthUser().addSiteToFavorites(this.firstSiteModel);
        this.restClient.withCoreAPI().usingAuthUser().addSiteToFavorites(this.secondSiteModel);
        this.userFavorites = this.restClient.withCoreAPI().usingAuthUser().getFavorites();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.userFavorites.assertThat().entriesListContains("targetGuid", this.firstSiteModel.getGuid())).and().entriesListContains("targetGuid", this.secondSiteModel.getGuid());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify Consumer user gets favorites with Rest API and status code is 200")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void consumerIsAbleToRetrieveFavorites() {
        this.restClient.authenticateUser(this.firstSiteUsers.getOneUserWithRole(UserRole.SiteConsumer)).withCoreAPI().usingAuthUser().addSiteToFavorites(this.firstSiteModel);
        this.restClient.withCoreAPI().usingAuthUser().addSiteToFavorites(this.secondSiteModel);
        this.userFavorites = this.restClient.withCoreAPI().usingAuthUser().getFavorites();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.userFavorites.assertThat().entriesListContains("targetGuid", this.firstSiteModel.getGuid())).assertThat().entriesListContains("targetGuid", this.secondSiteModel.getGuid());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify user doesn't have permission to get favorites of another user with Rest API and status code is 404")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void userIsNotAbleToRetrieveFavoritesOfAnotherUser() {
        this.restClient.authenticateUser(this.firstSiteUsers.getOneUserWithRole(UserRole.SiteConsumer)).withCoreAPI().usingUser(this.firstSiteUsers.getOneUserWithRole(UserRole.SiteCollaborator)).getFavorites();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, this.firstSiteUsers.getOneUserWithRole(UserRole.SiteCollaborator).getUsername()));
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify user doesn't have permission to get favorites of admin user with Rest API and status code is 200")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void userIsNotAbleToRetrieveFavoritesOfAdminUser() {
        this.restClient.authenticateUser(this.firstSiteUsers.getOneUserWithRole(UserRole.SiteConsumer)).withCoreAPI().usingUser(this.adminUserModel).getFavorites();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, this.adminUserModel.getUsername()));
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify admin user doesn't have permission to get favorites of another user with Rest API and status code is 200")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void adminIsNotAbleToRetrieveFavoritesOfAnotherUser() {
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingUser(this.firstSiteUsers.getOneUserWithRole(UserRole.SiteCollaborator)).getFavorites();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, this.firstSiteUsers.getOneUserWithRole(UserRole.SiteCollaborator).getUsername()));
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify User gets only favorites sites with Rest API and status code is 200")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void userIsAbleToRetrieveOnlyFavoritesSites() {
        this.restClient.authenticateUser(this.secondSiteUsers.getOneUserWithRole(UserRole.SiteManager));
        this.restClient.withCoreAPI().usingAuthUser().addSiteToFavorites(this.firstSiteModel);
        this.restClient.withCoreAPI().usingAuthUser().addFileToFavorites(this.firstFileModel);
        this.restClient.withCoreAPI().usingAuthUser().addFolderToFavorites(this.firstFolderModel);
        this.userFavorites = this.restClient.withCoreAPI().usingAuthUser().where().targetSiteExist().getFavorites();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)((RestModels)this.userFavorites.assertThat().entriesListContains("targetGuid", this.firstSiteModel.getGuid())).and().entriesListDoesNotContain("targetGuid", this.secondSiteModel.getGuid())).and().entriesListDoesNotContain("targetGuid", this.firstFileModel.getNodeRefWithoutVersion())).and().entriesListDoesNotContain("targetGuid", this.firstFolderModel.getNodeRef());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify User gets only favorites files with Rest API and status code is 200")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void userIsAbleToRetrieveOnlyFavoritesFiles() {
        this.restClient.authenticateUser(this.firstSiteUsers.getOneUserWithRole(UserRole.SiteCollaborator));
        this.restClient.withCoreAPI().usingAuthUser().addSiteToFavorites(this.firstSiteModel);
        this.restClient.withCoreAPI().usingAuthUser().addFileToFavorites(this.firstFileModel);
        this.restClient.withCoreAPI().usingAuthUser().addFolderToFavorites(this.firstFolderModel);
        this.userFavorites = this.restClient.withCoreAPI().usingAuthUser().where().targetFileExist().getFavorites();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)((RestModels)this.userFavorites.assertThat().entriesListContains("targetGuid", this.firstFileModel.getNodeRefWithoutVersion())).and().entriesListDoesNotContain("targetGuid", this.secondFileModel.getNodeRefWithoutVersion())).and().entriesListDoesNotContain("targetGuid", this.firstSiteModel.getGuid())).and().entriesListDoesNotContain("targetGuid", this.firstFolderModel.getNodeRef());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify User gets only favorites folders with Rest API and status code is 200")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void userIsAbleToRetrieveOnlyFavoritesFolders() {
        this.restClient.authenticateUser(this.firstSiteUsers.getOneUserWithRole(UserRole.SiteCollaborator));
        this.restClient.withCoreAPI().usingAuthUser().addSiteToFavorites(this.firstSiteModel);
        this.restClient.withCoreAPI().usingAuthUser().addFileToFavorites(this.firstFileModel);
        this.restClient.withCoreAPI().usingAuthUser().addFolderToFavorites(this.firstFolderModel);
        this.userFavorites = this.restClient.withCoreAPI().usingAuthUser().where().targetFolderExist().getFavorites();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)((RestModels)this.userFavorites.assertThat().entriesListContains("targetGuid", this.firstFolderModel.getNodeRef())).and().entriesListDoesNotContain("targetGuid", this.secondFolderModel.getNodeRef())).and().entriesListDoesNotContain("targetGuid", this.firstSiteModel.getGuid())).and().entriesListDoesNotContain("targetGuid", this.firstFileModel.getNodeRefWithoutVersion());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify User gets only favorites files or folders with Rest API and status code is 200")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void userIsAbleToRetrieveFavoritesFilesOrFolders() {
        this.restClient.authenticateUser(this.firstSiteUsers.getOneUserWithRole(UserRole.SiteConsumer));
        this.restClient.withCoreAPI().usingAuthUser().addSiteToFavorites(this.firstSiteModel);
        this.restClient.withCoreAPI().usingAuthUser().addFileToFavorites(this.firstFileModel);
        this.restClient.withCoreAPI().usingAuthUser().addFolderToFavorites(this.firstFolderModel);
        this.userFavorites = this.restClient.withCoreAPI().usingAuthUser().where().targetFolderExist().or().targetFileExist().getFavorites();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)((RestModels)((RestModels)this.userFavorites.assertThat().entriesListContains("targetGuid", this.firstFolderModel.getNodeRef())).and().entriesListContains("targetGuid", this.firstFileModel.getNodeRefWithoutVersion())).and().entriesListDoesNotContain("targetGuid", this.secondFolderModel.getNodeRef())).and().entriesListDoesNotContain("targetGuid", this.secondFileModel.getNodeRefWithoutVersion())).and().entriesListDoesNotContain("targetGuid", this.firstSiteModel.getGuid());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify User gets only favorites files or sites with Rest API and status code is 200")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void userIsAbleToRetrieveFavoritesFilesOrSites() {
        this.restClient.authenticateUser(this.secondSiteUsers.getOneUserWithRole(UserRole.SiteManager));
        this.restClient.withCoreAPI().usingAuthUser().addSiteToFavorites(this.firstSiteModel);
        this.restClient.withCoreAPI().usingAuthUser().addFileToFavorites(this.firstFileModel);
        this.restClient.withCoreAPI().usingAuthUser().addFolderToFavorites(this.firstFolderModel);
        this.userFavorites = this.restClient.withCoreAPI().usingAuthUser().where().targetSiteExist().or().targetFileExist().getFavorites();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)((RestModels)((RestModels)this.userFavorites.assertThat().entriesListContains("targetGuid", this.firstSiteModel.getGuid())).and().entriesListContains("targetGuid", this.firstFileModel.getNodeRefWithoutVersion())).and().entriesListDoesNotContain("targetGuid", this.secondSiteModel.getGuid())).and().entriesListDoesNotContain("targetGuid", this.secondFileModel.getNodeRefWithoutVersion())).and().entriesListDoesNotContain("targetGuid", this.firstFolderModel.getNodeRef());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify User gets only favorites folders or sites with Rest API and status code is 200")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void userIsAbleToRetrieveFavoritesFoldersOrSites() {
        this.restClient.authenticateUser(this.secondSiteUsers.getOneUserWithRole(UserRole.SiteManager));
        this.restClient.withCoreAPI().usingAuthUser().addSiteToFavorites(this.firstSiteModel);
        this.restClient.withCoreAPI().usingAuthUser().addFileToFavorites(this.firstFileModel);
        this.restClient.withCoreAPI().usingAuthUser().addFolderToFavorites(this.firstFolderModel);
        this.userFavorites = this.restClient.withCoreAPI().usingAuthUser().where().targetSiteExist().or().targetFolderExist().getFavorites();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)((RestModels)((RestModels)this.userFavorites.assertThat().entriesListContains("targetGuid", this.firstSiteModel.getGuid())).and().entriesListContains("targetGuid", this.firstFolderModel.getNodeRef())).and().entriesListDoesNotContain("targetGuid", this.secondSiteModel.getGuid())).and().entriesListDoesNotContain("targetGuid", this.secondFolderModel.getNodeRef())).and().entriesListDoesNotContain("targetGuid", this.firstFileModel.getNodeRefWithoutVersion());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify User gets all favorites with Rest API and status code is 200")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void userIsAbleToRetrieveAllFavorites() {
        this.restClient.authenticateUser(this.secondSiteUsers.getOneUserWithRole(UserRole.SiteCollaborator));
        this.restClient.withCoreAPI().usingAuthUser().addSiteToFavorites(this.firstSiteModel);
        this.restClient.withCoreAPI().usingAuthUser().addFileToFavorites(this.firstFileModel);
        this.restClient.withCoreAPI().usingAuthUser().addFolderToFavorites(this.firstFolderModel);
        this.userFavorites = this.restClient.withCoreAPI().usingAuthUser().where().targetSiteExist().or().targetFolderExist().or().targetFileExist().getFavorites();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)((RestModels)((RestModels)((RestModels)this.userFavorites.assertThat().entriesListContains("targetGuid", this.firstSiteModel.getGuid())).and().entriesListContains("targetGuid", this.firstFolderModel.getNodeRef())).and().entriesListContains("targetGuid", this.firstFileModel.getNodeRefWithoutVersion())).and().entriesListDoesNotContain("targetGuid", this.secondSiteModel.getGuid())).and().entriesListDoesNotContain("targetGuid", this.secondFolderModel.getNodeRef())).and().entriesListDoesNotContain("targetGuid", this.secondFileModel.getNodeRefWithoutVersion());
        this.userFavorites = this.restClient.withCoreAPI().usingAuthUser().getFavorites();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)((RestModels)((RestModels)((RestModels)this.userFavorites.assertThat().entriesListContains("targetGuid", this.firstSiteModel.getGuid())).and().entriesListContains("targetGuid", this.firstFolderModel.getNodeRef())).and().entriesListContains("targetGuid", this.firstFileModel.getNodeRefWithoutVersion())).and().entriesListDoesNotContain("targetGuid", this.secondSiteModel.getGuid())).and().entriesListDoesNotContain("targetGuid", this.secondFolderModel.getNodeRef())).and().entriesListDoesNotContain("targetGuid", this.secondFileModel.getNodeRefWithoutVersion());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify request for a user with no favorites returns status 200")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void userHasNoFavorites() {
        this.restClient.authenticateUser(this.secondSiteUsers.getOneUserWithRole(UserRole.SiteContributor));
        this.userFavorites = this.restClient.withCoreAPI().usingAuthUser().getFavorites();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.userFavorites.assertThat().entriesListIsEmpty()).and().paginationField("totalItems").is("0");
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify request using invalid where parameter returns status 400")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void getFavoritesUsingInvalidWhereParameter() {
        this.restClient.authenticateUser(this.firstSiteUsers.getOneUserWithRole(UserRole.SiteConsumer));
        this.restClient.withCoreAPI().usingAuthUser().addSiteToFavorites(this.firstSiteModel);
        this.restClient.withCoreAPI().usingAuthUser().addFileToFavorites(this.firstFileModel);
        this.restClient.withCoreAPI().usingAuthUser().addFolderToFavorites(this.firstFolderModel);
        this.userFavorites = this.restClient.withCoreAPI().usingAuthUser().where().or().getFavorites();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.INVALID_ARGUMENT, "WHERE query"));
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify User gets correct favorites after deleting a favorite")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void checkFavoriteFolderIsRemoved() {
        this.restClient.authenticateUser(this.firstSiteUsers.getOneUserWithRole(UserRole.SiteManager));
        this.restClient.withCoreAPI().usingAuthUser().addSiteToFavorites(this.firstSiteModel);
        this.restClient.withCoreAPI().usingAuthUser().addFileToFavorites(this.firstFileModel);
        this.restClient.withCoreAPI().usingAuthUser().addFolderToFavorites(this.firstFolderModel);
        this.restClient.withCoreAPI().usingAuthUser().deleteFolderFromFavorites(this.firstFolderModel);
        this.userFavorites = this.restClient.withCoreAPI().usingAuthUser().getFavorites();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.userFavorites.assertThat().entriesListDoesNotContain("targetGuid", this.firstFolderModel.getNodeRef())).and().paginationField("totalItems").is("2");
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify get favorites specifying -me- string in place of <personid> for request")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void userIsAbleToGetFavoritesWhenUsingMeAsUsername() {
        this.userFavorites = this.restClient.authenticateUser(this.userModel).withCoreAPI().usingMe().getFavorites();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.userFavorites.assertThat().entriesListContains("targetGuid", this.firstSiteModel.getGuid())).and().entriesListContains("targetGuid", this.secondSiteModel.getGuid());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify get favorites using empty for where parameter for request")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void userIsAbleToGetFavoritesWhenUsingEmptyWhereParameter() {
        this.userFavorites = this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingAuthUser().where().getFavorites();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.INVALID_ARGUMENT, "WHERE query"));
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify that for invalid maxItems parameter status code returned is 400.")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void checkInvalidMaxItemsStatusCode() {
        this.restClient.authenticateUser(this.adminUserModel).withParams(new String[]{"maxItems=AB"}).withCoreAPI().usingUser(this.adminUserModel).getFavorites();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary("Invalid paging parameter");
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify that for invalid skipCount parameter status code returned is 400.")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void checkInvalidSkipCountStatusCode() {
        this.restClient.authenticateUser(this.adminUserModel).withParams(new String[]{"skipCount=AB"}).withCoreAPI().usingUser(this.adminUserModel).getFavorites();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary("Invalid paging parameter");
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify get favorites when using invalid network id for non-tenant user")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void getFavoritesWhenNetworkIdIsInvalid() {
        UserModel networkUserModel = this.dataUser.createRandomTestUser();
        networkUserModel.setDomain("invalidNetwork");
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingUser(networkUserModel).where().targetSiteExist().getFavorites();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, networkUserModel.getUsername()));
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify get favorites using AND instead of OR in where parameter for request")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void userIsNotAbleToGetFavoritesWhenUsingANDInWhereParameter() {
        this.userFavorites = this.restClient.withCoreAPI().usingAuthUser().where().targetFolderExist().invalidWhereParameter("AND").targetFileExist().getFavorites();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.INVALID_ARGUMENT, "WHERE query"));
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify get favorites using wrong name instead of EXISTS in where parameter for request")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void userIsNotAbleToGetFavoritesWhenUsingWrongWhereParameter() {
        this.userFavorites = this.restClient.withCoreAPI().usingAuthUser().where().invalidWhereParameter("EXIST((target/site))").targetFileExist().getFavorites();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.INVALID_ARGUMENT, "WHERE query"));
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify get favorites except the first one for request")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void userIsAbleToGetFavoritesExceptTheFirstOne() {
        this.userFavorites = this.restClient.authenticateUser(this.userModel).withParams(new String[]{"skipCount=1"}).withCoreAPI().usingUser(this.userModel).getFavorites();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)this.userFavorites.assertThat().entriesListContains("targetGuid", this.firstSiteModel.getGuid())).and().entriesListContains("targetGuid", this.secondSiteModel.getGuid())).and().entriesListDoesNotContain("targetGuid", this.thirdSiteModel.getGuid());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify get first two favorites sites")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void userIsAbleToGetFirstTwoFavorites() {
        this.userFavorites = this.restClient.authenticateUser(this.userModel).withParams(new String[]{"maxItems=2"}).withCoreAPI().usingUser(this.userModel).getFavorites();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestPaginationModel)((RestPaginationModel)((RestModels)((RestModels)((RestModels)this.userFavorites.assertThat().entriesListContains("targetGuid", this.thirdSiteModel.getGuid())).and().entriesListContains("targetGuid", this.secondSiteModel.getGuid())).and().entriesListDoesNotContain("targetGuid", this.firstSiteModel.getGuid())).getPagination().assertThat().field("maxItems").is((Object)"2")).and().field("hasMoreItems").is((Object)"true")).and().field("count").is((Object)"2");
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify get favorites sites when using empty values for skipCount and maxItems")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void userIsAbleToGetFavoritesWhenSkipCountAndMaxItemsAreEmpty() {
        this.restClient.authenticateUser(this.userModel).withParams(new String[]{"skipCount= "}).withCoreAPI().usingUser(this.userModel).getFavorites();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.INVALID_SKIPCOUNT, " "));
        this.restClient.authenticateUser(this.userModel).withParams(new String[]{"maxItems= "}).withCoreAPI().usingUser(this.userModel).getFavorites();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.INVALID_MAXITEMS, " "));
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify the get favorites request for a high value for skipCount parameter")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void userIsAbleToGetFavoritesWithHighSkipCount() {
        this.userFavorites = this.restClient.authenticateUser(this.userModel).withParams(new String[]{"skipCount=999999999"}).withCoreAPI().usingUser(this.userModel).getFavorites();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.userFavorites.assertThat().entriesListIsEmpty()).assertThat().paginationField("skipCount").is("999999999");
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify the get favorites request with properties parameter applied")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void userIsAbleToGetFavoritesWithPropertiesParamApplied() {
        this.userFavorites = this.restClient.authenticateUser(this.userModel).withParams(new String[]{"properties=targetGuid"}).withCoreAPI().usingUser(this.userModel).getFavorites();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        RestPersonFavoritesModel restPersonFavoritesModel = ((RestPersonFavoritesModel)this.userFavorites.getEntries().get(0)).onModel();
        ((RestPersonFavoritesModel)restPersonFavoritesModel.assertThat().field("targetGuid").is((Object)this.thirdSiteModel.getGuid())).and().field("createdAt").isNull();
    }

    @Test(groups={"rest-api", "favorites", "regression"})
    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify entry details for get favorites response with Rest API")
    public void checkResponseSchemaForGetFavorites() {
        this.userFavorites = this.restClient.authenticateUser(this.userModel).withCoreAPI().usingAuthUser().getFavorites();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        RestPersonFavoritesModel restPersonFavoritesModel = ((RestPersonFavoritesModel)this.userFavorites.getEntries().get(0)).onModel();
        restPersonFavoritesModel.assertThat().field("targetGuid").is((Object)this.thirdSiteModel.getGuid());
        RestSiteModel restSiteModel = restPersonFavoritesModel.getTarget().getSite();
        ((RestSiteModel)((RestSiteModel)((RestSiteModel)((RestSiteModel)restSiteModel.assertThat().field("visibility").is((Object)this.thirdSiteModel.getVisibility())).and().field("guid").is((Object)this.thirdSiteModel.getGuid())).and().field("description").is((Object)this.thirdSiteModel.getDescription())).and().field("id").is((Object)this.thirdSiteModel.getId())).and().field("title").is((Object)this.thirdSiteModel.getTitle());
    }

    @Test(groups={"rest-api", "favorites", "regression"})
    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify if get favorites response returns allowableOperations object when requested")
    public void checkResponsesForGetFavoritesWithAllowableOperations() {
        RestPersonFavoritesModelsCollection adminFavorites = ((People)this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingAuthUser().include(new String[]{ALLOWABLE_OPERATIONS})).getFavorites();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        adminFavorites.getEntries().stream().map(RestPersonFavoritesModel::onModel).forEach(m -> m.assertThat().field(ALLOWABLE_OPERATIONS).isNotEmpty());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify the get favorites request with properties parameter applied")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void checkSearchResponseContainsIsFavoriteWhenRequested() throws InterruptedException {
        SearchRequest query = new SearchRequest();
        RestRequestQueryModel queryReq = new RestRequestQueryModel();
        queryReq.setQuery(this.firstFileModel.getName());
        query.setQuery(queryReq);
        query.setInclude(List.of("isFavorite"));
        Utility.sleep((int)500, (int)60000, () -> {
            this.restClient.authenticateUser(this.adminUserModel).withSearchAPI().search(query);
            this.restClient.onResponse().assertThat().body("list.entries.entry[0].isFavorite", Matchers.notNullValue(), new Object[0]);
        });
    }
}

