/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.sharedLinks;

import javax.json.Json;
import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestRenditionInfoModel;
import org.alfresco.rest.model.RestRenditionInfoModelCollection;
import org.alfresco.rest.model.RestSharedLinksModel;
import org.alfresco.rest.model.RestSharedLinksModelCollection;
import org.alfresco.rest.requests.coreAPI.RestCoreAPI;
import org.alfresco.utility.Utility;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.hamcrest.Matchers;
import org.springframework.http.HttpStatus;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class SharedLinksSanityTests
extends RestTest {
    private UserModel adminUser;
    private UserModel testUser1;
    private SiteModel siteModel1;
    private FolderModel folder1;
    private FileModel file1;
    private FileModel file2;
    private FileModel file3;
    private FileModel file4;
    private FileModel file5;
    private FileModel file6;
    private FileModel file7;
    private FileModel file8;
    private RestSharedLinksModel sharedLink1;
    private RestSharedLinksModel sharedLink2;
    private RestSharedLinksModel sharedLink3;
    private RestSharedLinksModel sharedLink4;
    private RestSharedLinksModel sharedLink5;
    private RestSharedLinksModel sharedLink6;
    private RestSharedLinksModel sharedLink7;
    private RestSharedLinksModel sharedLink8;
    private RestRenditionInfoModel nodeRenditionInfo;
    private RestSharedLinksModelCollection sharedLinksCollection;
    private RestRenditionInfoModelCollection nodeRenditionInfoCollection;
    private String expiryDate = "2027-03-23T23:00:00.000+0000";

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.restClient.authenticateUser(this.adminUser);
        this.testUser1 = ((DataUser)this.dataUser.usingUser(this.adminUser)).createRandomTestUser();
        this.siteModel1 = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        this.folder1 = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.siteModel1)).createFolder();
        this.file1 = ((DataContent)this.dataContent.usingUser(this.adminUser).usingResource((ContentModel)this.folder1)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.file2 = ((DataContent)this.dataContent.usingUser(this.adminUser).usingResource((ContentModel)this.folder1)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.file3 = ((DataContent)this.dataContent.usingUser(this.adminUser).usingResource((ContentModel)this.folder1)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.file4 = ((DataContent)this.dataContent.usingUser(this.adminUser).usingResource((ContentModel)this.folder1)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.file5 = ((DataContent)this.dataContent.usingUser(this.adminUser).usingResource((ContentModel)this.folder1)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.file7 = ((DataContent)this.dataContent.usingUser(this.adminUser).usingResource((ContentModel)this.folder1)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.file8 = ((DataContent)this.dataContent.usingUser(this.adminUser).usingResource((ContentModel)this.folder1)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        FileModel newFile = FileModel.getFileModelBasedOnTestDataFile((String)"sampleContent.txt");
        newFile.setName("sampleContent.txt");
        this.file6 = ((DataContent)this.dataContent.usingUser(this.adminUser).usingResource((ContentModel)this.folder1)).createContent(newFile);
    }

    @TestRail(section={"rest-api", "shared-links"}, executionType={ExecutionType.SANITY}, description="Verify create sharedLinks without Path")
    @Test(groups={"rest-api", "shared-links", "sanity"})
    public void testCreateAndGetSharedLinks() throws Exception {
        this.sharedLink1 = this.restClient.authenticateUser(this.testUser1).withCoreAPI().usingSharedLinks().createSharedLink(this.file1);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.onResponse().assertThat().body("entry.nodeId", Matchers.equalTo((Object)this.file1.getNodeRefWithoutVersion()), new Object[0]);
        this.restClient.onResponse().assertThat().body("entry.name", Matchers.equalTo((Object)this.file1.getName()), new Object[0]);
        this.restClient.onResponse().assertThat().body("entry.id", Matchers.equalTo((Object)this.sharedLink1.getId()), new Object[0]);
        this.restClient.onResponse().assertThat().body("entry.path", Matchers.nullValue(), new Object[0]);
        Assert.assertEquals((String)this.sharedLink1.getNodeId(), (String)this.file1.getNodeRefWithoutVersion());
        Assert.assertEquals((String)this.sharedLink1.getName(), (String)this.file1.getName());
        Assert.assertNull((Object)this.sharedLink1.getPath(), (String)("Path is expected to be null for noauth api: Response shows: " + this.sharedLink1.toJson()));
        this.restClient.authenticateUser(this.testUser1).withCoreAPI().usingSharedLinks().getSharedLink(this.sharedLink1);
        this.restClient.onResponse().assertThat().body("entry.nodeId", Matchers.equalTo((Object)this.file1.getNodeRefWithoutVersion()), new Object[0]);
        this.restClient.onResponse().assertThat().body("entry.name", Matchers.equalTo((Object)this.file1.getName()), new Object[0]);
        this.restClient.onResponse().assertThat().body("entry.id", Matchers.equalTo((Object)this.sharedLink1.getId()), new Object[0]);
        this.restClient.onResponse().assertThat().body("entry.path", Matchers.nullValue(), new Object[0]);
        Utility.sleep((int)500, (int)30000, () -> {
            this.sharedLinksCollection = this.restClient.withCoreAPI().usingSharedLinks().getSharedLinks();
            this.restClient.assertStatusCodeIs(HttpStatus.OK);
            ((RestModels)this.sharedLinksCollection.assertThat().entriesListContains("id", this.sharedLink1.getId())).and().entriesListContains("nodeId", this.sharedLink1.getNodeId());
        });
    }

    @TestRail(section={"rest-api", "shared-links"}, executionType={ExecutionType.REGRESSION}, description="Verify create sharedLinks with Path")
    @Test(groups={"rest-api", "shared-links", "regression"})
    public void testCreateAndGetSharedLinksWithInclude() throws Exception {
        this.sharedLink2 = ((RestCoreAPI)this.restClient.authenticateUser(this.testUser1).withCoreAPI().includePath()).usingSharedLinks().createSharedLink(this.file2);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.onResponse().assertThat().body("entry.nodeId", Matchers.equalTo((Object)this.file2.getNodeRefWithoutVersion()), new Object[0]);
        this.restClient.onResponse().assertThat().body("entry.name", Matchers.equalTo((Object)this.file2.getName()), new Object[0]);
        this.restClient.onResponse().assertThat().body("entry.id", Matchers.equalTo((Object)this.sharedLink2.getId()), new Object[0]);
        this.restClient.onResponse().assertThat().body("entry.path", Matchers.notNullValue(), new Object[0]);
        Assert.assertEquals((String)this.sharedLink2.getNodeId(), (String)this.file2.getNodeRefWithoutVersion());
        Assert.assertEquals((String)this.sharedLink2.getName(), (String)this.file2.getName());
        Assert.assertNotNull((Object)this.sharedLink2.getPath(), (String)("Path not expected to be null for noauth api: Response shows: " + this.sharedLink1.toJson()));
        this.restClient.authenticateUser(this.testUser1).withCoreAPI().usingSharedLinks().getSharedLink(this.sharedLink2);
        this.restClient.onResponse().assertThat().body("entry.nodeId", Matchers.equalTo((Object)this.file2.getNodeRefWithoutVersion()), new Object[0]);
        this.restClient.onResponse().assertThat().body("entry.name", Matchers.equalTo((Object)this.file2.getName()), new Object[0]);
        this.restClient.onResponse().assertThat().body("entry.id", Matchers.equalTo((Object)this.sharedLink2.getId()), new Object[0]);
        this.restClient.onResponse().assertThat().body("entry.path", Matchers.nullValue(), new Object[0]);
        this.sharedLink2 = this.restClient.withCoreAPI().usingSharedLinks().getSharedLink(this.sharedLink2);
        this.restClient.onResponse().assertThat().body("entry.nodeId", Matchers.equalTo((Object)this.file2.getNodeRefWithoutVersion()), new Object[0]);
        this.restClient.onResponse().assertThat().body("entry.name", Matchers.equalTo((Object)this.file2.getName()), new Object[0]);
        this.restClient.onResponse().assertThat().body("entry.id", Matchers.equalTo((Object)this.sharedLink2.getId()), new Object[0]);
        this.restClient.onResponse().assertThat().body("entry.path", Matchers.nullValue(), new Object[0]);
        Assert.assertEquals((String)this.sharedLink2.getNodeId(), (String)this.file2.getNodeRefWithoutVersion());
        Assert.assertEquals((String)this.sharedLink2.getName(), (String)this.file2.getName());
        Assert.assertNull((Object)this.sharedLink2.getPath(), (String)("Path is expected to be null for noauth api: Response shows: " + this.sharedLink2.toJson()));
    }

    @TestRail(section={"rest-api", "shared-links"}, executionType={ExecutionType.SANITY}, description="Verify delete sharedLinks with and without Path")
    @Test(groups={"rest-api", "shared-links", "sanity"})
    public void testDeleteSharedLinks() throws Exception {
        this.sharedLink3 = this.restClient.authenticateUser(this.testUser1).withCoreAPI().usingSharedLinks().createSharedLink(this.file3);
        this.restClient.authenticateUser(this.testUser1).withCoreAPI().usingSharedLinks().deleteSharedLink(this.sharedLink3);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.sharedLink4 = this.restClient.authenticateUser(this.testUser1).withCoreAPI().usingSharedLinks().createSharedLink(this.file4);
        ((RestCoreAPI)this.restClient.authenticateUser(this.testUser1).withCoreAPI().includePath()).usingSharedLinks().deleteSharedLink(this.sharedLink4);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
    }

    @TestRail(section={"rest-api", "shared-links"}, executionType={ExecutionType.SANITY}, description="Sanity tests for GET {sharedId}/content and POST {sharedId}/email endpoints")
    @Test(groups={"rest-api", "shared-links", "sanity"})
    public void testGetSharedLinkContentAndPostEmail() throws Exception {
        this.sharedLink6 = this.restClient.authenticateUser(this.testUser1).withCoreAPI().usingSharedLinks().createSharedLink(this.file6);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.withCoreAPI().usingSharedLinks().getSharedLinkContent(this.sharedLink6);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restClient.assertHeaderValueContains("Content-Disposition", this.file6.getName());
        this.restClient.onResponse().getResponse().body().asString().contains("Sample text.");
        String postBody = Json.createObjectBuilder().add("client", "share").add("recipientEmails", "john.doe@acme.com").build().toString();
        this.restClient.withCoreAPI().usingSharedLinks().sendSharedLinkEmail(this.sharedLink6, postBody);
        this.restClient.assertStatusCodeIs(HttpStatus.ACCEPTED);
    }

    @TestRail(section={"rest-api", "shared-links"}, executionType={ExecutionType.REGRESSION}, description="Verify get sharedLink/content and get/renditions")
    @Test(groups={"rest-api", "shared-links", "regression", "renditions"})
    public void testCreateWithExpiryDateAndGetSharedLinkRendition() throws Exception {
        this.sharedLink5 = ((RestCoreAPI)this.restClient.authenticateUser(this.testUser1).withCoreAPI().includePath()).usingSharedLinks().createSharedLinkWithExpiryDate(this.file5, this.expiryDate);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        Assert.assertEquals((String)this.sharedLink5.getExpiresAt(), (String)this.expiryDate);
        Assert.assertNotNull((Object)this.sharedLink5.getPath(), (String)("Path not expected to be null: Response shows: " + this.sharedLink5.toJson()));
        this.restClient.authenticateUser(this.testUser1).withCoreAPI().usingSharedLinks().getSharedLinkRenditions(this.sharedLink5);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @TestRail(section={"rest-api", "shared-links"}, executionType={ExecutionType.SANITY}, description="Sanity tests for GET /renditions, GET /renditions/{renditionId} and GET /renditions/{renditionId}/content endpoints")
    @Test(groups={"rest-api", "shared-links", "sanity", "renditions", "not-supported-by-ats"})
    public void testGetSharedLinkRendition() throws Exception {
        this.sharedLink7 = this.restClient.authenticateUser(this.testUser1).withCoreAPI().usingSharedLinks().createSharedLink(this.file7);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.withCoreAPI().usingNode((RepoTestModel)this.file7).createNodeRenditionIfNotExists("doclib");
        this.restClient.withCoreAPI().usingNode((RepoTestModel)this.file7).createNodeRendition("pdf");
        this.restClient.assertStatusCodeIs(HttpStatus.ACCEPTED);
        Utility.sleep((int)500, (int)50000, () -> {
            this.nodeRenditionInfoCollection = this.restClient.authenticateUser(this.testUser1).withCoreAPI().usingSharedLinks().getSharedLinkRenditions(this.sharedLink7);
            this.restClient.assertStatusCodeIs(HttpStatus.OK);
            this.nodeRenditionInfoCollection.assertThat().entriesListCountIs(2);
            ((RestRenditionInfoModel)((RestRenditionInfoModel)this.nodeRenditionInfoCollection.getEntryByIndex(0)).assertThat().field("id").is((Object)"doclib")).and().field("status").is((Object)"CREATED");
            ((RestRenditionInfoModel)((RestRenditionInfoModel)this.nodeRenditionInfoCollection.getEntryByIndex(1)).assertThat().field("id").is((Object)"pdf")).and().field("status").is((Object)"CREATED");
        });
        this.nodeRenditionInfo = this.restClient.authenticateUser(this.testUser1).withCoreAPI().usingSharedLinks().getSharedLinkRendition(this.sharedLink7, "pdf");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestRenditionInfoModel)this.nodeRenditionInfo.assertThat().field("id").is((Object)"pdf")).and().field("status").is((Object)"CREATED");
        this.restClient.authenticateUser(this.testUser1).withCoreAPI().usingSharedLinks().getSharedLinkRenditionContent(this.sharedLink7, "pdf");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restClient.assertHeaderValueContains("Content-Type", "application/pdf;charset=UTF-8");
        Assert.assertTrue((this.restClient.onResponse().getResponse().body().asInputStream().available() > 0 ? 1 : 0) != 0);
    }

    @TestRail(section={"rest-api", "shared-links"}, executionType={ExecutionType.SANITY}, description="Sanity tests for Range reuest header on   GET shared-links/{sharedId}/renditions/{renditionId}/content endpoints")
    @Test(groups={"rest-api", "shared-links", "sanity", "renditions"})
    public void testGetVerifyRangeReguestOnSharedLinks() throws Exception {
        this.sharedLink8 = this.restClient.authenticateUser(this.testUser1).withCoreAPI().usingSharedLinks().createSharedLink(this.file8);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.withCoreAPI().usingNode((RepoTestModel)this.file8).createNodeRendition("pdf");
        this.restClient.assertStatusCodeIs(HttpStatus.ACCEPTED);
        Utility.sleep((int)500, (int)30000, () -> {
            this.restClient.configureRequestSpec().addHeader("content-range", "bytes=1-10");
            this.restClient.authenticateUser(this.testUser1).withCoreAPI().usingSharedLinks().getSharedLinkRenditionContent(this.sharedLink8, "pdf");
            this.restClient.assertStatusCodeIs(HttpStatus.PARTIAL_CONTENT);
            this.restClient.assertHeaderValueContains("Content-Type", "application/pdf;charset=UTF-8");
            this.restClient.assertHeaderValueContains("content-range", "bytes 1-10");
        });
    }
}

