/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis;

import org.alfresco.cmis.CmisTest;
import org.alfresco.cmis.CmisWrapper;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class IsPrivateWorkingCopyTests
extends CmisTest {
    SiteModel testSite;
    UserModel managerUser;
    UserModel nonInvitedUser;
    FileModel checkedOutDoc;
    FileModel simpleDoc;
    private DataUser.ListUserWithRoles usersWithRoles;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.checkedOutDoc = FileModel.getRandomFileModel((FileType)FileType.XML, (String)this.documentContent);
        this.simpleDoc = FileModel.getRandomFileModel((FileType)FileType.HTML, (String)this.documentContent);
        this.managerUser = this.dataUser.createRandomTestUser();
        this.nonInvitedUser = this.dataUser.createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.managerUser)).createPublicRandomSite();
        this.usersWithRoles = ((DataUser)this.dataUser.usingUser(this.managerUser)).addUsersWithRolesToSite(this.testSite, new UserRole[]{UserRole.SiteContributor, UserRole.SiteCollaborator, UserRole.SiteConsumer});
        ((CmisWrapper)this.cmisApi.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.checkedOutDoc).and()).checkOut().createFile(this.simpleDoc);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify site manager is able to verify if checked out document is private working copy")
    @Test(groups={"sanity", "cmis"})
    public void siteManagerCanVerifyIsPrivateWorkingCopy() throws Exception {
        ((CmisWrapper)this.cmisApi.authenticateUser(this.managerUser).usingResource((ContentModel)this.checkedOutDoc).assertThat().isPrivateWorkingCopy().then()).usingResource((ContentModel)this.simpleDoc).assertThat().isNotPrivateWorkingCopy();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify site manager is able to verify if pwc document is private working copy")
    @Test(groups={"sanity", "cmis"})
    public void siteManagerCanVerifyIsPrivateWorkingCopyOnPwc() throws Exception {
        this.cmisApi.authenticateUser(this.managerUser).usingResource((ContentModel)this.checkedOutDoc).usingPWCDocument().assertThat().isPrivateWorkingCopy();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is not able to verify if deleted document is private working copy")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisObjectNotFoundException.class})
    public void siteManagerCannotVerifyIsPrivateWorkingCopyOnDeletedDoc() throws Exception {
        FileModel deletedDoc = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.documentContent);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(deletedDoc).then()).delete().and()).assertThat().doesNotExistInRepo().assertThat().isPrivateWorkingCopy();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site collaborator is able to verify if checked out document is private working copy")
    @Test(groups={"regression", "cmis"})
    public void collaboratorCanVerifyIsPrivateWorkingCopy() throws Exception {
        ((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingResource((ContentModel)this.checkedOutDoc).assertThat().isPrivateWorkingCopy().then()).usingResource((ContentModel)this.simpleDoc).assertThat().isNotPrivateWorkingCopy();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site contributor is able to verify if checked out document is private working copy")
    @Test(groups={"regression", "cmis"})
    public void contributorCanVerifyIsPrivateWorkingCopy() throws Exception {
        ((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingResource((ContentModel)this.checkedOutDoc).assertThat().isPrivateWorkingCopy().then()).usingResource((ContentModel)this.simpleDoc).assertThat().isNotPrivateWorkingCopy();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site consumer is able to verify if checked out document is private working copy")
    @Test(groups={"regression", "cmis"})
    public void consumerCanVerifyIsPrivateWorkingCopy() throws Exception {
        ((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).usingResource((ContentModel)this.checkedOutDoc).assertThat().isPrivateWorkingCopy().then()).usingResource((ContentModel)this.simpleDoc).assertThat().isNotPrivateWorkingCopy();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify non invited user is able to verify if checked out document is private working copy in public site")
    @Test(groups={"regression", "cmis"})
    public void nonInvitedUserCanVerifyIsPrivateWorkingCopyInPublicSite() throws Exception {
        ((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).usingResource((ContentModel)this.checkedOutDoc).assertThat().isPrivateWorkingCopy().then()).usingResource((ContentModel)this.simpleDoc).assertThat().isNotPrivateWorkingCopy();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify non invited user is not able to verify if checked out document is private working copy in private site")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void nonInvitedUserCannotVerifyIsPrivateWorkingCopyInPrivateSite() throws Exception {
        SiteModel privateSite = ((DataSite)this.dataSite.usingUser(this.managerUser)).createPrivateRandomSite();
        FileModel privateFile = FileModel.getRandomFileModel((FileType)FileType.HTML);
        ((CmisWrapper)this.cmisApi.authenticateUser(this.managerUser).usingSite(privateSite).createFile(privateFile).then()).authenticateUser(this.nonInvitedUser).assertThat().isPrivateWorkingCopy();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify non invited user is not able to verify if checked out document is private working copy in moderated site")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void nonInvitedUserCannotVerifyIsPrivateWorkingCopyInModeratedSite() throws Exception {
        SiteModel moderatedSite = ((DataSite)this.dataSite.usingUser(this.managerUser)).createPrivateRandomSite();
        FileModel moderatedFile = FileModel.getRandomFileModel((FileType)FileType.HTML);
        ((CmisWrapper)this.cmisApi.authenticateUser(this.managerUser).usingSite(moderatedSite).createFile(moderatedFile).then()).authenticateUser(this.nonInvitedUser).assertThat().isPrivateWorkingCopy();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to verify if document created with CHECKEDOUT versioning state is private working copy")
    @Test(groups={"regression", "cmis"})
    public void verifyIsPrivateWorkingCopyForDocumentWithCheckedOutVersioningState() throws Exception {
        FileModel checkedDoc = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.documentContent);
        this.cmisApi.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(checkedDoc, VersioningState.CHECKEDOUT).refreshResource().assertThat().isPrivateWorkingCopy();
    }
}

