/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis;

import java.util.HashMap;
import org.alfresco.cmis.CmisTest;
import org.alfresco.cmis.CmisWrapper;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisContentAlreadyExistsException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUnauthorizedException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class CreateFolderTests
extends CmisTest {
    UserModel testUser;
    SiteModel testSite;
    FolderModel testFolder;
    private DataUser.ListUserWithRoles usersWithRoles;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.testUser = this.dataUser.createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createPublicRandomSite();
        this.usersWithRoles = ((DataUser)this.dataUser.usingUser(this.testUser)).addUsersWithRolesToSite(this.testSite, new UserRole[]{UserRole.SiteContributor, UserRole.SiteCollaborator, UserRole.SiteConsumer});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify admin user is able to create folder in DocumentLibrary with CMIS")
    @Test(groups={"regression", "cmis"})
    public void adminShouldCreateFolder() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        ((CmisWrapper)this.cmisApi.authenticateUser(this.dataUser.getAdminUser()).usingSite(this.testSite).createFolder(this.testFolder).and()).assertThat().existsInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify site manager is able to create folder in DocumentLibrary with CMIS")
    @Test(groups={"sanity", "cmis"})
    public void siteManagerShouldCreateFolder() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        ((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.testFolder).and()).assertThat().existsInRepo();
    }

    @Bug(id="REPO-5388")
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify inexistent user can't create folder")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisUnauthorizedException.class})
    public void inexistentUserShouldNotCreateFolder() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        this.cmisApi.authenticateUser(new UserModel("random user", "random password")).usingSite(this.testSite).createFolder(this.testFolder);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify a folder with same name can't be created in the same location")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisContentAlreadyExistsException.class}, expectedExceptionsMessageRegExp="An object with this name already exists.*")
    public void shouldNotCreateFolderWithSameName() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        ((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.testFolder).and()).assertThat().existsInRepo();
        this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.testFolder);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify a folder can't be created at invalid path")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisObjectNotFoundException.class}, expectedExceptionsMessageRegExp="Object not found.*")
    public void shouldNotCreateFolderAtInvalidPath() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        this.cmisApi.authenticateUser(this.testUser).usingSite(new SiteModel("inexitentSite")).createFolder(this.testFolder);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is not able to create folder with invalid base type id with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisObjectNotFoundException.class})
    public void siteManagerCannotCreateFolderWithInvalidObjectTypeId() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.testFolder, "cmis:fakeType");
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is not able to create folder with cmis:document base type id with CMIS")
    @Test(groups={"bug-atom-REPO-5389", "regression", "cmis"}, expectedExceptions={CmisConstraintException.class}, expectedExceptionsMessageRegExp=".*Type is not a folder type.*")
    public void siteManagerCannotCreateFolderWithDocumentTypeId() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.testFolder, BaseTypeId.CMIS_DOCUMENT.value());
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify that admin user is not able to create folder with invalid characters in name")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisConstraintException.class})
    public void adminCannotCreateFolderWithInvalidCharacters() throws Exception {
        this.testFolder = new FolderModel("/.:?|\\`\\.txt");
        this.cmisApi.authenticateUser(this.dataUser.getAdminUser()).usingResource((ContentModel)FolderModel.getSharedFolderModel()).createFolder(this.testFolder);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify that admin user is not able to create folder with empty name")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisInvalidArgumentException.class}, expectedExceptionsMessageRegExp="Property cmis:name must be set!*")
    public void adminCannotCreateFolderWithEmptyName() throws Exception {
        this.cmisApi.authenticateUser(this.dataUser.getAdminUser()).usingResource((ContentModel)FolderModel.getSharedFolderModel()).createFolder(new FolderModel(""));
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is not able to create folder with empty properties")
    @Test(groups={"regression", "cmis"}, expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Properties must not be empty!*")
    public void siteManagerCannotCreateFolderWithNoParamenters() throws Exception {
        HashMap properties = new HashMap();
        this.testFolder = FolderModel.getRandomFolderModel();
        this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.testFolder, properties);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is not able to create folder with properties specific for documents")
    @Test(groups={"regression", "cmis"}, expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Property 'cmis:isLatestMajorVersion' is not valid for this type or one of the secondary types!*")
    public void siteManagerCannotCreateFolderWithDocumentParamenters() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("cmis:objectTypeId", BaseTypeId.CMIS_FOLDER.value());
        properties.put("cmis:name", this.testFolder.getName());
        properties.put("cmis:isLatestMajorVersion", "true");
        this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.testFolder, properties);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify contributor is able to create folder")
    @Test(groups={"regression", "cmis"})
    public void contributorCanCreateFolder() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        ((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingSite(this.testSite).createFolder(this.testFolder).and()).assertThat().existsInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify collaborator is able to create folder")
    @Test(groups={"regression", "cmis"})
    public void collaboratorCanCreateFolder() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        ((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingSite(this.testSite).createFolder(this.testFolder).and()).assertThat().existsInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify consumer is not able to create folder")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void consumerCannotCreateFolder() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).usingSite(this.testSite).createFolder(this.testFolder);
    }

    @Bug(id="REPO-5388")
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify disabled user is not able to create folder in Shared location")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisUnauthorizedException.class})
    public void disabledUserShouldNotCreateFolder() throws Exception {
        UserModel disabled = this.dataUser.createRandomTestUser();
        this.testFolder = FolderModel.getRandomFolderModel();
        this.cmisApi.authenticateUser(disabled);
        ((DataUser)this.dataUser.usingAdmin()).disableUser(disabled);
        this.cmisApi.usingShared().createFolder(this.testFolder);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify non invited user is not able to create folder in private site")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void nonInvitedUserShouldNotCreateDocumentInPrivateSite() throws Exception {
        SiteModel privateSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createPrivateRandomSite();
        this.testFolder = FolderModel.getRandomFolderModel();
        this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingSite(privateSite).createFolder(this.testFolder);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to create folder with a name containing multi byte characters.")
    @Test(groups={"regression", "cmis"})
    public void managerIsAbleToCreateFolderWithMultiByteName() throws Exception {
        this.testFolder = new FolderModel(RandomData.getRandomAlphanumeric() + "\ufeff\u6768\u6728\u91d1");
        ((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.testFolder).and()).assertThat().existsInRepo();
    }
}

