/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis;

import org.alfresco.cmis.CmisTest;
import org.alfresco.cmis.CmisWrapper;
import org.alfresco.cmis.exception.InvalidCmisObjectException;
import org.alfresco.utility.Utility;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisContentAlreadyExistsException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUnauthorizedException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class CreateDocumentFromSourceTests
extends CmisTest {
    SiteModel publicSite;
    SiteModel privateSite;
    UserModel siteManager;
    FileModel sourceFile;
    FileModel newFile;
    String sourceContent = "source content";
    private DataUser.ListUserWithRoles usersWithRoles;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.siteManager = this.dataUser.createRandomTestUser();
        this.publicSite = ((DataSite)this.dataSite.usingUser(this.siteManager)).createPublicRandomSite();
        this.privateSite = ((DataSite)this.dataSite.usingUser(this.siteManager)).createPrivateRandomSite();
        this.usersWithRoles = this.dataUser.addUsersWithRolesToSite(this.publicSite, new UserRole[]{UserRole.SiteManager, UserRole.SiteContributor, UserRole.SiteCollaborator, UserRole.SiteConsumer});
        this.sourceFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.sourceContent);
        ((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.sourceFile).and()).assertThat().existsInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify site manager is able to create file from source in DocumentLibrary with CMIS")
    @Test(groups={"sanity", "cmis", "not_supported_on_cmis_atom"})
    public void siteManagerShouldCreateDocumentFromSource() throws Exception {
        this.newFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFileFromSource(this.newFile, (ContentModel)this.sourceFile).and()).refreshResource().then()).assertThat().existsInRepo().and()).assertThat().contentIs(this.sourceContent);
    }

    @Bug(id="REPO-5388")
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify inexistent user isn't able to create file from source in DocumentLibrary with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisUnauthorizedException.class})
    public void inexistentUserShouldNotCreateDocumentFromSource() throws Exception {
        this.newFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        UserModel inexistentUser = new UserModel("inexistent", "inexistent");
        this.cmisApi.authenticateUser(inexistentUser).usingSite(this.publicSite).createFileFromSource(this.newFile, (ContentModel)this.sourceFile);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify unauthorized user isn't able to create file from source in DocumentLibrary with CMIS")
    @Test(groups={"sanity", "cmis", "not_supported_on_cmis_atom"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void unauthorizedUserShouldNotCreateDocumentFromSource() throws Exception {
        UserModel unauthorizedUser = this.dataUser.createRandomTestUser();
        this.newFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.cmisApi.authenticateUser(unauthorizedUser).usingSite(this.publicSite).createFileFromSource(this.newFile, (ContentModel)this.sourceFile);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify that manager user is not able to create document from source twice in the same location with CMIS")
    @Test(groups={"regression", "cmis", "not_supported_on_cmis_atom"}, expectedExceptions={CmisContentAlreadyExistsException.class})
    public void siteManagerCannotCreateDocumentFromSourceTwice() throws Exception {
        this.newFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFileFromSource(this.newFile, (ContentModel)this.sourceFile).and()).assertThat().existsInRepo().then()).usingSite(this.publicSite).createFileFromSource(this.newFile, (ContentModel)this.sourceFile);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify that admin user is not able to create document from source with invalid source with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisObjectNotFoundException.class})
    public void adminCannotCreateDocFromInvalidSource() throws Exception {
        this.newFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        FileModel sourceFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.dataUser.getAdminUser()).usingSite(this.publicSite).createFile(sourceFile).and()).assertThat().existsInRepo().then()).delete().when()).usingResource((ContentModel)sourceFile).createFileFromSource(this.newFile, (ContentModel)sourceFile);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify that manager user is not able to create document from source with invalid characters with CMIS")
    @Test(groups={"regression", "cmis", "not_supported_on_cmis_atom"}, expectedExceptions={CmisConstraintException.class})
    public void siteManagerCannotCreateDocFromSourceWithInvalidChars() throws Exception {
        this.newFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        FileModel invalidCharDoc = new FileModel("/.:?|\\`\\.txt", FileType.TEXT_PLAIN);
        this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFileFromSource(invalidCharDoc, (ContentModel)this.sourceFile);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify that admin user is not able to create document from source at invalid location with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisObjectNotFoundException.class})
    public void adminCannotCreateDocumentAtInvalidPath() throws Exception {
        this.newFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        FolderModel invalidLocation = new FolderModel("/Shared/invalidFolder");
        this.cmisApi.authenticateUser(this.dataUser.getAdminUser()).usingResource((ContentModel)invalidLocation).createFileFromSource(this.newFile, (ContentModel)this.sourceFile);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is not able to create file from folder source CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={InvalidCmisObjectException.class})
    public void siteManagerShouldNotCreateDocFromFolderSource() throws Exception {
        this.newFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        FolderModel folderSource = FolderModel.getRandomFolderModel();
        ((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFolder(folderSource).then()).createFileFromSource(this.newFile, (ContentModel)folderSource);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify that manager user is not able to create document from source with invalid base type id with CMIS")
    @Test(groups={"regression", "cmis", "not_supported_on_cmis_atom"}, expectedExceptions={CmisContentAlreadyExistsException.class})
    public void siteManagerCannotCreateDocFromSourceWithInvalidBaseTypeId() throws Exception {
        this.newFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFileFromSource(this.newFile, (ContentModel)this.sourceFile).and()).assertThat().existsInRepo().then()).usingSite(this.publicSite).createFileFromSource(this.newFile, (ContentModel)this.sourceFile, "cmis:fakeType");
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify that manager user is not able to create an unnamed document from source with CMIS")
    @Test(groups={"regression", "cmis", "not_supported_on_cmis_atom"})
    public void siteManagerCannotCreateUnnamedDocFromSource() throws Exception {
        this.newFile = new FileModel("");
        ((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFileFromSource(this.newFile, (ContentModel)this.sourceFile).then()).usingSite(this.publicSite).assertThat().doesNotHaveFile(new FileModel[]{this.newFile});
        Utility.sleep((int)100, (int)10000, () -> this.cmisApi.usingSite(this.publicSite).assertThat().doesNotHaveFile(new FileModel[]{this.newFile}));
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to create file from source added by another user with CMIS")
    @Test(groups={"regression", "cmis", "not_supported_on_cmis_atom"})
    public void anotherSiteManagerShouldCreateDocumentFromSource() throws Exception {
        this.newFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).usingSite(this.publicSite).createFileFromSource(this.newFile, (ContentModel)this.sourceFile);
        Utility.sleep((int)100, (int)10000, () -> ((CmisWrapper)((CmisWrapper)this.cmisApi.refreshResource().then()).assertThat().existsInRepo().and()).assertThat().contentIs(this.sourceContent));
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site contributor is able to create file from source added by another user with CMIS")
    @Test(groups={"regression", "cmis", "not_supported_on_cmis_atom"})
    public void contributorShouldCreateDocumentFromSource() throws Exception {
        this.newFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingSite(this.publicSite).createFileFromSource(this.newFile, (ContentModel)this.sourceFile);
        Utility.sleep((int)100, (int)10000, () -> ((CmisWrapper)((CmisWrapper)this.cmisApi.refreshResource().then()).assertThat().existsInRepo().and()).assertThat().contentIs(this.sourceContent));
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site collaborator is able to create file from source added by another user with CMIS")
    @Test(groups={"regression", "cmis", "not_supported_on_cmis_atom"})
    public void collaboratorShouldCreateDocumentFromSource() throws Exception {
        this.newFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingSite(this.publicSite).createFileFromSource(this.newFile, (ContentModel)this.sourceFile);
        Utility.sleep((int)100, (int)10000, () -> ((CmisWrapper)((CmisWrapper)this.cmisApi.refreshResource().then()).assertThat().existsInRepo().and()).assertThat().contentIs(this.sourceContent));
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site consumer is not able to create file from source with CMIS")
    @Test(groups={"regression", "cmis", "not_supported_on_cmis_atom"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void consumerShouldNotCreateDocumentFromSource() throws Exception {
        this.newFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).usingSite(this.publicSite).createFileFromSource(this.newFile, (ContentModel)this.sourceFile);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to create file from source with versioning state set to Minor with CMIS")
    @Test(groups={"regression", "cmis", "not_supported_on_cmis_atom"})
    public void managerCreatesDocumentFromSourceWithVersionMinor() throws Exception {
        this.newFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFileFromSource(this.newFile, (ContentModel)this.sourceFile, VersioningState.MINOR);
        Utility.sleep((int)100, (int)10000, () -> ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.refreshResource().then()).assertThat().existsInRepo().and()).assertThat().contentIs(this.sourceContent).and()).assertThat().documentHasVersion(0.1).and()).assertThat().isNotLatestMajorVersion());
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to create file from source with versioning state set to None with CMIS")
    @Test(groups={"regression", "cmis", "not_supported_on_cmis_atom"})
    public void managerShouldCreateDocumentFromSourceWithVersionNone() throws Exception {
        this.newFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFileFromSource(this.newFile, (ContentModel)this.sourceFile, VersioningState.NONE);
        Utility.sleep((int)100, (int)35000, () -> ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.refreshResource().then()).assertThat().existsInRepo().and()).assertThat().contentIs(this.sourceContent).and()).assertThat().documentHasVersion(1.0));
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to create file from source with versioning state set to CHECKEDOUT with CMIS")
    @Test(groups={"regression", "cmis", "not_supported_on_cmis_atom"})
    public void managerCreatesDocumentFromSourceWithVersionCHECKEDOUT() throws Exception {
        this.newFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFileFromSource(this.newFile, (ContentModel)this.sourceFile, VersioningState.CHECKEDOUT);
        Utility.sleep((int)100, (int)35000, () -> ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.refreshResource().then()).assertThat().existsInRepo().and()).assertThat().contentIs(this.sourceContent).and()).assertThat().documentIsCheckedOut());
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify that admin user is not able to create document from null source with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={NullPointerException.class})
    public void adminCannotCreateDocFromNullSource() throws Exception {
        this.newFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ContentModel sourceFile = null;
        this.cmisApi.authenticateUser(this.dataUser.getAdminUser()).usingSite(this.publicSite).createFileFromSource(this.newFile, sourceFile);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify that manager is able to create document from a source that is checked out with CMIS")
    @Test(groups={"regression", "cmis", "not_supported_on_cmis_atom"})
    public void managerShouldCreateDocFromSourceThatIsCheckedOut() throws Exception {
        this.newFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        FileModel sourceFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.sourceContent);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(sourceFile).and()).assertThat().existsInRepo().then()).checkOut().and()).assertThat().documentIsCheckedOut().when()).usingSite(this.publicSite).createFileFromSource(this.newFile, (ContentModel)sourceFile).then()).assertThat().existsInRepo().and()).assertThat().contentIs(this.sourceContent).and()).assertThat().documentIsNotCheckedOut();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify that manager is able to create document from a source from his private site with CMIS")
    @Test(groups={"regression", "cmis", "not_supported_on_cmis_atom"})
    public void managerShouldCreateDocFromSourceFromHisPrivateSite() throws Exception {
        this.newFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        FileModel sourceFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.sourceContent);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.privateSite).createFile(sourceFile).and()).assertThat().existsInRepo().when()).usingSite(this.publicSite).createFileFromSource(this.newFile, (ContentModel)sourceFile).then()).assertThat().existsInRepo().and()).assertThat().contentIs(this.sourceContent);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify that an user is not able to create document from a source from a private site with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void userShouldNotCreateDocFromSourceFromPrivateSite() throws Exception {
        this.newFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        FileModel sourceFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.sourceContent);
        ((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.privateSite).createFile(sourceFile).and()).assertThat().existsInRepo();
        this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).usingSite(this.publicSite).createFileFromSource(this.newFile, (ContentModel)sourceFile);
    }
}

