/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis;

import org.alfresco.cmis.CmisTest;
import org.alfresco.cmis.CmisWrapper;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisContentAlreadyExistsException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUpdateConflictException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class RenameTests
extends CmisTest {
    SiteModel testSite;
    UserModel managerUser;
    UserModel inexistentUser;
    UserModel nonInvitedUser;
    FileModel testFile;
    FolderModel testFolder;
    private DataUser.ListUserWithRoles usersWithRoles;
    private String prefix = "-edit";

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.managerUser = this.dataUser.createRandomTestUser();
        this.nonInvitedUser = this.dataUser.createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.managerUser)).createPublicRandomSite();
        this.inexistentUser = new UserModel("inexistent", "inexistent");
        this.usersWithRoles = ((DataUser)this.dataUser.usingUser(this.managerUser)).addUsersWithRolesToSite(this.testSite, new UserRole[]{UserRole.SiteContributor, UserRole.SiteCollaborator, UserRole.SiteConsumer});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify site manager is able to rename document and folder created by himself")
    @Test(groups={"sanity", "cmis"})
    public void siteManagerCanRenameContent() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.documentContent);
        this.testFolder = FolderModel.getRandomFolderModel();
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).assertThat().existsInRepo().createFolder(this.testFolder).assertThat().existsInRepo().then()).usingResource((ContentModel)this.testFile).rename(this.testFile.getName() + this.prefix).assertThat().existsInRepo().when()).usingResource((ContentModel)this.testFile).assertThat().doesNotExistInRepo().then()).usingResource((ContentModel)this.testFolder).rename(this.testFolder.getName() + this.prefix).assertThat().existsInRepo().when()).usingResource((ContentModel)this.testFolder).assertThat().doesNotExistInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify admin user is able to rename document and folder created by himself")
    @Test(groups={"regression", "cmis"})
    public void adminCanRenameContentFromPublicSite() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.documentContent);
        this.testFolder = FolderModel.getRandomFolderModel();
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).assertThat().existsInRepo().createFolder(this.testFolder).assertThat().existsInRepo().then()).authenticateUser(this.dataUser.getAdminUser()).usingResource((ContentModel)this.testFile).rename(this.testFile.getName() + this.prefix).assertThat().existsInRepo().when()).usingResource((ContentModel)this.testFile).assertThat().doesNotExistInRepo().usingResource((ContentModel)this.testFolder).rename(this.testFolder.getName() + this.prefix).assertThat().existsInRepo().when()).usingResource((ContentModel)this.testFolder).assertThat().doesNotExistInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is not able to rename inexistent document")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisObjectNotFoundException.class})
    public void siteManagerCannotRenameInexistentDocument() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.documentContent);
        this.testFile.setCmisLocation("/fake-folder/test.txt");
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.managerUser).usingSite(this.testSite).then()).usingResource((ContentModel)this.testFile).rename(this.testFile.getName() + this.prefix).assertThat().existsInRepo().when()).usingResource((ContentModel)this.testFile).assertThat().doesNotExistInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is not able to rename inexistent folder")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisObjectNotFoundException.class})
    public void siteManagerCannotRenameInexistentFolder() throws Exception {
        FolderModel folder = FolderModel.getRandomFolderModel();
        folder.setCmisLocation("/" + folder.getName() + "/");
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.managerUser).usingSite(this.testSite).then()).usingResource((ContentModel)folder).rename(this.prefix).assertThat().existsInRepo().when()).usingResource((ContentModel)this.testFile).assertThat().doesNotExistInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is not able to rename document with invalid symbols")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisConstraintException.class})
    public void siteManagerCannotRenameDocumentInvalidSymbols() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.documentContent);
        ((CmisWrapper)this.cmisApi.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).assertThat().existsInRepo().then()).usingResource((ContentModel)this.testFile).rename("/.:?|\\`\\.txt").assertThat().existsInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is not able to rename folder with invalid symbols")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisConstraintException.class})
    public void siteManagerCannotRenameFolderInvalidSymbols() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        ((CmisWrapper)this.cmisApi.authenticateUser(this.managerUser).usingSite(this.testSite).createFolder(this.testFolder).assertThat().existsInRepo().then()).usingResource((ContentModel)this.testFolder).rename("/.:?|\\`\\.txt").assertThat().existsInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is not able to rename document with empty string")
    @Test(groups={"regression", "cmis"}, expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="New name must not be empty!*")
    public void siteManagerCannotRenameDocumentEmptyName() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.documentContent);
        ((CmisWrapper)this.cmisApi.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).assertThat().existsInRepo().then()).usingResource((ContentModel)this.testFile).rename("").assertThat().existsInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is not able to rename folder with empty name")
    @Test(groups={"regression", "cmis"}, expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="New name must not be empty!*")
    public void siteManagerCannotRenameFolderEmptyName() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        ((CmisWrapper)this.cmisApi.authenticateUser(this.managerUser).usingSite(this.testSite).createFolder(this.testFolder).assertThat().existsInRepo().then()).usingResource((ContentModel)this.testFolder).rename("").assertThat().existsInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is not able to rename checked out document")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisUpdateConflictException.class})
    public void siteManagerCannotRenameCheckedOutDocument() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.documentContent);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).assertThat().existsInRepo().then()).checkOut().assertThat().documentIsCheckedOut().then()).usingResource((ContentModel)this.testFile).rename(this.testFile.getName() + this.prefix).assertThat().existsInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to rename pwc document")
    @Test(groups={"regression", "cmis"})
    public void siteManagerCanRenamePwcDocument() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.documentContent);
        FileModel renamedPwc = new FileModel("pwc" + this.prefix + " (Working Copy)");
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).assertThat().existsInRepo().then()).checkOut().assertThat().documentIsCheckedOut().then()).usingResource((ContentModel)this.testFile).usingPWCDocument().assertThat().existsInRepo().rename("pwc" + this.prefix);
        renamedPwc.setCmisLocation(this.testFile.getCmisLocation().replace(this.testFile.getName(), renamedPwc.getName()));
        this.cmisApi.usingResource((ContentModel)renamedPwc).assertThat().existsInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to rename document with same name")
    @Test(groups={"regression", "cmis"})
    public void siteManagerCanRenameDocumentWithSameName() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.documentContent);
        ((CmisWrapper)this.cmisApi.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).assertThat().existsInRepo().then()).usingResource((ContentModel)this.testFile).rename(this.testFile.getName()).assertThat().existsInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to rename document with multiple versions")
    @Test(groups={"regression", "cmis", "not_supported_on_cmis_ws"})
    public void siteManagerCanRenameDocumentWithMultipleVersions() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.documentContent);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).assertThat().existsInRepo().then()).update("first content").assertThat().documentHasVersion(1.1).then()).update("second content").assertThat().documentHasVersion(1.2).rename(this.testFile.getName() + this.prefix).assertThat().existsInRepo().and()).assertThat().documentHasVersion(1.2);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site collaborator is able to rename document created by manager")
    @Test(groups={"regression", "cmis"})
    public void siteCollaboratorCanRenameDocumentCreatedByManager() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.documentContent);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).assertThat().existsInRepo().then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).rename(this.testFile.getName() + this.prefix).assertThat().existsInRepo().when()).usingResource((ContentModel)this.testFile).assertThat().doesNotExistInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site collaborator is able to rename folder created by manager")
    @Test(groups={"regression", "cmis"})
    public void siteCollaboratorCanRenameFolderCreatedByManager() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.managerUser).usingSite(this.testSite).createFolder(this.testFolder).assertThat().existsInRepo().then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).rename(this.testFolder.getName() + this.prefix).assertThat().existsInRepo().when()).usingResource((ContentModel)this.testFolder).assertThat().doesNotExistInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to rename folder created by collaborator")
    @Test(groups={"regression", "cmis"})
    public void siteManagerCanRenameFolderCreatedByCollaborator() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingSite(this.testSite).createFolder(this.testFolder).assertThat().existsInRepo().then()).authenticateUser(this.managerUser).rename(this.testFolder.getName() + this.prefix).assertThat().existsInRepo().when()).usingResource((ContentModel)this.testFolder).assertThat().doesNotExistInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site collaborator is able to rename document created by himself")
    @Test(groups={"regression", "cmis"})
    public void siteCollaboratorCanRenameDocumentCreatedByHimself() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.documentContent);
        ((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingSite(this.testSite).createFile(this.testFile).assertThat().existsInRepo().rename(this.testFile.getName() + this.prefix).assertThat().existsInRepo().when()).usingResource((ContentModel)this.testFile).assertThat().doesNotExistInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site contributor is not able to rename document created by manager")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void siteContributorCannotRenameDocumentCreatedByManager() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.documentContent);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).assertThat().existsInRepo().then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).rename(this.testFile.getName() + this.prefix).assertThat().existsInRepo().when()).usingResource((ContentModel)this.testFile).assertThat().doesNotExistInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site contributor is able to rename document created by himself")
    @Test(groups={"regression", "cmis"})
    public void siteContributorCanRenameDocumentCreatedByHimself() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.documentContent);
        ((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingSite(this.testSite).createFile(this.testFile).assertThat().existsInRepo().rename(this.testFile.getName() + this.prefix).assertThat().existsInRepo().when()).usingResource((ContentModel)this.testFile).assertThat().doesNotExistInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site consumer is not able to rename document created by manager")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void siteConsumerCannotRenameDocumentCreatedByManager() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.documentContent);
        ((CmisWrapper)this.cmisApi.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).assertThat().existsInRepo().then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).rename(this.testFile.getName() + this.prefix).assertThat().existsInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify non invited user is not able to rename document in public site")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void siteConsumerCannotRenameDocumentInPublicSite() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.documentContent);
        ((CmisWrapper)this.cmisApi.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).assertThat().existsInRepo().then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).rename(this.testFile.getName() + this.prefix).assertThat().existsInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify non invited user is not able to rename document in private site")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void nonInvitedUserCannotRenameDocumentInPrivateSite() throws Exception {
        SiteModel privateSite = ((DataSite)this.dataSite.usingUser(this.managerUser)).createPrivateRandomSite();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.documentContent);
        ((CmisWrapper)this.cmisApi.authenticateUser(this.managerUser).usingSite(privateSite).createFile(this.testFile).assertThat().existsInRepo().then()).authenticateUser(this.nonInvitedUser).rename(this.testFile.getName() + this.prefix).assertThat().existsInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify non invited user is not able to rename document in moderated site")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void nonInvitedUserCannotRenameDocumentInModeratedSite() throws Exception {
        SiteModel moderatedSite = ((DataSite)this.dataSite.usingUser(this.managerUser)).createModeratedRandomSite();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.documentContent);
        ((CmisWrapper)this.cmisApi.authenticateUser(this.managerUser).usingSite(moderatedSite).createFile(this.testFile).assertThat().existsInRepo().then()).authenticateUser(this.nonInvitedUser).rename(this.testFile.getName() + this.prefix).assertThat().existsInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is not able to rename document with same name as another file in same location")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisContentAlreadyExistsException.class}, expectedExceptionsMessageRegExp="An object with this name already exists.*")
    public void siteManagerCannotRenameDocumentWithSameNameFromOtherFile() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.documentContent);
        FileModel secondFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.documentContent);
        ((CmisWrapper)this.cmisApi.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).assertThat().existsInRepo().createFile(secondFile).then()).usingResource((ContentModel)this.testFile).rename(secondFile.getName()).assertThat().existsInRepo();
    }
}

