/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis;

import org.alfresco.cmis.CmisTest;
import org.alfresco.cmis.CmisWrapper;
import org.alfresco.cmis.exception.InvalidCmisObjectException;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.chemistry.opencmis.commons.exceptions.CmisContentAlreadyExistsException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUnauthorizedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUpdateConflictException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class SetContentTests
extends CmisTest {
    UserModel siteManager;
    SiteModel publicSite;
    FileModel testFile;
    FolderModel testFolder;
    private String someContent = "some content";
    private String secondContent = "second content";
    private DataUser.ListUserWithRoles usersWithRoles;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.siteManager = this.dataUser.createRandomTestUser();
        this.publicSite = ((DataSite)this.dataSite.usingUser(this.siteManager)).createPublicRandomSite();
        this.usersWithRoles = this.dataUser.addUsersWithRolesToSite(this.publicSite, new UserRole[]{UserRole.SiteManager, UserRole.SiteContributor, UserRole.SiteCollaborator, UserRole.SiteConsumer});
    }

    @Test(groups={"sanity", "cmis", "not_supported_on_cmis_ws"})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify site manager is able to set content to a valid document in DocumentLibrary with CMIS")
    public void siteManagerSetFileContentForFileCreatedBySelf() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"first content");
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.testFile).assertThat().existsInRepo().then()).update("content").then()).setContent(this.someContent).and()).refreshResource().then()).assertThat().contentIs(this.someContent).and()).assertThat().contentLengthIs(12L);
    }

    @Test(expectedExceptions={InvalidCmisObjectException.class}, groups={"regression", "cmis"})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify if exception is thrown when user tries to set content to an invalid document in DocumentLibrary with CMIS")
    public void siteManagerSetFolderContent() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFolder(this.testFolder).setContent(this.someContent);
    }

    @Bug(id="REPO-5388")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisUnauthorizedException.class})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify that inexistent user is not able to set content to a document with CMIS")
    public void inexistentUserCannotSetFileContent() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.testFile).assertThat().existsInRepo().then()).authenticateUser(UserModel.getRandomUserModel()).setContent(this.someContent);
    }

    @Test(groups={"regression", "cmis"})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to set content to a document with no content with overwrite parameter set to false with CMIS")
    public void siteManagerCanSetContentWithFalseOverwriteToDocWithNoContent() throws Exception {
        FileModel newFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(newFile).assertThat().existsInRepo().deleteContent(true).then()).assertThat().contentLengthIs(-1L).then()).setContent(this.someContent, false).and()).assertThat().contentIs(this.someContent);
    }

    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisContentAlreadyExistsException.class})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is not able to set content to a document with content with overwrite parameter set to false with CMIS")
    public void siteManagerCanSetContentWithFalseOverwriteToDocWithContent() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.someContent);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.testFile).assertThat().existsInRepo().and()).assertThat().contentIs(this.someContent).then()).setContent(this.secondContent, false);
    }

    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify unauthorized user is not able to set content to a document")
    public void unauthorizedUserCannotSetContent() throws Exception {
        UserModel unauthorizedUser = this.dataUser.createRandomTestUser();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.someContent);
        ((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.testFile).assertThat().existsInRepo().then()).authenticateUser(unauthorizedUser).setContent(this.secondContent);
    }

    @Test(groups={"regression", "cmis"})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify admin is able to set file content with CMIS")
    public void adminCanSetFileContent() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"first content");
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingSite(this.publicSite).createFile(this.testFile).assertThat().existsInRepo().then()).authenticateUser(this.dataUser.getAdminUser()).and()).setContent(this.someContent).and()).refreshResource().then()).assertThat().contentIs(this.someContent).and()).assertThat().contentLengthIs(12L);
    }

    @Test(groups={"sanity", "cmis"})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify site manager is able to set file content  for a file created by other user with CMIS")
    public void managerCanSetFileContentForFileCreatedByOtherUser() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"first content");
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingSite(this.publicSite).createFile(this.testFile).assertThat().existsInRepo().then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).and()).setContent(this.someContent).and()).refreshResource().then()).assertThat().contentIs(this.someContent).and()).assertThat().contentLengthIs(12L);
    }

    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site contributor is not able to set content to a document created by other user with CMIS")
    public void contributorCannotSetFileContentForFileCreatedByOtherUser() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"first content");
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.testFile).assertThat().existsInRepo().then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).then()).setContent(this.someContent);
    }

    @Test(groups={"regression", "cmis"})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site contributor is able to set content to a document created by self with CMIS")
    public void contributorCanSetFileContentForFileCreatedBySelf() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"first content");
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingSite(this.publicSite).createFile(this.testFile).assertThat().existsInRepo().then()).setContent(this.someContent).and()).refreshResource().then()).assertThat().contentIs(this.someContent).and()).assertThat().contentLengthIs(12L);
    }

    @Test(groups={"regression", "cmis"})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site collaborator is able to set content to a document created by other user with CMIS")
    public void collaboratorCanSetFileContentForFileCreatedByOtherUser() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"first content");
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.testFile).assertThat().existsInRepo().then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).then()).usingResource((ContentModel)this.testFile).setContent(this.someContent).and()).refreshResource().and()).assertThat().contentIs(this.someContent).assertThat().contentLengthIs(12L);
    }

    @Test(groups={"regression", "cmis"})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site collaborator is able to set content to a document created by self with CMIS")
    public void collaboratorCanSetFileContentForFileCreatedBySelf() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"first content");
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingSite(this.publicSite).createFile(this.testFile).assertThat().existsInRepo().then()).setContent(this.someContent).and()).refreshResource().then()).assertThat().contentIs(this.someContent).and()).assertThat().contentLengthIs(12L);
    }

    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site consumer is not able to set file content with CMIS")
    public void consumerCannotSetFileContent() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"first content");
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.testFile).assertThat().existsInRepo().then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).then()).setContent(this.someContent);
    }

    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisUpdateConflictException.class}, expectedExceptionsMessageRegExp="^.*Cannot perform operation since the node.*is locked.$")
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to set content to a checked out document with CMIS")
    public void siteManagerCannotSetContentToCheckedOutFile() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"first content");
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.testFile).assertThat().existsInRepo().then()).checkOut().and()).assertThat().documentIsCheckedOut().setContent(this.someContent);
    }

    @Test(groups={"regression", "cmis"})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to set content to PWC document version with CMIS")
    public void siteManagerSetContentToPWCFile() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"first content");
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.testFile).assertThat().existsInRepo().then()).checkOut().and()).assertThat().documentIsCheckedOut().usingPWCDocument().setContent(this.someContent).and()).refreshResource().then()).assertThat().contentIs(this.someContent).and()).assertThat().contentLengthIs(12L);
    }

    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify unauthorized user is not able to set content to a document from a private site")
    public void unauthorizedUserCannotSetContentToPrivateSiteDoc() throws Exception {
        SiteModel privateSite = ((DataSite)this.dataSite.usingUser(this.siteManager)).createPrivateRandomSite();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.someContent);
        ((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(privateSite).createFile(this.testFile).assertThat().existsInRepo().then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingResource((ContentModel)this.testFile).setContent(this.secondContent);
    }
}

