/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis;

import org.alfresco.cmis.CmisTest;
import org.alfresco.cmis.CmisWrapper;
import org.alfresco.cmis.exception.InvalidCmisObjectException;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUpdateConflictException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class AppendContentStreamTests
extends CmisTest {
    UserModel siteManager;
    SiteModel publicSite;
    SiteModel privateSite;
    FileModel testFile;
    String initialContent = "initial content ";
    String textToAppend = "text to append";
    private DataUser.ListUserWithRoles usersWithRoles;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.siteManager = this.dataUser.createRandomTestUser();
        this.publicSite = ((DataSite)this.dataSite.usingUser(this.siteManager)).createPublicRandomSite();
        this.privateSite = ((DataSite)this.dataSite.usingUser(this.siteManager)).createPrivateRandomSite();
        this.usersWithRoles = this.dataUser.addUsersWithRolesToSite(this.publicSite, new UserRole[]{UserRole.SiteManager, UserRole.SiteContributor, UserRole.SiteCollaborator, UserRole.SiteConsumer});
    }

    @Test(groups={"sanity", "cmis", "not_supported_on_cmis_ws"})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify site manager is able to append content to a not empty file in DocumentLibrary with CMIS")
    public void siteManagerShouldAppendContentToNotEmptyFile() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD, (String)this.initialContent);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.testFile).assertThat().existsInRepo().and()).assertThat().contentIs(this.initialContent).then()).update(this.textToAppend).assertThat().contentIs(this.initialContent + this.textToAppend);
    }

    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisObjectNotFoundException.class})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify user is not able to append content to a non existent Document in DocumentLibrary with CMIS")
    public void userShouldNotAppendContentToNonexistentFile() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD, (String)this.initialContent);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.testFile).assertThat().existsInRepo().and()).assertThat().contentIs(this.initialContent).then()).delete().and()).assertThat().doesNotExistInRepo().then()).update(this.textToAppend);
    }

    @Test(groups={"regression", "cmis", "not_supported_on_cmis_ws"})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to append content to an empty file with version with CMIS")
    public void siteManagerCanAppendContentToEmptyFileWithVersion() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD, (String)this.initialContent);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.testFile).assertThat().existsInRepo().and()).assertThat().contentIs(this.initialContent).then()).setContent("").assertThat().contentIs("").refreshResource().then()).update(this.textToAppend).and()).assertThat().contentIs(this.textToAppend);
    }

    @Test(groups={"regression", "cmis", "not_supported_on_cmis_ws"})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to append content to an empty file with no version in DocumentLibrary with CMIS")
    public void siteManagerCanAppendContentToEmptyFileWithNoVersion() throws Exception {
        FileModel emptyFile = FileModel.getRandomFileModel((FileType)FileType.HTML);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(emptyFile).assertThat().existsInRepo().and()).assertThat().contentIs("").then()).update(this.textToAppend).and()).assertThat().contentIs(this.textToAppend);
    }

    @Test(groups={"regression", "cmis", "not_supported_on_cmis_ws"})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to append content with last chunk parameter set to FALSE with CMIS")
    public void siteManagerCanAppendContentWithLastChunkSetToFalse() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD, (String)this.initialContent);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.testFile).assertThat().existsInRepo().and()).assertThat().contentIs(this.initialContent).then()).update(this.textToAppend, false).and()).assertThat().contentIs(this.initialContent + this.textToAppend);
    }

    @Test(groups={"regression", "cmis", "not_supported_on_cmis_ws"})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify admin is able to append content to a file created by other user in DocumentLibrary with CMIS")
    public void adminShouldAppendContentToFileCreatedByOtherUser() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD, (String)this.initialContent);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.testFile).assertThat().existsInRepo().and()).assertThat().contentIs(this.initialContent).then()).authenticateUser(this.dataUser.getAdminUser()).update(this.textToAppend).assertThat().contentIs(this.initialContent + this.textToAppend);
    }

    @Test(groups={"regression", "cmis", "not_supported_on_cmis_ws"})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to append content to a file created by other user in DocumentLibrary with CMIS")
    public void siteManagerShouldAppendContentToFileCreatedByOtherUser() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD, (String)this.initialContent);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.testFile).assertThat().existsInRepo().and()).assertThat().contentIs(this.initialContent).then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).update(this.textToAppend).assertThat().contentIs(this.initialContent + this.textToAppend);
    }

    @Test(groups={"regression", "cmis", "not_supported_on_cmis_ws"})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site contributor is able to append content to a file created by self in DocumentLibrary with CMIS")
    public void contributorShouldAppendContentToFileCreatedBySelf() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD, (String)this.initialContent);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingSite(this.publicSite).createFile(this.testFile).assertThat().existsInRepo().and()).assertThat().contentIs(this.initialContent).then()).update(this.textToAppend).assertThat().contentIs(this.initialContent + this.textToAppend);
    }

    @Test(groups={"regression", "cmis", "not_supported_on_cmis_ws"}, expectedExceptions={CmisPermissionDeniedException.class})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site contributor is not able to append content to a file created by other user in DocumentLibrary with CMIS")
    public void contributorCannotAppendContentToFileCreatedByOtherUser() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD, (String)this.initialContent);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.testFile).assertThat().existsInRepo().and()).assertThat().contentIs(this.initialContent).then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).update(this.textToAppend);
    }

    @Test(groups={"regression", "cmis", "not_supported_on_cmis_ws"})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site collaborator is able to append content to a file created by other user in DocumentLibrary with CMIS")
    public void collaboratorShouldAppendContentToFileCreatedByOtherUser() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD, (String)this.initialContent);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.testFile).assertThat().existsInRepo().and()).assertThat().contentIs(this.initialContent).then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).update(this.textToAppend).assertThat().contentIs(this.initialContent + this.textToAppend);
    }

    @Test(groups={"regression", "cmis", "not_supported_on_cmis_ws"})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site collaborator is able to append content to a file created by self in DocumentLibrary with CMIS")
    public void collaboratorShouldAppendContentToFileCreatedBySelf() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD, (String)this.initialContent);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingSite(this.publicSite).createFile(this.testFile).assertThat().existsInRepo().and()).assertThat().contentIs(this.initialContent).then()).update(this.textToAppend).assertThat().contentIs(this.initialContent + this.textToAppend);
    }

    @Test(groups={"regression", "cmis", "not_supported_on_cmis_ws"}, expectedExceptions={CmisPermissionDeniedException.class})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site consumer is not able to append content to a file with CMIS")
    public void consumerCannotAppendContentToFile() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD, (String)this.initialContent);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.testFile).assertThat().existsInRepo().and()).assertThat().contentIs(this.initialContent).then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).update(this.textToAppend);
    }

    @Test(groups={"regression", "cmis", "not_supported_on_cmis_ws"}, expectedExceptions={CmisUpdateConflictException.class}, expectedExceptionsMessageRegExp="^.*Cannot perform operation since the node.*is locked.$")
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is not able to append content to a checked out file with CMIS")
    public void managerCannotAppendContentToCheckedOutFile() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD, (String)this.initialContent);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.testFile).assertThat().existsInRepo().then()).checkOut().assertThat().documentIsCheckedOut().when()).update(this.textToAppend);
    }

    @Test(groups={"regression", "cmis", "not_supported_on_cmis_ws"})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to append content to a PWC file with CMIS")
    public void managerCanAppendContentToPWCFile() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD, (String)this.initialContent);
        ((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.testFile).assertThat().existsInRepo().then()).checkOut().assertThat().documentIsCheckedOut().usingPWCDocument().update(this.textToAppend).assertThat().contentIs(this.initialContent + this.textToAppend);
    }

    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify unauthorized user is not able to append content to a file created in a private site with CMIS")
    public void unauthorizedUserCannotAppendContentToFileFromPrivateSite() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD, (String)this.initialContent);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.privateSite).createFile(this.testFile).assertThat().existsInRepo().and()).assertThat().contentIs(this.initialContent).then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).usingResource((ContentModel)this.testFile).update(this.textToAppend);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify user is not able to append content to an invalid file with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={InvalidCmisObjectException.class}, expectedExceptionsMessageRegExp="^Content at.*is not a file$")
    public void userCannotAppendContentOfInvalidFile() throws Exception {
        FolderModel testFolder = FolderModel.getRandomFolderModel();
        this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFolder(testFolder).assertThat().existsInRepo().update(this.textToAppend);
    }
}

