/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis;

import org.alfresco.cmis.CmisTest;
import org.alfresco.cmis.CmisWrapper;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class GetPropertiesTests
extends CmisTest {
    UserModel testUser;
    SiteModel testSite;
    FileModel testFile;
    FolderModel testFolder;
    DataUser.ListUserWithRoles usersWithRoles;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.testUser = this.dataUser.createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createPublicRandomSite();
        this.usersWithRoles = this.dataUser.addUsersWithRolesToSite(this.testSite, new UserRole[]{UserRole.SiteManager, UserRole.SiteCollaborator, UserRole.SiteContributor, UserRole.SiteConsumer});
    }

    @BeforeMethod(alwaysRun=true)
    public void generateRandomContent() {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.testFolder = FolderModel.getRandomFolderModel();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify secondaryObjectTypeIds property for valid document")
    @Test(groups={"not_supported_on_cmis_ws", "sanity", "cmis"})
    public void verifySecondaryObjectTypeIdsPropertyForValidDocument() throws Exception {
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo().then()).assertThat().objectHasProperty("cmis:secondaryObjectTypeIds", "Secondary Object Type Ids", "secondaryObjectTypeIds", "cmis:secondaryObjectTypeIds", new String[]{"P:cm:titled", "P:sys:localized"});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify secondaryObjectTypeIds property for valid folder")
    @Test(groups={"not_supported_on_cmis_ws", "sanity", "cmis"})
    public void verifySecondaryObjectTypeIdsPropertyForValidFolder() throws Exception {
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.testFolder).and()).assertThat().existsInRepo().then()).assertThat().objectHasProperty("cmis:secondaryObjectTypeIds", "Secondary Object Type Ids", "secondaryObjectTypeIds", "cmis:secondaryObjectTypeIds", new String[]{"P:cm:titled", "P:sys:localized"});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify secondaryObjectTypeIds property for inexistent folder (that was previously deleted)")
    @Test(groups={"not_supported_on_cmis_ws", "regression", "cmis"}, expectedExceptions={CmisObjectNotFoundException.class})
    public void verifySecondaryObjectTypeIdsPropertyForInexistentFolder() throws Exception {
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.testFolder).then()).assertThat().objectHasProperty("cmis:secondaryObjectTypeIds", "Secondary Object Type Ids", "secondaryObjectTypeIds", "cmis:secondaryObjectTypeIds", new String[]{"P:cm:titled", "P:sys:localized"}).and()).usingResource((ContentModel)this.testFolder).deleteFolderTree().then()).assertThat().objectHasProperty("cmis:secondaryObjectTypeIds", "Secondary Object Type Ids", "secondaryObjectTypeIds", "cmis:secondaryObjectTypeIds", new String[]{"P:cm:titled", "P:sys:localized"});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify secondaryObjectTypeIds property for valid folder")
    @Test(groups={"not_supported_on_cmis_ws", "regression", "cmis"})
    public void managerVerifiesSecondaryObjectTypeIdsPropertyForValidFolder() throws Exception {
        this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.testFolder);
        ((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).usingSite(this.testSite).usingResource((ContentModel)this.testFolder).then()).assertThat().objectHasProperty("cmis:secondaryObjectTypeIds", "Secondary Object Type Ids", "secondaryObjectTypeIds", "cmis:secondaryObjectTypeIds", new String[]{"P:cm:titled", "P:sys:localized"});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify secondaryObjectTypeIds property as site collaborator for valid document")
    @Test(groups={"not_supported_on_cmis_ws", "regression", "cmis"})
    public void collaboratorVerifiesSecondaryObjectTypeIdsPropertyForValidDocumentCreatedBySelf() throws Exception {
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo().then()).assertThat().objectHasProperty("cmis:secondaryObjectTypeIds", "Secondary Object Type Ids", "secondaryObjectTypeIds", "cmis:secondaryObjectTypeIds", new String[]{"P:cm:titled", "P:sys:localized"});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify secondaryObjectTypeIds property as site collaborator for valid folder")
    @Test(groups={"not_supported_on_cmis_ws", "regression", "cmis"})
    public void collaboratorVerifiesSecondaryObjectTypeIdsPropertyForValidFolderCreatedBySelf() throws Exception {
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingSite(this.testSite).createFolder(this.testFolder).and()).assertThat().existsInRepo().then()).assertThat().objectHasProperty("cmis:secondaryObjectTypeIds", "Secondary Object Type Ids", "secondaryObjectTypeIds", "cmis:secondaryObjectTypeIds", new String[]{"P:cm:titled", "P:sys:localized"});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify secondaryObjectTypeIds property as site collaborator for valid document")
    @Test(groups={"not_supported_on_cmis_ws", "regression", "cmis"})
    public void collaboratorVerifiesSecondaryObjectTypeIdsPropertyForValidDocumentCreatedByManager() throws Exception {
        ((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo();
        this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingResource((ContentModel)this.testFile).assertThat().objectHasProperty("cmis:secondaryObjectTypeIds", "Secondary Object Type Ids", "secondaryObjectTypeIds", "cmis:secondaryObjectTypeIds", new String[]{"P:cm:titled", "P:sys:localized"});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify secondaryObjectTypeIds property as site collaborator for valid folder")
    @Test(groups={"not_supported_on_cmis_ws", "regression", "cmis"})
    public void collaboratorVerifiesSecondaryObjectTypeIdsPropertyForValidFolderCreatedByManager() throws Exception {
        ((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.testFolder).and()).assertThat().existsInRepo();
        this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingResource((ContentModel)this.testFolder).assertThat().objectHasProperty("cmis:secondaryObjectTypeIds", "Secondary Object Type Ids", "secondaryObjectTypeIds", "cmis:secondaryObjectTypeIds", new String[]{"P:cm:titled", "P:sys:localized"});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify secondaryObjectTypeIds property as site contributor for valid document")
    @Test(groups={"not_supported_on_cmis_ws", "regression", "cmis"})
    public void contributorVerifiesSecondaryObjectTypeIdsPropertyForValidDocumentCreatedBySelf() throws Exception {
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo().then()).assertThat().objectHasProperty("cmis:secondaryObjectTypeIds", "Secondary Object Type Ids", "secondaryObjectTypeIds", "cmis:secondaryObjectTypeIds", new String[]{"P:cm:titled", "P:sys:localized"});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify secondaryObjectTypeIds property as site contributor for valid folder")
    @Test(groups={"not_supported_on_cmis_ws", "regression", "cmis"})
    public void contributorVerifiesSecondaryObjectTypeIdsPropertyForValidFolderCreatedBySelf() throws Exception {
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingSite(this.testSite).createFolder(this.testFolder).and()).assertThat().existsInRepo().then()).assertThat().objectHasProperty("cmis:secondaryObjectTypeIds", "Secondary Object Type Ids", "secondaryObjectTypeIds", "cmis:secondaryObjectTypeIds", new String[]{"P:cm:titled", "P:sys:localized"});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify secondaryObjectTypeIds property as site contributor for valid document")
    @Test(groups={"not_supported_on_cmis_ws", "regression", "cmis"})
    public void contributorVerifiesSecondaryObjectTypeIdsPropertyForValidDocumentCreatedByManager() throws Exception {
        ((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo();
        this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingResource((ContentModel)this.testFile).assertThat().objectHasProperty("cmis:secondaryObjectTypeIds", "Secondary Object Type Ids", "secondaryObjectTypeIds", "cmis:secondaryObjectTypeIds", new String[]{"P:cm:titled", "P:sys:localized"});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify secondaryObjectTypeIds property as site contributor for valid folder")
    @Test(groups={"not_supported_on_cmis_ws", "regression", "cmis"})
    public void contributorVerifiesSecondaryObjectTypeIdsPropertyForValidFolderCreatedByManager() throws Exception {
        ((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.testFolder).and()).assertThat().existsInRepo();
        this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingResource((ContentModel)this.testFolder).assertThat().objectHasProperty("cmis:secondaryObjectTypeIds", "Secondary Object Type Ids", "secondaryObjectTypeIds", "cmis:secondaryObjectTypeIds", new String[]{"P:cm:titled", "P:sys:localized"});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify secondaryObjectTypeIds property as site consumer for valid document")
    @Test(groups={"not_supported_on_cmis_ws", "regression", "cmis"})
    public void consumerVerifiesSecondaryObjectTypeIdsPropertyForValidDocument() throws Exception {
        ((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo();
        this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).usingResource((ContentModel)this.testFile).assertThat().objectHasProperty("cmis:secondaryObjectTypeIds", "Secondary Object Type Ids", "secondaryObjectTypeIds", "cmis:secondaryObjectTypeIds", new String[]{"P:cm:titled", "P:sys:localized"});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify secondaryObjectTypeIds property as site consumer for valid folder")
    @Test(groups={"not_supported_on_cmis_ws", "regression", "cmis"})
    public void consumerVerifiesSecondaryObjectTypeIdsPropertyForValidFolder() throws Exception {
        ((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.testFolder).and()).assertThat().existsInRepo();
        this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).usingResource((ContentModel)this.testFolder).assertThat().objectHasProperty("cmis:secondaryObjectTypeIds", "Secondary Object Type Ids", "secondaryObjectTypeIds", "cmis:secondaryObjectTypeIds", new String[]{"P:cm:titled", "P:sys:localized"});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify that non site member cannot get secondaryObjectTypeIds property for a valid document from a private site")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void nonSiteMemberCannotGetSecondaryObjectTypeIdsForAValidDocumentFromAPrivateSite() throws Exception {
        SiteModel privateSite = ((DataSite)this.dataSite.usingAdmin()).createPrivateRandomSite();
        ((CmisWrapper)this.cmisApi.authenticateUser(this.dataUser.getAdminUser()).usingSite(privateSite).createFile(this.testFile).and()).assertThat().existsInRepo();
        this.cmisApi.authenticateUser(this.testUser).usingResource((ContentModel)this.testFile).assertThat().objectHasProperty("cmis:secondaryObjectTypeIds", "Secondary Object Type Ids", "secondaryObjectTypeIds", "cmis:secondaryObjectTypeIds", new String[]{"P:cm:titled", "P:sys:localized"});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify that non site member cannot get secondaryObjectTypeIds property for a valid folder from a private site")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void nonSiteMemberCannotGetSecondaryObjectTypeIdsForAValidFolderFromAPrivateSite() throws Exception {
        SiteModel privateSite = ((DataSite)this.dataSite.usingAdmin()).createPrivateRandomSite();
        ((CmisWrapper)this.cmisApi.authenticateUser(this.dataUser.getAdminUser()).usingSite(privateSite).createFolder(this.testFolder).and()).assertThat().existsInRepo();
        this.cmisApi.authenticateUser(this.testUser).usingResource((ContentModel)this.testFolder).assertThat().objectHasProperty("cmis:secondaryObjectTypeIds", "Secondary Object Type Ids", "secondaryObjectTypeIds", "cmis:secondaryObjectTypeIds", new String[]{"P:cm:titled", "P:sys:localized"});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify that non site member cannot get secondaryObjectTypeIds property for a valid document from a moderated site")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void nonSiteMemberCannotGetSecondaryObjectTypeIdsForAValidDocumentFromAModeratedSite() throws Exception {
        SiteModel moderatedSite = ((DataSite)this.dataSite.usingAdmin()).createModeratedRandomSite();
        ((CmisWrapper)this.cmisApi.authenticateUser(this.dataUser.getAdminUser()).usingSite(moderatedSite).createFile(this.testFile).and()).assertThat().existsInRepo();
        this.cmisApi.authenticateUser(this.testUser).usingResource((ContentModel)this.testFile).assertThat().objectHasProperty("cmis:secondaryObjectTypeIds", "Secondary Object Type Ids", "secondaryObjectTypeIds", "cmis:secondaryObjectTypeIds", new String[]{"P:cm:titled", "P:sys:localized"});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify that non site member cannot get secondaryObjectTypeIds property for a valid folder from a moderated site")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void nonSiteMemberCannotGetSecondaryObjectTypeIdsForAValidFolderFromAModeratedSite() throws Exception {
        SiteModel moderatedSite = ((DataSite)this.dataSite.usingAdmin()).createModeratedRandomSite();
        ((CmisWrapper)this.cmisApi.authenticateUser(this.dataUser.getAdminUser()).usingSite(moderatedSite).createFolder(this.testFolder).and()).assertThat().existsInRepo();
        this.cmisApi.authenticateUser(this.testUser).usingResource((ContentModel)this.testFolder).assertThat().objectHasProperty("cmis:secondaryObjectTypeIds", "Secondary Object Type Ids", "secondaryObjectTypeIds", "cmis:secondaryObjectTypeIds", new String[]{"P:cm:titled", "P:sys:localized"});
    }
}

