/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis;

import org.alfresco.cmis.CmisTest;
import org.alfresco.cmis.CmisWrapper;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class GetParentsTests
extends CmisTest {
    UserModel testUser;
    SiteModel testSite;
    FolderModel testFolder;
    FolderModel parentFolder;
    FileModel testFile;
    DataUser.ListUserWithRoles usersWithRoles;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.testUser = this.dataUser.createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createPublicRandomSite();
        this.usersWithRoles = this.dataUser.addUsersWithRolesToSite(this.testSite, new UserRole[]{UserRole.SiteCollaborator, UserRole.SiteContributor, UserRole.SiteConsumer});
    }

    @BeforeMethod(alwaysRun=true)
    public void generateRandomContent() {
        this.parentFolder = FolderModel.getRandomFolderModel();
        this.testFolder = FolderModel.getRandomFolderModel();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify site manager is able to get file parents with CMIS")
    @Test(groups={"sanity", "cmis"})
    public void siteManagerGetsFileParents() throws Exception {
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.testFolder).and()).assertThat().existsInRepo().createFolder(this.parentFolder).and()).assertThat().existsInRepo().usingResource((ContentModel)this.parentFolder).createFile(this.testFile).and()).assertThat().existsInRepo().addDocumentToFolder(this.testFolder, true).and()).assertThat().existsInRepo().then()).assertThat().hasParents(new String[]{this.testFolder.getName(), this.parentFolder.getName()});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify site manager is able to get folder parents with CMIS")
    @Test(groups={"sanity", "cmis"})
    public void siteManagerGetsFolderParents() throws Exception {
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.parentFolder).and()).assertThat().existsInRepo().usingResource((ContentModel)this.parentFolder).createFolder(this.testFolder).and()).assertThat().existsInRepo().then()).assertThat().hasParents(new String[]{this.parentFolder.getName()});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is NOT able to get parents for an inexistent folder with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisObjectNotFoundException.class})
    public void siteManagerCannotGetInexistentFolderParents() throws Exception {
        FolderModel inexistentFolder = FolderModel.getRandomFolderModel();
        inexistentFolder.setCmisLocation("/" + inexistentFolder.getName() + "/");
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.parentFolder).and()).assertThat().existsInRepo().and()).usingResource((ContentModel)inexistentFolder).assertThat().hasParents(new String[]{this.parentFolder.getName()});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site contributor is able to get folder parents with CMIS")
    @Test(groups={"regression", "cmis"})
    public void siteContributorGetsFolderParentsCreatedBySelf() throws Exception {
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingSite(this.testSite).createFolder(this.parentFolder).and()).assertThat().existsInRepo().usingResource((ContentModel)this.parentFolder).createFolder(this.testFolder).and()).assertThat().existsInRepo().then()).assertThat().hasParents(new String[]{this.parentFolder.getName()});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site contributor is able to get file parents with CMIS")
    @Test(groups={"regression", "cmis"})
    public void siteContributorGetsFileParentsCreatedBySelf() throws Exception {
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingSite(this.testSite).createFolder(this.parentFolder).and()).assertThat().existsInRepo().usingResource((ContentModel)this.parentFolder).createFile(this.testFile).and()).assertThat().existsInRepo().assertThat().hasParents(new String[]{this.parentFolder.getName()});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site contributor is able to get folder parents with CMIS")
    @Test(groups={"regression", "cmis"})
    public void siteContributorGetsFolderParentsCreatedByManager() throws Exception {
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.parentFolder).and()).assertThat().existsInRepo().usingResource((ContentModel)this.parentFolder).createFolder(this.testFolder).and()).assertThat().existsInRepo();
        this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingResource((ContentModel)this.testFolder).assertThat().hasParents(new String[]{this.parentFolder.getName()});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site contributor is able to get file parents with CMIS")
    @Test(groups={"regression", "cmis"})
    public void siteContributorGetsFileParentsCreatedByManager() throws Exception {
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.parentFolder).and()).assertThat().existsInRepo().usingResource((ContentModel)this.parentFolder).createFolder(this.testFolder).and()).assertThat().existsInRepo().usingResource((ContentModel)this.testFolder).createFile(this.testFile).and()).assertThat().existsInRepo();
        this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingResource((ContentModel)this.testFile).assertThat().hasParents(new String[]{this.testFolder.getName()});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site collaborator is able to get folder parents with CMIS")
    @Test(groups={"regression", "cmis"})
    public void siteCollaboratorGetsFolderParentsCreatedBySelf() throws Exception {
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingSite(this.testSite).createFolder(this.parentFolder).and()).assertThat().existsInRepo().usingResource((ContentModel)this.parentFolder).createFolder(this.testFolder).and()).assertThat().existsInRepo().then()).assertThat().hasParents(new String[]{this.parentFolder.getName()});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site collaborator is able to get file parents with CMIS")
    @Test(groups={"regression", "cmis"})
    public void siteCollaboratorGetsFileParentsCreatedBySelf() throws Exception {
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingSite(this.testSite).createFolder(this.parentFolder).and()).assertThat().existsInRepo().usingResource((ContentModel)this.parentFolder).createFile(this.testFile).and()).assertThat().existsInRepo().assertThat().hasParents(new String[]{this.parentFolder.getName()});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site collaborator is able to get folder parents with CMIS")
    @Test(groups={"regression", "cmis"})
    public void siteCollaboratorGetsFolderParentsCreatedByManager() throws Exception {
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.parentFolder).and()).assertThat().existsInRepo().usingResource((ContentModel)this.parentFolder).createFolder(this.testFolder).and()).assertThat().existsInRepo();
        this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingResource((ContentModel)this.testFolder).assertThat().hasParents(new String[]{this.parentFolder.getName()});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site collaborator is able to get file parents with CMIS")
    @Test(groups={"regression", "cmis"})
    public void siteCollaboratorGetsFileParentsCreatedByManager() throws Exception {
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.parentFolder).and()).assertThat().existsInRepo().usingResource((ContentModel)this.parentFolder).createFolder(this.testFolder).and()).assertThat().existsInRepo().usingResource((ContentModel)this.testFolder).createFile(this.testFile).and()).assertThat().existsInRepo();
        this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingResource((ContentModel)this.testFile).assertThat().hasParents(new String[]{this.testFolder.getName()});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site consumer is able to get folder parents with CMIS")
    @Test(groups={"regression", "cmis"})
    public void siteConsumerGetsFolderParents() throws Exception {
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.parentFolder).and()).assertThat().existsInRepo().usingResource((ContentModel)this.parentFolder).createFolder(this.testFolder).and()).assertThat().existsInRepo();
        this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).usingResource((ContentModel)this.testFolder).assertThat().hasParents(new String[]{this.parentFolder.getName()});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site consumer is able to get file parents with CMIS")
    @Test(groups={"regression", "cmis"})
    public void siteConsumerGetsFileParents() throws Exception {
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.parentFolder).and()).assertThat().existsInRepo().usingResource((ContentModel)this.parentFolder).createFolder(this.testFolder).and()).assertThat().existsInRepo().usingResource((ContentModel)this.testFolder).createFile(this.testFile).and()).assertThat().existsInRepo();
        this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).usingResource((ContentModel)this.testFile).assertThat().hasParents(new String[]{this.testFolder.getName()});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify non site member for a private site is not able to get folder parents with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void nonSiteMemberGetsFolderParentsFromPrivateSite() throws Exception {
        SiteModel privateSite = ((DataSite)this.dataSite.usingAdmin()).createPrivateRandomSite();
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.dataUser.getAdminUser()).usingSite(privateSite).createFolder(this.parentFolder).and()).assertThat().existsInRepo().usingResource((ContentModel)this.parentFolder).createFolder(this.testFolder).and()).assertThat().existsInRepo();
        this.cmisApi.authenticateUser(this.testUser).usingResource((ContentModel)this.testFolder).assertThat().hasParents(new String[]{this.parentFolder.getName()});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify non site member for a private site is not able to get file parents with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void nonSiteMemberGetsFileParentsFromPrivateSite() throws Exception {
        SiteModel privateSite = ((DataSite)this.dataSite.usingAdmin()).createPrivateRandomSite();
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.dataUser.getAdminUser()).usingSite(privateSite).createFolder(this.parentFolder).and()).assertThat().existsInRepo().usingResource((ContentModel)this.parentFolder).createFile(this.testFile).and()).assertThat().existsInRepo();
        this.cmisApi.authenticateUser(this.testUser).usingResource((ContentModel)this.testFile).assertThat().hasParents(new String[]{this.parentFolder.getName()});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify non site member for a moderated site is not able to get folder parents with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void nonSiteMemberGetsFolderParentsFromModeratedSite() throws Exception {
        SiteModel moderatedSite = ((DataSite)this.dataSite.usingAdmin()).createModeratedRandomSite();
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.dataUser.getAdminUser()).usingSite(moderatedSite).createFolder(this.parentFolder).and()).assertThat().existsInRepo().usingResource((ContentModel)this.parentFolder).createFolder(this.testFolder).and()).assertThat().existsInRepo();
        this.cmisApi.authenticateUser(this.testUser).usingResource((ContentModel)this.testFolder).assertThat().hasParents(new String[]{this.parentFolder.getName()});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify non site member for a moderated site is not able to get file parents with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void nonSiteMemberGetsFileParentsFromModeratedSite() throws Exception {
        SiteModel moderatedSite = ((DataSite)this.dataSite.usingAdmin()).createModeratedRandomSite();
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.dataUser.getAdminUser()).usingSite(moderatedSite).createFolder(this.parentFolder).and()).assertThat().existsInRepo().usingResource((ContentModel)this.parentFolder).createFile(this.testFile).and()).assertThat().existsInRepo();
        this.cmisApi.authenticateUser(this.testUser).usingResource((ContentModel)this.testFile).assertThat().hasParents(new String[]{this.parentFolder.getName()});
    }
}

