/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis;

import org.alfresco.cmis.CmisTest;
import org.alfresco.cmis.CmisWrapper;
import org.alfresco.cmis.exception.InvalidCmisObjectException;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetAllVersionsTests
extends CmisTest {
    UserModel siteManager;
    SiteModel publicSite;
    FileModel testFile;
    FileModel managerFile;
    private DataUser.ListUserWithRoles usersWithRoles;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.managerFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.documentContent);
        this.siteManager = this.dataUser.createRandomTestUser();
        this.publicSite = ((DataSite)this.dataSite.usingUser(this.siteManager)).createPublicRandomSite();
        this.usersWithRoles = ((DataUser)this.dataUser.usingUser(this.siteManager)).addUsersWithRolesToSite(this.publicSite, new UserRole[]{UserRole.SiteContributor, UserRole.SiteCollaborator, UserRole.SiteConsumer});
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.managerFile).assertThat().existsInRepo().and()).checkOut().assertThat().documentIsCheckedOut().then()).prepareDocumentForCheckIn().checkIn().and()).checkOut().assertThat().documentIsCheckedOut().then()).prepareDocumentForCheckIn().withMajorVersion().checkIn();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify site manager can get all versions for a valid document")
    @Test(groups={"sanity", "cmis"})
    public void siteManagerShouldGetAllVersionsForAValidDocument() throws Exception {
        this.cmisApi.authenticateUser(this.siteManager).usingResource((ContentModel)this.managerFile).usingVersion().getAllDocumentVersions().assertHasVersions(new Object[]{1.0, 1.1, 2.0});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager can not get all versions for a document that was deleted")
    @Test(groups={"regression", "cmis", "not_supported_on_cmis_ws"}, expectedExceptions={CmisObjectNotFoundException.class})
    public void siteManagerShouldNotGetAllVersionsForADeletedDocument() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.testFile).assertThat().existsInRepo().and()).update("content 1").update("content 2").assertThat().documentHasVersion(1.2).usingVersion().getAllDocumentVersions().assertHasVersions(new Object[]{1.0, 1.1, 1.2}).and()).delete().then()).usingVersion().getAllDocumentVersions();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager can get all versions for a document using OperationContext: OrderBy")
    @Test(groups={"regression", "cmis"})
    public void siteManagerShouldGetAllVersionsWithOperationContextForADocument() throws Exception {
        OperationContext context = this.cmisApi.authenticateUser(this.siteManager).getSession().createOperationContext();
        context.setOrderBy("cmis:objectId DESC");
        this.cmisApi.authenticateUser(this.siteManager).usingResource((ContentModel)this.managerFile).usingVersion().getAllDocumentVersionsBy(context).assertHasVersionsInOrder(new Object[]{2.0, 1.1, 1.0});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager cannot get all versions for a folder")
    @Test(groups={"regression", "cmis"}, expectedExceptions={InvalidCmisObjectException.class})
    public void siteManagerCannotGetAllVersionsForFolder() throws Exception {
        FolderModel folder = FolderModel.getRandomFolderModel();
        this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFolder(folder).assertThat().existsInRepo().usingVersion().getAllDocumentVersions();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager can get all versions for a valid checked out document")
    @Test(groups={"regression", "cmis"})
    public void siteManagerShouldGetAllVersionsForCheckedOutDocument() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.testFile).assertThat().existsInRepo().and()).checkOut().assertThat().documentIsCheckedOut().then()).prepareDocumentForCheckIn().checkIn().and()).checkOut().assertThat().documentIsCheckedOut().then()).usingResource((ContentModel)this.testFile).usingVersion().getAllDocumentVersions().assertHasVersions(new Object[]{"pwc", 1.1, 1.0});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager can get all versions for a valid pwc document")
    @Test(groups={"regression", "cmis"})
    public void siteManagerShouldGetAllVersionsForPWCDocument() throws Exception {
        OperationContext context = this.cmisApi.getSession().createOperationContext();
        context.setOrderBy("cmis:objectId DESC");
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.testFile).assertThat().existsInRepo().and()).checkOut().assertThat().documentIsCheckedOut().then()).prepareDocumentForCheckIn().checkIn().and()).checkOut().assertThat().documentIsCheckedOut().then()).usingResource((ContentModel)this.testFile).usingPWCDocument().usingVersion().getAllDocumentVersions().assertHasVersions(new Object[]{1.1, 1.0, "pwc"}).usingVersion().getAllDocumentVersionsBy(context).assertHasVersionsInOrder(new Object[]{"pwc", 1.1, 1.0});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site collaborator can get all versions for a document created by manager")
    @Test(groups={"regression", "cmis"})
    public void collaboratorCanGetAllVersionsForDocumentCreatedByManager() throws Exception {
        this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingResource((ContentModel)this.managerFile).usingVersion().getAllDocumentVersions().assertHasVersions(new Object[]{1.0, 1.1, 2.0});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site collaborator can get all versions for a document created by manager")
    @Test(groups={"regression", "cmis"})
    public void contributorCanGetAllVersionsForDocumentCreatedByManager() throws Exception {
        this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingResource((ContentModel)this.managerFile).usingVersion().getAllDocumentVersions().assertHasVersions(new Object[]{1.0, 1.1, 2.0});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site consumer can get all versions for a document created by manager")
    @Test(groups={"regression", "cmis"})
    public void consumerCanGetAllVersionsForDocumentCreatedByManager() throws Exception {
        this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).usingResource((ContentModel)this.managerFile).usingVersion().getAllDocumentVersions().assertHasVersions(new Object[]{1.0, 1.1, 2.0});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify non invited user can get all versions for a document in public site")
    @Test(groups={"regression", "cmis"})
    public void nonInvitedUserCannotGetAllVersionsForDocumentFromPublicSite() throws Exception {
        UserModel nonInvitedUser = this.dataUser.createRandomTestUser();
        this.cmisApi.authenticateUser(nonInvitedUser).usingResource((ContentModel)this.managerFile).usingVersion().getAllDocumentVersions().assertHasVersions(new Object[]{1.0, 1.1, 2.0});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify non invited user cannot get all versions for a document in private site")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void nonInvitedUserCannotGetAllVersionsForDocumentFromPrivateSite() throws Exception {
        SiteModel privateSite = ((DataSite)this.dataSite.usingUser(this.siteManager)).createPrivateRandomSite();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.documentContent);
        ((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(privateSite).createFile(this.testFile).then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).usingResource((ContentModel)this.testFile).usingVersion().getAllDocumentVersions().assertHasVersions(new Object[]{1.0});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify non invited user cannot get all versions for a document in moderated site")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void nonInvitedUserCannotGetAllVersionsForDocumentFromModeratedSite() throws Exception {
        SiteModel moderated = ((DataSite)this.dataSite.usingUser(this.siteManager)).createPrivateRandomSite();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.documentContent);
        ((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(moderated).createFile(this.testFile).then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).usingResource((ContentModel)this.testFile).usingVersion().getAllDocumentVersions().assertHasVersions(new Object[]{1.0});
    }
}

