/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.search;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.alfresco.cmis.CmisProperties;
import org.alfresco.cmis.dsl.QueryExecutor;
import org.alfresco.cmis.search.AbstractE2EFunctionalTest;
import org.alfresco.utility.Utility;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.report.log.Step;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.test.context.ContextConfiguration;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;

@ContextConfiguration(value={"classpath:alfresco-cmis-context.xml"})
@Component
@Scope(value="prototype")
public abstract class AbstractCmisE2ETest
extends AbstractE2EFunctionalTest {
    private static Logger LOGGER = LoggerFactory.getLogger(AbstractCmisE2ETest.class);
    @Autowired
    protected CmisProperties cmisProperties;
    public String documentContent = "CMIS document content";

    @BeforeMethod(alwaysRun=true)
    public void showStartTestInfo(Method method) {
        LOGGER.info(String.format("*** STARTING Test: [%s] ***", method.getName()));
    }

    @AfterMethod(alwaysRun=true)
    public void showEndTestInfo(Method method) {
        LOGGER.info(String.format("*** ENDING Test: [%s] ***", method.getName()));
    }

    public Integer getElasticWaitTimeInSeconds() {
        return this.cmisProperties.envProperty().getSolrWaitTimeInSeconds();
    }

    protected boolean waitForIndexing(String query, long expectedResultsCount) {
        try {
            this.waitForIndexing(query, (QueryExecutor.QueryResultAssertion execution) -> execution.hasLength(expectedResultsCount));
            return true;
        }
        catch (AssertionError ae) {
            Step.STEP((String)("Received assertion error for query '" + query + "': " + String.valueOf(ae)));
            return false;
        }
    }

    protected void waitForIndexing(String query, ContentModel ... expectedResults) {
        Set expectedNames = Arrays.stream(expectedResults).map(ContentModel::getName).collect(Collectors.toSet());
        this.waitForIndexing(query, (QueryExecutor.QueryResultAssertion execution) -> execution.isReturningValues("cmis:name", expectedNames));
    }

    protected void waitForIndexingOrdered(String query, ContentModel ... expectedResults) {
        List expectedNames = Arrays.stream(expectedResults).map(ContentModel::getName).collect(Collectors.toList());
        this.waitForIndexing(query, (QueryExecutor.QueryResultAssertion execution) -> execution.isReturningOrderedValues("cmis:name", expectedNames));
    }

    protected void waitForIndexing(String query, Consumer<QueryExecutor.QueryResultAssertion> assertionMethod) {
        int searchCount = 0;
        while (true) {
            try {
                assertionMethod.accept(this.cmisApi.withQuery(query).assertValues());
                return;
            }
            catch (AssertionError ae) {
                if (++searchCount < 20) {
                    LOGGER.info(String.format("WaitForIndexing in Progress: %s", ae));
                    Utility.waitToLoopTime((int)this.getElasticWaitTimeInSeconds(), (String[])new String[]{"Wait For Indexing"});
                    continue;
                }
                throw ae;
            }
            break;
        }
    }
}

