/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis;

import org.alfresco.cmis.CmisTest;
import org.alfresco.cmis.CmisWrapper;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class GetDescendantsTests
extends CmisTest {
    UserModel testUser;
    SiteModel testSite;
    FileModel testFile;
    FileModel fileModel;
    FolderModel testFolder;
    FolderModel folderModel;
    DataUser.ListUserWithRoles usersWithRoles;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.testUser = this.dataUser.createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createPublicRandomSite();
        this.usersWithRoles = this.dataUser.addUsersWithRolesToSite(this.testSite, new UserRole[]{UserRole.SiteCollaborator, UserRole.SiteContributor, UserRole.SiteConsumer});
    }

    @BeforeMethod(alwaysRun=true)
    public void generateRandomContent() {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.fileModel = FileModel.getRandomFileModel((FileType)FileType.MSPOWERPOINT);
        this.testFolder = FolderModel.getRandomFolderModel();
        this.folderModel = FolderModel.getRandomFolderModel();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify site manager can get descendants for valid parent folder with at least 3 children and depth set to >=1")
    @Test(groups={"sanity", "cmis"})
    public void getDescendantsForValidParentFolderWithAtLeast3ChildrenAndDepthGreaterThan1() throws Exception {
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.testFolder).and()).assertThat().existsInRepo().and()).usingResource((ContentModel)this.testFolder).createFile(this.testFile).and()).createFile(this.fileModel).and()).createFolder(this.folderModel).then()).usingResource((ContentModel)this.testFolder).assertThat().hasDescendants(1, new ContentModel[]{this.folderModel, this.fileModel, this.testFile});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify site manager can get descendants for valid parent folder with at least 3 children and depth set to -1")
    @Test(groups={"sanity", "cmis"})
    public void getDescendantsForValidParentFolderWithAtLeast3ChildrenAndDepthSetToMinus1() throws Exception {
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.testFolder).and()).assertThat().existsInRepo().and()).usingResource((ContentModel)this.testFolder).createFile(this.testFile).then()).createFile(this.fileModel).and()).createFolder(this.folderModel).then()).usingResource((ContentModel)this.testFolder).assertThat().hasDescendants(-1, new ContentModel[]{this.folderModel, this.fileModel, this.testFile});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager CANNOT get descendants for valid parent folder with at least 2 children and depth set to 0")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisInvalidArgumentException.class})
    public void getDescendantsForValidParentFolderWithAtLeast2ChildrenAndDepthSetTo0() throws Exception {
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.testFolder).and()).usingResource((ContentModel)this.testFolder).createFile(this.testFile).and()).createFolder(this.folderModel).then()).usingResource((ContentModel)this.testFolder).assertThat().hasDescendants(0, new ContentModel[]{this.folderModel, this.testFile});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager CANNOT get descendants for valid parent folder with at least 2 children and depth set to -2")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisInvalidArgumentException.class})
    public void getDescendantsForValidParentFolderWithAtLeast2ChildrenAndDepthSetToMinus2() throws Exception {
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.testFolder).and()).usingResource((ContentModel)this.testFolder).createFile(this.testFile).and()).createFolder(this.folderModel).then()).usingResource((ContentModel)this.testFolder).assertThat().hasDescendants(-2, new ContentModel[]{this.folderModel, this.testFile});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager CANNOT get descendants for parent folder with at least 2 children that was previously deleted")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisObjectNotFoundException.class})
    public void getDescendantsForDeletedParentFolderWithAtLeast2Children() throws Exception {
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.testFolder).and()).usingResource((ContentModel)this.testFolder).createFile(this.testFile).and()).createFolder(this.folderModel).and()).usingResource((ContentModel)this.testFolder).deleteFolderTree().then()).usingResource((ContentModel)this.testFolder).assertThat().hasDescendants(1, new ContentModel[]{this.folderModel, this.testFile});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site collaborator can get descendants for parent folder")
    @Test(groups={"regression", "cmis"})
    public void siteCollaboratorCanGetDescendantsForValidFolderCreatedBySelf() throws Exception {
        this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingSite(this.testSite).createFolder(this.testFolder).usingResource((ContentModel)this.testFolder).createFile(this.testFile).usingResource((ContentModel)this.testFolder).assertThat().hasDescendants(-1, new ContentModel[]{this.testFile});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site collaborator can get descendants for parent folder")
    @Test(groups={"regression", "cmis"})
    public void siteCollaboratorCanGetDescendantsForValidFolderCreatedByManager() throws Exception {
        this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.testFolder).usingResource((ContentModel)this.testFolder).createFile(this.testFile);
        this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingResource((ContentModel)this.testFolder).assertThat().hasDescendants(-1, new ContentModel[]{this.testFile});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site contributor can get descendants for parent folder")
    @Test(groups={"regression", "cmis"})
    public void siteContributorCanGetDescendantsForValidFolderCreatedBySelf() throws Exception {
        this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingSite(this.testSite).createFolder(this.testFolder).usingResource((ContentModel)this.testFolder).createFile(this.testFile).usingResource((ContentModel)this.testFolder).assertThat().hasDescendants(-1, new ContentModel[]{this.testFile});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site contributor can get descendants for parent folder")
    @Test(groups={"regression", "cmis"})
    public void siteContributorCanGetDescendantsForValidFolderCreatedByManager() throws Exception {
        this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.testFolder).usingResource((ContentModel)this.testFolder).createFile(this.testFile);
        this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingResource((ContentModel)this.testFolder).assertThat().hasDescendants(-1, new ContentModel[]{this.testFile});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site consumer can get descendants for parent folder")
    @Test(groups={"regression", "cmis"})
    public void siteConsumerCanGetDescendantsForValidFolder() throws Exception {
        this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.testFolder).usingResource((ContentModel)this.testFolder).createFile(this.testFile);
        this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).usingResource((ContentModel)this.testFolder).assertThat().hasDescendants(-1, new ContentModel[]{this.testFile});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify that non site member cannot get descendants for a folder from a private site")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void nonSiteMemberCannotGetDescendantsAFolderFromAPrivateSite() throws Exception {
        SiteModel privateSite = ((DataSite)this.dataSite.usingAdmin()).createPrivateRandomSite();
        this.cmisApi.authenticateUser(this.dataUser.getAdminUser()).usingSite(privateSite).createFolder(this.testFolder).usingResource((ContentModel)this.testFolder).createFile(this.testFile);
        this.cmisApi.authenticateUser(this.testUser).usingResource((ContentModel)this.testFolder).assertThat().hasDescendants(-1, new ContentModel[]{this.testFile});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify that non site member cannot get descendants for a folder from a moderated site")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void nonSiteMemberCannotGetDescendantsAFolderFromAModeratedSite() throws Exception {
        SiteModel moderatedSite = ((DataSite)this.dataSite.usingAdmin()).createModeratedRandomSite();
        this.cmisApi.authenticateUser(this.dataUser.getAdminUser()).usingSite(moderatedSite).createFolder(this.testFolder).usingResource((ContentModel)this.testFolder).createFile(this.testFile);
        this.cmisApi.authenticateUser(this.testUser).usingResource((ContentModel)this.testFolder).assertThat().hasDescendants(-1, new ContentModel[]{this.testFile});
    }
}

