/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis;

import org.alfresco.cmis.CmisTest;
import org.alfresco.cmis.CmisWrapper;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetObjectOfLatestVersionTests
extends CmisTest {
    UserModel testUser;
    UserModel nonInvitedUser;
    SiteModel testSite;
    FileModel testFile;
    FileModel managerFile;
    private DataUser.ListUserWithRoles usersWithRoles;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.managerFile = FileModel.getRandomFileModel((FileType)FileType.HTML, (String)this.documentContent);
        this.testUser = this.dataUser.createRandomTestUser();
        this.nonInvitedUser = this.dataUser.createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createPublicRandomSite();
        this.usersWithRoles = ((DataUser)this.dataUser.usingUser(this.testUser)).addUsersWithRolesToSite(this.testSite, new UserRole[]{UserRole.SiteContributor, UserRole.SiteCollaborator, UserRole.SiteConsumer});
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.managerFile).assertThat().existsInRepo().then()).checkOut().and()).prepareDocumentForCheckIn().withMajorVersion().checkIn().then()).checkOut().and()).prepareDocumentForCheckIn().withMinorVersion().checkIn();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify site manager is able to get last major version for document checked in with minor version")
    @Test(groups={"sanity", "cmis"})
    public void siteManagerShouldGetLastMajorVersionForDocumentCheckedInWithMajorVersion() throws Exception {
        this.cmisApi.authenticateUser(this.testUser).usingResource((ContentModel)this.managerFile).usingVersion().assertLatestMajorVersionIs(Double.valueOf(2.0));
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify site manager is able to get last minor version for document checked in with major version")
    @Test(groups={"sanity", "cmis"})
    public void siteManagerShouldGetLastMinorVersionForDocumentCheckedInWithMajorVersion() throws Exception {
        this.cmisApi.authenticateUser(this.testUser).usingResource((ContentModel)this.managerFile).usingVersion().assertLatestMinorVersionIs(Double.valueOf(2.1));
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is NOT able to get last major version for document that was already deleted")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisObjectNotFoundException.class})
    public void siteManagerCannotGetLastMajorVersionForInexistentDocument() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo().and()).checkOut().and()).prepareDocumentForCheckIn().withMajorVersion().checkIn().then()).usingVersion().assertLatestMajorVersionIs(Double.valueOf(2.0)).and()).delete().then()).usingVersion().assertLatestMajorVersionIs(Double.valueOf(2.0));
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to get last major version for document that was checked out")
    @Test(groups={"regression", "cmis"})
    public void siteManagerCanGetLastMajorVersionForCheckedOutDocument() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo().and()).checkOut().and()).prepareDocumentForCheckIn().withMajorVersion().checkIn().usingVersion().assertLatestMajorVersionIs(Double.valueOf(2.0)).checkOut().then()).usingVersion().assertLatestMajorVersionIs(Double.valueOf(2.0));
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to get last minor version for document created with minor VersioningState")
    @Test(groups={"regression", "cmis"})
    public void siteManagerCanGetLastMinorVersionForDocumentWithMinorVersioningState() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile, VersioningState.MINOR).and()).assertThat().existsInRepo().then()).usingVersion().assertLatestMinorVersionIs(Double.valueOf(0.1));
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is not able to get last major version for document created with minor VersioningState")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisObjectNotFoundException.class}, expectedExceptionsMessageRegExp="There is no major version!*")
    public void siteManagerCannotGetLastMajorVersionForDocumentWithMinorVersioningState() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile, VersioningState.MINOR).and()).assertThat().existsInRepo().then()).usingVersion().assertLatestMajorVersionIs(Double.valueOf(0.1));
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to get last minor version for document created with checked out VersioningState")
    @Test(groups={"regression", "cmis"})
    public void siteManagerCanGetLastVersionForDocumentWithCheckedOutVersioningState() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile, VersioningState.CHECKEDOUT).and()).assertThat().existsInRepo().then()).usingVersion().assertLatestMinorVersionIs(Double.valueOf(1.0)).usingVersion().assertLatestMajorVersionIs(Double.valueOf(1.0)).then()).usingPWCDocument().usingVersion().assertLatestMajorVersionIs(Double.valueOf(1.0)).usingVersion().assertLatestMinorVersionIs(Double.valueOf(1.0));
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site collaborator is able to get last versions for document created by manager")
    @Test(groups={"regression", "cmis"})
    public void collaboratorCanGetLastVersionsForDocumentCreatedByManager() throws Exception {
        this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingResource((ContentModel)this.managerFile).usingVersion().assertLatestMinorVersionIs(Double.valueOf(2.1)).usingVersion().assertLatestMajorVersionIs(Double.valueOf(2.0));
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site contributor is able to get last versions for document created by manager")
    @Test(groups={"regression", "cmis"})
    public void contributorCanGetLastVersionsForDocumentCreatedByManager() throws Exception {
        this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingResource((ContentModel)this.managerFile).usingVersion().assertLatestMinorVersionIs(Double.valueOf(2.1)).usingVersion().assertLatestMajorVersionIs(Double.valueOf(2.0));
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site consumer is able to get last versions for document created by manager")
    @Test(groups={"regression", "cmis"})
    public void consumerCanGetLastVersionsForDocumentCreatedByManager() throws Exception {
        this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingResource((ContentModel)this.managerFile).usingVersion().assertLatestMinorVersionIs(Double.valueOf(2.1)).usingVersion().assertLatestMajorVersionIs(Double.valueOf(2.0));
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify non invited user is able to get last versions for document created in public site")
    @Test(groups={"regression", "cmis"})
    public void nonInvitedUserCanGetLastVersionsForDocumentInPublicSite() throws Exception {
        this.cmisApi.authenticateUser(this.nonInvitedUser).usingResource((ContentModel)this.managerFile).usingVersion().assertLatestMinorVersionIs(Double.valueOf(2.1)).usingVersion().assertLatestMajorVersionIs(Double.valueOf(2.0));
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify non invited user is not able to get last versions for document from private site")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void nonInvitedUserCannotGetLastVersionsForDocumentCreatedByManagerInPrivateSite() throws Exception {
        SiteModel privateSite = this.dataSite.createPrivateRandomSite();
        FileModel privateDoc = FileModel.getRandomFileModel((FileType)FileType.XML, (String)this.documentContent);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingSite(privateSite).createFile(privateDoc).then()).checkOut().and()).prepareDocumentForCheckIn().withMajorVersion().checkIn().authenticateUser(this.nonInvitedUser).usingVersion().assertLatestMinorVersionIs(Double.valueOf(2.0));
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify non invited user is not able to get last versions for document from moderated site")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void nonInvitedUserCannotGetLastVersionsForDocumentCreatedByManagerInModeratedSite() throws Exception {
        SiteModel moderatedSite = this.dataSite.createModeratedRandomSite();
        FileModel moderatedDoc = FileModel.getRandomFileModel((FileType)FileType.XML, (String)this.documentContent);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingSite(moderatedSite).createFile(moderatedDoc).then()).checkOut().and()).prepareDocumentForCheckIn().withMajorVersion().checkIn().authenticateUser(this.nonInvitedUser).usingVersion().assertLatestMinorVersionIs(Double.valueOf(2.0));
    }
}

