/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis;

import org.alfresco.cmis.CmisTest;
import org.alfresco.cmis.CmisWrapper;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisVersioningException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class CheckOutTests
extends CmisTest {
    UserModel unauthorizedUser;
    UserModel siteManager;
    SiteModel testSite;
    FileModel testFile;
    private String fileContent = "content";
    private DataUser.ListUserWithRoles usersWithRoles;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.unauthorizedUser = this.dataUser.createRandomTestUser();
        this.siteManager = this.dataUser.createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.siteManager)).createPublicRandomSite();
        this.usersWithRoles = this.dataUser.addUsersWithRolesToSite(this.testSite, new UserRole[]{UserRole.SiteContributor, UserRole.SiteConsumer});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify check out valid document")
    @Test(groups={"sanity", "cmis"})
    public void verifyCheckOutValidDocument() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.fileContent);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo().and()).checkOut().then()).assertThat().documentIsCheckedOut().and()).assertThat().isPrivateWorkingCopy();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify check out inexistent document")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisObjectNotFoundException.class})
    public void verifyCheckOutInexistentDocument() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.fileContent);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.testSite).createFile(this.testFile).and()).delete().assertThat().doesNotExistInRepo().then()).checkOut();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify if PWC is created for document that is not checked out")
    @Test(groups={"regression", "cmis"})
    public void verifyPWCForDocThatIsNotCheckedOut() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.fileContent);
        this.cmisApi.authenticateUser(this.siteManager).usingSite(this.testSite).createFile(this.testFile).assertThat().isNotPrivateWorkingCopy();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify error when a document is checked out twice")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisVersioningException.class}, expectedExceptionsMessageRegExp="^Check out failed.*This node is already checked out.$")
    public void checkOutDocumentTwice() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.fileContent);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.testSite).createFile(this.testFile).assertThat().existsInRepo().then()).checkOut().assertThat().documentIsCheckedOut().then()).checkOut();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify private working copy does NOT exists for a document that was deleted")
    @Test(groups={"regression", "cmis"})
    public void verifyPWCDoesNotExistsForDeletedDocument() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.fileContent);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.testSite).createFile(this.testFile).and()).checkOut().then()).assertThat().documentIsCheckedOut().usingPWCDocument().delete().and()).assertThat().doesNotExistInRepo().then()).usingResource((ContentModel)this.testFile).assertThat().isNotPrivateWorkingCopy().and()).assertThat().documentIsNotCheckedOut();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify that contributor user can NOT check out document created by manager")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void contributorCannotCheckOutDocumentCreatedByManager() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.fileContent);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo().authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).and()).checkOut();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify that consumer user can NOT check out document")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void consumerCannotCheckOutDocument() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.fileContent);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo().authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).and()).checkOut();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify that unauthorized user can NOT check out document from private site")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void unauthorizedUserCannotCheckOutDocumentFromPrivateSite() throws Exception {
        SiteModel privateSite = ((DataSite)this.dataSite.usingUser(this.siteManager)).createPrivateRandomSite();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.fileContent);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(privateSite).createFile(this.testFile).and()).assertThat().existsInRepo().authenticateUser(this.unauthorizedUser).and()).checkOut();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify that unauthorized user can NOT check out document from moderated site")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void unauthorizedUserCannotCheckOutDocumentModeratedSite() throws Exception {
        SiteModel moderatedSite = ((DataSite)this.dataSite.usingUser(this.siteManager)).createModeratedRandomSite();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.fileContent);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(moderatedSite).createFile(this.testFile).and()).assertThat().existsInRepo().authenticateUser(this.unauthorizedUser).and()).checkOut();
    }
}

