/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.dsl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.alfresco.cmis.CmisWrapper;
import org.alfresco.utility.report.log.Step;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.testng.Assert;

public class DocumentVersioning {
    private CmisWrapper cmisWrapper;
    private CmisObject cmisObject;
    private boolean majorVersion;
    private Object versionLabel;
    private List<Object> versions;

    public DocumentVersioning(CmisWrapper cmisWrapper, CmisObject cmisObject) {
        this.cmisWrapper = cmisWrapper;
        this.cmisObject = cmisObject;
    }

    private DocumentVersioning withLatestMajorVersion() {
        this.majorVersion = true;
        return this;
    }

    private DocumentVersioning withLatestMinorVersion() {
        this.majorVersion = false;
        return this;
    }

    private Document getVersionOfDocument() {
        Document document = (Document)this.cmisObject;
        if (this.versionLabel != null) {
            List documents = document.getAllVersions();
            for (Document documentVersion : documents) {
                if (!documentVersion.getVersionLabel().equals(this.versionLabel.toString())) continue;
                return documentVersion;
            }
        } else {
            return document.getObjectOfLatestVersion(this.majorVersion);
        }
        return document;
    }

    private List<Object> getDocumentVersions(List<Document> documentList) {
        ArrayList<Object> versions = new ArrayList<Object>();
        for (Document document : documentList) {
            versions.add(document.getVersionLabel());
        }
        return versions;
    }

    public CmisWrapper assertVersionIs(Double expectedVersion) {
        Step.STEP((String)String.format("%s Verify if document '%s' has version '%s'", this.cmisWrapper.getProtocolName(), this.cmisObject.getName(), expectedVersion));
        Assert.assertEquals((String)this.getVersionOfDocument().getVersionLabel(), (String)expectedVersion.toString(), (String)"File has version");
        return this.cmisWrapper;
    }

    public CmisWrapper assertLatestMajorVersionIs(Double expectedVersion) {
        Step.STEP((String)String.format("%s Verify if latest major version of document '%s' is '%s'", this.cmisWrapper.getProtocolName(), this.cmisObject.getName(), expectedVersion));
        Assert.assertEquals((String)this.withLatestMajorVersion().getVersionOfDocument().getVersionLabel(), (String)expectedVersion.toString(), (String)"File has version");
        return this.cmisWrapper;
    }

    public CmisWrapper assertLatestMinorVersionIs(Double expectedVersion) {
        Step.STEP((String)String.format("%s Verify if latest minor version of document '%s' is '%s'", this.cmisWrapper.getProtocolName(), this.cmisObject.getName(), expectedVersion));
        Assert.assertEquals((String)this.withLatestMinorVersion().getVersionOfDocument().getVersionLabel(), (String)expectedVersion.toString(), (String)"File has version");
        return this.cmisWrapper;
    }

    public DocumentVersioning getAllDocumentVersions() {
        this.setVersions(this.getDocumentVersions(this.cmisWrapper.withCMISUtil().getAllDocumentVersions()));
        return this;
    }

    public CmisWrapper assertHasVersions(Object ... versions) {
        this.setVersions(this.getDocumentVersions(this.cmisWrapper.withCMISUtil().getAllDocumentVersions()));
        List<Object> documentVersions = this.getVersions();
        for (Object version : versions) {
            Step.STEP((String)String.format("%s Verify if document '%s' has version '%s'", this.cmisWrapper.getProtocolName(), this.cmisObject.getName(), version));
            Assert.assertTrue((boolean)documentVersions.contains(version.toString()), (String)String.format("Document %s does not have version %s", this.cmisObject.getName(), version));
        }
        return this.cmisWrapper;
    }

    public DocumentVersioning getAllDocumentVersionsBy(OperationContext context) {
        this.setVersions(this.getDocumentVersions(this.cmisWrapper.withCMISUtil().getAllDocumentVersionsBy(context)));
        return this;
    }

    public CmisWrapper assertHasVersionsInOrder(Object ... versions) {
        List<Object> documentVersions = this.getVersions();
        List<Object> expectedVersions = Arrays.asList(versions);
        Step.STEP((String)String.format("%s Verify if document '%s' has versions in this order '%s'", this.cmisWrapper.getProtocolName(), this.cmisObject.getName(), Arrays.toString(expectedVersions.toArray())));
        Assert.assertTrue((boolean)documentVersions.toString().equals(expectedVersions.toString()), (String)String.format("Document %s does not have versions in this order %s", this.cmisObject.getName(), Arrays.toString(expectedVersions.toArray())));
        return this.cmisWrapper;
    }

    public List<Object> getVersions() {
        return this.versions;
    }

    public void setVersions(List<Object> versions) {
        this.versions = versions;
    }
}

