/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis;

import org.alfresco.cmis.CmisTest;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUnauthorizedException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetTypeDescendantsTests
extends CmisTest {
    @BeforeClass(alwaysRun=true)
    public void setup() throws Exception {
        this.cmisApi.authenticateUser(this.dataUser.getAdminUser());
    }

    @Test(groups={"cmis", "regression"})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify admin can get type descendantes for valid type id and includePropertyDefinitions = true  and depth = -1")
    public void adminShouldGetTypeDescendantsValidInputCase1() {
        this.cmisApi.usingObjectType(BaseTypeId.CMIS_DOCUMENT.value()).withPropertyDefinitions().hasDescendantType(-1, new String[]{"D:cm:dictionaryModel", "D:trx:transferLock"});
    }

    @Test(groups={"cmis", "regression"})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify admin can get type descendantes for valid type id and includePropertyDefinitions = true  and depth = 1")
    public void adminShouldGetTypeDescendantsValidInputCase2() {
        this.cmisApi.usingObjectType(BaseTypeId.CMIS_DOCUMENT.value()).withPropertyDefinitions().hasDescendantType(1, new String[]{"D:cm:dictionaryModel", "D:trx:transferLock"});
    }

    @Test(groups={"cmis", "regression"})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify admin can get type descendants for valid type id and includePropertyDefinitions = false  and depth = 1")
    public void adminShouldGetTypeDescendantsValidInputCase3() {
        this.cmisApi.usingObjectType(BaseTypeId.CMIS_DOCUMENT.value()).withoutPropertyDefinitions().hasDescendantType(1, new String[]{"D:cm:dictionaryModel", "D:trx:transferLock"});
    }

    @Test(groups={"cmis", "regression"})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify admin can get type descendantes for valid type id and includePropertyDefinitions = false  and depth = -1")
    public void adminShouldGetTypeDescendantsValidInputCase4() {
        this.cmisApi.usingObjectType(BaseTypeId.CMIS_DOCUMENT.value()).withoutPropertyDefinitions().hasDescendantType(-1, new String[]{"D:cm:dictionaryModel", "D:trx:transferLock"});
    }

    @Test(groups={"cmis", "regression"}, expectedExceptions={CmisObjectNotFoundException.class}, expectedExceptionsMessageRegExp="Type 'cmis:documentfake' is unknown!*")
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify admin cannot get type descendantes for invalid type id and includePropertyDefinitions = false  and depth = -1")
    public void adminCannotGetTypeDescendantsForInvalidType() {
        this.cmisApi.usingObjectType(BaseTypeId.CMIS_DOCUMENT.value() + "fake").withoutPropertyDefinitions().hasDescendantType(-1, new String[]{"D:cm:dictionaryModel", "D:trx:transferLock"});
    }

    @Test(groups={"cmis", "regression"}, expectedExceptions={CmisInvalidArgumentException.class})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify admin can get type descendantes for valid type id and includePropertyDefinitions = false  and incorrect depth = -2")
    public void adminShouldGetTypeDescendantsValidTypeWithIncorrectDepth() {
        this.cmisApi.usingObjectType(BaseTypeId.CMIS_DOCUMENT.value()).withoutPropertyDefinitions().hasDescendantType(-2, new String[]{"D:cm:dictionaryModel", "D:trx:transferLock"});
    }

    @Test(groups={"cmis", "sanity"})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify random user can get type descendantes for valid type id and includePropertyDefinitions = false  and depth = 1")
    public void userGetTypeDescendants() throws Exception {
        UserModel user = this.dataUser.createRandomTestUser();
        this.cmisApi.authenticateUser(user).usingObjectType(BaseTypeId.CMIS_DOCUMENT.value()).withoutPropertyDefinitions().hasDescendantType(1, new String[]{"D:cm:dictionaryModel", "D:trx:transferLock"});
    }

    @Bug(id="REPO-5388")
    @Test(groups={"cmis", "regression"}, expectedExceptions={CmisUnauthorizedException.class})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify deleted user cannot get type descendantes for valid type id and includePropertyDefinitions = false  and depth = 1")
    public void deletedUserCannotGetTypeDescendants() throws Exception {
        UserModel deletedUser = this.dataUser.createRandomTestUser();
        this.cmisApi.authenticateUser(deletedUser).usingObjectType(BaseTypeId.CMIS_DOCUMENT.value()).withoutPropertyDefinitions().hasDescendantType(1, new String[]{"D:cm:dictionaryModel", "D:trx:transferLock"});
        ((DataUser)this.dataUser.usingAdmin()).deleteUser(deletedUser);
        this.cmisApi.disconnect().usingObjectType(BaseTypeId.CMIS_DOCUMENT.value()).withoutPropertyDefinitions().hasDescendantType(1, new String[]{"D:cm:dictionaryModel", "D:trx:transferLock"});
    }

    @Bug(id="REPO-5388")
    @Test(groups={"cmis", "regression"}, expectedExceptions={CmisUnauthorizedException.class})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify disabled user cannot get type descendantes for valid type id and includePropertyDefinitions = false  and depth = 1")
    public void disabledUserCannotGetTypeDescendants() throws Exception {
        UserModel disabledUser = this.dataUser.createRandomTestUser();
        this.cmisApi.authenticateUser(disabledUser).usingObjectType(BaseTypeId.CMIS_DOCUMENT.value()).withoutPropertyDefinitions().hasDescendantType(1, new String[]{"D:cm:dictionaryModel", "D:trx:transferLock"});
        ((DataUser)this.dataUser.usingAdmin()).disableUser(disabledUser);
        this.cmisApi.disconnect().usingObjectType(BaseTypeId.CMIS_DOCUMENT.value()).withoutPropertyDefinitions().hasDescendantType(1, new String[]{"D:cm:dictionaryModel", "D:trx:transferLock"});
    }
}

