/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.dsl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.alfresco.cmis.CmisWrapper;
import org.alfresco.cmis.exception.InvalidCmisObjectException;
import org.alfresco.utility.LogFactory;
import org.alfresco.utility.Utility;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.exception.IORuntimeException;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.GroupModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.FileableCmisObject;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Property;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.apache.chemistry.opencmis.client.api.Rendition;
import org.apache.chemistry.opencmis.client.api.SecondaryType;
import org.apache.chemistry.opencmis.client.api.Tree;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.AclCapabilities;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.PermissionMapping;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisVersioningException;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.testng.collections.Lists;

public class CmisUtil {
    private CmisWrapper cmisAPI;
    private Logger LOG = LogFactory.getLogger();

    public CmisUtil(CmisWrapper cmisAPI) {
        this.cmisAPI = cmisAPI;
    }

    public CmisObject getCmisObjectById(String objectId) {
        this.LOG.debug("Get CMIS object by ID {}", (Object)objectId);
        if (this.cmisAPI.getSession() == null) {
            throw new CmisRuntimeException("Please authenticate user, call: cmisAPI.authenticate(..)!");
        }
        if (objectId == null) {
            throw new InvalidCmisObjectException("Invalid content id");
        }
        return this.cmisAPI.getSession().getObject(objectId);
    }

    public CmisObject getCmisObjectById(String objectId, OperationContext context) {
        if (this.cmisAPI.getSession() == null) {
            throw new CmisRuntimeException("Please authenticate user, call: cmisAPI.authenticate(..)!");
        }
        if (objectId == null) {
            throw new InvalidCmisObjectException("Invalid content id");
        }
        return this.cmisAPI.getSession().getObject(objectId, context);
    }

    public CmisObject getCmisObject(String pathToItem) {
        if (this.cmisAPI.getSession() == null) {
            throw new CmisRuntimeException("Please authenticate user, call: cmisAPI.authenticate(..)!");
        }
        if (pathToItem == null) {
            throw new InvalidCmisObjectException("Invalid path set for content");
        }
        Object cmisObject = this.cmisAPI.getSession().getObjectByPath(Utility.removeLastSlash((String)pathToItem));
        if (cmisObject instanceof Document) {
            cmisObject = !((Document)cmisObject).getVersionLabel().contentEquals("pwc") ? ((Document)cmisObject).getObjectOfLatestVersion(false) : this.cmisAPI.getSession().getObject(((Document)cmisObject).getObjectOfLatestVersion(false).getVersionSeriesCheckedOutId());
        }
        return cmisObject;
    }

    public CmisObject getCmisObject(String pathToItem, OperationContext context) {
        if (this.cmisAPI.getSession() == null) {
            throw new CmisRuntimeException("Please authenticate user!");
        }
        if (pathToItem == null) {
            throw new InvalidCmisObjectException("Invalid path set for content");
        }
        Object cmisObject = this.cmisAPI.getSession().getObjectByPath(Utility.removeLastSlash((String)pathToItem), context);
        if (cmisObject instanceof Document) {
            cmisObject = !((Document)cmisObject).getVersionLabel().contentEquals("pwc") ? ((Document)cmisObject).getObjectOfLatestVersion(false, context) : this.cmisAPI.getSession().getObject(((Document)cmisObject).getObjectOfLatestVersion(false, context).getVersionSeriesCheckedOutId());
        }
        return cmisObject;
    }

    public Document getCmisDocument(String path) {
        this.LOG.debug("Get CMIS Document by path {}", (Object)path);
        Document d = null;
        CmisObject docObj = this.getCmisObject(path);
        if (docObj instanceof Document) {
            d = (Document)docObj;
        } else if (docObj instanceof Folder) {
            throw new InvalidCmisObjectException("Content at " + path + " is not a file");
        }
        return d;
    }

    public Folder getCmisFolder(String path) {
        Folder f = null;
        CmisObject folderObj = this.getCmisObject(path);
        if (folderObj instanceof Folder) {
            f = (Folder)folderObj;
        } else if (folderObj instanceof Document) {
            throw new InvalidCmisObjectException("Content at " + path + " is not a folder");
        }
        return f;
    }

    protected String getContentAsString(ContentStream stream) {
        String result;
        this.LOG.debug("Get Content as String {}", (Object)stream);
        InputStream inputStream = stream.getStream();
        try {
            result = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return result;
    }

    protected void copyChildrenFromFolder(Folder sourceFolder, Folder targetFolder) {
        for (Tree t : sourceFolder.getDescendants(-1)) {
            CmisObject obj = (CmisObject)t.getItem();
            if (obj instanceof Document) {
                Document d = (Document)obj;
                d.copy((ObjectId)targetFolder);
                continue;
            }
            if (!(obj instanceof Folder)) continue;
            this.copyFolder((Folder)obj, targetFolder);
        }
    }

    public CmisObject copyFolder(Folder sourceFolder, Folder targetFolder) {
        HashMap<String, String> folderProperties = new HashMap<String, String>(2);
        folderProperties.put("cmis:name", sourceFolder.getName());
        folderProperties.put("cmis:objectTypeId", sourceFolder.getBaseTypeId().value());
        Folder newFolder = targetFolder.createFolder(folderProperties);
        this.copyChildrenFromFolder(sourceFolder, newFolder);
        return newFolder;
    }

    protected boolean isPrivateWorkingCopy() {
        Document document;
        try {
            document = this.getPWCDocument();
        }
        catch (CmisVersioningException cmisVersioningException) {
            return false;
        }
        if (Boolean.FALSE.equals(document.isVersionable())) {
            return false;
        }
        if (Boolean.FALSE.equals(document.isVersionSeriesCheckedOut())) {
            return false;
        }
        Boolean isPWC = document.isPrivateWorkingCopy();
        if (isPWC != null) {
            return isPWC;
        }
        String vsCoId = document.getVersionSeriesCheckedOutId();
        if (vsCoId == null) {
            return false;
        }
        return vsCoId.equals(document.getId());
    }

    public Document getPWCDocument() {
        Document document = this.getCmisDocument(this.cmisAPI.getLastResource());
        String pwcId = document.getVersionSeriesCheckedOutId();
        if (pwcId != null) {
            return (Document)this.cmisAPI.getSession().getObject(pwcId);
        }
        throw new CmisVersioningException(String.format("Document %s is not checked out", document.getName()));
    }

    public FileModel getPWCFileModel() {
        Document document = this.getPWCDocument();
        String[] pathTokens = this.cmisAPI.getLastResource().split("/");
        String path = "";
        for (int i = 0; i < pathTokens.length - 1; ++i) {
            path = Utility.buildPath((String)path, (String[])new String[]{pathTokens[i]});
        }
        path = Utility.buildPath((String)path, (String[])new String[]{document.getName()});
        FileModel fileModel = new FileModel();
        fileModel.setName(document.getName());
        fileModel.setCmisLocation(path);
        return fileModel;
    }

    protected Folder getFolderParent() {
        return this.getCmisFolder(this.cmisAPI.getLastResource()).getFolderParent();
    }

    protected List<Action> getAllowableActions() {
        return Lists.newArrayList((Collection)this.getCmisObject(this.cmisAPI.getLastResource()).getAllowableActions().getAllowableActions());
    }

    protected <T> Property<T> getProperty(String propertyId) {
        CmisObject cmisObject = this.getCmisObject(this.cmisAPI.getLastResource());
        return cmisObject.getProperty(propertyId);
    }

    protected List<Rendition> getRenditions() {
        OperationContext operationContext = this.cmisAPI.getSession().createOperationContext();
        operationContext.setRenditionFilterString("*");
        CmisObject obj = this.cmisAPI.getSession().getObjectByPath(this.cmisAPI.getLastResource(), operationContext);
        obj.refresh();
        List renditions = obj.getRenditions();
        for (int retry = 0; (renditions == null || renditions.isEmpty()) && retry < Utility.retryCountSeconds; ++retry) {
            Utility.waitToLoopTime((int)1, (String[])new String[0]);
            obj.refresh();
            renditions = obj.getRenditions();
        }
        return obj.getRenditions();
    }

    protected List<SecondaryType> getSecondaryTypes() {
        CmisObject obj = this.getCmisObject(this.cmisAPI.getLastResource());
        obj.refresh();
        return obj.getSecondaryTypes();
    }

    public Map<ContentModel, ObjectType> getChildren() {
        String folderParent = this.cmisAPI.getLastResource();
        ItemIterable children = this.cmisAPI.withCMISUtil().getCmisFolder(folderParent).getChildren();
        HashMap<ContentModel, ObjectType> contents = new HashMap<ContentModel, ObjectType>();
        for (CmisObject o : children) {
            ContentModel content = new ContentModel(o.getName());
            content.setNodeRef(o.getId());
            content.setDescription(o.getDescription());
            content.setCmisLocation(Utility.buildPath((String)folderParent, (String[])new String[]{o.getName()}));
            contents.put(content, o.getType());
        }
        return contents;
    }

    public List<CmisObject> getFolderDescendants(int depth) {
        return this.getFolderTreeCmisObjects(this.getCmisFolder(this.cmisAPI.getLastResource()).getDescendants(depth));
    }

    public List<CmisObject> getCmisObjectsFromContentModels(ContentModel ... contentModels) {
        ArrayList<CmisObject> cmisObjects = new ArrayList<CmisObject>();
        for (ContentModel contentModel : contentModels) {
            cmisObjects.add(this.getCmisObject(contentModel.getCmisLocation()));
        }
        return cmisObjects;
    }

    public ContentStream getContentStream(String content) {
        String fileName = this.getCmisDocument(this.cmisAPI.getLastResource()).getName();
        return this.cmisAPI.getDataContentService().getContentStream(fileName, content);
    }

    public Acl getAcls() {
        OperationContext context = this.cmisAPI.getSession().createOperationContext();
        context.setIncludeAcls(true);
        return this.getCmisObject(this.cmisAPI.getLastResource(), context).getAcl();
    }

    public List<CmisObject> getFolderTree(int depth) {
        return this.getFolderTreeCmisObjects(this.getCmisFolder(this.cmisAPI.getLastResource()).getFolderTree(depth));
    }

    private List<CmisObject> getFolderTreeCmisObjects(List<Tree<FileableCmisObject>> descendants) {
        ArrayList<CmisObject> cmisObjectList = new ArrayList<CmisObject>();
        for (Tree<FileableCmisObject> descendant : descendants) {
            cmisObjectList.add((CmisObject)descendant.getItem());
            cmisObjectList.addAll(descendant.getChildren().stream().map(Tree::getItem).collect(Collectors.toList()));
        }
        return cmisObjectList;
    }

    protected List<Document> getAllDocumentVersions() {
        return this.getCmisDocument(this.cmisAPI.getLastResource()).getAllVersions();
    }

    public List<Document> getAllDocumentVersionsBy(OperationContext context) {
        return this.getCmisDocument(this.cmisAPI.getLastResource()).getAllVersions(context);
    }

    public List<Document> getCheckedOutDocumentsFromSession() {
        return com.google.common.collect.Lists.newArrayList((Iterable)this.cmisAPI.getSession().getCheckedOutDocs());
    }

    public List<Document> getCheckedOutDocumentsFromSession(OperationContext context) {
        return com.google.common.collect.Lists.newArrayList((Iterable)this.cmisAPI.getSession().getCheckedOutDocs(context));
    }

    public List<Document> getCheckedOutDocumentsFromFolder() {
        Folder folder = this.cmisAPI.withCMISUtil().getCmisFolder(this.cmisAPI.getLastResource());
        return com.google.common.collect.Lists.newArrayList((Iterable)folder.getCheckedOutDocs());
    }

    public List<Document> getCheckedOutDocumentsFromFolder(OperationContext context) {
        Folder folder = this.cmisAPI.withCMISUtil().getCmisFolder(this.cmisAPI.getLastResource());
        return com.google.common.collect.Lists.newArrayList((Iterable)folder.getCheckedOutDocs(context));
    }

    protected boolean isCmisObjectContainedInCmisCheckedOutDocumentsList(CmisObject cmisObject, List<Document> cmisCheckedOutDocuments) {
        for (Document cmisCheckedOutDocument : cmisCheckedOutDocuments) {
            if (!cmisObject.getId().split(";")[0].equals(cmisCheckedOutDocument.getId().split(";")[0])) continue;
            return true;
        }
        return false;
    }

    public Map<String, Object> getProperties(ContentModel contentModel, String baseTypeId) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("cmis:objectTypeId", baseTypeId);
        properties.put("cmis:name", contentModel.getName());
        if (this.cmisAPI.getSession().getBinding().getBindingType().value().equals(BindingType.WEBSERVICES.value())) {
            return properties;
        }
        ArrayList<String> aspects = new ArrayList<String>();
        aspects.add("P:cm:titled");
        properties.put("cmis:secondaryObjectTypeIds", aspects);
        properties.put("cm:title", contentModel.getTitle());
        properties.put("cm:description", contentModel.getDescription());
        return properties;
    }

    public OperationContext setIncludeAclContext() {
        OperationContext context = this.cmisAPI.getSession().createOperationContext();
        context.setIncludeAcls(true);
        return context;
    }

    public List<Ace> createAce(UserModel user, UserRole role) {
        ArrayList<String> addPermission = new ArrayList<String>();
        addPermission.add(role.getRoleId());
        Ace addAce = this.cmisAPI.getSession().getObjectFactory().createAce(user.getUsername(), addPermission);
        ArrayList<Ace> addAces = new ArrayList<Ace>();
        addAces.add(addAce);
        return addAces;
    }

    public List<Ace> createAce(GroupModel group, UserRole role) {
        ArrayList<String> addPermission = new ArrayList<String>();
        addPermission.add(role.getRoleId());
        Ace addAce = this.cmisAPI.getSession().getObjectFactory().createAce(group.getDisplayName(), addPermission);
        ArrayList<Ace> addAces = new ArrayList<Ace>();
        addAces.add(addAce);
        return addAces;
    }

    public List<Ace> createAce(UserModel user, String ... permissions) {
        ArrayList<Ace> addAces = new ArrayList<Ace>();
        RepositoryInfo repositoryInfo = this.cmisAPI.getSession().getRepositoryInfo();
        AclCapabilities aclCapabilities = repositoryInfo.getAclCapabilities();
        Map permissionMappings = aclCapabilities.getPermissionMapping();
        for (String perm : permissions) {
            Step.STEP((String)String.format("%s Add permission '%s' for user %s ", CmisWrapper.STEP_PREFIX, perm, user.getUsername()));
            PermissionMapping permissionMapping = (PermissionMapping)permissionMappings.get(perm);
            List permissionsList = permissionMapping.getPermissions();
            Ace addAce = this.cmisAPI.getSession().getObjectFactory().createAce(user.getUsername(), permissionsList);
            addAces.add(addAce);
        }
        return addAces;
    }

    public ObjectType getTypeDefinition() {
        CmisObject cmisObject = this.cmisAPI.withCMISUtil().getCmisObject(this.cmisAPI.getLastResource());
        return this.cmisAPI.getSession().getTypeDefinition(cmisObject.getBaseTypeId().value());
    }

    public ItemIterable<ObjectType> getTypeChildren(String baseType, boolean includePropertyDefinitions) {
        Step.STEP((String)String.format("%s Get type children for '%s' and includePropertyDefinitions set to '%s'", CmisWrapper.STEP_PREFIX, baseType, includePropertyDefinitions));
        return this.cmisAPI.getSession().getTypeChildren(baseType, includePropertyDefinitions);
    }

    public List<Tree<ObjectType>> getTypeDescendants(String baseTypeId, int depth, boolean includePropertyDefinitions) {
        Step.STEP((String)String.format("%s Get type descendants for '%s' with depth set to %d and includePropertyDefinitions set to '%s'", CmisWrapper.STEP_PREFIX, baseTypeId, depth, includePropertyDefinitions));
        return this.cmisAPI.getSession().getTypeDescendants(baseTypeId, depth, includePropertyDefinitions);
    }

    public String getObjectId(String pathToObject) {
        return this.getCmisObject(pathToObject).getId();
    }

    public void updateProperties(String propertyName, Object propertyValue) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put(propertyName, propertyValue);
        this.getCmisObject(this.cmisAPI.getLastResource()).updateProperties(props);
    }

    protected boolean isFolderInList(FolderModel folderModel, List<FolderModel> folders) {
        for (FolderModel folder : folders) {
            if (!folderModel.getName().equals(folder.getName())) continue;
            return true;
        }
        return false;
    }

    protected boolean isFileInList(FileModel fileModel, List<FileModel> files) {
        for (FileModel file : files) {
            if (!fileModel.getName().equals(file.getName())) continue;
            return true;
        }
        return false;
    }

    protected boolean isContentInList(ContentModel contentModel, List<ContentModel> contents) {
        for (ContentModel content : contents) {
            if (!content.getName().equals(content.getName())) continue;
            return true;
        }
        return false;
    }

    public List<FolderModel> getFolders() {
        Step.STEP((String)String.format("%s Get the folder children from '%s'", CmisWrapper.STEP_PREFIX, this.cmisAPI.getLastResource()));
        Map<ContentModel, ObjectType> children = this.getChildren();
        ArrayList<FolderModel> folders = new ArrayList<FolderModel>();
        for (Map.Entry<ContentModel, ObjectType> entry : children.entrySet()) {
            if (!entry.getValue().getId().equals(BaseTypeId.CMIS_FOLDER.value())) continue;
            FolderModel folder = new FolderModel(entry.getKey().getName());
            folder.setNodeRef(entry.getKey().getNodeRef());
            folder.setDescription(entry.getKey().getDescription());
            folder.setCmisLocation(entry.getKey().getCmisLocation());
            folder.setProtocolLocation(entry.getKey().getCmisLocation());
            folders.add(folder);
        }
        return folders;
    }

    public List<FileModel> getFiles() {
        Step.STEP((String)String.format("%s Get the file children from '%s'", CmisWrapper.STEP_PREFIX, this.cmisAPI.getLastResource()));
        Map<ContentModel, ObjectType> children = this.getChildren();
        ArrayList<FileModel> files = new ArrayList<FileModel>();
        for (Map.Entry<ContentModel, ObjectType> entry : children.entrySet()) {
            if (!entry.getValue().getId().equals(BaseTypeId.CMIS_DOCUMENT.value())) continue;
            FileModel file = new FileModel(entry.getKey().getName());
            file.setNodeRef(entry.getKey().getNodeRef());
            file.setDescription(entry.getKey().getDescription());
            file.setCmisLocation(entry.getKey().getCmisLocation());
            file.setProtocolLocation(entry.getKey().getCmisLocation());
            files.add(file);
        }
        return files;
    }

    public String getDocumentContent() {
        Utility.waitToLoopTime((int)2, (String[])new String[0]);
        Document lastVersion = this.getCmisDocument(this.cmisAPI.getLastResource());
        lastVersion.refresh();
        this.LOG.info(String.format("Get the content from %s - node: %s", lastVersion.getName(), lastVersion.getId()));
        ContentStream contentStream = lastVersion.getContentStream();
        String actualContent = "";
        if (contentStream != null) {
            actualContent = this.getContentAsString(contentStream);
        } else {
            lastVersion = this.getCmisDocument(this.cmisAPI.getLastResource());
            lastVersion.refresh();
            this.LOG.info(String.format("Retry get content stream for %s node: %s", lastVersion.getName(), lastVersion.getId()));
            contentStream = lastVersion.getContentStream();
            if (contentStream != null) {
                actualContent = this.getContentAsString(contentStream);
            }
        }
        if (actualContent.isEmpty()) {
            Utility.waitToLoopTime((int)2, (String[])new String[0]);
            Document retryDoc = this.getCmisDocument(this.cmisAPI.getLastResource());
            retryDoc.refresh();
            this.LOG.info(String.format("Retry get content stream for %s node: %s", retryDoc.getName(), retryDoc.getId()));
            contentStream = retryDoc.getContentStream();
            if (contentStream != null) {
                actualContent = this.getContentAsString(contentStream);
            }
        }
        return actualContent;
    }

    public String getUserNodeRef(UserModel user) {
        String objectId = "";
        ItemIterable results = this.cmisAPI.getSession().query("select cmis:objectId from cm:person where cm:userName = '" + user.getUsername() + "'", false);
        for (QueryResult qResult : results) {
            PropertyData propData = qResult.getPropertyById("cmis:objectId");
            objectId = (String)propData.getFirstValue();
        }
        return objectId;
    }
}

