/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis;

import org.alfresco.cmis.CmisTest;
import org.alfresco.cmis.CmisWrapper;
import org.alfresco.cmis.exception.InvalidCmisObjectException;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetContentStreamTests
extends CmisTest {
    SiteModel publicSite;
    SiteModel privateSite;
    UserModel siteManager;
    FileModel testFile;
    String content = "file content";
    private DataUser.ListUserWithRoles usersWithRoles;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.siteManager = this.dataUser.createRandomTestUser();
        this.publicSite = ((DataSite)this.dataSite.usingUser(this.siteManager)).createPublicRandomSite();
        this.privateSite = ((DataSite)this.dataSite.usingUser(this.siteManager)).createPrivateRandomSite();
        this.usersWithRoles = this.dataUser.addUsersWithRolesToSite(this.publicSite, new UserRole[]{UserRole.SiteManager, UserRole.SiteContributor, UserRole.SiteCollaborator, UserRole.SiteConsumer});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify site manager is able to get a document content in DocumentLibrary with CMIS")
    @Test(groups={"sanity", "cmis"})
    public void siteManagerShouldGetDocumentContent() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.testFile).then()).assertThat().existsInRepo().and()).assertThat().contentIs(this.content);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify site manager is able to get empty document content in DocumentLibrary with CMIS")
    @Test(groups={"regression", "cmis"})
    public void siteManagerShouldGetEmptyDocumentContent() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.testFile).then()).assertThat().existsInRepo().and()).assertThat().contentIs("");
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to get content from checked out document with CMIS")
    @Test(groups={"regression", "cmis"})
    public void siteManagerShouldGetContentFromCheckedOutDoc() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.testFile).and()).assertThat().existsInRepo().then()).checkOut().and()).assertThat().contentIs(this.content);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify admin is able to get document content with CMIS")
    @Test(groups={"regression", "cmis"})
    public void adminShouldGetContentOfFileCreatedByOtherUser() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        ((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.testFile).assertThat().existsInRepo().then()).authenticateUser(this.dataUser.getAdminUser()).usingResource((ContentModel)this.testFile).assertThat().contentIs(this.content);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to get content of file created by other user in DocumentLibrary with CMIS")
    @Test(groups={"regression", "cmis"})
    public void siteManagerShouldGetContentOfFileCreatedByOtherUser() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        ((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.testFile).assertThat().existsInRepo().then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).usingResource((ContentModel)this.testFile).assertThat().contentIs(this.content);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site collaborator is able to get content of file created by other user in DocumentLibrary with CMIS")
    @Test(groups={"regression", "cmis"})
    public void collaboratorShouldGetContentOfFileCreatedByOtherUser() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        ((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.testFile).assertThat().existsInRepo().then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingResource((ContentModel)this.testFile).assertThat().contentIs(this.content);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site collaborator is able to get content of file created by self in DocumentLibrary with CMIS")
    @Test(groups={"regression", "cmis"})
    public void collaboratorShouldGetContentOfFileCreatedBySelf() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        ((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingSite(this.publicSite).createFile(this.testFile).assertThat().existsInRepo().and()).assertThat().contentIs(this.content);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site contributor is able to get content of file created by other user in DocumentLibrary with CMIS")
    @Test(groups={"regression", "cmis"})
    public void contributorShouldGetContentOfFileCreatedByOtherUser() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        ((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.testFile).assertThat().existsInRepo().then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingResource((ContentModel)this.testFile).assertThat().contentIs(this.content);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site contributor is able to get content of file created by self in DocumentLibrary with CMIS")
    @Test(groups={"regression", "cmis"})
    public void contributorShouldGetContentOfFileCreatedBySelf() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        ((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingSite(this.publicSite).createFile(this.testFile).assertThat().existsInRepo().and()).assertThat().contentIs(this.content);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site consumer is able to get content of file created by other user in DocumentLibrary with CMIS")
    @Test(groups={"regression", "cmis"})
    public void consumerShouldGetContentOfFileCreatedByOtherUser() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        ((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.testFile).assertThat().existsInRepo().then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).usingResource((ContentModel)this.testFile).assertThat().contentIs(this.content);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to get content from checked out document with CMIS")
    @Test(groups={"regression", "cmis"})
    public void siteManagerShouldGetContentOfPWCDoc() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.testFile).and()).assertThat().existsInRepo().then()).checkOut().assertThat().documentIsCheckedOut().usingPWCDocument().assertThat().contentIs(this.content);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify unauthorized is not able to get content of file created in a private site with CMIS")
    @Test(groups={"sanity", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void unauthorizedUserShouldNotGetFileContent() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        ((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.privateSite).createFile(this.testFile).assertThat().existsInRepo().then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).usingResource((ContentModel)this.testFile).assertThat().contentIs(this.content);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify user is not able to get content of non existent file with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisObjectNotFoundException.class})
    public void userShouldNotGetContentOfNonexistentFile() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        this.testFile.setCmisLocation("/" + this.testFile.getName() + "/");
        this.cmisApi.authenticateUser(this.siteManager).usingResource((ContentModel)this.testFile).assertThat().contentIs(this.content);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify user is not able to get content of invalid file with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={InvalidCmisObjectException.class}, expectedExceptionsMessageRegExp="^Content at.*is not a file$")
    public void userShouldNotGetContentOfInvalidFile() throws Exception {
        FolderModel testFolder = FolderModel.getRandomFolderModel();
        ((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFolder(testFolder).assertThat().existsInRepo().and()).assertThat().contentIs(this.content);
    }
}

