/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis;

import org.alfresco.cmis.CmisTest;
import org.alfresco.cmis.CmisWrapper;
import org.alfresco.cmis.exception.InvalidCmisObjectException;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class IsLatestMajorVersionTests
extends CmisTest {
    UserModel managerUser;
    UserModel nonInviteUser;
    SiteModel testSite;
    FileModel minorVersionDoc;
    FileModel majorVersionDoc;
    private DataUser.ListUserWithRoles usersWithRoles;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.minorVersionDoc = FileModel.getRandomFileModel((FileType)FileType.XML, (String)this.documentContent);
        this.majorVersionDoc = FileModel.getRandomFileModel((FileType)FileType.XML, (String)this.documentContent);
        this.managerUser = this.dataUser.createRandomTestUser();
        this.nonInviteUser = this.dataUser.createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.managerUser)).createPublicRandomSite();
        this.usersWithRoles = ((DataUser)this.dataUser.usingUser(this.managerUser)).addUsersWithRolesToSite(this.testSite, new UserRole[]{UserRole.SiteContributor, UserRole.SiteCollaborator, UserRole.SiteConsumer});
        this.cmisApi.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.minorVersionDoc, VersioningState.MINOR).createFile(this.majorVersionDoc, VersioningState.MAJOR);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify is latest major version for document created with VersioningState set to major")
    @Test(groups={"sanity", "cmis"})
    public void verifyIsLatestMajorVersionForMajorState() throws Exception {
        ((CmisWrapper)this.cmisApi.authenticateUser(this.managerUser).usingResource((ContentModel)this.majorVersionDoc).and()).assertThat().isLatestMajorVersion();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify latest major version for folder")
    @Test(groups={"sanity", "cmis"}, expectedExceptions={InvalidCmisObjectException.class})
    public void verifyIsLatestMajorVersionOnFolders() throws Exception {
        FolderModel folderModel = FolderModel.getRandomFolderModel();
        ((CmisWrapper)this.cmisApi.authenticateUser(this.managerUser).usingSite(this.testSite).createFolder(folderModel).and()).assertThat().isLatestMajorVersion();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify is latest major version for document created with VersioningState set to minor")
    @Test(groups={"regression", "cmis"})
    public void verifyIsLatestMajorVersionForMinorState() throws Exception {
        ((CmisWrapper)this.cmisApi.authenticateUser(this.managerUser).usingResource((ContentModel)this.minorVersionDoc).and()).assertThat().isNotLatestMajorVersion();
    }

    @Bug(id="MNT-17961", status=Bug.Status.FIXED)
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify that major version doesn't change for document created with VersioningState set to none")
    @Test(groups={"regression", "cmis"})
    public void verifyMajorVersionNotChangedForNoneState() throws Exception {
        FileModel testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(testFile, VersioningState.NONE).and()).assertThat().existsInRepo().and()).assertThat().isLatestMajorVersion().and()).checkOut().and()).assertThat().documentIsCheckedOut().and()).prepareDocumentForCheckIn().withMinorVersion().checkIn().refreshResource().and()).assertThat().documentIsNotCheckedOut().then()).assertThat().documentHasVersion(1.0);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify is latest major version for document created with VersioningState set to checkedout")
    @Test(groups={"regression", "cmis"})
    public void verifyIsLatestMajorVersionForCheckedOutState() throws Exception {
        FileModel testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(testFile, VersioningState.CHECKEDOUT).usingPWCDocument().assertThat().existsInRepo().and()).assertThat().isNotLatestMajorVersion().and()).assertThat().documentIsCheckedOut();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify latest major version fails for document that was deleted")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisObjectNotFoundException.class})
    public void verifyIsLatestMajorVersionFailsOnDeletedDocument() throws Exception {
        FileModel testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(testFile).and()).assertThat().isLatestMajorVersion().and()).delete().then()).assertThat().isLatestMajorVersion();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify collaborator can verify is latest major version for document created by manager")
    @Test(groups={"regression", "cmis"})
    public void collaboratorCanVerifyIsLatestMajorVersion() throws Exception {
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingResource((ContentModel)this.majorVersionDoc).usingResource((ContentModel)this.majorVersionDoc).and()).assertThat().isLatestMajorVersion().then()).usingResource((ContentModel)this.minorVersionDoc).assertThat().isNotLatestMajorVersion();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify contributor can verify is latest major version for document created by manager")
    @Test(groups={"regression", "cmis"})
    public void contributorCanVerifyIsLatestMajorVersion() throws Exception {
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingResource((ContentModel)this.majorVersionDoc).usingResource((ContentModel)this.majorVersionDoc).and()).assertThat().isLatestMajorVersion().then()).usingResource((ContentModel)this.minorVersionDoc).assertThat().isNotLatestMajorVersion();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify consumer can verify is latest major version for document created by manager")
    @Test(groups={"regression", "cmis"})
    public void consumerCanVerifyIsLatestMajorVersion() throws Exception {
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).usingResource((ContentModel)this.majorVersionDoc).usingResource((ContentModel)this.majorVersionDoc).and()).assertThat().isLatestMajorVersion().then()).usingResource((ContentModel)this.minorVersionDoc).assertThat().isNotLatestMajorVersion();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify non invited user can verify is latest major version for document in public site")
    @Test(groups={"regression", "cmis"})
    public void nonInvitedUserCanVerifyIsLatestMajorVersionInPublicSite() throws Exception {
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.nonInviteUser).usingResource((ContentModel)this.majorVersionDoc).usingResource((ContentModel)this.majorVersionDoc).and()).assertThat().isLatestMajorVersion().then()).usingResource((ContentModel)this.minorVersionDoc).assertThat().isNotLatestMajorVersion();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify non invited user can verify is latest major version for document in private site")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void nonInvitedUserCannotVerifyIsLatestMajorVersionInPrivateSite() throws Exception {
        SiteModel privateSite = ((DataSite)this.dataSite.usingUser(this.managerUser)).createPrivateRandomSite();
        FileModel privateDoc = FileModel.getRandomFileModel((FileType)FileType.HTML, (String)this.documentContent);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.managerUser).usingSite(privateSite).createFile(privateDoc).then()).authenticateUser(this.nonInviteUser).usingResource((ContentModel)privateDoc).and()).assertThat().isLatestMajorVersion();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify non invited user can verify is latest major version for document in moderated site")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void nonInvitedUserCannotVerifyIsLatestMajorVersionInModeratedSite() throws Exception {
        SiteModel moderatedSite = ((DataSite)this.dataSite.usingUser(this.managerUser)).createPrivateRandomSite();
        FileModel moderatedDoc = FileModel.getRandomFileModel((FileType)FileType.HTML, (String)this.documentContent);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.managerUser).usingSite(moderatedSite).createFile(moderatedDoc).then()).authenticateUser(this.nonInviteUser).usingResource((ContentModel)moderatedDoc).and()).assertThat().isLatestMajorVersion();
    }
}

