/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.webdav;

import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.alfresco.webdav.WebDavTest;
import org.alfresco.webdav.WebDavWrapper;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetContentsFromParentFolderTests
extends WebDavTest {
    UserModel managerUser;
    SiteModel testSite;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.managerUser = this.dataUser.createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.managerUser)).createPublicRandomSite();
    }

    @Test(groups={"protocols", "webdav", "sanity"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that site manager can get contents from parent folder")
    public void siteManagerShouldGetContentsFromParent() throws Exception {
        FolderModel parentFolder = FolderModel.getRandomFolderModel();
        FolderModel subFolder1 = FolderModel.getRandomFolderModel();
        FolderModel subFolder2 = FolderModel.getRandomFolderModel();
        FolderModel subFolder3 = FolderModel.getRandomFolderModel();
        FileModel subFile1 = FileModel.getRandomFileModel((FileType)FileType.HTML);
        FileModel subFile2 = FileModel.getRandomFileModel((FileType)FileType.MSEXCEL);
        FileModel subFile3 = FileModel.getRandomFileModel((FileType)FileType.MSWORD);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFolder(parentFolder).then()).usingResource((ContentModel)parentFolder).createFolder(subFolder1).createFolder(subFolder2).createFile(subFile1).createFile(subFile2).then()).usingResource((ContentModel)subFolder1).createFolder(subFolder3).createFile(subFile3).when()).usingResource((ContentModel)parentFolder).assertThat().hasChildren(new ContentModel[]{subFolder1, subFolder2, subFile1, subFile2}).and()).assertThat().hasFolders(new FolderModel[]{subFolder1, subFolder2}).assertThat().hasFiles(new FileModel[]{subFile1, subFile2}).then()).usingResource((ContentModel)subFolder1).assertThat().hasChildren(new ContentModel[]{subFolder3, subFile3}).and()).assertThat().hasFolders(new FolderModel[]{subFolder3}).assertThat().hasFiles(new FileModel[]{subFile3}).then()).usingSite(this.testSite).assertThat().hasChildren(new ContentModel[]{parentFolder});
    }
}

