/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.webdav;

import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.alfresco.webdav.WebDavTest;
import org.alfresco.webdav.WebDavWrapper;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class UnlockFileTests
extends WebDavTest {
    UserModel managerUser;
    SiteModel testSite;
    FileModel testFile;
    private String content = "webdav file content";
    private DataUser.ListUserWithRoles usersWithRoles;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.managerUser = this.dataUser.createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.managerUser)).createPublicRandomSite();
        this.usersWithRoles = this.dataUser.addUsersWithRolesToSite(this.testSite, new UserRole[]{UserRole.SiteCollaborator, UserRole.SiteConsumer, UserRole.SiteContributor});
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that admin user can unlock a file created in Guest Home folder")
    @Test(groups={"protocols", "webdav", "sanity"})
    public void adminCanUnlockFile() throws Exception {
        FolderModel guestHomeFolder = FolderModel.getGuestHomeFolderModel();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.dataUser.getAdminUser()).usingResource((ContentModel)guestHomeFolder).createFile(this.testFile).then()).assertThat().existsInRepo()).then()).lock().assertThat().isLocked().and()).unlock().and()).assertThat().isUnlocked();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that site manager user can unlock a file")
    @Test(groups={"protocols", "webdav", "sanity"})
    public void siteManagerCanUnlockFile() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).then()).assertThat().existsInRepo()).then()).lock().assertThat().isLocked().and()).unlock().assertThat().hasStatus(HttpStatus.NO_CONTENT.value()).and()).assertThat().isUnlocked();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that site collaborator user cannot unlock a file locked by manager")
    @Test(groups={"protocols", "webdav", "sanity"})
    public void siteCollaboratorCannotUnlockFileLockedByManager() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).then()).assertThat().existsInRepo()).and()).lock().assertThat().isLocked().then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).and()).unlock().and()).assertThat().isLocked();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that site collaborator user can unlock a file locked by himself")
    @Test(groups={"protocols", "webdav", "sanity"})
    public void siteCollaboratorCanUnlockFileLockedByHimself() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).then()).assertThat().existsInRepo()).then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).and()).lock().assertThat().isLocked().and()).unlock().and()).assertThat().isUnlocked();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that site contributor user cannot unlock a file locked by manager")
    @Test(groups={"protocols", "webdav", "sanity"})
    public void siteContributorCannotUnlockFileLockedByManager() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).then()).assertThat().existsInRepo()).and()).lock().assertThat().isLocked().then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).unlock().and()).assertThat().isLocked();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that site contributor user cannot unlock a file created by himself")
    @Test(groups={"protocols", "webdav", "sanity"})
    public void siteContributorCanUnlockFileCreatedByHimself() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingSite(this.testSite).createFile(this.testFile).then()).assertThat().existsInRepo()).and()).lock().assertThat().isLocked().unlock().and()).assertThat().hasStatus(HttpStatus.NO_CONTENT.value()).and()).assertThat().isUnlocked();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that site consumer user cannot unlock a file locked by manager")
    @Test(groups={"protocols", "webdav", "sanity"})
    public void siteConsumerCannotUnlockFileLockedByManager() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).then()).assertThat().existsInRepo()).and()).lock().assertThat().isLocked().then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).unlock().and()).assertThat().isLocked();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that site manager user cannot unlock inexistent file")
    @Test(groups={"protocols", "webdav", "core"})
    public void siteManagerCannotUnlockInexistentFile() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        this.webDavProtocol.authenticateUser(this.managerUser).usingResource((ContentModel)FileModel.getRandomFileModel((FileType)FileType.MSEXCEL2007)).unlock().assertThat().hasStatus(HttpStatus.BAD_REQUEST.value());
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that inexistent user cannot unlock a file")
    @Test(groups={"protocols", "webdav", "core"})
    public void inexistentUserCannotUnlockFile() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).then()).assertThat().existsInRepo()).and()).lock().assertThat().isLocked().then()).authenticateUser(UserModel.getRandomUserModel()).unlock().and()).assertThat().hasStatus(HttpStatus.UNAUTHORIZED.value()).and()).authenticateUser(this.managerUser).assertThat().isLocked();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that disconected user cannot unlock a file")
    @Test(groups={"protocols", "webdav", "core"})
    public void disconectedUserCannotUnlockFile() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).then()).assertThat().existsInRepo()).and()).lock().assertThat().isLocked().then()).disconnect().unlock().and()).assertThat().hasStatus(HttpStatus.UNAUTHORIZED.value()).and()).authenticateUser(this.managerUser).assertThat().isLocked();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that unauthorized user cannot unlock a file")
    @Test(groups={"protocols", "webdav", "core"})
    public void unauthorizedUserCannotUnlockFile() throws Exception {
        UserModel unauthorized = this.dataUser.createRandomTestUser();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).then()).assertThat().existsInRepo()).and()).lock().assertThat().isLocked().then()).authenticateUser(unauthorized).unlock().and()).assertThat().hasStatus(HttpStatus.PRECONDITION_FAILED.value()).and()).assertThat().isLocked();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that site manager cannot unlock a file that is not locked")
    @Test(groups={"protocols", "webdav", "core"})
    public void unlockFileThatIsNotLocked() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).then()).assertThat().existsInRepo()).unlock().and()).assertThat().hasStatus(HttpStatus.BAD_REQUEST.value()).and()).assertThat().isUnlocked();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that site manager cannot unlock a folder")
    @Test(groups={"protocols", "webdav", "core"})
    public void siteManagerCanUnlockFolder() throws Exception {
        FolderModel testFolder = FolderModel.getRandomFolderModel();
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFolder(testFolder).then()).assertThat().existsInRepo()).lock().assertThat().isLocked().then()).unlock().and()).assertThat().hasStatus(HttpStatus.NO_CONTENT.value()).and()).assertThat().isUnlocked();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Checks no existent file is not locked (and status 404)")
    @Test(groups={"protocols", "webdav", "sanity"})
    public void checkLockStatusForNonExistentFile() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        this.webDavProtocol.authenticateUser(this.dataUser.getAdminUser()).usingResource((ContentModel)this.testFile).assertThat().isUnlocked().assertThat().hasStatus(HttpStatus.NOT_FOUND.value());
    }
}

