/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.webdav;

import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.alfresco.webdav.WebDavTest;
import org.apache.jackrabbit.webdav.DavException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class WebDavRootTests
extends WebDavTest {
    UserModel testUser;
    FolderModel testFolder;
    FileModel testFile;
    FolderModel shared = new FolderModel("Shared");
    FolderModel imapAttachments = new FolderModel("Imap Attachments");
    FolderModel guest = new FolderModel("Guest Home");
    FolderModel userHome = new FolderModel("User Homes");
    FolderModel sites = new FolderModel("Sites");
    FolderModel dataDictionary = new FolderModel("Data Dictionary");
    FolderModel imapHome = new FolderModel("IMAP Home");

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.testUser = this.dataUser.createRandomTestUser();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify if valid user can get webdav root folders")
    @Test(groups={"protocols", "webdav", "sanity"})
    public void siteManagerShouldGetRootFolders() throws Exception {
        UserModel testUser = this.dataUser.createRandomTestUser();
        this.webDavProtocol.authenticateUser(testUser).usingRoot().assertThat().hasFolders(new FolderModel[]{this.shared, this.imapAttachments, this.guest, this.userHome, this.dataDictionary, this.imapHome});
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify if admin user can get webdav root folders")
    @Test(groups={"protocols", "webdav", "sanity"})
    public void adminShouldGetRootFolders() throws Exception {
        this.webDavProtocol.authenticateUser(this.dataUser.getAdminUser()).usingRoot().assertThat().hasFolders(new FolderModel[]{this.shared, this.imapAttachments, this.guest, this.userHome, this.dataDictionary, this.imapHome});
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that inexistent user cannot get webdav root folders")
    @Test(groups={"protocols", "webdav", "core"}, expectedExceptions={DavException.class})
    public void inexistentUserShouldNotGetRootFolders() throws Exception {
        this.webDavProtocol.authenticateUser(UserModel.getRandomUserModel()).usingRoot().assertThat().hasFolders(new FolderModel[]{this.shared, this.imapAttachments, this.guest, this.userHome, this.dataDictionary, this.imapHome});
    }
}

