/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.webdav;

import java.io.FileNotFoundException;
import java.nio.file.FileAlreadyExistsException;
import org.alfresco.dataprep.CMISUtil;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.alfresco.webdav.WebDavTest;
import org.alfresco.webdav.WebDavWrapper;
import org.apache.commons.lang3.SystemUtils;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class NetworkDriveTests
extends WebDavTest {
    UserModel siteManager;
    SiteModel testSite;
    FolderModel folderModel;
    FileModel fileModel;
    String fileContent = "webdav file content";

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        if (SystemUtils.IS_OS_WINDOWS) {
            this.webDavProtocol.unmountNetworkDrive();
        }
        this.siteManager = this.dataUser.getAdminUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.siteManager)).createPublicRandomSite();
    }

    @Test(groups={"protocols", "webdav", "full", "windows"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify admin can create folder in Alfresco root folder on mapped drive")
    public void adminCanCreateFolderInRootOnMappedDrive() throws Exception {
        this.folderModel = FolderModel.getRandomFolderModel();
        ((WebDavWrapper)this.webDavProtocol.authenticateUser(this.dataUser.getAdminUser()).usingNetworkDrive().usingRoot().createFolder(this.folderModel).then()).assertThat().existsInWebdav().assertThat().existsInRepo();
    }

    @Test(groups={"protocols", "webdav", "full", "windows"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify site manager can create folder on mapped drive")
    public void siteManagerCanCreateFolderOnMappedDrive() throws Exception {
        this.folderModel = FolderModel.getRandomFolderModel();
        ((WebDavWrapper)this.webDavProtocol.authenticateUser(this.siteManager).usingNetworkDrive().usingSite(this.testSite).createFolder(this.folderModel).then()).assertThat().existsInWebdav().assertThat().existsInRepo();
    }

    @Test(groups={"protocols", "webdav", "full", "windows"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager can create folder with name that contains spaces on mapped drive")
    public void siteManagerCanCreateFolderWithSpacesInNameOnMappedDrive() throws Exception {
        this.folderModel = new FolderModel("folder with name that contains spaces");
        ((WebDavWrapper)this.webDavProtocol.authenticateUser(this.siteManager).usingNetworkDrive().usingSite(this.testSite).createFolder(this.folderModel).then()).assertThat().existsInWebdav().assertThat().existsInRepo();
    }

    @Test(groups={"protocols", "webdav", "full", "windows"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager can create folder with name that contains special characters on mapped drive")
    public void siteManagerCanCreateFolderWithSpecialCharactersInNameOnMappedDrive() throws Exception {
        this.folderModel = new FolderModel("!$(){}[]_folder");
        ((WebDavWrapper)this.webDavProtocol.authenticateUser(this.siteManager).usingNetworkDrive().usingSite(this.testSite).createFolder(this.folderModel).then()).assertThat().existsInWebdav().assertThat().existsInRepo();
    }

    @Test(groups={"protocols", "webdav", "full", "windows"}, expectedExceptions={FileAlreadyExistsException.class})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager cannot create folder twice on mapped drive")
    public void siteManagerCannotCreateFolderTwiceOnMappedDrive() throws Exception {
        this.folderModel = FolderModel.getRandomFolderModel();
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.siteManager).usingNetworkDrive().usingSite(this.testSite).createFolder(this.folderModel).then()).assertThat().existsInWebdav().assertThat().existsInRepo()).and()).usingSite(this.testSite).createFolder(this.folderModel);
    }

    @Test(groups={"protocols", "webdav", "full", "windows"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify site manager can create folder inside another folder on mapped drive")
    public void siteManagerCanCreateFolderInFolderOnMappedDrive() throws Exception {
        FolderModel parentFolder = ((DataContent)this.dataContent.usingUser(this.siteManager).usingSite(this.testSite)).createFolder();
        this.folderModel = FolderModel.getRandomFolderModel();
        ((WebDavWrapper)this.webDavProtocol.authenticateUser(this.siteManager).usingNetworkDrive().usingResource((ContentModel)parentFolder).createFolder(this.folderModel).then()).assertThat().existsInWebdav().assertThat().existsInRepo();
    }

    @Test(groups={"protocols", "webdav", "full", "windows"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify site manager can create folder with name prefixed by dot on mapped drive")
    public void siteManagerCanCreateFolderWithNamePrefixedByDotOnMappedDrive() throws Exception {
        this.folderModel = new FolderModel("." + RandomData.getRandomName((String)"folder"));
        ((WebDavWrapper)this.webDavProtocol.authenticateUser(this.siteManager).usingNetworkDrive().usingSite(this.testSite).createFolder(this.folderModel).then()).assertThat().existsInWebdav().assertThat().existsInRepo();
    }

    @Test(groups={"protocols", "webdav", "full", "windows"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify site manager can create file on mapped drive")
    public void siteManagerCanCreateFileOnMappedDrive() throws Exception {
        this.fileModel = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.siteManager).usingNetworkDrive().usingSite(this.testSite).createFile(this.fileModel).then()).assertThat().existsInWebdav().assertThat().existsInRepo()).assertThat().contentIs("");
    }

    @Test(groups={"protocols", "webdav", "full", "windows"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify site manager can create file with content on mapped drive")
    public void siteManagerCanCreateFileWithContentOnMappedDrive() throws Exception {
        this.fileModel = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.fileContent);
        ((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.siteManager).usingNetworkDrive().usingSite(this.testSite).createFile(this.fileModel).then()).assertThat().existsInWebdav().assertThat().existsInRepo()).assertThat().contentIs(this.fileContent);
    }

    @Test(groups={"protocols", "webdav", "full", "windows"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify site manager can delete file on mapped drive")
    public void siteManagerCanDeleteFileOnMappedDrive() throws Exception {
        this.fileModel = ((DataContent)this.dataContent.usingUser(this.siteManager).usingSite(this.testSite)).createContent(FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN));
        ((WebDavWrapper)this.webDavProtocol.authenticateUser(this.siteManager).usingNetworkDrive().usingResource((ContentModel)this.fileModel).delete().then()).assertThat().doesNotExistInWebdav().assertThat().doesNotExistInRepo();
    }

    @Test(groups={"protocols", "webdav", "full", "windows"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify site manager can delete folder on mapped drive")
    public void siteManagerCanDeleteFolderOnMappedDrive() throws Exception {
        this.folderModel = ((DataContent)this.dataContent.usingUser(this.siteManager).usingSite(this.testSite)).createFolder();
        ((WebDavWrapper)this.webDavProtocol.authenticateUser(this.siteManager).usingNetworkDrive().usingResource((ContentModel)this.folderModel).delete().then()).assertThat().doesNotExistInWebdav().assertThat().doesNotExistInRepo();
    }

    @Test(groups={"protocols", "webdav", "full", "windows"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify site manager can rename file on mapped drive")
    public void siteManagerCanRenameFileOnMappedDrive() throws Exception {
        this.fileModel = ((DataContent)this.dataContent.usingUser(this.siteManager).usingSite(this.testSite)).createContent(FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN));
        FileModel originalFileModel = new FileModel(this.fileModel);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.siteManager).usingNetworkDrive().usingResource((ContentModel)this.fileModel).rename("renamedFile").and()).assertThat().existsInWebdav().assertThat().existsInRepo()).then()).usingResource((ContentModel)originalFileModel).assertThat().doesNotExistInWebdav().assertThat().doesNotExistInRepo();
    }

    @Test(groups={"protocols", "webdav", "full", "windows"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify site manager can rename folder on mapped drive")
    public void siteManagerCanRenameFolderOnMappedDrive() throws Exception {
        this.folderModel = ((DataContent)this.dataContent.usingUser(this.siteManager).usingSite(this.testSite)).createFolder();
        FolderModel originalFolderModel = new FolderModel(this.folderModel);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.siteManager).usingNetworkDrive().usingResource((ContentModel)this.folderModel).rename("renamedFolder").and()).assertThat().existsInWebdav().assertThat().existsInRepo()).then()).usingResource((ContentModel)originalFolderModel).assertThat().doesNotExistInWebdav().assertThat().doesNotExistInRepo();
    }

    @Test(groups={"protocols", "webdav", "full", "windows"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify site manager can copy file on mapped drive")
    public void siteManagerCanCopyFileOnMappedDrive() throws Exception {
        this.fileModel = ((DataContent)this.dataContent.usingUser(this.siteManager).usingSite(this.testSite)).createContent(FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN));
        FileModel copiedFile = new FileModel("copiedFile.txt");
        copiedFile.setCmisLocation(this.fileModel.getCmisLocation().replace(this.fileModel.getName(), copiedFile.getName()));
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.siteManager).usingNetworkDrive().usingResource((ContentModel)this.fileModel).copyTo((ContentModel)copiedFile).and()).assertThat().existsInWebdav().assertThat().existsInRepo()).then()).usingResource((ContentModel)this.fileModel).assertThat().existsInWebdav().assertThat().existsInRepo();
    }

    @Test(groups={"protocols", "webdav", "full", "windows"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify site manager can copy folder on mapped drive")
    public void siteManagerCanCopyFolderOnMappedDrive() throws Exception {
        this.folderModel = ((DataContent)this.dataContent.usingUser(this.siteManager).usingSite(this.testSite)).createFolder();
        this.fileModel = ((DataContent)((DataContent)this.dataContent.usingUser(this.siteManager).usingSite(this.testSite)).usingResource((ContentModel)this.folderModel)).createContent(FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN));
        FolderModel copiedFolder = new FolderModel("copiedFolder");
        copiedFolder.setCmisLocation(this.folderModel.getCmisLocation().replace(this.folderModel.getName(), copiedFolder.getName()));
        ((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.siteManager).usingNetworkDrive().usingSite(this.testSite).assertThat().hasFolders(new FolderModel[]{this.folderModel}).usingResource((ContentModel)this.folderModel).copyTo((ContentModel)copiedFolder).assertThat().existsInWebdav().assertThat().existsInRepo()).assertThat().hasChildren(new ContentModel[]{this.fileModel}).assertThat().hasFiles(new FileModel[]{this.fileModel}).then()).usingResource((ContentModel)this.folderModel).assertThat().existsInWebdav().assertThat().existsInRepo();
    }

    @Test(groups={"protocols", "webdav", "full", "windows"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify site manager can move file on mapped drive")
    public void siteManagerCanMoveFileOnMappedDrive() throws Exception {
        this.fileModel = ((DataContent)this.dataContent.usingUser(this.siteManager).usingSite(this.testSite)).createContent(FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN));
        FileModel movedFile = new FileModel("movedFile");
        movedFile.setCmisLocation(this.fileModel.getCmisLocation().replace(this.fileModel.getName(), movedFile.getName()));
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.siteManager).usingNetworkDrive().usingResource((ContentModel)this.fileModel).moveTo((ContentModel)movedFile).and()).assertThat().existsInWebdav().assertThat().existsInRepo()).then()).usingResource((ContentModel)this.fileModel).assertThat().doesNotExistInWebdav().assertThat().doesNotExistInRepo();
    }

    @Test(groups={"protocols", "webdav", "full", "windows"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify site manager can move folder on mapped drive")
    public void siteManagerCanMoveFolderOnMappedDrive() throws Exception {
        this.folderModel = ((DataContent)this.dataContent.usingUser(this.siteManager).usingSite(this.testSite)).createFolder();
        this.fileModel = ((DataContent)((DataContent)this.dataContent.usingUser(this.siteManager).usingSite(this.testSite)).usingResource((ContentModel)this.folderModel)).createContent(FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN));
        FolderModel moveFolder = ((DataContent)this.dataContent.usingUser(this.siteManager).usingSite(this.testSite)).createFolder();
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.siteManager).usingNetworkDrive().usingSite(this.testSite).assertThat().hasFolders(new FolderModel[]{this.folderModel}).usingResource((ContentModel)this.folderModel).moveTo((ContentModel)moveFolder).assertThat().existsInWebdav().assertThat().existsInRepo()).assertThat().hasChildren(new ContentModel[]{this.fileModel}).assertThat().hasFiles(new FileModel[]{this.fileModel}).then()).usingSite(this.testSite).usingResource((ContentModel)this.folderModel).assertThat().doesNotExistInWebdav().assertThat().doesNotExistInRepo()).and()).usingSite(this.testSite).usingResource((ContentModel)this.folderModel).usingResource((ContentModel)this.fileModel).assertThat().doesNotExistInWebdav().assertThat().doesNotExistInRepo();
    }

    @Test(groups={"protocols", "webdav", "full", "windows"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify site manager can update file content on mapped drive")
    public void siteManagerCanUpdateFileContentOnMappedDrive() throws Exception {
        this.fileModel = ((DataContent)this.dataContent.usingUser(this.siteManager).usingSite(this.testSite)).createContent(FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN));
        ((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.siteManager).usingNetworkDrive().usingResource((ContentModel)this.fileModel).assertThat().contentIs("").and()).update("updated content").then()).assertThat().contentIs("updated content");
    }

    @Test(groups={"protocols", "webdav", "full", "windows"}, expectedExceptions={FileNotFoundException.class})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify site manager cannot update content for a deleted file on mapped drive")
    public void siteManagerCannotUpdateFileContentForADeletedFileOnMappedDrive() throws Exception {
        this.fileModel = ((DataContent)this.dataContent.usingUser(this.siteManager).usingSite(this.testSite)).createContent(FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN));
        ((WebDavWrapper)this.webDavProtocol.authenticateUser(this.siteManager).usingNetworkDrive().usingResource((ContentModel)this.fileModel).delete().then()).update("updated content");
    }

    @Test(groups={"protocols", "webdav", "full", "windows"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that file version is incremented after file is edited on mapped drive")
    public void verifyFileVersionIsIncrementedAfterEditOnMappedDrive() throws Exception {
        this.fileModel = ((DataContent)this.dataContent.usingUser(this.siteManager).usingSite(this.testSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.webDavProtocol.authenticateUser(this.siteManager).usingNetworkDrive().usingResource((ContentModel)this.fileModel).update("new content");
        ((DataContent)this.dataContent.usingResource((ContentModel)this.fileModel)).assertContentVersionIs("1.1");
    }
}

