/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.webdav;

import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.alfresco.webdav.WebDavTest;
import org.alfresco.webdav.WebDavWrapper;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class DeleteFolderTests
extends WebDavTest {
    UserModel managerUser;
    SiteModel testSite;
    FolderModel testFolder;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.managerUser = this.dataUser.createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.managerUser)).createPublicRandomSite();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that admin user can delete folder from repository")
    @Test(groups={"protocols", "webdav", "sanity"})
    public void adminShouldDeleteFolder() throws Exception {
        FolderModel guest = FolderModel.getGuestHomeFolderModel();
        this.testFolder = FolderModel.getRandomFolderModel();
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.dataUser.getAdminUser()).usingResource((ContentModel)guest).createFolder(this.testFolder).then()).delete().and()).assertThat().hasStatus(200).and()).assertThat().doesNotExistInRepo()).assertThat().doesNotExistInWebdav().and()).assertThat().hasStatus(404);
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that site manager can delete folder from site")
    @Test(groups={"protocols", "webdav", "sanity"})
    public void siteManagerShouldDeleteFolder() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFolder(this.testFolder).then()).delete().assertThat().hasStatus(200).and()).assertThat().doesNotExistInRepo()).and()).assertThat().doesNotExistInWebdav().and()).assertThat().hasStatus(404);
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that site collaborator cannot delete folder from site")
    @Test(groups={"protocols", "webdav", "sanity"})
    public void siteCollaboratorShouldNotDeleteFolder() throws Exception {
        UserModel collaborator = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.managerUser)).addUserToSite(collaborator, this.testSite, UserRole.SiteCollaborator);
        this.testFolder = FolderModel.getRandomFolderModel();
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFolder(this.testFolder).then()).authenticateUser(collaborator).usingResource((ContentModel)this.testFolder).delete().and()).assertThat().hasStatus(403).and()).assertThat().existsInRepo()).and()).assertThat().existsInWebdav().assertThat().hasStatus(200);
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that site contributor cannot delete folder from site")
    @Test(groups={"protocols", "webdav", "sanity"})
    public void siteContributorShouldNotDeleteFolder() throws Exception {
        UserModel contributor = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.managerUser)).addUserToSite(contributor, this.testSite, UserRole.SiteContributor);
        this.testFolder = FolderModel.getRandomFolderModel();
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFolder(this.testFolder).then()).authenticateUser(contributor).usingResource((ContentModel)this.testFolder).delete().and()).assertThat().hasStatus(403).and()).assertThat().existsInRepo()).and()).assertThat().existsInWebdav().assertThat().hasStatus(200);
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that site consumer cannot delete folder from site")
    @Test(groups={"protocols", "webdav", "sanity"})
    public void siteConsumerShouldNotDeleteFolder() throws Exception {
        UserModel consumer = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.managerUser)).addUserToSite(consumer, this.testSite, UserRole.SiteConsumer);
        this.testFolder = FolderModel.getRandomFolderModel();
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFolder(this.testFolder).then()).authenticateUser(consumer).usingResource((ContentModel)this.testFolder).delete().and()).assertThat().hasStatus(403).and()).assertThat().existsInRepo()).and()).assertThat().existsInWebdav().assertThat().hasStatus(200);
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that site manager cannot delete a folder twice from site")
    @Test(groups={"protocols", "webdav", "sanity"})
    public void siteManagerShouldNotDeleteAFolderTwice() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFolder(this.testFolder).delete().and()).assertThat().doesNotExistInRepo()).when()).delete().assertThat().hasStatus(404);
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that site manager cannot delete inexistent folder")
    @Test(groups={"protocols", "webdav", "sanity"})
    public void siteManagerShouldNotDeleteInexistentFolder() throws Exception {
        this.webDavProtocol.authenticateUser(this.managerUser).usingResource((ContentModel)FolderModel.getRandomFolderModel()).delete().assertThat().hasStatus(404);
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that a disconected user cannot delete folder from site")
    @Test(groups={"protocols", "webdav", "core"})
    public void disconectedUserShouldNotDeleteFolder() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFolder(this.testFolder).and()).disconnect().then()).delete().assertThat().hasStatus(401).then()).authenticateUser(this.managerUser).usingResource((ContentModel)this.testFolder).assertThat().existsInRepo()).and()).assertThat().existsInWebdav();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that a unauthorized user cannot delete folder from site")
    @Test(groups={"protocols", "webdav", "core"})
    public void unauthorizedUserShouldNotDeleteFolder() throws Exception {
        UserModel unauthorized = this.dataUser.createRandomTestUser();
        this.testFolder = FolderModel.getRandomFolderModel();
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFolder(this.testFolder).and()).assertThat().existsInRepo()).then()).authenticateUser(unauthorized).and()).delete().assertThat().hasStatus(403).assertThat().existsInRepo()).and()).assertThat().existsInWebdav();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that a inexistent user cannot delete folder")
    @Test(groups={"protocols", "webdav", "core"})
    public void inexistentUserShouldNotDeleteFolder() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFolder(this.testFolder).and()).assertThat().existsInRepo()).then()).authenticateUser(UserModel.getRandomUserModel()).and()).delete().assertThat().hasStatus(401).then()).authenticateUser(this.managerUser).assertThat().existsInRepo()).and()).assertThat().existsInWebdav();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that site manager can delete folder with children")
    @Test(groups={"protocols", "webdav", "core"})
    public void siteManagerShouldDeleteFolderWithChildren() throws Exception {
        FileModel subFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD2007);
        FolderModel subFolder = FolderModel.getRandomFolderModel();
        this.testFolder = FolderModel.getRandomFolderModel();
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFolder(this.testFolder).usingResource((ContentModel)this.testFolder).createFile(subFile).createFolder(subFolder).usingResource((ContentModel)this.testFolder).delete().assertThat().hasStatus(200).and()).assertThat().doesNotExistInRepo()).and()).assertThat().doesNotExistInWebdav().and()).assertThat().hasStatus(404).usingResource((ContentModel)subFile).assertThat().doesNotExistInRepo()).usingResource((ContentModel)subFolder).assertThat().doesNotExistInRepo();
    }
}

