/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.webdav;

import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.alfresco.webdav.WebDavTest;
import org.alfresco.webdav.WebDavWrapper;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class MoveTests
extends WebDavTest {
    UserModel managerUser;
    SiteModel testSite;
    FolderModel sourceFolder;
    FolderModel destinationFolder;
    FileModel testFile;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.managerUser = this.dataUser.createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.managerUser)).createPublicRandomSite();
        this.destinationFolder = FolderModel.getRandomFolderModel();
        this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFolder(this.destinationFolder);
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that admin user can move folder")
    @Test(groups={"protocols", "webdav", "sanity"})
    public void adminShouldMoveFolder() throws Exception {
        FolderModel guest = FolderModel.getGuestHomeFolderModel();
        this.sourceFolder = new FolderModel("move " + RandomData.getRandomFolder());
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.dataUser.getAdminUser()).usingRoot().createFolder(this.sourceFolder).and()).assertThat().existsInRepo()).then()).moveTo((ContentModel)guest).and()).assertThat().existsInRepo()).and()).assertThat().hasStatus(201).when()).usingResource((ContentModel)this.sourceFolder).assertThat().doesNotExistInRepo();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that site manager can move folder with content in site")
    @Test(groups={"protocols", "webdav", "sanity"})
    public void siteManagerShouldMoveFolder() throws Exception {
        this.sourceFolder = FolderModel.getRandomFolderModel();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSEXCEL);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFolder(this.sourceFolder).then()).usingResource((ContentModel)this.sourceFolder).createFile(this.testFile).and()).assertThat().existsInRepo()).when()).usingResource((ContentModel)this.sourceFolder).moveTo((ContentModel)this.destinationFolder).and()).assertThat().existsInRepo()).and()).assertThat().hasStatus(201).then()).usingResource((ContentModel)this.sourceFolder).assertThat().doesNotExistInRepo()).and()).usingResource((ContentModel)this.testFile).assertThat().doesNotExistInRepo();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that user with contributor role cannot move folder with content in site folder")
    @Test(groups={"protocols", "webdav", "sanity"})
    public void siteContributorShouldNotMoveFolder() throws Exception {
        this.sourceFolder = FolderModel.getRandomFolderModel();
        UserModel contributor = this.dataUser.createRandomTestUser();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSEXCEL);
        ((DataUser)this.dataUser.usingUser(this.managerUser)).addUserToSite(contributor, this.testSite, UserRole.SiteContributor);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFolder(this.sourceFolder).and()).usingResource((ContentModel)this.sourceFolder).createFile(this.testFile).then()).authenticateUser(contributor).usingResource((ContentModel)this.sourceFolder).moveTo((ContentModel)this.destinationFolder).and()).assertThat().doesNotExistInRepo()).and()).assertThat().hasStatus(403).when()).usingResource((ContentModel)this.sourceFolder).assertThat().existsInRepo()).and()).usingResource((ContentModel)this.testFile).assertThat().existsInRepo();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that user with collaborator role cannot move folder with content in site folder")
    @Test(groups={"protocols", "webdav", "sanity"})
    public void siteCollaboratorShouldNotMoveFolder() throws Exception {
        this.sourceFolder = FolderModel.getRandomFolderModel();
        UserModel collaborator = this.dataUser.createRandomTestUser();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSEXCEL);
        ((DataUser)this.dataUser.usingUser(this.managerUser)).addUserToSite(collaborator, this.testSite, UserRole.SiteCollaborator);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFolder(this.sourceFolder).and()).usingResource((ContentModel)this.sourceFolder).createFile(this.testFile).then()).authenticateUser(collaborator).usingResource((ContentModel)this.sourceFolder).moveTo((ContentModel)this.destinationFolder).and()).assertThat().doesNotExistInRepo()).and()).assertThat().hasStatus(403).when()).usingResource((ContentModel)this.sourceFolder).assertThat().existsInRepo()).and()).usingResource((ContentModel)this.testFile).assertThat().existsInRepo();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that user with consumer role cannot move folder with content in site folder")
    @Test(groups={"protocols", "webdav", "sanity"})
    public void siteConsumerShouldNotMoveFolder() throws Exception {
        this.sourceFolder = FolderModel.getRandomFolderModel();
        UserModel consumer = this.dataUser.createRandomTestUser();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSEXCEL);
        ((DataUser)this.dataUser.usingUser(this.managerUser)).addUserToSite(consumer, this.testSite, UserRole.SiteConsumer);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFolder(this.sourceFolder).and()).usingResource((ContentModel)this.sourceFolder).createFile(this.testFile).then()).authenticateUser(consumer).usingResource((ContentModel)this.sourceFolder).moveTo((ContentModel)this.destinationFolder).and()).assertThat().doesNotExistInRepo()).and()).assertThat().hasStatus(403).when()).usingResource((ContentModel)this.sourceFolder).assertThat().existsInRepo()).and()).usingResource((ContentModel)this.testFile).assertThat().existsInRepo();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that site manager can move file from site in repository")
    @Test(groups={"protocols", "webdav", "sanity"})
    public void siteManagerShouldMoveFileInRepository() throws Exception {
        FolderModel guest = FolderModel.getSharedFolderModel();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSEXCEL);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).moveTo((ContentModel)guest).assertThat().existsInRepo()).and()).assertThat().hasStatus(201).then()).usingResource((ContentModel)this.testFile).assertThat().doesNotExistInRepo();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that disconected user cannot move folder")
    @Test(groups={"protocols", "webdav", "core"})
    public void disconnectedUserShouldNotMoveFolder() throws Exception {
        this.sourceFolder = FolderModel.getRandomFolderModel();
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFolder(this.sourceFolder).then()).disconnect().and()).moveTo((ContentModel)this.destinationFolder).and()).assertThat().hasStatus(401).then()).authenticateUser(this.managerUser).usingResource((ContentModel)this.sourceFolder).assertThat().existsInRepo()).assertThat().existsInWebdav();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that disconected user cannot move file")
    @Test(groups={"protocols", "webdav", "core"})
    public void disconnectedUserShouldNotMoveFile() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSEXCEL);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).then()).disconnect().and()).moveTo((ContentModel)this.destinationFolder).and()).assertThat().hasStatus(401).then()).authenticateUser(this.managerUser).usingResource((ContentModel)this.testFile).assertThat().existsInRepo()).assertThat().existsInWebdav();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that unauthorized user cannot move file or folder")
    @Test(groups={"protocols", "webdav", "core"})
    public void unauthorizedUserShouldNotMoveContent() throws Exception {
        UserModel unauthorized = this.dataUser.createRandomTestUser();
        this.sourceFolder = FolderModel.getRandomFolderModel();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSEXCEL);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).createFolder(this.sourceFolder).then()).authenticateUser(unauthorized).usingResource((ContentModel)this.testFile).moveTo((ContentModel)this.destinationFolder).and()).assertThat().hasStatus(403).usingResource((ContentModel)this.sourceFolder).moveTo((ContentModel)this.destinationFolder).and()).assertThat().hasStatus(403).usingResource((ContentModel)this.testFile).assertThat().existsInRepo()).assertThat().existsInWebdav().usingResource((ContentModel)this.sourceFolder).assertThat().existsInRepo()).assertThat().existsInWebdav();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that inexistent user cannot move file or folder")
    @Test(groups={"protocols", "webdav", "core"})
    public void inexistentUserShouldNotMoveContent() throws Exception {
        this.sourceFolder = FolderModel.getRandomFolderModel();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSEXCEL);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).createFolder(this.sourceFolder).then()).authenticateUser(UserModel.getRandomUserModel()).usingResource((ContentModel)this.testFile).moveTo((ContentModel)this.destinationFolder).and()).assertThat().hasStatus(401).usingResource((ContentModel)this.sourceFolder).moveTo((ContentModel)this.destinationFolder).and()).assertThat().hasStatus(401).authenticateUser(this.managerUser).usingResource((ContentModel)this.testFile).assertThat().existsInRepo()).assertThat().existsInWebdav().usingResource((ContentModel)this.sourceFolder).assertThat().existsInRepo()).assertThat().existsInWebdav();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that site manager cannot move locked file")
    @Test(groups={"protocols", "webdav", "core"})
    public void siteManagerShouldNotMoveLockedFolder() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSEXCEL);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo()).then()).lock().assertThat().isLocked().when()).usingResource((ContentModel)this.testFile).moveTo((ContentModel)this.destinationFolder).and()).assertThat().doesNotExistInRepo()).and()).assertThat().hasStatus(423).and()).usingResource((ContentModel)this.testFile).assertThat().existsInRepo()).assertThat().existsInWebdav().and()).assertThat().isLocked();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify the response code for a conflict when a file is moved in a folder that already has a file with the same name")
    @Test(groups={"protocols", "webdav", "core"})
    public void conflictWhileMovingFile() throws Exception {
        this.sourceFolder = FolderModel.getRandomFolderModel();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        FileModel testFileSource = new FileModel(this.testFile);
        FileModel testFileDestination = new FileModel(this.testFile);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.dataUser.getAdminUser()).usingSite(this.testSite).createFolder(this.sourceFolder).assertThat().existsInRepo()).then()).usingResource((ContentModel)this.sourceFolder).createFile(testFileSource).assertThat().existsInRepo()).then()).usingResource((ContentModel)this.destinationFolder).createFile(testFileDestination).assertThat().existsInRepo()).when()).usingResource((ContentModel)testFileSource).doNotOverwriteIfExists().moveTo((ContentModel)this.destinationFolder).and()).assertThat().hasStatus(412);
    }
}

