/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.processes;

import java.util.List;
import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestProcessModel;
import org.alfresco.rest.model.RestProcessModelsCollection;
import org.alfresco.rest.requests.workflowAPI.RestWorkflowAPI;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataWorkflow;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.ProcessModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.TaskModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetProcessesFullTests
extends RestTest {
    private FileModel document;
    private SiteModel siteModel;
    private UserModel adminUser;
    private UserModel userWhoStartsTask;
    private UserModel assignee;
    private TaskModel task1;
    private TaskModel task2;
    private ProcessModel process3;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.userWhoStartsTask = this.dataUser.createRandomTestUser();
        this.assignee = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.userWhoStartsTask)).createPublicRandomSite();
        this.document = ((DataContent)this.dataContent.usingUser(this.userWhoStartsTask).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.task1 = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.document)).createNewTaskAndAssignTo(this.assignee);
        this.task2 = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.document)).createNewTaskAndAssignTo(this.adminUser);
        this.process3 = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.document)).createSingleReviewerTaskAndAssignTo(this.assignee);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Verify user gets processes when skipCount parameter is applied")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void getProcessesWithSkipCountParameter() throws Exception {
        RestProcessModelsCollection processes = this.restClient.authenticateUser(this.userWhoStartsTask).withWorkflowAPI().getProcesses();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        processes.assertThat().paginationField("count").is("3");
        RestProcessModel process1 = ((RestProcessModel)processes.getEntries().get(0)).onModel();
        RestProcessModel process2 = ((RestProcessModel)processes.getEntries().get(1)).onModel();
        RestProcessModel process3 = ((RestProcessModel)processes.getEntries().get(2)).onModel();
        processes = ((RestWorkflowAPI)this.restClient.authenticateUser(this.userWhoStartsTask).withWorkflowAPI().usingParams(new String[]{"skipCount=2"})).getProcesses();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        processes.assertThat().paginationField("count").is("1");
        processes.assertThat().paginationField("skipCount").is("2");
        processes.assertThat().entriesListDoesNotContain("id", process1.getId());
        processes.assertThat().entriesListDoesNotContain("id", process2.getId());
        ((RestProcessModel)processes.getEntries().get(0)).onModel().assertThat().field("id").is((Object)process3.getId());
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Verify user gets processes when maxItems parameter is applied")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void getProcessesWithMaxItemsParameter() throws Exception {
        RestProcessModelsCollection processes = this.restClient.authenticateUser(this.userWhoStartsTask).withWorkflowAPI().getProcesses();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        processes.assertThat().paginationField("count").is("3");
        RestProcessModel process1 = ((RestProcessModel)processes.getEntries().get(0)).onModel();
        RestProcessModel process2 = ((RestProcessModel)processes.getEntries().get(1)).onModel();
        RestProcessModel process3 = ((RestProcessModel)processes.getEntries().get(2)).onModel();
        processes = ((RestWorkflowAPI)this.restClient.authenticateUser(this.userWhoStartsTask).withWorkflowAPI().usingParams(new String[]{"maxItems=2"})).getProcesses();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        processes.assertThat().paginationField("count").is("2");
        processes.assertThat().paginationField("maxItems").is("2");
        processes.assertThat().entriesListDoesNotContain("id", process3.getId());
        ((RestProcessModel)processes.getEntries().get(0)).onModel().assertThat().field("id").is((Object)process1.getId());
        ((RestProcessModel)processes.getEntries().get(1)).onModel().assertThat().field("id").is((Object)process2.getId());
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Verify user gets processes when properties parameter is applied")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void getProcessesWithPropertiesParameter() throws Exception {
        RestProcessModelsCollection processes = this.restClient.authenticateUser(this.userWhoStartsTask).withParams(new String[]{"properties=id"}).withWorkflowAPI().getProcesses();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        List processesList = processes.getEntries();
        ((RestProcessModel)((RestProcessModel)((RestProcessModel)((RestProcessModel)processesList.get(0)).onModel().assertThat().fieldsCount().is((Object)1)).and().field("id").isNotEmpty()).and().field("processDefinitionId").isNull()).and().field("startUserId").isNull();
        ((RestProcessModel)((RestProcessModel)((RestProcessModel)((RestProcessModel)processesList.get(1)).onModel().assertThat().fieldsCount().is((Object)1)).and().field("id").isNotEmpty()).and().field("processDefinitionId").isNull()).and().field("startUserId").isNull();
        ((RestProcessModel)((RestProcessModel)((RestProcessModel)((RestProcessModel)processesList.get(2)).onModel().assertThat().fieldsCount().is((Object)1)).and().field("id").isNotEmpty()).and().field("processDefinitionId").isNull()).and().field("startUserId").isNull();
        ((RestModels)((RestModels)((RestModels)processes.assertThat().entriesListIsNotEmpty()).and().entriesListContains("id", this.process3.getId())).and().entriesListContains("id", this.task2.getProcessId())).and().entriesListContains("id", this.task1.getProcessId());
    }

    @Bug(id="REPO-1958")
    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Verify user cannot get processes when using an invalid orderBy parameter")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void getProcessesWithInvalidOrderByParameter() throws Exception {
        this.restClient.authenticateUser(this.userWhoStartsTask).withParams(new String[]{"orderBy=test"}).withWorkflowAPI().getProcesses();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsErrorKey(String.format(RestErrorModel.INVALID_ORDERBY, "test", "processDefinitionId, startUserId, startActivityId,startedAt, id, completed, processDefinitionKey")).containsSummary(String.format(RestErrorModel.INVALID_ORDERBY, "test", "processDefinitionId, startUserId, startActivityId,startedAt, id, completed, processDefinitionKey")).stackTraceIs(RestErrorModel.STACKTRACE).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Verify user cannot get processes when using an invalid parameter in where clause")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void getProcessesWithInvalidWhereParameter() throws Exception {
        this.restClient.authenticateUser(this.userWhoStartsTask).where("startUserIdd='" + this.userWhoStartsTask.getUsername() + "'").withWorkflowAPI().getProcesses();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsErrorKey(RestErrorModel.INVALID_PROPERTY_ERRORKEY).containsSummary(String.format(RestErrorModel.PROPERTY_IS_NOT_SUPPORTED_EQUALS, "startUserIdd", this.userWhoStartsTask.getUsername())).stackTraceIs(RestErrorModel.STACKTRACE).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Verify user cannot get processes when using an invalid where clause expression")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void getProcessesWithInvalidWhereClauseExpression() throws Exception {
        this.restClient.authenticateUser(this.userWhoStartsTask).where("startUserId AND '" + this.userWhoStartsTask.getUsername() + "'").withWorkflowAPI().getProcesses();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsErrorKey(RestErrorModel.INVALID_QUERY_ERRORKEY).containsSummary(String.format(RestErrorModel.INVALID_WHERE_QUERY, "(startUserId AND '" + this.userWhoStartsTask.getUsername() + "')")).stackTraceIs(RestErrorModel.STACKTRACE).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER);
    }
}

