/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.tags;

import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestTagModel;
import org.alfresco.rest.tags.TagsDataPrep;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.Test;

@Test(groups={"require-solr"})
public class GetTagTests
extends TagsDataPrep {
    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify admin user gets tag using REST API and status code is OK (200)")
    @Test(groups={"rest-api", "tags", "regression"})
    public void adminIsAbleToGetTag() throws Exception {
        RestTagModel returnedTag = this.restClient.authenticateUser(adminUserModel).withCoreAPI().getTag(documentTag);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        returnedTag.assertThat().field("tag").is((Object)documentTagValue.toLowerCase());
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.SANITY}, description="Verify user with Manager role gets tag using REST API and status code is OK (200)")
    @Test(groups={"rest-api", "tags", "sanity"})
    public void userWithManagerRoleIsAbleToGetTag() throws Exception {
        this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteManager));
        RestTagModel returnedTag = this.restClient.withCoreAPI().getTag(documentTag);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTagModel)returnedTag.assertThat().field("tag").is((Object)documentTagValue.toLowerCase())).assertThat().field("id").is((Object)documentTag.getId());
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify user with Collaborator role gets tag using REST API and status code is OK (200)")
    @Test(groups={"rest-api", "tags", "regression"})
    public void userWithCollaboratorRoleIsAbleToGetTag() throws Exception {
        this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator));
        RestTagModel returnedTag = this.restClient.withCoreAPI().getTag(documentTag);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        returnedTag.assertThat().field("tag").is((Object)documentTagValue.toLowerCase());
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify user with Contributor role gets tag using REST API and status code is OK (200)")
    @Test(groups={"rest-api", "tags", "regression"})
    public void userWithContributorRoleIsAbleToGetTag() throws Exception {
        this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteContributor));
        RestTagModel returnedTag = this.restClient.withCoreAPI().getTag(documentTag);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        returnedTag.assertThat().field("tag").is((Object)documentTagValue.toLowerCase());
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify user with Consumer role gets tag using REST API and status code is OK (200)")
    @Test(groups={"rest-api", "tags", "regression"})
    public void userWithConsumerRoleIsAbleToGetTag() throws Exception {
        this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer));
        RestTagModel returnedTag = this.restClient.withCoreAPI().getTag(documentTag);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        returnedTag.assertThat().field("tag").is((Object)documentTagValue.toLowerCase());
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.SANITY}, description="Verify Manager user gets status code 401 if authentication call fails")
    @Test(groups={"rest-api", "tags", "sanity"})
    public void managerIsNotAbleToGetTagIfAuthenticationFails() throws Exception {
        UserModel managerUser = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        String managerPassword = managerUser.getPassword();
        this.dataUser.addUserToSite(managerUser, siteModel, UserRole.SiteManager);
        managerUser.setPassword("wrongPassword");
        this.restClient.authenticateUser(managerUser).withCoreAPI().getTag(documentTag);
        managerUser.setPassword(managerPassword);
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify that if tag id is invalid status code returned is 400")
    @Test(groups={"rest-api", "tags", "regression"})
    public void invalidTagIdTest() throws Exception {
        String tagId = documentTag.getId();
        documentTag.setId("random_tag_value");
        this.restClient.authenticateUser(adminUserModel).withCoreAPI().getTag(documentTag);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, "random_tag_value"));
        documentTag.setId(tagId);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Check that properties filter is applied when getting tag using Manager user.")
    @Test(groups={"rest-api", "tags", "regression"})
    public void checkPropertiesFilterIsApplied() throws Exception {
        RestTagModel returnedTag = this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withParams(new String[]{"properties=id,tag"}).withCoreAPI().getTag(documentTag);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTagModel)((RestTagModel)returnedTag.assertThat().field("id").is((Object)documentTag.getId())).assertThat().field("tag").is((Object)documentTag.getTag().toLowerCase())).assertThat().fieldsCount().is((Object)2);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Check that Manager user can get tag of a folder.")
    @Test(groups={"rest-api", "tags", "regression"})
    public void getTagOfAFolder() throws Exception {
        RestTagModel returnedTag = this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().getTag(folderTag);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        returnedTag.assertThat().field("tag").is((Object)folderTagValue.toLowerCase());
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Check default error model schema. Use invalid skipCount parameter.")
    @Test(groups={"rest-api", "tags", "regression"})
    public void checkDefaultErrorModelSchema() throws Exception {
        this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withParams(new String[]{"skipCount=abc"}).withCoreAPI().getTag(documentTag);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsErrorKey(String.format(RestErrorModel.INVALID_SKIPCOUNT, "abc")).containsSummary(String.format(RestErrorModel.INVALID_SKIPCOUNT, "abc")).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }
}

