/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.tas.integration;

import org.alfresco.cmis.CmisWrapper;
import org.alfresco.ftp.FTPWrapper;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestTagModel;
import org.alfresco.tas.integration.IntegrationTest;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.exception.DataPreparationException;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.alfresco.webdav.WebDavWrapper;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class IntegrationFullTestsBulk2
extends IntegrationTest {
    private UserModel testUser1;
    private SiteModel testSitePublic;
    private FolderModel testFolder1;
    private FolderModel testFolder2;
    private FileModel wordFile;
    private FileModel testFile;
    private DataUser.ListUserWithRoles usersWithRoles;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.testUser1 = this.dataUser.createRandomTestUser();
        this.wordFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD2007, (String)"tasTesting");
    }

    @BeforeMethod(alwaysRun=true)
    public void setup() throws DataPreparationException {
        this.testSitePublic = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        this.testFolder1 = FolderModel.getRandomFolderModel();
        this.testFolder2 = FolderModel.getRandomFolderModel();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"testContent");
    }

    @Test(groups={"integration", "full"})
    @TestRail(section={"integration", "content"}, executionType={ExecutionType.REGRESSION}, description="Edit checked out document using several protocols")
    public void updateFileUsingDifferentProtocolsWhileDocumentIsCheckedOut() throws Exception {
        Step.STEP((String)"1. Create testFile1 using ftp");
        this.ftpProtocol.authenticateUser(this.testUser1).usingSite(this.testSitePublic).createFolder(this.testFolder1).usingResource((ContentModel)this.testFolder1).createFile(this.wordFile).assertThat().contentIs("tasTesting");
        Step.STEP((String)"2. Open document for edit using CMIS");
        this.cmisAPI.authenticateUser(this.testUser1).usingResource((ContentModel)this.wordFile).checkOut();
        FileModel wordFilePWC = this.cmisAPI.usingResource((ContentModel)this.wordFile).withCMISUtil().getPWCFileModel();
        Step.STEP((String)"3. Try to edit document using Webdav while checked-out with CMIS - content should be updated");
        ((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)wordFilePWC).update("update").and()).assertThat().contentIs("update");
        Step.STEP((String)"4. Copy document to testFolder2 with ftp");
        FileModel copiedWordFile = new FileModel(this.wordFile);
        this.ftpProtocol.usingSite(this.testSitePublic).createFolder(this.testFolder2).usingResource((ContentModel)this.wordFile).copyTo((ContentModel)this.testFolder2);
        copiedWordFile.setCmisLocation(this.ftpProtocol.getLastResourceWithoutPrefix());
        ((FTPWrapper)this.ftpProtocol.usingResource((ContentModel)this.testFolder1).assertThat().hasFiles(new FileModel[]{this.wordFile}).and()).usingResource((ContentModel)this.testFolder2).assertThat().hasFiles(new FileModel[]{copiedWordFile});
        Step.STEP((String)"5. Update document from folder2, check its content is updated with Webdav");
        ((WebDavWrapper)this.webDavProtocol.usingResource((ContentModel)copiedWordFile).update("Step5").and()).assertThat().contentIs("Step5");
        Step.STEP((String)"6. Update document with WebDAV");
        this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.wordFile).update("WebDAVUpdate");
    }

    @Test(groups={"integration", "full"})
    @TestRail(section={"integration", "content"}, executionType={ExecutionType.REGRESSION}, description="Update checked out document")
    public void updateCheckedOutFile() throws Exception {
        Step.STEP((String)"1. Create folder1 with webdav");
        ((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser1).usingSite(this.testSitePublic).createFolder(this.testFolder1).and()).assertThat().existsInRepo();
        Step.STEP((String)"2. Upload new file, file1 with ftp");
        ((FTPWrapper)((FTPWrapper)((FTPWrapper)this.ftpProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFolder1).createFile(this.testFile).and()).assertThat().existsInRepo()).and()).assertThat().existsInFtp();
        Step.STEP((String)"3. Set content for file1 with cmis");
        ((CmisWrapper)this.cmisAPI.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFile).update("cmisUpdate").and()).assertThat().contentIs("testContentcmisUpdate");
        Step.STEP((String)"4. CheckOut file1 with cmis");
        this.cmisAPI.usingResource((ContentModel)this.testFile).checkOut();
        Step.STEP((String)"5. Try to edit file while checked-out with ftp - content should not be updated since file is checked out");
        ((FTPWrapper)this.ftpProtocol.usingResource((ContentModel)this.testFile).update("ftpUpdate").and()).assertThat().contentIs("testContentcmisUpdate");
        Step.STEP((String)"6. Cancel checkout with cmis");
        this.cmisAPI.usingResource((ContentModel)this.testFile).cancelCheckOut();
        Step.STEP((String)"7. Try again to edit file with ftp");
        ((FTPWrapper)this.ftpProtocol.usingResource((ContentModel)this.testFile).update("ftpUpdate").and()).assertThat().contentIs("ftpUpdate");
        Step.STEP((String)"8. Edit file content using webDav");
        ((WebDavWrapper)this.webDavProtocol.usingResource((ContentModel)this.testFile).update("webdavUpdate").and()).assertThat().contentIs("webdavUpdate");
        Step.STEP((String)"9. Get content using cmis, validate it");
        this.cmisAPI.usingResource((ContentModel)this.testFile).assertThat().contentIs("webdavUpdate");
    }

    @Test(groups={"integration", "full"})
    @TestRail(section={"integration", "content"}, executionType={ExecutionType.REGRESSION}, description="Update file with different user roles and protocols")
    public void updateFileWithDifferentRolesUsingDifferentProtocols() throws Exception {
        this.usersWithRoles = this.dataUser.addUsersWithRolesToSite(this.testSitePublic, new UserRole[]{UserRole.SiteManager, UserRole.SiteCollaborator, UserRole.SiteConsumer, UserRole.SiteContributor});
        Step.STEP((String)"1. Create folder1 with cmis");
        ((CmisWrapper)this.cmisAPI.authenticateUser(this.testUser1).usingSite(this.testSitePublic).createFolder(this.testFolder1).and()).assertThat().existsInRepo();
        Step.STEP((String)"2. Add new file with webdav");
        ((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFolder1).createFile(this.testFile).and()).assertThat().existsInRepo();
        Step.STEP((String)"3. Open file with Manager, add some content, save with webdav");
        ((WebDavWrapper)this.webDavProtocol.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).usingResource((ContentModel)this.testFile).update("webdavUpdate").and()).assertThat().contentIs("webdavUpdate");
        Step.STEP((String)"4. Open file with Consumer, add some content, save with ftp");
        ((FTPWrapper)this.ftpProtocol.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).usingResource((ContentModel)this.testFile).update("ftpUpdate").and()).assertThat().contentIs("webdavUpdate");
        Step.STEP((String)"5. Open file with Contributor, delete some content, save with webdav");
        ((WebDavWrapper)this.webDavProtocol.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingResource((ContentModel)this.testFile).update("webdavUpdate").and()).assertThat().contentIs("webdavUpdate");
        Step.STEP((String)"6. Open file with Collaborator, add some content, save with WebDAV");
        ((WebDavWrapper)this.webDavProtocol.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingResource((ContentModel)this.testFile).update("webdavUpdate2").and()).assertThat().contentIs("webdavUpdate2");
        Step.STEP((String)"7. Open file with Consumer, delete some content, save with webdav");
        ((WebDavWrapper)this.webDavProtocol.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).usingResource((ContentModel)this.testFile).update("webdavUpdate3").and()).assertThat().contentIs("webdavUpdate2");
        Step.STEP((String)"8. Open file with Manager, add new content, save with cmis");
        ((CmisWrapper)this.cmisAPI.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).usingResource((ContentModel)this.testFile).update("cmisUpdate").and()).assertThat().contentIs("webdavUpdate2cmisUpdate");
        Step.STEP((String)"9. Open file with Collaborator, delete content that Manager added with ftp");
        ((FTPWrapper)this.ftpProtocol.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingResource((ContentModel)this.testFile).update("ftpUpdate").and()).assertThat().contentIs("ftpUpdate");
        Step.STEP((String)"10. Open file with Contributor, add new page with webdav");
        ((WebDavWrapper)this.webDavProtocol.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).usingResource((ContentModel)this.testFile).update("webdavUpdate").and()).assertThat().contentIs("webdavUpdate");
        Step.STEP((String)"11. Delete all content with admin using FTP");
        ((FTPWrapper)this.ftpProtocol.authenticateUser(this.dataUser.getAdminUser()).usingResource((ContentModel)this.testFile).update("").and()).assertThat().contentIs("");
        Step.STEP((String)"12. Delete file with cmis");
        ((CmisWrapper)this.cmisAPI.usingResource((ContentModel)this.testFile).delete().and()).assertThat().doesNotExistInRepo();
        Step.STEP((String)"13. Check file is deleted with WebDAV");
        this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFile).assertThat().doesNotExistInWebdav();
    }

    @Test(groups={"integration", "full"})
    @TestRail(section={"integration", "content"}, executionType={ExecutionType.REGRESSION}, description="Check document versioning")
    public void documentVersioningTest() throws Exception {
        Step.STEP((String)"1. Add file1 to document library with ftp");
        ((FTPWrapper)this.ftpProtocol.authenticateUser(this.testUser1).usingSite(this.testSitePublic).createFile(this.testFile).and()).assertThat().existsInRepo();
        Step.STEP((String)"2. Update file content with WebDAV");
        ((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFile).update("WebDAVUpdate").and()).assertThat().contentIs("WebDAVUpdate");
        Step.STEP((String)"3. Add a minor change to a document with cmis");
        ((CmisWrapper)((CmisWrapper)this.cmisAPI.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFile).update("cmisUpdate").then()).assertThat().documentHasVersion(1.1).and()).assertThat().contentIs("WebDAVUpdatecmisUpdate");
        Step.STEP((String)"4. Check document version with webdav");
        this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFile).update("webdavUpdate");
        this.cmisAPI.assertThat().documentHasVersion(1.2);
        Step.STEP((String)"5. Add a major change to a document with cmis");
        ((CmisWrapper)this.cmisAPI.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFile).checkOut().prepareDocumentForCheckIn().withMajorVersion().checkIn().and()).assertThat().documentHasVersion(2.0);
        Step.STEP((String)"6. Delete document last version with cmis");
        ((CmisWrapper)this.cmisAPI.usingResource((ContentModel)this.testFile).deleteAllVersions(false).and()).assertThat().documentHasVersion(1.2);
        Step.STEP((String)"7. Try to edit previous version with cmis");
        ((CmisWrapper)((CmisWrapper)this.cmisAPI.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFile).update("cmisUpdate").then()).assertThat().documentHasVersion(1.3).and()).assertThat().contentIs("webdavUpdatecmisUpdate");
        Step.STEP((String)"8. Update content with ftp, check version");
        this.ftpProtocol.usingResource((ContentModel)this.testFile).update("ftpUpdate");
        this.cmisAPI.assertThat().documentHasVersion(1.4);
        Step.STEP((String)"9. Check document content with WebDAV");
        this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFile).assertThat().contentIs("ftpUpdate");
    }

    @Test(groups={"integration", "full"})
    @TestRail(section={"integration", "content", "tags"}, executionType={ExecutionType.REGRESSION}, description="Check negative scenarios for tags")
    public void tagsNegativeScenariosTest() throws Exception {
        Step.STEP((String)"1. Create user1, user2");
        UserModel user1 = this.dataUser.createRandomTestUser();
        UserModel user2 = this.dataUser.createRandomTestUser();
        user2.setUserRole(UserRole.SiteManager);
        Step.STEP((String)"2. User1 creates site1 and invites user2 as manager");
        SiteModel site = ((DataSite)this.dataSite.usingUser(user1)).createPublicRandomSite();
        this.restAPI.authenticateUser(user1).withCoreAPI().usingSite(site).addPerson(user2);
        Step.STEP((String)"3. User1 adds document1 and tag1 to doc");
        ((DataContent)this.dataContent.usingUser(user1).usingSite(site)).createContent(this.testFile);
        RestTagModel tag = this.restAPI.withCoreAPI().usingResource((RepoTestModel)this.testFile).addTag("tag1");
        this.restAPI.withCoreAPI().usingResource((RepoTestModel)this.testFile).getNodeTags().assertThat().entriesListContains("tag", "tag1");
        Step.STEP((String)"4. User2 gets tags and verifies tag1 appears");
        this.restAPI.authenticateUser(user2).withCoreAPI().usingResource((RepoTestModel)this.testFile).getNodeTags().assertThat().entriesListContains("tag", "tag1");
        Step.STEP((String)"5. User2 delete tag1");
        this.restAPI.withCoreAPI().usingResource((RepoTestModel)this.testFile).deleteTag(tag);
        this.restAPI.withCoreAPI().usingResource((RepoTestModel)this.testFile).getNodeTags().assertThat().entriesListDoesNotContain("tag", "tag1");
        Step.STEP((String)"6. User1 tries to update tag1");
        this.restAPI.authenticateUser(user2).withCoreAPI().usingTag(tag).update("updatedTag");
        this.restAPI.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED).containsErrorKey(RestErrorModel.PERMISSION_DENIED_ERRORKEY);
        Step.STEP((String)"7. User1 add new tag tag2");
        tag = this.restAPI.authenticateUser(user1).withCoreAPI().usingResource((RepoTestModel)this.testFile).addTag("tag2");
        this.restAPI.withCoreAPI().usingResource((RepoTestModel)this.testFile).getNodeTags().assertThat().entriesListContains("tag", "tag2");
        Step.STEP((String)"8. User2 verifies tag2 appears and tag1 is not in the list");
        ((RestModels)this.restAPI.authenticateUser(user2).withCoreAPI().usingResource((RepoTestModel)this.testFile).getNodeTags().assertThat().entriesListDoesNotContain("tag", "tag1")).assertThat().entriesListContains("tag", "tag2");
        Step.STEP((String)"9. User2 deletes document1");
        ((DataContent)this.dataContent.usingUser(user2).usingResource((ContentModel)this.testFile)).deleteContent();
        Step.STEP((String)"10. User1 tries to delete tag2");
        this.restAPI.authenticateUser(user1).withCoreAPI().usingResource((RepoTestModel)this.testFile).deleteTag(tag);
        this.restAPI.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, this.testFile.getNodeRefWithoutVersion())).containsErrorKey(RestErrorModel.ENTITY_NOT_FOUND_ERRORKEY);
    }

    @Test(groups={"integration", "full"}, expectedExceptions={CmisObjectNotFoundException.class}, expectedExceptionsMessageRegExp=".*Object not found:.*")
    @TestRail(section={"integration", "content"}, executionType={ExecutionType.REGRESSION}, description="Negative scenarios for update document")
    public void fileUpdateNegativeScenariosTest() throws Exception {
        Step.STEP((String)"1. Create user1, user2");
        UserModel user1 = this.dataUser.createRandomTestUser();
        UserModel user2 = this.dataUser.createRandomTestUser();
        user2.setUserRole(UserRole.SiteManager);
        Step.STEP((String)"2. User1 creates site1 and invites user2 as manager with rest api");
        SiteModel site = ((DataSite)this.dataSite.usingUser(user1)).createPublicRandomSite();
        this.restAPI.authenticateUser(user1).withCoreAPI().usingSite(site).addPerson(user2);
        Step.STEP((String)"3. User1 adds document1 with webdav");
        ((WebDavWrapper)this.webDavProtocol.authenticateUser(user1).usingSite(site).createFile(this.testFile).and()).assertThat().existsInRepo();
        Step.STEP((String)"4. User2 reads the document1 with ftp");
        this.ftpProtocol.authenticateUser(user2).usingResource((ContentModel)this.testFile).assertThat().contentIs("testContent");
        Step.STEP((String)"5. User1 update document1 with WebDAV");
        this.webDavProtocol.authenticateUser(user1).usingResource((ContentModel)this.testFile).update("WebDAVUpdate1").assertThat().contentIs("WebDAVUpdate1");
        Step.STEP((String)"6. User2 update the document1 with WebDAV");
        this.webDavProtocol.authenticateUser(user2).usingResource((ContentModel)this.testFile).update("WebDAVUpdate2").assertThat().contentIs("WebDAVUpdate2");
        Step.STEP((String)"7. User1 deletes the document1 with ftp");
        this.ftpProtocol.authenticateUser(user1).usingResource((ContentModel)this.testFile).delete().assertThat().doesNotExistInFtp().assertThat().doesNotExistInRepo();
        Step.STEP((String)"8. Verify user2 cannot update document1 with cmis");
        this.cmisAPI.authenticateUser(user2).usingResource((ContentModel)this.testFile).update("cmisUpdate");
    }

    @Test(groups={"integration", "full"})
    @TestRail(section={"integration", "content"}, executionType={ExecutionType.REGRESSION}, description="File versioning test scenarios")
    public void fileVersioningScenariosTest() throws Exception {
        Step.STEP((String)"1. Upload file with CMIS");
        ((CmisWrapper)this.cmisAPI.authenticateUser(this.testUser1).usingSite(this.testSitePublic).createFile(this.testFile).and()).assertThat().existsInRepo();
        Step.STEP((String)"2. Add some content with ftp ");
        ((FTPWrapper)this.ftpProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFile).update("ftpUpdate").and()).assertThat().contentIs("ftpUpdate");
        Step.STEP((String)"3. Add a minor change to document, 1.1 with cmis");
        ((CmisWrapper)this.cmisAPI.usingResource((ContentModel)this.testFile).checkOut().prepareDocumentForCheckIn().withContent("cmisUpdate").withMinorVersion().checkIn().refreshResource().and()).assertThat().documentHasVersion(1.2);
        Step.STEP((String)"4. Add a major change to document, 2.0 with cmis");
        ((CmisWrapper)this.cmisAPI.usingResource((ContentModel)this.testFile).checkOut().prepareDocumentForCheckIn().withContent("cmisUpdate").withMajorVersion().checkIn().and()).assertThat().documentHasVersion(2.0);
        Step.STEP((String)"5. Add a minor change to document, 2.1 with cmis");
        ((CmisWrapper)this.cmisAPI.usingResource((ContentModel)this.testFile).checkOut().prepareDocumentForCheckIn().withContent("cmisUpdate").withMinorVersion().checkIn().and()).assertThat().documentHasVersion(2.1);
        Step.STEP((String)"6. Delete version 2.0 with cmis with cmis");
        this.cmisAPI.usingResource((ContentModel)this.testFile).deleteAllVersions(false);
        Step.STEP((String)"7. Get document version with cmis");
        this.cmisAPI.usingResource((ContentModel)this.testFile).assertThat().documentHasVersion(2.0);
        Step.STEP((String)"8. Try to edit version 2.0 with cmis");
        ((CmisWrapper)((CmisWrapper)this.cmisAPI.usingResource((ContentModel)this.testFile).update("cmisUpdate").and()).assertThat().contentIs("cmisUpdatecmisUpdate").and()).assertThat().documentHasVersion(2.1);
        Step.STEP((String)"9. Delete version 2.1 with cmis");
        this.cmisAPI.usingResource((ContentModel)this.testFile).deleteAllVersions(false);
        Step.STEP((String)"10. Get document version with cmis");
        this.cmisAPI.usingResource((ContentModel)this.testFile).assertThat().documentHasVersion(2.0);
        Step.STEP((String)"11. Try to edit version 2.0 with cmis");
        ((CmisWrapper)((CmisWrapper)this.cmisAPI.usingResource((ContentModel)this.testFile).update("cmisUpdate").and()).assertThat().contentIs("cmisUpdatecmisUpdate").and()).assertThat().documentHasVersion(2.1);
        Step.STEP((String)"12. Update and check document content with ftp");
        this.ftpProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFile).update("ftpUpdate").assertThat().contentIs("ftpUpdate");
        Step.STEP((String)"13. Check document version with cmis");
        this.cmisAPI.usingResource((ContentModel)this.testFile).assertThat().documentHasVersion(2.2);
    }

    @Test(groups={"integration", "full"}, expectedExceptionsMessageRegExp=".*Version Series not found.*", expectedExceptions={CmisObjectNotFoundException.class})
    @TestRail(section={"integration", "content"}, executionType={ExecutionType.REGRESSION}, description="File versioning additional test scenarios")
    public void fileVersioningNegativeScenariosTest() throws Exception {
        Step.STEP((String)"1. Upload file with cmis");
        ((CmisWrapper)this.cmisAPI.authenticateUser(this.testUser1).usingSite(this.testSitePublic).createFile(this.testFile).and()).assertThat().existsInRepo();
        Step.STEP((String)"2. Add some content with WebDAV");
        ((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFile).update("WebDAVUpdate").and()).assertThat().contentIs("WebDAVUpdate");
        Step.STEP((String)"3. Add a minor change to document, 1.2 with cmis");
        ((CmisWrapper)this.cmisAPI.usingResource((ContentModel)this.testFile).checkOut().prepareDocumentForCheckIn().withContent("cmisUpdate").withMinorVersion().checkIn().refreshResource().and()).assertThat().documentHasVersion(1.2);
        Step.STEP((String)"4. Add a major change to document, 2.0 with cmis");
        ((CmisWrapper)this.cmisAPI.usingResource((ContentModel)this.testFile).checkOut().prepareDocumentForCheckIn().withContent("cmisUpdate").withMajorVersion().checkIn().and()).assertThat().documentHasVersion(2.0);
        Step.STEP((String)"5. Add a minor change to document, 2.1 with cmis");
        ((CmisWrapper)this.cmisAPI.usingResource((ContentModel)this.testFile).checkOut().prepareDocumentForCheckIn().withContent("cmisUpdate").withMinorVersion().checkIn().refreshResource().and()).assertThat().documentHasVersion(2.1);
        Step.STEP((String)"6. Delete version 2.1 with cmis");
        this.cmisAPI.usingResource((ContentModel)this.testFile).deleteAllVersions(false).assertThat().documentHasVersion(2.0);
        Step.STEP((String)"7. Try to edit the last version (which is now 2.0) with webdav");
        this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFile).update("webdavUpdate");
        Step.STEP((String)"8. Check version with CMIS");
        this.cmisAPI.usingResource((ContentModel)this.testFile).assertThat().documentHasVersion(2.1);
        Step.STEP((String)"9. Add new major change, version 3.0 with cmis");
        ((CmisWrapper)this.cmisAPI.usingResource((ContentModel)this.testFile).checkOut().prepareDocumentForCheckIn().withContent("cmisUpdate").withMajorVersion().checkIn().and()).assertThat().documentHasVersion(3.0);
        Step.STEP((String)"10. Delete previous version with cmis");
        this.cmisAPI.usingResource((ContentModel)this.testFile).deleteAllVersions(false).assertThat().documentHasVersion(2.1);
        Step.STEP((String)"11. Delete document with ftp");
        this.ftpProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFile).delete().assertThat().doesNotExistInRepo();
        Step.STEP((String)"12. Check document version with cmis - should fail");
        this.cmisAPI.usingResource((ContentModel)this.testFile).assertThat().documentHasVersion(2.1);
    }
}

