/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.tas.integration;

import io.restassured.RestAssured;
import java.util.HashMap;
import org.alfresco.rest.core.JsonBodyGenerator;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.core.RestResponse;
import org.alfresco.rest.model.RestNodeModel;
import org.alfresco.rest.model.RestRenditionInfoModel;
import org.alfresco.rest.requests.cmisAPI.RestCmisAPI;
import org.alfresco.tas.integration.IntegrationTest;
import org.alfresco.utility.Utility;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.exception.DataPreparationException;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.report.log.Step;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class IntegrationWithCmisTests
extends IntegrationTest {
    private UserModel user;
    private SiteModel site;

    @BeforeClass(alwaysRun=true)
    public void createUserAndSite() throws DataPreparationException {
        this.user = this.dataUser.createRandomTestUser();
        this.site = ((DataSite)this.dataSite.usingUser(this.user)).createPublicRandomSite();
    }

    @TestRail(section={"integration", "cmis"}, executionType={ExecutionType.REGRESSION}, description="Verify getChildren action for a large number of files from CMIS returns only unique values with few retries")
    public void verifyGetChildrenReturnsUniqueValues() throws Exception {
        Step.STEP((String)"1. Create user, site, folder.");
        FolderModel folder = FolderModel.getRandomFolderModel();
        folder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder(folder);
        Step.STEP((String)"2. Create 5000 files in folder using webscript");
        int totalFiles = 5000;
        String fileCreationWebScript = "alfresco/s/api/model/filefolder/load";
        HashMap<String, String> input = new HashMap<String, String>();
        input.put("folderPath", folder.getCmisLocation());
        input.put("fileCount", String.valueOf(totalFiles));
        String postBody = JsonBodyGenerator.keyValueJson(input);
        RestAssured.basePath = "";
        this.restAPI.configureRequestSpec().setBasePath(RestAssured.basePath);
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.POST, (String)postBody, (String)fileCreationWebScript, (String[])new String[0]);
        RestResponse response = this.restAPI.authenticateUser(this.user).process(request);
        Assert.assertEquals((int)response.getResponse().getStatusCode(), (int)HttpStatus.OK.value());
        Step.STEP((String)"3. Verify getChildren from CMIS returns unique values");
        this.cmisAPI.authenticateUser(this.user).usingSite(this.site).usingResource((ContentModel)folder);
        for (int i = 1; i <= 20; ++i) {
            System.out.println(String.format("Try no: %d", i));
            this.cmisAPI.usingResource((ContentModel)folder).assertThat().hasUniqueChildren(totalFiles);
        }
    }

    @Test(groups={"integration", "cmis", "core"})
    @TestRail(section={"integration", "cmis"}, executionType={ExecutionType.REGRESSION}, description="Verify content and thumbnail of TIF files are retrieved by CMIS ")
    @Bug(id="REPO-2042", description="Should fail only on MAC OS System and Linux")
    public void verifyContentAndThumbnailForTifFile() throws Exception {
        Step.STEP((String)"1. Create user, site and a folder ");
        FolderModel folder = FolderModel.getRandomFolderModel();
        folder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder(folder);
        Step.STEP((String)"2. Upload existing TIF file using RESTAPI");
        this.restAPI.authenticateUser(this.user).configureRequestSpec().addMultiPart("filedata", Utility.getResourceTestDataFile((String)"my-file.tif"));
        RestNodeModel fileNode = this.restAPI.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)folder).createNode();
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        FileModel file = new FileModel("my-file.tif");
        file.setCmisLocation(folder.getCmisLocation() + "/my-file.tif");
        file.setNodeRef(fileNode.getId());
        Step.STEP((String)"3. Create thumbnail and content of TIF files using file");
        this.restAPI.withCoreAPI().usingNode((RepoTestModel)file).createNodeRendition("pdf");
        this.restAPI.assertStatusCodeIs(HttpStatus.ACCEPTED);
        this.restAPI.withCoreAPI().usingNode((RepoTestModel)file).createNodeRendition("doclib");
        this.restAPI.assertStatusCodeIs(HttpStatus.ACCEPTED);
        Step.STEP((String)"4. Verify thumbnail and content of TIF files are created using RESTAPI");
        this.cmisAPI.authenticateUser(this.user).usingSite(this.site).usingResource((ContentModel)folder).usingResource((ContentModel)file).assertThat().contentContains("Adobe Photoshop CC 2015");
        RestRenditionInfoModel renditionInfo = this.restAPI.withCoreAPI().usingNode((RepoTestModel)file).getNodeRendition("pdf");
        this.restAPI.assertStatusCodeIs(HttpStatus.OK);
        renditionInfo.assertThat().field("status").is((Object)"CREATED");
        renditionInfo = this.restAPI.withCoreAPI().usingNode((RepoTestModel)file).getNodeRendition("doclib");
        this.restAPI.assertStatusCodeIs(HttpStatus.OK);
        renditionInfo.assertThat().field("status").is((Object)"CREATED");
    }

    @Test(groups={"integration", "cmis", "full"})
    @TestRail(section={"integration", "cmis"}, executionType={ExecutionType.REGRESSION}, description="Verify getChildren action for a large number of files from CMIS returns only unique values with few retries")
    public void verifyContentDispositionForContentThatAreWhiteListed() throws Exception {
        Step.STEP((String)"1. Create a .pdf and a .html file in the Shared folder in CMIS");
        FolderModel sharedFolder = FolderModel.getSharedFolderModel();
        FileModel pdfFile = FileModel.getRandomFileModel((FileType)FileType.PDF);
        FileModel htmlFile = FileModel.getRandomFileModel((FileType)FileType.HTML);
        Step.STEP((String)"2. Upload the .pdf file and verify the reponse header adding the download=inline/attachement parameters (accepted both).");
        this.cmisAPI.authenticateUser(this.user).usingResource((ContentModel)sharedFolder).createFile(pdfFile);
        RestResponse response = this.restAPI.authenticateUser(this.user).withCMISApi().getRootObjectByLocation((ContentModel)pdfFile);
        this.restAPI.assertStatusCodeIs(HttpStatus.OK);
        response.assertThat().header("Content-Disposition", String.format("inline; filename=%s", pdfFile.getName()));
        response = ((RestCmisAPI)this.restAPI.authenticateUser(this.user).withCMISApi().usingParams(new String[]{"download=inline"})).getRootObjectByLocation((ContentModel)pdfFile);
        this.restAPI.assertStatusCodeIs(HttpStatus.OK);
        response.assertThat().header("Content-Disposition", String.format("inline; filename=%s", pdfFile.getName()));
        response = ((RestCmisAPI)this.restAPI.authenticateUser(this.user).withCMISApi().usingParams(new String[]{"download=attachment"})).getRootObjectByLocation((ContentModel)pdfFile);
        this.restAPI.assertStatusCodeIs(HttpStatus.OK);
        response.assertThat().header("Content-Disposition", String.format("attachment; filename=%s", pdfFile.getName()));
        Step.STEP((String)"3. Upload the .html file and verify the reponse header adding the download=inline/attachement parameters (accepted only attachment) .");
        this.cmisAPI.usingResource((ContentModel)sharedFolder).createFile(htmlFile);
        response = this.restAPI.authenticateUser(this.user).withCMISApi().getRootObjectByLocation((ContentModel)htmlFile);
        this.restAPI.assertStatusCodeIs(HttpStatus.OK);
        response.assertThat().header("Content-Disposition", String.format("attachment; filename=%s", htmlFile.getName()));
        response = ((RestCmisAPI)this.restAPI.authenticateUser(this.user).withCMISApi().usingParams(new String[]{"download=attachment"})).getRootObjectByLocation((ContentModel)htmlFile);
        this.restAPI.assertStatusCodeIs(HttpStatus.OK);
        response.assertThat().header("Content-Disposition", String.format("attachment; filename=%s", htmlFile.getName()));
        response = ((RestCmisAPI)this.restAPI.authenticateUser(this.user).withCMISApi().usingParams(new String[]{"download=inline"})).getRootObjectByLocation((ContentModel)htmlFile);
        this.restAPI.assertStatusCodeIs(HttpStatus.OK);
        response.assertThat().header("Content-Disposition", String.format("attachment; filename=%s", htmlFile.getName()));
    }

    @Test(groups={"integration", "cmis", "full"})
    @TestRail(section={"integration", "cmis"}, executionType={ExecutionType.SANITY}, description="Verify that alfresco returns the correct encoding for files created via CMIS.")
    public void verifyFileEncodingUsingCMIS() throws Exception {
        Step.STEP((String)"1. Create a folder, two text file with specific encoding content and define the expected encoding.");
        FileModel utf8File = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)" \u222e E\u22c5da = Q");
        FileModel iso8859File = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"<html><head><title>aegif Mind Share Leader Generating New Paradigms by aegif corporation</title></head><body><p> Test html</p></body></html></body></html>");
        String utf8Type = "text/plain;charset=UTF-8";
        String iso8859Type = "text/plain;charset=ISO-8859-1";
        Step.STEP((String)"2. Upload the files via CMIS.");
        this.cmisAPI.authenticateUser(this.user).usingSite(this.site).createFile(utf8File);
        this.cmisAPI.createFile(iso8859File);
        String fileCreationWebScript = "alfresco/service/api/node/content/workspace/SpacesStore/";
        RestAssured.basePath = "";
        Step.STEP((String)"3. Retrieve the nodes via webscripts and verify that the content type is the expected one (GET alfresco/service/api/node/content/workspace/SpacesStore/).");
        this.restAPI.configureRequestSpec().setBasePath(RestAssured.basePath);
        RestRequest request = RestRequest.simpleRequest((HttpMethod)HttpMethod.GET, (String)(fileCreationWebScript + utf8File.getNodeRefWithoutVersion()), (String[])new String[0]);
        RestResponse response = this.restAPI.authenticateUser(this.user).process(request);
        Assert.assertEquals((int)response.getResponse().getStatusCode(), (int)HttpStatus.OK.value());
        Assert.assertEquals((String)response.getResponse().getContentType(), (String)utf8Type);
        request = RestRequest.simpleRequest((HttpMethod)HttpMethod.GET, (String)(fileCreationWebScript + iso8859File.getNodeRefWithoutVersion()), (String[])new String[0]);
        response = this.restAPI.process(request);
        Assert.assertEquals((int)response.getResponse().getStatusCode(), (int)HttpStatus.OK.value());
        Assert.assertEquals((String)response.getResponse().getContentType(), (String)iso8859Type);
    }
}

