/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.email.imap;

import jakarta.mail.MessagingException;
import org.alfresco.dataprep.CMISUtil;
import org.alfresco.email.EmailTest;
import org.alfresco.email.ImapWrapper;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ImapCopyMessagesTests
extends EmailTest {
    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.testUser = this.dataUser.createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createIMAPSite();
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.SANITY}, description="Verify site manager can copy non-empty file via IMAP client to a different location")
    @Test(groups={"protocols", "imap", "sanity"})
    public void siteManagerShouldCopyNonEmptyFile() throws Exception {
        this.testFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createFolder();
        FileModel fileModel = ((DataContent)this.dataContent.usingSite(this.testSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        ((ImapWrapper)((ImapWrapper)((ImapWrapper)this.imapProtocol.authenticateUser(this.testUser).usingSite(this.testSite).usingResource((ContentModel)fileModel).assertThat().existsInRepo()).and()).assertThat().existsInImap().then()).copyMessageTo((ContentModel)this.testFolder).assertThat().containsMessages(new FileModel[]{fileModel});
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.SANITY}, description="Verify site manager can copy non-empty files via IMAP client to a different location")
    @Test(groups={"protocols", "imap", "sanity"})
    public void siteManagerShouldCopyNonEmptyFiles() throws Exception {
        this.testFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createFolder();
        FileModel fileModel1 = ((DataContent)this.dataContent.usingSite(this.testSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        FileModel fileModel2 = ((DataContent)this.dataContent.usingSite(this.testSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        ((ImapWrapper)((ImapWrapper)((ImapWrapper)this.imapProtocol.authenticateUser(this.testUser).usingSite(this.testSite).usingResource((ContentModel)fileModel1).assertThat().existsInRepo()).and()).assertThat().existsInImap().then()).usingSite(this.testSite).copyMessagesTo((ContentModel)this.testFolder).assertThat().containsMessages(new FileModel[]{fileModel1, fileModel2});
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager can copy empty file via IMAP client to a different location")
    @Test(groups={"protocols", "imap", "core"})
    public void siteManagerShouldCopyEmptyFile() throws Exception {
        this.testFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createFolder();
        FileModel fileModel = new FileModel("EmptyFile.txt", FileType.TEXT_PLAIN, "");
        fileModel = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createContent(fileModel);
        ((ImapWrapper)((ImapWrapper)((ImapWrapper)this.imapProtocol.authenticateUser(this.testUser).usingSite(this.testSite).usingResource((ContentModel)fileModel).assertThat().existsInRepo()).and()).assertThat().existsInImap().then()).copyMessageTo((ContentModel)this.testFolder).assertThat().containsMessages(new FileModel[]{fileModel});
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify user can copy file via IMAP client to a location where the message already exists")
    @Test(groups={"protocols", "imap", "core"})
    public void userShouldCopyFileWhereAlreadyExists() throws Exception {
        this.testFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createFolder();
        FileModel fileModel = new FileModel("CopyFile.txt", FileType.TEXT_PLAIN, "content of copied file");
        ((DataContent)((DataContent)this.dataContent.usingSite(this.testSite)).usingResource((ContentModel)this.testFolder)).createContent(fileModel);
        FileModel fileToBeCopied = ((DataContent)this.dataContent.usingSite(this.testSite)).createContent(fileModel);
        ((ImapWrapper)((ImapWrapper)((ImapWrapper)this.imapProtocol.authenticateUser(this.testUser).usingSite(this.testSite).usingResource((ContentModel)fileToBeCopied).assertThat().existsInRepo()).and()).assertThat().existsInImap().then()).copyMessageTo((ContentModel)this.testFolder).assertThat().containsMessages(new FileModel[]{fileToBeCopied});
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify user cannot copy a file via IMAP client if it was already deleted from repository")
    @Test(groups={"protocols", "imap", "core"}, expectedExceptions={MessagingException.class}, expectedExceptionsMessageRegExp="There are no messages to be copied")
    public void userCannotCopyDeletedFile() throws Exception {
        this.testFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createFolder();
        FileModel fileModel = ((DataContent)this.dataContent.usingSite(this.testSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.imapProtocol.authenticateUser(this.testUser).usingSite(this.testSite).usingResource((ContentModel)fileModel).assertThat().existsInImap();
        ((DataContent)this.dataContent.usingResource((ContentModel)fileModel)).deleteContent();
        this.imapProtocol.copyMessageTo((ContentModel)this.testFolder);
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify user cannot copy file via IMAP client to a location where you don't have permissions")
    @Test(groups={"protocols", "imap", "core"}, expectedExceptions={MessagingException.class}, expectedExceptionsMessageRegExp=".*NO APPEND failed. Can't append message - Permission denied.*")
    public void userCannotCopyFileWhereNoPermissions() throws Exception {
        this.testFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createFolder();
        UserModel user = this.dataUser.createRandomTestUser();
        SiteModel site = ((DataSite)this.dataSite.usingUser(user)).createIMAPSite();
        FileModel file = ((DataContent)this.dataContent.usingUser(user).usingSite(site)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        ((DataSite)((DataSite)this.dataSite.usingUser(user)).usingSite(this.testSite)).setIMAPFavorite();
        ((ImapWrapper)((ImapWrapper)((ImapWrapper)this.imapProtocol.authenticateUser(user).usingSite(site).usingResource((ContentModel)file).assertThat().existsInRepo()).and()).assertThat().existsInImap().then()).copyMessageTo((ContentModel)this.testFolder);
    }
}

