/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.email.imap;

import org.alfresco.email.EmailTest;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.testng.annotations.Test;

public class ImapSearchMessagesTests
extends EmailTest {
    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.SANITY}, description="Verify that no results are returned when searching for a message name term with no match")
    @Test(groups={"protocols", "imap", "sanity"})
    public void noResultsReturnedWhenSearchingForNotExistingMessage() throws Exception {
        this.testUser = this.dataUser.createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createIMAPSite();
        this.testFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createFolder();
        String fileName1 = "File-new1";
        FileModel fileModel1 = ((DataContent)((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).usingResource((ContentModel)this.testFolder)).createContent(new FileModel(fileName1, fileName1, fileName1 + "description", FileType.TEXT_PLAIN, fileName1 + "content"));
        String fileName2 = "File2";
        FileModel fileModel2 = ((DataContent)((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).usingResource((ContentModel)this.testFolder)).createContent(new FileModel(fileName2, fileName2, fileName2 + "description", FileType.TEXT_PLAIN, fileName2 + "content"));
        this.imapProtocol.authenticateUser(this.testUser).usingSite(this.testSite).usingResource((ContentModel)this.testFolder).searchSubjectFor("new").assertThat().resultsContainMessage(new FileModel[]{fileModel1}).assertThat().resultsDoNotContainMessage(new FileModel[]{fileModel2});
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.SANITY}, description="Verify that searched message is returned when searching for full message name")
    @Test(groups={"protocols", "imap", "sanity"})
    public void searchedMessageIsReturnedWhenSearchingForFullMessageName() throws Exception {
        this.testUser = this.dataUser.createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createIMAPSite();
        this.testFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createFolder();
        String fileName1 = "File-new1";
        FileModel fileModel1 = ((DataContent)((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).usingResource((ContentModel)this.testFolder)).createContent(new FileModel(fileName1, fileName1, fileName1 + "description", FileType.TEXT_PLAIN, fileName1 + "content"));
        String fileName2 = "File2";
        FileModel fileModel2 = ((DataContent)((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).usingResource((ContentModel)this.testFolder)).createContent(new FileModel(fileName2, fileName2, fileName2 + "description", FileType.TEXT_PLAIN, fileName2 + "content"));
        this.imapProtocol.authenticateUser(this.testUser).usingSite(this.testSite).usingResource((ContentModel)this.testFolder).searchSubjectFor("File2").assertThat().resultsContainMessage(new FileModel[]{fileModel2}).assertThat().resultsDoNotContainMessage(new FileModel[]{fileModel1});
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify that search results are returned for search term containing white spaces")
    @Test(groups={"protocols", "imap", "core"})
    public void siteManagerVerifySearchResultsForWhiteSpaces() throws Exception {
        this.testUser = this.dataUser.createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createIMAPSite();
        String fileName1 = "File new";
        FileModel fileModel1 = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createContent(new FileModel(fileName1, fileName1, fileName1 + "description", FileType.TEXT_PLAIN, fileName1 + "content"));
        String fileName2 = "File new1";
        FileModel fileModel2 = ((DataContent)this.dataContent.usingSite(this.testSite)).createContent(new FileModel(fileName2, fileName2, fileName2 + "description", FileType.TEXT_PLAIN, fileName2 + "content"));
        this.imapProtocol.authenticateUser(this.testUser).usingSite(this.testSite).searchSubjectFor("File new").assertThat().resultsContainMessage(new FileModel[]{fileModel1, fileModel2});
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify that search results are returned for search term containing wildcards")
    @Test(groups={"protocols", "imap", "core"})
    public void siteManagerVerifySearchResultsForWildcards() throws Exception {
        this.testUser = this.dataUser.createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createIMAPSite();
        String fileName1 = "File new 1";
        FileModel fileModel1 = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createContent(new FileModel(fileName1, fileName1, fileName1 + "description", FileType.TEXT_PLAIN, fileName1 + "content"));
        String fileName2 = "File presentation 2";
        FileModel fileModel2 = ((DataContent)this.dataContent.usingSite(this.testSite)).createContent(new FileModel(fileName2, fileName2, fileName2 + "description", FileType.TEXT_PLAIN, fileName2 + "content"));
        this.imapProtocol.authenticateUser(this.testUser).usingSite(this.testSite).searchSubjectWithWildcardsFor("File.*1.*").assertThat().resultsContainMessage(new FileModel[]{fileModel1}).assertThat().resultsDoNotContainMessage(new FileModel[]{fileModel2});
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify that search results are returned for search term containing special characters")
    @Test(groups={"protocols", "imap", "core"})
    public void siteManagerVerifySearchResultsForSpecialCharacters() throws Exception {
        this.testUser = this.dataUser.createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createIMAPSite();
        String fileName1 = "File@#$%^&()-_=+-[]{};'";
        FileModel fileModel1 = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createContent(new FileModel(fileName1, fileName1, fileName1 + "description", FileType.TEXT_PLAIN, fileName1 + "content"));
        String fileName2 = "File";
        FileModel fileModel2 = ((DataContent)this.dataContent.usingSite(this.testSite)).createContent(new FileModel(fileName2, fileName2, fileName2 + "description", FileType.TEXT_PLAIN, fileName2 + "content"));
        this.imapProtocol.authenticateUser(this.testUser).usingSite(this.testSite).searchSubjectFor("=").assertThat().resultsContainMessage(new FileModel[]{fileModel1}).assertThat().resultsDoNotContainMessage(new FileModel[]{fileModel2}).searchSubjectFor("@").assertThat().resultsContainMessage(new FileModel[]{fileModel1}).assertThat().resultsDoNotContainMessage(new FileModel[]{fileModel2}).searchSubjectFor("#").assertThat().resultsContainMessage(new FileModel[]{fileModel1}).assertThat().resultsDoNotContainMessage(new FileModel[]{fileModel2}).searchSubjectFor("$").assertThat().resultsContainMessage(new FileModel[]{fileModel1}).assertThat().resultsDoNotContainMessage(new FileModel[]{fileModel2}).searchSubjectFor("@#").assertThat().resultsContainMessage(new FileModel[]{fileModel1}).assertThat().resultsDoNotContainMessage(new FileModel[]{fileModel2}).searchSubjectFor("[]").assertThat().resultsContainMessage(new FileModel[]{fileModel1}).assertThat().resultsDoNotContainMessage(new FileModel[]{fileModel2});
    }
}

