/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.email.imap;

import org.alfresco.email.EmailTest;
import org.alfresco.email.ImapWrapper;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.exception.TestConfigurationException;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ImapConnectionTests
extends EmailTest {
    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.testUser = this.dataUser.createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createIMAPSite();
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.SANITY}, description="Verify user can connect successfully to IMAP")
    @Test(groups={"protocols", "imap", "sanity"})
    public void correctUserConnectsToIMAPSuccessfully() throws Exception {
        ((ImapWrapper)this.imapProtocol.authenticateUser(this.testUser).then()).assertThat().userIsConnected();
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.SANITY}, description="Verify user fails to connect to IMAP on different port")
    @Test(groups={"protocols", "imap", "sanity"}, expectedExceptions={TestConfigurationException.class})
    public void userFailsConnectToIMAPOnDifferentPort() throws Exception {
        ((ImapWrapper)this.imapProtocol.authenticateUser(this.testUser, 43).then()).assertThat().userIsNotConnected();
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.SANITY}, description="Verify user can disconnect successfully from IMAP Server")
    @Test(groups={"protocols", "imap", "sanity"})
    public void userDisconnectsFromImapServerSuccessfully() throws Exception {
        ((ImapWrapper)this.imapProtocol.authenticateUser(this.testUser).disconnect().then()).assertThat().userIsNotConnected();
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify user fails to connect to IMAP on different host")
    @Test(groups={"protocols", "imap", "core"}, expectedExceptions={TestConfigurationException.class})
    public void userFailsConnectToIMAPOnDifferentHost() throws Exception {
        ((ImapWrapper)this.imapProtocol.authenticateUser(this.testUser, "172.29.101.1256").then()).assertThat().userIsNotConnected();
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify existing user with wrong password fails to connect to IMAP")
    @Test(groups={"protocols", "imap", "core"}, expectedExceptions={TestConfigurationException.class}, expectedExceptionsMessageRegExp=".*You missed some configuration settings in your tests: User failed to connect to IMAP server LOGIN failed. Invalid login/password$")
    public void userFailsConnectToIMAPWithWrongPassword() throws Exception {
        this.testUser = this.dataUser.createRandomTestUser();
        this.testUser.setPassword("invalid");
        this.imapProtocol.authenticateUser(this.testUser);
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify a non existing user fails to connect to IMAP.")
    @Test(groups={"protocols", "imap", "full"}, expectedExceptions={TestConfigurationException.class}, expectedExceptionsMessageRegExp=".*You missed some configuration settings in your tests: User failed to connect to IMAP server LOGIN failed. Invalid login/password")
    public void nonExistentUserFailsConnectToIMAP() throws Exception {
        this.imapProtocol.authenticateUser(new UserModel("nonExistingUser", "pass"));
    }
}

