/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.email.imap;

import jakarta.mail.FolderNotFoundException;
import jakarta.mail.MessagingException;
import org.alfresco.dataprep.CMISUtil;
import org.alfresco.email.EmailTest;
import org.alfresco.email.ImapWrapper;
import org.alfresco.utility.Utility;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ImapCopyFolderTests
extends EmailTest {
    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.testUser = this.dataUser.createRandomTestUser();
        this.adminSite = ((DataSite)this.dataSite.usingAdmin()).createIMAPSite();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createIMAPSite();
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.SANITY}, description="Verify copy non-empty folder to a different location by admin user")
    @Test(groups={"protocols", "imap", "sanity"})
    public void adminShouldCopyNonEmptyFolder() throws Exception {
        this.testFolder = ((DataContent)this.dataContent.usingAdmin().usingSite(this.adminSite)).createFolder();
        FolderModel copyFolder = ((DataContent)this.dataContent.usingAdmin().usingSite(this.adminSite)).createFolder();
        FolderModel copiedFolder = this.testFolder;
        copiedFolder.setProtocolLocation(Utility.buildPath((String)copyFolder.getProtocolLocation(), (String[])new String[]{this.testFolder.getName()}));
        ((DataContent)this.dataContent.usingResource((ContentModel)this.testFolder)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        ((ImapWrapper)this.imapProtocol.authenticateUser(this.adminUser).usingSite(this.adminSite).usingResource((ContentModel)this.testFolder).copyTo((ContentModel)copyFolder).then()).usingResource((ContentModel)copiedFolder).assertThat().countMessagesIs(1);
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.SANITY}, description="Verify copy folder with Manager")
    @Test(groups={"protocols", "imap", "sanity"})
    public void siteManagerShouldCopyFolder() throws Exception {
        this.testFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createFolder();
        FolderModel copyFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createFolder();
        FolderModel copiedFolder = this.testFolder;
        copiedFolder.setCmisLocation(Utility.buildPath((String)copyFolder.getCmisLocation(), (String[])new String[]{this.testFolder.getName()}));
        copiedFolder.setProtocolLocation(Utility.buildPath((String)copyFolder.getProtocolLocation(), (String[])new String[]{this.testFolder.getName()}));
        ((ImapWrapper)((ImapWrapper)this.imapProtocol.authenticateUser(this.testUser).usingSite(this.testSite).usingResource((ContentModel)this.testFolder).copyTo((ContentModel)copyFolder).then()).usingResource((ContentModel)copiedFolder).assertThat().existsInRepo()).assertThat().existsInImap();
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify copy folder that has been deleted with Manager")
    @Test(groups={"protocols", "imap", "core"}, expectedExceptions={FolderNotFoundException.class})
    public void siteManagerShouldNotCopyFolderThatHasBeenDeleted() throws Exception {
        this.testFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createFolder();
        FolderModel folderModel = ((DataContent)((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).usingResource((ContentModel)this.testFolder)).createFolder();
        ((ImapWrapper)((ImapWrapper)((ImapWrapper)this.imapProtocol.authenticateUser(this.testUser).usingSite(this.testSite).usingResource((ContentModel)folderModel).delete().and()).assertThat().doesNotExistInRepo()).assertThat().doesNotContain(new FolderModel[]{folderModel}).then()).copyTo((ContentModel)this.testFolder);
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify copy folder with Contributor user")
    @Test(groups={"protocols", "imap", "core"})
    public void contributorShouldCopyFolder() throws Exception {
        UserModel contributorUser = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(contributorUser, this.testSite, UserRole.SiteContributor);
        this.testFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createFolder();
        FolderModel copyFolder = ((DataContent)this.dataContent.usingUser(contributorUser).usingSite(this.testSite)).createFolder();
        FolderModel copiedFolder = this.testFolder;
        copiedFolder.setProtocolLocation(Utility.buildPath((String)copyFolder.getProtocolLocation(), (String[])new String[]{this.testFolder.getName()}));
        ((DataContent)this.dataContent.usingResource((ContentModel)this.testFolder)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        ((ImapWrapper)this.imapProtocol.authenticateUser(contributorUser).usingSite(this.testSite).usingResource((ContentModel)this.testFolder).copyTo((ContentModel)copyFolder).then()).usingResource((ContentModel)copiedFolder).assertThat().countMessagesIs(1);
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify copy folder with Collaborator user")
    @Test(groups={"protocols", "imap", "core"})
    public void collaboratorShouldCopyFolder() throws Exception {
        UserModel collaboratorUser = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(collaboratorUser, this.testSite, UserRole.SiteCollaborator);
        this.testFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createFolder();
        FolderModel copyFolder = ((DataContent)this.dataContent.usingUser(collaboratorUser).usingSite(this.testSite)).createFolder();
        FolderModel copiedFolder = this.testFolder;
        copiedFolder.setProtocolLocation(Utility.buildPath((String)copyFolder.getProtocolLocation(), (String[])new String[]{this.testFolder.getName()}));
        ((DataContent)this.dataContent.usingResource((ContentModel)this.testFolder)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        ((ImapWrapper)this.imapProtocol.authenticateUser(collaboratorUser).usingSite(this.testSite).usingResource((ContentModel)this.testFolder).copyTo((ContentModel)copyFolder).then()).usingResource((ContentModel)copiedFolder).assertThat().countMessagesIs(1);
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify that copy folder with Consumer user is not possible")
    @Test(groups={"protocols", "imap", "core"}, expectedExceptions={FolderNotFoundException.class})
    public void consumerShouldNotCopyFolder() throws Exception {
        UserModel consumerUser = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(consumerUser, this.testSite, UserRole.SiteConsumer);
        this.testFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createFolder();
        FolderModel copyFolder = new FolderModel("copyFolder");
        this.imapProtocol.authenticateUser(consumerUser).usingSite(this.testSite).createFolder(copyFolder).usingResource((ContentModel)this.testFolder).copyTo((ContentModel)copyFolder);
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify copy folder to a location for which the user does not have permission")
    @Test(groups={"protocols", "imap", "core"}, expectedExceptions={MessagingException.class})
    public void userCopyFolderToALocationThatHeDoesNotHaveAccess() throws Exception {
        SiteModel siteModel = ((DataSite)this.dataSite.usingAdmin()).createPrivateRandomSite();
        this.testFolder = ((DataContent)this.dataContent.usingAdmin().usingSite(this.testSite)).createFolder();
        FolderModel copyFolder = ((DataContent)this.dataContent.usingAdmin().usingSite(siteModel)).createFolder();
        ((DataContent)this.dataContent.usingResource((ContentModel)this.testFolder)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.imapProtocol.authenticateUser(this.testUser).usingResource((ContentModel)this.testFolder).copyTo((ContentModel)copyFolder);
    }
}

