/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.email.imap;

import jakarta.mail.FolderNotFoundException;
import org.alfresco.email.EmailTest;
import org.alfresco.email.ImapWrapper;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.exception.TestConfigurationException;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.commons.lang3.RandomStringUtils;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ImapRenameFolderTests
extends EmailTest {
    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.testUser = this.dataUser.createRandomTestUser();
        this.adminSite = ((DataSite)this.dataSite.usingAdmin()).createIMAPSite();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createIMAPSite();
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.SANITY}, description="Verify rename folder by admin user")
    @Test(groups={"protocols", "imap", "sanity"})
    public void adminShouldRenameFolder() throws Exception {
        this.testFolder = ((DataContent)this.dataContent.usingAdmin().usingSite(this.adminSite)).createFolder();
        String newFolderName = RandomData.getRandomName((String)"Folder");
        this.imapProtocol.authenticateUser(this.adminUser).usingSite(this.adminSite).usingResource((ContentModel)this.testFolder).rename(newFolderName).usingSite(this.adminSite).assertThat().contains(new FolderModel[]{new FolderModel(newFolderName)}).assertThat().doesNotContain(new FolderModel[]{this.testFolder});
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.SANITY}, description="Verify renaming folder by user with MANAGER role")
    @Test(groups={"protocols", "imap", "sanity"})
    public void siteManagerShouldRenameFolder() throws Exception {
        this.testFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createFolder();
        String newFolderName = RandomData.getRandomName((String)"Folder");
        this.imapProtocol.authenticateUser(this.testUser).usingSite(this.testSite).usingResource((ContentModel)this.testFolder).rename(newFolderName).usingSite(this.testSite).assertThat().contains(new FolderModel[]{new FolderModel(newFolderName)}).assertThat().doesNotContain(new FolderModel[]{this.testFolder});
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify user with MANAGER role is not able to rename an nonexistent folder")
    @Test(groups={"protocols", "imap", "core"}, expectedExceptions={FolderNotFoundException.class})
    public void siteManagerShouldNotRenameNonExistentFolder() throws Exception {
        String newFolderName = RandomData.getRandomName((String)"Folder");
        ((ImapWrapper)this.imapProtocol.authenticateUser(this.testUser).usingSite(this.testSite).usingResource((ContentModel)FolderModel.getRandomFolderModel()).rename(newFolderName).assertThat().contains(new FolderModel[]{this.testFolder}).and()).assertThat().doesNotContain(new FolderModel[]{new FolderModel(newFolderName)});
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify user with MANAGER role is able to rename a folder with long name")
    @Test(groups={"protocols", "imap", "core"})
    public void siteManagerShouldRenameFolderWithLongName() throws Exception {
        this.testFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createFolder();
        String longName = RandomStringUtils.randomAlphabetic((int)200);
        this.imapProtocol.authenticateUser(this.testUser).usingSite(this.testSite).usingResource((ContentModel)this.testFolder).rename(longName).usingSite(this.testSite).assertThat().contains(new FolderModel[]{new FolderModel(longName)}).assertThat().doesNotContain(new FolderModel[]{this.testFolder});
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify unauthorized user is not able to rename a folder")
    @Test(groups={"protocols", "imap", "full"}, expectedExceptions={FolderNotFoundException.class})
    public void unauthorizedUserShouldNotRenameFolder() throws Exception {
        UserModel unauthorizedUser = this.dataUser.createRandomTestUser();
        this.testFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createFolder();
        ((DataSite)((DataSite)this.dataSite.usingUser(unauthorizedUser)).usingSite(this.testSite)).setIMAPFavorite();
        String newFolderName = RandomData.getRandomName((String)"Folder");
        ((ImapWrapper)((ImapWrapper)((ImapWrapper)this.imapProtocol.authenticateUser(unauthorizedUser).usingResource((ContentModel)this.testFolder).rename(newFolderName).then()).assertThat().doesNotExistInRepo()).assertThat().contains(new FolderModel[]{this.testFolder}).and()).assertThat().doesNotContain(new FolderModel[]{new FolderModel(newFolderName)});
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify inexistent user is not able to rename a folder")
    @Test(groups={"protocols", "imap", "core"}, expectedExceptions={TestConfigurationException.class}, expectedExceptionsMessageRegExp=".*You missed some configuration settings in your tests: User failed to connect to IMAP server LOGIN failed. Invalid login/password$")
    public void nonexistentUserShouldNotRenameFolder() throws Exception {
        this.testFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createFolder();
        String newFolderName = RandomData.getRandomName((String)"Folder");
        ((ImapWrapper)((ImapWrapper)((ImapWrapper)((ImapWrapper)this.imapProtocol.authenticateUser(UserModel.getRandomUserModel()).usingResource((ContentModel)this.testFolder).rename(newFolderName).then()).assertThat().doesNotExistInRepo()).and()).assertThat().contains(new FolderModel[]{this.testFolder}).and()).assertThat().doesNotContain(new FolderModel[]{new FolderModel(newFolderName)});
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify disconnected user is not able to rename a folder")
    @Test(groups={"protocols", "imap", "core"}, expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="Not connected")
    public void disconnectedUserShouldNotRenameFolder() throws Exception {
        this.testFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createFolder();
        String newFolderName = RandomData.getRandomName((String)"Folder");
        ((ImapWrapper)((ImapWrapper)((ImapWrapper)((ImapWrapper)((ImapWrapper)this.imapProtocol.authenticateUser(this.testUser).usingResource((ContentModel)this.testFolder).assertThat().existsInImap().then()).disconnect().usingResource((ContentModel)this.testFolder).rename(newFolderName).then()).assertThat().doesNotExistInRepo()).and()).assertThat().contains(new FolderModel[]{this.testFolder}).and()).assertThat().doesNotContain(new FolderModel[]{new FolderModel(newFolderName)});
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify renaming folder by user with COLLABORATOR role - folder created by self")
    @Test(groups={"protocols", "imap", "core"})
    public void collaboratorShouldRenameFolderCreatedBySelf() throws Exception {
        UserModel collaboratorUser = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.testUser)).addUserToSite(collaboratorUser, this.testSite, UserRole.SiteCollaborator);
        ((DataSite)((DataSite)this.dataSite.usingUser(collaboratorUser)).usingSite(this.testSite)).setIMAPFavorite();
        this.testFolder = ((DataContent)this.dataContent.usingUser(collaboratorUser).usingSite(this.testSite)).createFolder();
        String newFolderName = RandomData.getRandomName((String)"Folder");
        this.imapProtocol.authenticateUser(collaboratorUser).usingSite(this.testSite).usingResource((ContentModel)this.testFolder).rename(newFolderName).usingSite(this.testSite).assertThat().contains(new FolderModel[]{new FolderModel(newFolderName)}).assertThat().doesNotContain(new FolderModel[]{this.testFolder});
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify user with COLLABORATOR role is not able to rename a folder created by other user")
    @Test(groups={"protocols", "imap", "core"})
    public void collaboratorShouldNotRenameFolderCreatedByOtherUser() throws Exception {
        UserModel collaboratorUser = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.testUser)).addUserToSite(collaboratorUser, this.testSite, UserRole.SiteCollaborator);
        ((DataSite)((DataSite)this.dataSite.usingUser(collaboratorUser)).usingSite(this.testSite)).setIMAPFavorite();
        this.testFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createFolder();
        String newFolderName = RandomData.getRandomName((String)"Folder");
        this.imapProtocol.authenticateUser(collaboratorUser).usingResource((ContentModel)this.testFolder).rename(newFolderName).usingSite(this.testSite).assertThat().contains(new FolderModel[]{this.testFolder}).assertThat().doesNotContain(new FolderModel[]{new FolderModel(newFolderName)});
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify user with CONTRIBUTOR role is able to rename a folder created by self")
    @Test(groups={"protocols", "imap", "core"})
    public void contributorShouldRenameFolderCreatedBySelf() throws Exception {
        UserModel contributorUser = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.testUser)).addUserToSite(contributorUser, this.testSite, UserRole.SiteContributor);
        ((DataSite)((DataSite)this.dataSite.usingUser(contributorUser)).usingSite(this.testSite)).setIMAPFavorite();
        this.testFolder = ((DataContent)this.dataContent.usingUser(contributorUser).usingSite(this.testSite)).createFolder();
        String newFolderName = RandomData.getRandomName((String)"Folder");
        this.imapProtocol.authenticateUser(contributorUser).usingSite(this.testSite).usingResource((ContentModel)this.testFolder).rename(newFolderName).usingSite(this.testSite).assertThat().contains(new FolderModel[]{new FolderModel(newFolderName)}).assertThat().doesNotContain(new FolderModel[]{this.testFolder});
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify user with CONTRIBUTOR role is NOT able to rename a folder created by other user")
    @Test(groups={"protocols", "imap", "core"})
    public void contributorShouldNotRenameFolderCreatedByOtherUser() throws Exception {
        UserModel contributorUser = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.testUser)).addUserToSite(contributorUser, this.testSite, UserRole.SiteContributor);
        ((DataSite)((DataSite)this.dataSite.usingUser(contributorUser)).usingSite(this.testSite)).setIMAPFavorite();
        FolderModel testFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createFolder();
        String newFolderName = RandomData.getRandomName((String)"Folder");
        ((ImapWrapper)((ImapWrapper)this.imapProtocol.authenticateUser(contributorUser).usingSite(this.testSite).usingResource((ContentModel)testFolder).rename(newFolderName).usingSite(this.testSite).then()).assertThat().contains(new FolderModel[]{testFolder}).and()).assertThat().doesNotContain(new FolderModel[]{new FolderModel(newFolderName)});
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify user with CONSUMER role is not able to rename a folder created by other user")
    @Test(groups={"protocols", "imap", "full"})
    public void consumerShouldNotRenameFolderCreatedByOtherUser() throws Exception {
        UserModel consumer = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.testUser)).addUserToSite(consumer, this.testSite, UserRole.SiteConsumer);
        ((DataSite)((DataSite)this.dataSite.usingUser(consumer)).usingSite(this.testSite)).setIMAPFavorite();
        FolderModel testFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createFolder();
        String newFolderName = RandomData.getRandomName((String)"Folder");
        ((ImapWrapper)((ImapWrapper)this.imapProtocol.authenticateUser(consumer).usingSite(this.testSite).usingResource((ContentModel)testFolder).rename(newFolderName).usingSite(this.testSite).then()).assertThat().contains(new FolderModel[]{testFolder}).and()).assertThat().doesNotContain(new FolderModel[]{new FolderModel(newFolderName)});
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify renaming folder fails when it was deleted by another user")
    @Test(groups={"protocols", "imap", "full"}, expectedExceptions={FolderNotFoundException.class})
    public void userCannotRenameFolderDeletedByAnotherUser() throws Exception {
        UserModel contributorUser = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.testUser)).addUserToSite(contributorUser, this.testSite, UserRole.SiteContributor);
        FolderModel testFolder = FolderModel.getRandomFolderModel();
        ((DataSite)((DataSite)this.dataSite.usingUser(contributorUser)).usingSite(this.testSite)).setIMAPFavorite();
        ((ImapWrapper)this.imapProtocol.authenticateUser(contributorUser).usingSite(this.testSite).createFolder(testFolder).assertThat().existsInRepo()).assertThat().existsInImap().delete().disconnect();
        this.imapProtocol.authenticateUser(this.testUser).usingSite(this.testSite).usingResource((ContentModel)testFolder).rename("deletedFolderRename");
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify user can rename folder to a name that contains white spaces")
    @Test(groups={"protocols", "imap", "full"})
    public void userCanRenameFolderToAFolderThatContainsWhiteSpaces() throws Exception {
        FolderModel testFolder = FolderModel.getRandomFolderModel();
        ((ImapWrapper)((ImapWrapper)((ImapWrapper)this.imapProtocol.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(testFolder).and()).assertThat().existsInRepo()).assertThat().existsInImap().rename("folder with name that contains spaces").then()).usingSite(this.testSite).assertThat().contains(new FolderModel[]{new FolderModel("folder with name that contains spaces")}).assertThat().doesNotContain(new FolderModel[]{testFolder});
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify user can rename folder successfully with name that contains special characters")
    @Test(groups={"protocols", "imap", "full"})
    public void userCanRenameFolderWithSpecialCharacters() throws Exception {
        FolderModel testFolder = FolderModel.getRandomFolderModel();
        ((ImapWrapper)((ImapWrapper)((ImapWrapper)this.imapProtocol.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(testFolder).and()).assertThat().existsInRepo()).assertThat().existsInImap().rename("(a)[b]!#%^").then()).usingSite(this.testSite).assertThat().contains(new FolderModel[]{new FolderModel("(a)[b]!#%^")}).assertThat().doesNotContain(new FolderModel[]{testFolder});
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify user can rename folder successfully with name that contains symbols")
    @Test(groups={"protocols", "imap", "full"})
    public void userCanRenameFolderWithSymbols() throws Exception {
        FolderModel testFolder = FolderModel.getRandomFolderModel();
        ((ImapWrapper)((ImapWrapper)((ImapWrapper)this.imapProtocol.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(testFolder).and()).assertThat().existsInRepo()).assertThat().existsInImap().rename("a\u00a3\u00a5\u20ac$\u264a\u264e \u264f \u2650 \u2651 \u2652 \u2653").then()).usingSite(this.testSite).assertThat().contains(new FolderModel[]{new FolderModel("a\u00a3\u00a5\u20ac$\u264a\u264e \u264f \u2650 \u2651 \u2652 \u2653")}).assertThat().doesNotContain(new FolderModel[]{testFolder});
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify user cannot create folder with name omega\u03a9_<>./?")
    @Test(groups={"protocols", "imap", "full"})
    public void userCannotRenameFolderWithNameThatContainsRestrictedCharacters() throws Exception {
        FolderModel testFolder = FolderModel.getRandomFolderModel();
        ((ImapWrapper)((ImapWrapper)((ImapWrapper)this.imapProtocol.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(testFolder).and()).assertThat().existsInRepo()).assertThat().existsInImap().rename("omega\u03a9_<>./?").then()).usingSite(this.testSite).assertThat().contains(new FolderModel[]{testFolder}).assertThat().doesNotContain(new FolderModel[]{new FolderModel("omega\u03a9_<>./?")});
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify renaming folder fails when it was renamed by another user")
    @Test(groups={"protocols", "imap", "full"}, expectedExceptions={FolderNotFoundException.class})
    public void userCannotRenameFolderRenamedByAnotherUser() throws Exception {
        UserModel contributorUser = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.testUser)).addUserToSite(contributorUser, this.testSite, UserRole.SiteContributor);
        FolderModel testFolder = FolderModel.getRandomFolderModel();
        ((DataSite)((DataSite)this.dataSite.usingUser(contributorUser)).usingSite(this.testSite)).setIMAPFavorite();
        ((ImapWrapper)this.imapProtocol.authenticateUser(contributorUser).usingSite(this.testSite).createFolder(testFolder).assertThat().existsInRepo()).assertThat().existsInImap().rename("folderRenamedByUser").disconnect();
        this.imapProtocol.authenticateUser(this.testUser).usingSite(this.testSite).usingResource((ContentModel)testFolder).rename("deletedFolderRename");
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify a site folder cannot be renamed via IMAP client")
    @Test(groups={"protocols", "imap", "full"})
    public void verifyASiteFolderCannotBeRenamedViaImap() throws Exception {
        SiteModel siteModel = ((DataSite)this.dataSite.usingUser(this.testUser)).createIMAPSite();
        ((ImapWrapper)((ImapWrapper)((ImapWrapper)this.imapProtocol.authenticateUser(this.testUser).usingSiteRoot(siteModel).rename("new site name").and()).assertThat().doesNotExistInRepo()).then()).usingSites().assertThat().doesNotContain(new FolderModel[]{new FolderModel("new site name")});
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify renaming folder by changing the case")
    @Test(groups={"protocols", "imap", "full"})
    public void verifyFolderCanBeRenamedByChangingTheCase() throws Exception {
        FolderModel testFolder = FolderModel.getRandomFolderModel();
        ((ImapWrapper)((ImapWrapper)((ImapWrapper)this.imapProtocol.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(testFolder).and()).assertThat().existsInRepo()).assertThat().existsInImap().rename(testFolder.getName().toUpperCase()).then()).usingSite(this.testSite).assertThat().contains(new FolderModel[]{new FolderModel(testFolder.getName().toUpperCase())}).assertThat().doesNotContain(new FolderModel[]{testFolder});
    }
}

