/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.email.imap;

import jakarta.mail.FolderNotFoundException;
import jakarta.mail.MessagingException;
import org.alfresco.email.EmailTest;
import org.alfresco.email.ImapWrapper;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ImapCheckFolderTests
extends EmailTest {
    UserModel managerUser;
    SiteModel managerTestSite;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.managerUser = this.dataUser.createRandomTestUser();
        this.managerTestSite = ((DataSite)this.dataSite.usingUser(this.managerUser)).createIMAPSite();
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.SANITY}, description="Returns the current working directory with admin user")
    @Test(groups={"protocols", "imap", "sanity"})
    public void adminShouldGetCurrentWorkingDirectory() throws Exception {
        this.testUser = this.dataUser.getAdminUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createIMAPSite();
        this.testFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createFolder();
        ((ImapWrapper)((ImapWrapper)this.imapProtocol.authenticateUser(this.testUser).usingSite(this.testSite).usingResource((ContentModel)this.testFolder).assertThat().existsInRepo()).then()).assertThat().currentDirectoryIs((ContentModel)this.testFolder);
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.SANITY}, description="Verify in IMAP client current directory/list of directories for site manager")
    @Test(groups={"protocols", "imap", "sanity"})
    public void siteManagerShouldGetCurrentWorkingDirectory() throws Exception {
        this.testFolder = ((DataContent)this.dataContent.usingUser(this.managerUser).usingSite(this.managerTestSite)).createFolder();
        ((ImapWrapper)((ImapWrapper)this.imapProtocol.authenticateUser(this.managerUser).usingSite(this.managerTestSite).usingResource((ContentModel)this.testFolder).assertThat().existsInRepo()).then()).assertThat().currentDirectoryIs((ContentModel)this.testFolder);
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.SANITY}, description="Returns the directories list of the root for site manager")
    @Test(groups={"protocols", "imap", "sanity"})
    public void siteManagerShouldGetDirectoriesListOfRoot() throws Exception {
        this.testUser = this.dataUser.createRandomTestUser();
        FolderModel alfrescoImap = FolderModel.getRandomFolderModel();
        alfrescoImap.setName("Alfresco IMAP");
        FolderModel inbox = FolderModel.getRandomFolderModel();
        inbox.setName("INBOX");
        ((ImapWrapper)((ImapWrapper)this.imapProtocol.authenticateUser(this.testUser).usingRoot()).then()).assertThat().contains(new FolderModel[]{alfrescoImap, inbox});
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.SANITY}, description="User finds all its folders for IMAP Sites in Alfresco IMAP > Sites folder")
    @Test(groups={"protocols", "imap", "sanity"})
    public void userShouldFindAllIMAPSitesFoldersInAlfrescoIMAPFolder() throws Exception {
        this.testUser = this.dataUser.createRandomTestUser();
        SiteModel imapSite1 = ((DataSite)this.dataSite.usingUser(this.testUser)).createIMAPSite();
        SiteModel imapSite2 = ((DataSite)this.dataSite.usingUser(this.testUser)).createIMAPSite();
        ((ImapWrapper)this.imapProtocol.authenticateUser(this.testUser).usingSites().assertThat().existsInImap().then()).assertThat().contains(new SiteModel[]{imapSite1, imapSite2});
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify in IMAP client current directory/list of directories for COLLABORATOR user - folder created by other user")
    @Test(groups={"protocols", "imap", "core"})
    public void collaboratorShouldGetCurrentWorkingDirectory() throws Exception {
        UserModel collaborator = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.managerUser)).addUserToSite(collaborator, this.managerTestSite, UserRole.SiteCollaborator);
        this.testFolder = ((DataContent)this.dataContent.usingUser(this.managerUser).usingSite(this.managerTestSite)).createFolder();
        ((ImapWrapper)((ImapWrapper)this.imapProtocol.authenticateUser(collaborator).usingSite(this.managerTestSite).usingResource((ContentModel)this.testFolder).assertThat().existsInRepo()).then()).assertThat().currentDirectoryIs((ContentModel)this.testFolder);
        ((DataSite)((DataSite)this.dataSite.usingUser(collaborator)).usingSite(this.managerTestSite)).setIMAPFavorite();
        FolderModel testFolder1 = ((DataContent)((DataContent)this.dataContent.usingUser(this.managerUser).usingSite(this.managerTestSite)).usingResource((ContentModel)this.testFolder)).createFolder();
        FolderModel testFolder2 = ((DataContent)((DataContent)this.dataContent.usingUser(this.managerUser).usingSite(this.managerTestSite)).usingResource((ContentModel)this.testFolder)).createFolder();
        ((ImapWrapper)this.imapProtocol.authenticateUser(collaborator).usingSite(this.managerTestSite).usingResource((ContentModel)this.testFolder).then()).assertThat().contains(new FolderModel[]{testFolder1, testFolder2});
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify in IMAP client current directory/list of directories for CONTRIBUTOR user - folder created by other user")
    @Test(groups={"protocols", "imap", "core"})
    public void contributorShouldGetCurrentWorkingDirectory() throws Exception {
        UserModel contributor = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.managerUser)).addUserToSite(contributor, this.managerTestSite, UserRole.SiteContributor);
        this.testFolder = ((DataContent)this.dataContent.usingUser(this.managerUser).usingSite(this.managerTestSite)).createFolder();
        ((ImapWrapper)((ImapWrapper)this.imapProtocol.authenticateUser(contributor).usingSite(this.managerTestSite).usingResource((ContentModel)this.testFolder).assertThat().existsInRepo()).then()).assertThat().currentDirectoryIs((ContentModel)this.testFolder);
        ((DataSite)((DataSite)this.dataSite.usingUser(contributor)).usingSite(this.managerTestSite)).setIMAPFavorite();
        FolderModel testFolder1 = ((DataContent)((DataContent)this.dataContent.usingUser(this.managerUser).usingSite(this.managerTestSite)).usingResource((ContentModel)this.testFolder)).createFolder();
        FolderModel testFolder2 = ((DataContent)((DataContent)this.dataContent.usingUser(this.managerUser).usingSite(this.managerTestSite)).usingResource((ContentModel)this.testFolder)).createFolder();
        ((ImapWrapper)this.imapProtocol.authenticateUser(contributor).usingSite(this.managerTestSite).usingResource((ContentModel)this.testFolder).then()).assertThat().contains(new FolderModel[]{testFolder1, testFolder2});
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify in IMAP client current directory/list of directories for CONSUMER user - folder created by other user")
    @Test(groups={"protocols", "imap", "full"})
    public void consumerShouldGetCurrentWorkingDirectory() throws Exception {
        UserModel consumer = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.managerUser)).addUserToSite(consumer, this.managerTestSite, UserRole.SiteConsumer);
        this.testFolder = ((DataContent)this.dataContent.usingUser(this.managerUser).usingSite(this.managerTestSite)).createFolder();
        ((ImapWrapper)((ImapWrapper)this.imapProtocol.authenticateUser(consumer).usingSite(this.managerTestSite).usingResource((ContentModel)this.testFolder).assertThat().existsInRepo()).then()).assertThat().currentDirectoryIs((ContentModel)this.testFolder);
        ((DataSite)((DataSite)this.dataSite.usingUser(consumer)).usingSite(this.managerTestSite)).setIMAPFavorite();
        FolderModel testFolder1 = ((DataContent)((DataContent)this.dataContent.usingUser(this.managerUser).usingSite(this.managerTestSite)).usingResource((ContentModel)this.testFolder)).createFolder();
        FolderModel testFolder2 = ((DataContent)((DataContent)this.dataContent.usingUser(this.managerUser).usingSite(this.managerTestSite)).usingResource((ContentModel)this.testFolder)).createFolder();
        ((ImapWrapper)this.imapProtocol.authenticateUser(consumer).usingSite(this.managerTestSite).usingResource((ContentModel)this.testFolder).then()).assertThat().contains(new FolderModel[]{testFolder1, testFolder2});
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify unauthorized is not able to access document library section ( PUBLIC imap SITE)")
    @Test(groups={"protocols", "imap", "full"}, expectedExceptions={FolderNotFoundException.class})
    public void unAuthorizedUserCannotAccessPublicImapSiteDocumentLibrary() throws Exception {
        this.testUser = this.dataUser.createRandomTestUser();
        UserModel unauthorizedUser = this.dataUser.createRandomTestUser();
        SiteModel publicImapSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createPublicRandomSite();
        ((DataSite)((DataSite)this.dataSite.usingUser(unauthorizedUser)).usingSite(publicImapSite)).setIMAPFavorite();
        this.imapProtocol.authenticateUser(unauthorizedUser).usingSite(publicImapSite).assertThat().doesNotContain(new FolderModel[]{this.testFolder});
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify unauthorized is not able to access document library section ( Moderated imap SITE)")
    @Test(groups={"protocols", "imap", "full"}, expectedExceptions={FolderNotFoundException.class})
    public void unAuthorizedUserCannotAccessModeratedImapSiteDocumentLibrary() throws Exception {
        this.testUser = this.dataUser.createRandomTestUser();
        UserModel unauthorizedUser = this.dataUser.createRandomTestUser();
        SiteModel moderatedImapSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createModeratedRandomSite();
        ((DataSite)((DataSite)this.dataSite.usingUser(unauthorizedUser)).usingSite(moderatedImapSite)).setIMAPFavorite();
        this.imapProtocol.authenticateUser(unauthorizedUser).usingSite(moderatedImapSite).assertThat().doesNotContain(new FolderModel[]{this.testFolder});
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify unauthorized is not able to access document library section ( Private imap SITE)")
    @Test(groups={"protocols", "imap", "full"}, expectedExceptions={MessagingException.class}, expectedExceptionsMessageRegExp=".*Access Denied.*You do not have the appropriate permissions to perform this operation.*")
    public void unAuthorizedUserCannotAccessPrivateImapSiteDocumentLibrary() throws Exception {
        this.testUser = this.dataUser.createRandomTestUser();
        UserModel unauthorizedUser = this.dataUser.createRandomTestUser();
        SiteModel privateImapSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createPrivateRandomSite();
        ((DataSite)((DataSite)this.dataSite.usingUser(unauthorizedUser)).usingSite(privateImapSite)).setIMAPFavorite();
        this.imapProtocol.authenticateUser(unauthorizedUser).usingSite(privateImapSite).assertThat().doesNotContain(new FolderModel[]{this.testFolder});
    }
}

