/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.servlet.mvc;

import java.util.Locale;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.extensions.config.ConfigService;
import org.springframework.extensions.webscripts.Match;
import org.springframework.extensions.webscripts.RuntimeContainer;
import org.springframework.extensions.webscripts.servlet.ServletAuthenticatorFactory;
import org.springframework.extensions.webscripts.servlet.mvc.AbstractWebScriptViewResolver;
import org.springframework.extensions.webscripts.servlet.mvc.WebScriptView;
import org.springframework.web.servlet.view.AbstractUrlBasedView;

public class WebScriptViewResolver
extends AbstractWebScriptViewResolver
implements ApplicationListener {
    protected RuntimeContainer container;
    protected ConfigService configService;
    protected ServletAuthenticatorFactory authenticatorFactory;

    public WebScriptViewResolver() {
        Class viewClass = this.requiredViewClass();
        this.setViewClass(viewClass);
    }

    public void setContainer(RuntimeContainer container) {
        this.container = container;
    }

    public void setAuthenticatorFactory(ServletAuthenticatorFactory authenticatorFactory) {
        this.authenticatorFactory = authenticatorFactory;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        ContextRefreshedEvent refreshEvent;
        ApplicationContext refreshContext;
        if (event instanceof ContextRefreshedEvent && (refreshContext = (refreshEvent = (ContextRefreshedEvent)event).getApplicationContext()) != null && refreshContext.equals(this.getApplicationContext())) {
            this.onBootstrap();
        }
    }

    public void onBootstrap() {
        ApplicationContext context = this.getApplicationContext();
        this.configService = (ConfigService)context.getBean("web.config");
        if (this.container == null) {
            this.container = (RuntimeContainer)context.getBean("webscripts.container");
        }
        String authenticatorId = null;
        if (this.authenticatorFactory != null) {
            authenticatorId = this.authenticatorFactory.getClass().getName();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Initialised Web Script View Resolver (authenticator='" + authenticatorId + "')"));
        }
    }

    protected boolean canHandle(String viewName, Locale locale) {
        Match match;
        Object uri = viewName;
        if (uri != null && ((String)uri).length() != 0 && ((String)uri).charAt(0) != '/') {
            uri = "/" + (String)uri;
        }
        return (match = this.container.getRegistry().findWebScript("get", (String)uri)) != null;
    }

    protected AbstractUrlBasedView buildView(String viewName) throws Exception {
        Match match;
        WebScriptView view = null;
        Object uri = viewName;
        if (uri != null && ((String)uri).length() != 0 && ((String)uri).charAt(0) != '/') {
            uri = "/" + (String)uri;
        }
        if ((match = this.container.getRegistry().findWebScript("get", (String)uri)) != null) {
            view = new WebScriptView(this.container, this.authenticatorFactory, this.configService);
            view.setUrl((String)uri);
        }
        return view;
    }
}

