/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.servlet;

import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Runtime;
import org.springframework.extensions.webscripts.WebScriptResponseImpl;
import org.springframework.extensions.webscripts.ui.common.StringUtils;

public class WebScriptServletResponse
extends WebScriptResponseImpl {
    private static final String NO_CACHE = "no-cache";
    private static final Log logger = LogFactory.getLog(WebScriptServletResponse.class);
    private HttpServletResponse res;
    private static ThreadLocal<SimpleDateFormat> s_dateFormat = new ThreadLocal();

    public WebScriptServletResponse(Runtime container, HttpServletResponse res) {
        super(container);
        this.res = res;
    }

    public HttpServletResponse getHttpServletResponse() {
        return this.res;
    }

    @Override
    public void setStatus(int status) {
        this.res.setStatus(status);
    }

    @Override
    public void setHeader(String name, String value) {
        this.res.setHeader(name, this.formatHeaderValue(value));
    }

    @Override
    public void addHeader(String name, String value) {
        this.res.addHeader(name, this.formatHeaderValue(value));
    }

    private String formatHeaderValue(String value) {
        int newLineIndex;
        if (value != null && (newLineIndex = value.indexOf(10)) > 0) {
            value = value.trim();
            while (newLineIndex > 0) {
                char nextChar = value.charAt(newLineIndex + 1);
                if (nextChar != ' ' && nextChar != '\t') {
                    value = value.replaceFirst("\n" + nextChar, "\n " + nextChar);
                }
                newLineIndex = value.indexOf(10, newLineIndex + 1);
            }
        }
        return value;
    }

    @Override
    public void setContentType(String contentType) {
        this.res.setContentType(contentType);
    }

    @Override
    public void setContentEncoding(String contentEncoding) {
        this.res.setCharacterEncoding(contentEncoding);
    }

    @Override
    public void setCache(Cache cache) {
        Object cacheControl = "";
        Object pragma = "";
        if (cache.getIsPublic()) {
            cacheControl = (String)cacheControl + "public";
        }
        if (cache.getNeverCache()) {
            cacheControl = (String)cacheControl + (((String)cacheControl).length() > 0 ? ", " : "") + NO_CACHE;
            pragma = (String)pragma + (((String)pragma).length() > 0 ? ", " : NO_CACHE);
        }
        if (cache.getMaxAge() != null && !cache.getNeverCache()) {
            cacheControl = (String)cacheControl + (((String)cacheControl).length() > 0 ? ", " : "") + " max-age=" + cache.getMaxAge();
        }
        if (cache.getMustRevalidate() && !cache.getNeverCache()) {
            cacheControl = (String)cacheControl + (((String)cacheControl).length() > 0 ? ", " : "") + " must-revalidate";
        }
        if (((String)cacheControl).length() > 0) {
            this.res.setHeader("Cache-Control", (String)cacheControl);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Cache - set response header Cache-Control: " + (String)cacheControl));
            }
            if (NO_CACHE.equals(cacheControl)) {
                this.res.setHeader("Expires", "Thu, 01 Jan 1970 00:00:00 GMT");
            }
        }
        if (((String)pragma).length() > 0) {
            this.res.setHeader("Pragma", (String)pragma);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Cache - set response header Pragma: " + (String)pragma));
            }
        }
        if (cache.getETag() != null) {
            String eTag = "\"" + cache.getETag() + "\"";
            this.res.setHeader("ETag", eTag);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Cache - set response header ETag: " + eTag));
            }
        }
        if (cache.getLastModified() != null) {
            this.res.setDateHeader("Last-Modified", cache.getLastModified().getTime());
            if (logger.isDebugEnabled()) {
                SimpleDateFormat formatter = WebScriptServletResponse.getHTTPDateFormat();
                String lastModified = formatter.format(cache.getLastModified());
                logger.debug((Object)("Cache - set response header Last-Modified: " + lastModified));
            }
        }
    }

    @Override
    public void reset() {
        try {
            this.res.reset();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    public void reset(String preserveHeadersPattern) {
        if (preserveHeadersPattern == null || preserveHeadersPattern.isEmpty()) {
            this.reset();
        } else {
            Pattern pattern = Pattern.compile(preserveHeadersPattern);
            Collection headers = this.res.getHeaderNames();
            HashMap<String, String> savedHeaders = new HashMap<String, String>();
            for (String string : headers) {
                String headerValue;
                Matcher matcher = pattern.matcher(string);
                if (!matcher.find() || (headerValue = this.res.getHeader(string)) == null) continue;
                savedHeaders.put(string, headerValue);
            }
            this.reset();
            for (Map.Entry entry : savedHeaders.entrySet()) {
                this.res.setHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    @Override
    public Writer getWriter() throws IOException {
        return this.res.getWriter();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.res.getOutputStream();
    }

    @Override
    public String encodeScriptUrl(String url) {
        return url;
    }

    @Override
    public String getEncodeScriptUrlFunction(String name) {
        String s = "{ $name$: function(url) { return url; } }".replace("$name$", name);
        return StringUtils.encodeJavascript(s);
    }

    @Override
    public String encodeResourceUrl(String url) {
        return url;
    }

    @Override
    public String getEncodeResourceUrlFunction(String name) {
        String s = "{ $name$: function(url) { return url; } }".replace("$name$", name);
        return StringUtils.encodeJavascript(s);
    }

    private static SimpleDateFormat getHTTPDateFormat() {
        if (s_dateFormat.get() != null) {
            return s_dateFormat.get();
        }
        SimpleDateFormat formatter = new SimpleDateFormat("EEE, dd MMM yyyy kk:mm:ss zzz");
        formatter.setLenient(false);
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        s_dateFormat.set(formatter);
        return s_dateFormat.get();
    }
}

